/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bluemix.utility.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class IOUtils {
    public static void copy(Reader reader, Writer writer) throws IOException {
        int bytesRead;
        char[] buffer = new char[2048];
        while ((bytesRead = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = from.read(buffer)) != -1) {
            to.write(buffer, 0, bytesRead);
        }
    }

    public static void copy(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            IOUtils.copy(in, out);
        }
        finally {
            IOUtils.close(in);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean recursiveDelete(File root) {
        File[] files;
        if (root == null) {
            return true;
        }
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    IOUtils.recursiveDelete(file);
                    continue;
                }
                file.delete();
            }
        }
        return root.delete();
    }
}

