/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.eclipselink.logging;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jpa.container.eclipselink.logging.LogChannel;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.platform.server.ServerLog;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EclipseLinkLogger
extends ServerLog {
    private static final String ECLIPSELINK_STRING = "eclipselink";
    private static final String EMPTY_CHANNEL = "eclipselink";
    private static final TraceComponent _tc = Tr.register(EclipseLinkLogger.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private final Map<String, LogChannel> _channels = new ConcurrentHashMap<String, LogChannel>();
    static final long serialVersionUID = 4788609729357303833L;

    public EclipseLinkLogger() {
        for (String category : SessionLog.loggerCatagories) {
            this._channels.put(category, new LogChannel("eclipselink." + category));
        }
        this._channels.put("eclipselink", new LogChannel("eclipselink"));
    }

    @Trivial
    public void log(SessionLogEntry entry) {
        String category = entry.getNameSpace();
        int level = entry.getLevel();
        LogChannel channel = this.getLogChannel(category);
        if (channel.shouldLog(level)) {
            channel.log(entry, this.formatMessage(entry));
        }
    }

    @Trivial
    public boolean shouldLog(int level, String category) {
        return this.getLogChannel(category).shouldLog(level);
    }

    @Trivial
    private LogChannel getLogChannel(String category) {
        LogChannel channel;
        if (category == null) {
            category = "eclipselink";
        }
        if ((channel = this._channels.get(category)) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Found an unmapped logging channel (" + category + ") in log(...). Possibly something wrong in EclipseLink, remapping to base channel."), (Object[])new Object[0]);
                channel = this._channels.get("eclipselink");
            }
            channel = this._channels.get("eclipselink");
        }
        return channel;
    }
}

