/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ChainInitiationObserver
implements MessageObserver {
    protected Endpoint endpoint;
    protected Bus bus;
    protected ClassLoader loader;
    private final PhaseChainCache chainCache = new PhaseChainCache();
    static final long serialVersionUID = -1700059394083457869L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ChainInitiationObserver(Endpoint endpoint, Bus bus) {
        this.endpoint = endpoint;
        this.bus = bus;
        if (bus != null) {
            this.loader = (ClassLoader)bus.getExtension(ClassLoader.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={RuntimeException.class})
    public void onMessage(Message m) {
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
        Object origLoader = null;
        try {
            Message message;
            Exchange exchange;
            InterceptorChain phaseChain = null;
            if (m.getInterceptorChain() != null) {
                InterceptorChain interceptorChain = phaseChain = m.getInterceptorChain();
                synchronized (interceptorChain) {
                    if (phaseChain.getState() == InterceptorChain.State.PAUSED || phaseChain.getState() == InterceptorChain.State.SUSPENDED) {
                        phaseChain.resume();
                        return;
                    }
                }
            }
            if ((exchange = (message = this.getBinding().createMessage(m)).getExchange()) == null) {
                exchange = new ExchangeImpl();
                m.setExchange(exchange);
            }
            exchange.setInMessage(message);
            this.setExchangeProperties(exchange, message);
            InterceptorProvider dbp = null;
            if (this.endpoint.getService().getDataBinding() instanceof InterceptorProvider) {
                dbp = (InterceptorProvider)this.endpoint.getService().getDataBinding();
            }
            phaseChain = dbp == null ? this.chainCache.get(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getService().getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors()) : this.chainCache.get(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getService().getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors(), dbp.getInInterceptors());
            message.setInterceptorChain(phaseChain);
            phaseChain.setFaultObserver(this.endpoint.getOutFaultObserver());
            this.addToChain(phaseChain, message);
            phaseChain.doIntercept(message);
            return;
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
        }
    }

    private void addToChain(InterceptorChain chain, Message m) {
        Collection is;
        Collection providers = CastUtils.cast((Collection)((Collection)m.get((Object)Message.INTERCEPTOR_PROVIDERS)));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                chain.add((Collection)p.getInInterceptors());
            }
        }
        if ((is = CastUtils.cast((Collection)((Collection)m.get((Object)Message.IN_INTERCEPTORS)))) != null) {
            String rqURL = (String)m.get((Object)"org.apache.cxf.request.url");
            boolean isHttps = rqURL != null && rqURL.indexOf("https:") > -1;
            for (Interceptor i : is) {
                if (i instanceof CertConstraintsInterceptor && !isHttps) continue;
                chain.add(i);
            }
        }
        if (m.getDestination() instanceof InterceptorProvider) {
            chain.add((Collection)((InterceptorProvider)m.getDestination()).getInInterceptors());
        }
    }

    protected Binding getBinding() {
        return this.endpoint.getBinding();
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Endpoint.class, (Object)this.endpoint);
        exchange.put(Binding.class, (Object)this.getBinding());
        exchange.put(Bus.class, (Object)this.bus);
        if (exchange.getDestination() == null) {
            exchange.setDestination(m.getDestination());
        }
        if (this.endpoint != null && this.endpoint.getService() != null) {
            exchange.put(Service.class, (Object)this.endpoint.getService());
            EndpointInfo endpointInfo = this.endpoint.getEndpointInfo();
            if (endpointInfo.getService() != null) {
                QName serviceQName = endpointInfo.getService().getName();
                exchange.put((Object)"javax.xml.ws.wsdl.service", (Object)serviceQName);
                QName interfaceQName = endpointInfo.getService().getInterface().getName();
                exchange.put((Object)"javax.xml.ws.wsdl.interface", (Object)interfaceQName);
                QName portQName = endpointInfo.getName();
                exchange.put((Object)"javax.xml.ws.wsdl.port", (Object)portQName);
                URI wsdlDescription = (URI)endpointInfo.getProperty("URI", URI.class);
                if (wsdlDescription == null && !endpointInfo.hasProperty("URI")) {
                    String address = endpointInfo.getAddress();
                    try {
                        wsdlDescription = new URI(address + "?wsdl");
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        FFDCFilter.processException((Throwable)uRISyntaxException, (String)"org.apache.cxf.transport.ChainInitiationObserver", (String)"194", (Object)this, (Object[])new Object[]{exchange, m});
                    }
                    endpointInfo.setProperty("URI", (Object)wsdlDescription);
                }
                exchange.put((Object)"javax.xml.ws.wsdl.description", (Object)wsdlDescription);
            }
        } else {
            exchange.put(Service.class, null);
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ChainInitiationObserver.class);
    }
}

