/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.ResourceBundle;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JAXRSDefaultFaultOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final ResourceBundle BUNDLE;
    static final long serialVersionUID = 1676985006493736369L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JAXRSDefaultFaultOutInterceptor() {
        super("marshal");
    }

    public JAXRSDefaultFaultOutInterceptor(String phase) {
        super(phase);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={Exception.class})
    public void handleMessage(Message message) throws Fault {
        if (PropertyUtils.isTrue((Object)message.getExchange().get((Object)"second.jaxrs.exception"))) {
            return;
        }
        Fault f = (Fault)((Object)message.getContent(Exception.class));
        Response r = JAXRSUtils.convertFaultToResponse(f.getCause(), message);
        if (r == null) {
            try {
                AsyncResponseImpl asyncResponse = (AsyncResponseImpl)message.getExchange().getInMessage().get(AsyncResponse.class);
                if (asyncResponse != null) {
                    asyncResponse.setUnmappedThrowable(f.getCause());
                }
            }
            catch (Exception asyncResponse) {
                // empty catch block
            }
        }
        if (r != null) {
            JAXRSUtils.setMessageContentType(message, r);
            message.setContent(List.class, (Object)new MessageContentsList(new Object[]{r}));
            if (message.getExchange().getOutMessage() == null && message.getExchange().getOutFaultMessage() != null) {
                message.getExchange().setOutMessage(message.getExchange().getOutFaultMessage());
            }
            new JAXRSOutInterceptor().handleMessage(message);
            return;
        }
        ServerProviderFactory.releaseRequestState(message);
        if (this.mustPropogateException(message)) {
            throw f;
        }
        new StaxOutInterceptor().handleMessage(message);
        message.put((Object)Message.RESPONSE_CODE, (Object)f.getStatusCode());
        NSStack nsStack = new NSStack();
        nsStack.push();
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        try {
            nsStack.add("http://cxf.apache.org/bindings/xformat");
            String prefix = nsStack.getPrefix("http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement(writer, prefix, "XMLFault", "http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement(writer, prefix, "faultstring", "http://cxf.apache.org/bindings/xformat");
            Throwable t = f.getCause();
            writer.writeCharacters(t == null ? f.getMessage() : t.toString());
            writer.writeEndElement();
            if (f.getDetail() != null) {
                StaxUtils.writeStartElement(writer, prefix, "detail", "http://cxf.apache.org/bindings/xformat");
                StaxUtils.writeNode(DOMUtils.getChild((Node)f.getDetail(), (int)1), writer, false);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException prefix) {
            void xe;
            FFDCFilter.processException((Throwable)prefix, (String)"org.apache.cxf.jaxrs.interceptor.JAXRSDefaultFaultOutInterceptor", (String)"128", (Object)((Object)this), (Object[])new Object[]{message});
            throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)xe);
        }
    }

    public void handleFault(Message message) throws Fault {
        if (this.mustPropogateException(message)) {
            throw (Fault)((Object)message.getContent(Exception.class));
        }
    }

    protected boolean mustPropogateException(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get((Object)Message.PROPOGATE_EXCEPTION));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JAXRSDefaultFaultOutInterceptor.class);
        BUNDLE = BundleUtils.getBundle(JAXRSDefaultFaultOutInterceptor.class);
    }
}

