/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.ChecksumsManager;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.adaptor.ESAAdaptor;
import com.ibm.ws.install.internal.adaptor.FixAdaptor;
import com.ibm.ws.install.internal.adaptor.ServerPackageJarAdaptor;
import com.ibm.ws.install.internal.adaptor.ServicePackageAdaptor;
import com.ibm.ws.install.internal.asset.ESAAsset;
import com.ibm.ws.install.internal.asset.FixAsset;
import com.ibm.ws.install.internal.asset.InstallAsset;
import com.ibm.ws.install.internal.asset.JarAsset;
import com.ibm.ws.install.internal.asset.ServerPackageAsset;
import com.ibm.ws.install.internal.asset.UninstallAsset;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Engine {
    private final Product product;

    public Engine(Product product) {
        this.product = product;
    }

    public void install(InstallAsset installAsset, List<File> filesInstalled, Collection<String> featuresToBeInstalled, InstallConstants.ExistsAction existsAction, Set<String> executableFiles, Map<String, Set<String>> extattrFiles, boolean downloadDependencies, RestRepositoryConnectionProxy proxy, ChecksumsManager checksumsManager) throws IOException, InstallException {
        if (installAsset.isFeature()) {
            ESAAdaptor.install(this.product, (ESAAsset)installAsset, filesInstalled, featuresToBeInstalled, existsAction, executableFiles, extattrFiles, checksumsManager);
        } else if (installAsset.isFix()) {
            FixAdaptor.install(this.product, (FixAsset)installAsset);
        } else if (installAsset.isServerPackage()) {
            if (installAsset instanceof JarAsset) {
                ServerPackageJarAdaptor.install(this.product, (JarAsset)installAsset, filesInstalled, downloadDependencies, proxy);
            } else {
                ServicePackageAdaptor.install(this.product, (ServerPackageAsset)((Object)installAsset), filesInstalled, existsAction);
            }
        } else if (installAsset.isSample()) {
            ServerPackageJarAdaptor.install(this.product, (JarAsset)installAsset, filesInstalled, downloadDependencies, proxy);
        } else if (installAsset.isOpenSource()) {
            ServerPackageJarAdaptor.install(this.product, (JarAsset)installAsset, filesInstalled, downloadDependencies, proxy);
        }
    }

    public void uninstall(UninstallAsset uninstallAsset, boolean checkDependency, List<File> filesRestored) throws IOException, ParserConfigurationException, SAXException, InstallException {
        if (uninstallAsset.getType().equals((Object)UninstallAsset.UninstallAssetType.feature)) {
            ESAAdaptor.uninstallFeature(uninstallAsset.getProvisioningFeatureDefinition(), this.product.getFeatureDefinitions(), this.getBaseDir(uninstallAsset.getProvisioningFeatureDefinition()), checkDependency, filesRestored);
        } else if (uninstallAsset.getType().equals((Object)UninstallAsset.UninstallAssetType.fix)) {
            FixAdaptor.uninstallFix(uninstallAsset.getIFixInfo(), this.product.getInstallDir(), filesRestored);
        }
        InstallUtils.updateFingerprint(this.product.getInstallDir());
    }

    private File getBaseDir(ProvisioningFeatureDefinition pd) throws InstallException {
        if (pd.getBundleRepositoryType().equals("usr")) {
            return this.product.getUserExtensionDir();
        }
        if (pd.getBundleRepositoryType().equals("")) {
            return this.product.getInstallDir();
        }
        String repoType = pd.getBundleRepositoryType();
        return this.product.getUserDirExternal(repoType);
    }

    public void preCheck(UninstallAsset uninstallAsset, boolean checkDependency) throws InstallException {
        if (uninstallAsset.getType().equals((Object)UninstallAsset.UninstallAssetType.feature)) {
            ESAAdaptor.preCheck(uninstallAsset.getProvisioningFeatureDefinition(), this.product.getFeatureDefinitions(), this.getBaseDir(uninstallAsset.getProvisioningFeatureDefinition()), checkDependency);
        } else if (uninstallAsset.getType().equals((Object)UninstallAsset.UninstallAssetType.fix)) {
            FixAdaptor.preCheck(uninstallAsset.getIFixInfo(), this.product.getInstallDir());
        }
    }
}

