/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.constraints;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.DecimalMax;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DecimalMaxValidatorForNumber
implements ConstraintValidator<DecimalMax, Number> {
    private BigDecimal maxValue;
    private int comparator = 1;
    static final long serialVersionUID = -6435466975546588892L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void initialize(DecimalMax annotation) {
        try {
            this.maxValue = new BigDecimal(annotation.value());
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"org.apache.bval.constraints.DecimalMaxValidatorForNumber", (String)"36", (Object)this, (Object[])new Object[]{annotation});
            throw new IllegalArgumentException(annotation.value() + " does not represent a valid BigDecimal format");
        }
        if (!annotation.inclusive()) {
            this.comparator = 0;
        }
    }

    public boolean isValid(Number value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(this.maxValue) < this.comparator;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value).compareTo(this.maxValue) < this.comparator;
        }
        return new BigDecimal(value.doubleValue()).compareTo(this.maxValue) < this.comparator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DecimalMaxValidatorForNumber.class);
    }
}

