/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver;

import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.product.utility.extension.ifix.xml.IFixInfo;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resolver.ProductRequirementInformation;
import com.ibm.ws.repository.resolver.RepositoryResolutionException;
import com.ibm.ws.repository.resolver.internal.FixFeatureComparator;
import com.ibm.ws.repository.resolver.internal.RepositoryResolveContext;
import com.ibm.ws.repository.resolver.internal.StopAutoFeaturesInstallingTheirRequiredCapabilities;
import com.ibm.ws.repository.resolver.internal.namespace.InstallableEntityIdentityConstants;
import com.ibm.ws.repository.resolver.internal.resource.FeatureResource;
import com.ibm.ws.repository.resolver.internal.resource.IFixResource;
import com.ibm.ws.repository.resolver.internal.resource.LpmResource;
import com.ibm.ws.repository.resolver.internal.resource.ProductRequirement;
import com.ibm.ws.repository.resolver.internal.resource.ProductResource;
import com.ibm.ws.repository.resolver.internal.resource.RequirementImpl;
import com.ibm.ws.repository.resolver.internal.resource.ResourceImpl;
import com.ibm.ws.repository.resolver.internal.resource.SampleResource;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.IfixResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.resolver.ResolverImpl;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

public class RepositoryResolver {
    private final RepositoryConnectionList loginInfo;
    private final List<Resource> installedProductResources;
    private final List<Resource> installedEntities;
    private final List<Resource> repoResources;
    private final List<Resource> repoIFixResources;
    private final Collection<Resource> autoFeatures;
    private static final FixFeatureComparator FIX_FEATURE_COMPARATOR = new FixFeatureComparator();

    public RepositoryResolver(Collection<ProductDefinition> installDefinition, Collection<ProvisioningFeatureDefinition> installedFeatures, Collection<IFixInfo> installedIFixes, RepositoryConnectionList repoConnections) throws RepositoryException {
        this.loginInfo = repoConnections;
        this.installedProductResources = new ArrayList<Resource>();
        this.installedProductResources.add(ProductResource.createInstance(installDefinition));
        this.installedEntities = new ArrayList<Resource>();
        HashSet<String> installedFeaturesSymbolicNames = new HashSet<String>();
        for (ProvisioningFeatureDefinition featureDefinition : installedFeatures) {
            this.installedEntities.add(FeatureResource.createInstance(featureDefinition));
            installedFeaturesSymbolicNames.add(featureDefinition.getSymbolicName());
        }
        for (IFixInfo iFixInfo : installedIFixes) {
            this.installedEntities.add(IFixResource.createInstance(iFixInfo));
        }
        HashSet<ResourceType> interestingTypes = new HashSet<ResourceType>();
        interestingTypes.add(ResourceType.FEATURE);
        interestingTypes.add(ResourceType.IFIX);
        interestingTypes.add(ResourceType.OPENSOURCE);
        interestingTypes.add(ResourceType.PRODUCTSAMPLE);
        Map resources = repoConnections.getResources(installDefinition, interestingTypes, null);
        Collection esaMassiveResources = (Collection)resources.get(ResourceType.FEATURE);
        ArrayList<FeatureResource> featureResources = new ArrayList<FeatureResource>();
        this.autoFeatures = new HashSet<Resource>();
        if (esaMassiveResources != null) {
            for (EsaResource esaMassiveResource : esaMassiveResources) {
                FeatureResource featureResource = FeatureResource.createInstance(esaMassiveResource);
                featureResources.add(featureResource);
                if (!featureResource.isAutoFeatureThatShouldBeInstalledWhenSatisfied() || installedFeaturesSymbolicNames.contains(esaMassiveResource.getProvideFeature())) continue;
                this.autoFeatures.add(featureResource);
            }
        }
        Collections.sort(featureResources);
        Collection sampleMassiveResources = (Collection)resources.get(ResourceType.OPENSOURCE);
        Collection productMassiveResources = (Collection)resources.get(ResourceType.PRODUCTSAMPLE);
        if (sampleMassiveResources == null) {
            sampleMassiveResources = productMassiveResources;
        } else if (productMassiveResources != null) {
            sampleMassiveResources.addAll(productMassiveResources);
        }
        ArrayList<SampleResource> sampleResources = new ArrayList<SampleResource>();
        if (sampleMassiveResources != null) {
            for (com.ibm.ws.repository.resources.SampleResource sampleMassiveResource : sampleMassiveResources) {
                SampleResource sampleResource = SampleResource.createInstance(sampleMassiveResource);
                sampleResources.add(sampleResource);
            }
        }
        Collection ifixMassiveResources = (Collection)resources.get(ResourceType.IFIX);
        ArrayList<IFixResource> sortableRepoIFixResources = new ArrayList<IFixResource>();
        if (ifixMassiveResources != null) {
            for (IfixResource ifixMassiveResource : ifixMassiveResources) {
                sortableRepoIFixResources.add(IFixResource.createInstance(ifixMassiveResource));
            }
        }
        Collections.sort(sortableRepoIFixResources);
        this.repoIFixResources = new ArrayList<Resource>(sortableRepoIFixResources);
        this.repoResources = new ArrayList<Resource>(featureResources);
        this.repoResources.addAll(sampleResources);
        this.repoResources.addAll(this.repoIFixResources);
    }

    public Collection<List<RepositoryResource>> resolve(Collection<String> toResolve) throws RepositoryResolutionException {
        Map wirings = null;
        ResolverImpl resolver = new ResolverImpl(null, null);
        LinkedHashMap<String, Collection<InstallableEntityIdentityConstants.NameAttributes>> typesAndAttributesToSearch = new LinkedHashMap<String, Collection<InstallableEntityIdentityConstants.NameAttributes>>();
        typesAndAttributesToSearch.put("osgi.subsystem.feature", Arrays.asList(InstallableEntityIdentityConstants.NameAttributes.values()));
        typesAndAttributesToSearch.put("sample", InstallableEntityIdentityConstants.SAMPLES_NAME_ATTRIBUTES);
        RepositoryResolveContext existingResolveContext = new RepositoryResolveContext(Collections.<Resource>emptySet(), Collections.<Resource>emptySet(), this.installedProductResources, this.installedEntities, this.repoResources, this.loginInfo);
        HashSet<Resource> resourcesToResolve = new HashSet<Resource>();
        for (String toResolveString : toResolve) {
            LpmResource toResolveResource = null;
            block5: for (Map.Entry typesAndAttributesEntry : typesAndAttributesToSearch.entrySet()) {
                String type = (String)typesAndAttributesEntry.getKey();
                Collection attributesToMatch = (Collection)typesAndAttributesEntry.getValue();
                for (InstallableEntityIdentityConstants.NameAttributes attributeToMatch : attributesToMatch) {
                    toResolveResource = LpmResource.createInstance(toResolveString, attributeToMatch, type);
                    boolean allRequirementsCanBeMet = true;
                    for (Requirement requirement : toResolveResource.getRequirements(null)) {
                        if (!existingResolveContext.findProviders(requirement).isEmpty()) continue;
                        allRequirementsCanBeMet = false;
                        break;
                    }
                    if (!allRequirementsCanBeMet) continue;
                    break block5;
                }
            }
            resourcesToResolve.add(toResolveResource);
        }
        RepositoryResolveContext resolveContext = new RepositoryResolveContext(resourcesToResolve, Collections.<Resource>emptySet(), this.installedProductResources, this.installedEntities, this.repoResources, this.loginInfo);
        try {
            wirings = resolver.resolve((ResolveContext)resolveContext);
        }
        catch (ResolutionException e) {
            Collection<String> missingTopLevelFeatures = this.getNamesOfRequirements(e.getUnresolvedRequirements());
            Collection<String> requirementsNotFound = this.getNamesOfRequirements(resolveContext.getRequirementsNotFound());
            Collection<RepositoryResolutionException.MissingRequirement> requirementResourcesNotFound = this.getNamesAndResourcesOfRequirements(resolveContext.getRequirementsNotFound());
            Collection<ProductRequirementInformation> productsNotFound = this.getProductsNotFoundFromRequirements(resolveContext.getRequirementsNotFound());
            throw new RepositoryResolutionException(e, missingTopLevelFeatures, requirementsNotFound, productsNotFound, requirementResourcesNotFound);
        }
        if (this.autoFeatures != null && !this.autoFeatures.isEmpty()) {
            ArrayList<Resource> resolvedAndInstalledResources = new ArrayList<Resource>(this.installedEntities);
            for (Resource resource : wirings.keySet()) {
                if (resolvedAndInstalledResources.contains(resource)) continue;
                resolvedAndInstalledResources.add(resource);
            }
            RepositoryResolveContext autoFeatureResolveContext = new RepositoryResolveContext(Collections.<Resource>emptySet(), this.autoFeatures, this.installedProductResources, resolvedAndInstalledResources, this.repoResources, this.loginInfo);
            autoFeatureResolveContext.addFilter(new StopAutoFeaturesInstallingTheirRequiredCapabilities());
            try {
                Map autoFeatureWirings = resolver.resolve((ResolveContext)autoFeatureResolveContext);
                wirings.putAll(autoFeatureWirings);
            }
            catch (ResolutionException resolutionException) {
                // empty catch block
            }
        }
        Collection<List<RepositoryResource>> installLists = this.convertWiringsToInstallLists(wirings, resourcesToResolve);
        return installLists;
    }

    private Collection<List<RepositoryResource>> convertWiringsToInstallLists(Map<Resource, List<Wire>> wirings, Collection<Resource> resourcesAskedFor) {
        ArrayList<Object> installList;
        HashSet<List<RepositoryResource>> resourcesToInstall = new HashSet<List<RepositoryResource>>();
        for (Resource resourceAskedFor : resourcesAskedFor) {
            installList = new ArrayList<RepositoryResource>();
            this.addRequiredDependenciesToInstallList(wirings, resourceAskedFor, installList, new HashSet<Resource>());
            this.addResourceList(installList, resourcesToInstall);
        }
        for (Resource autoFeature : this.autoFeatures) {
            RepositoryResource autoFeatureMassiveResource;
            if (!wirings.containsKey(autoFeature)) continue;
            installList = new ArrayList();
            if (autoFeature instanceof ResourceImpl && (autoFeatureMassiveResource = ((ResourceImpl)autoFeature).getResource()) != null) {
                installList.add(autoFeatureMassiveResource);
            }
            this.addRequiredDependenciesToInstallList(wirings, autoFeature, installList, new HashSet<Resource>());
            this.addResourceList(installList, resourcesToInstall);
        }
        return resourcesToInstall;
    }

    private void addResourceList(List<RepositoryResource> installList, Collection<List<RepositoryResource>> resourcesToInstall) {
        if (!installList.isEmpty()) {
            ArrayList<RepositoryResource> installListCopy = new ArrayList<RepositoryResource>(installList.size());
            for (RepositoryResource massiveResource : installList) {
                if (installListCopy.contains(massiveResource)) continue;
                installListCopy.add(massiveResource);
            }
            resourcesToInstall.add(installListCopy);
        }
    }

    private void addRequiredDependenciesToInstallList(Map<Resource, List<Wire>> wirings, Resource resource, List<RepositoryResource> installList, Set<Resource> resourcesProcessedInThisStack) {
        resourcesProcessedInThisStack.add(resource);
        List<Wire> wires = wirings.get(resource);
        ArrayList<ResourceImpl> thingsToInstall = new ArrayList<ResourceImpl>();
        for (Wire wire : wires) {
            ResourceImpl wireProviderResourceImpl;
            RepositoryResource massiveResource;
            Resource wireProvider = wire.getProvider();
            if (!(wireProvider instanceof ResourceImpl) || (massiveResource = (wireProviderResourceImpl = (ResourceImpl)wireProvider).getResource()) == null || resourcesProcessedInThisStack.contains(wireProviderResourceImpl)) continue;
            thingsToInstall.add(wireProviderResourceImpl);
        }
        Collections.sort(thingsToInstall, FIX_FEATURE_COMPARATOR);
        for (ResourceImpl resourceImpl : thingsToInstall) {
            installList.add(0, resourceImpl.getResource());
        }
        for (ResourceImpl resourceImpl : thingsToInstall) {
            this.addRequiredDependenciesToInstallList(wirings, resourceImpl, installList, new HashSet<Resource>(resourcesProcessedInThisStack));
        }
    }

    private Collection<String> getNamesOfRequirements(Collection<Requirement> requirements) {
        HashSet<String> requirementNames = new HashSet<String>();
        for (Requirement requirement : requirements) {
            if (requirement instanceof RequirementImpl) {
                requirementNames.add(((RequirementImpl)requirement).getName());
                continue;
            }
            requirementNames.add(requirement.toString());
        }
        return requirementNames;
    }

    private Collection<RepositoryResolutionException.MissingRequirement> getNamesAndResourcesOfRequirements(Collection<Requirement> requirements) {
        HashSet<RepositoryResolutionException.MissingRequirement> requirementResources = new HashSet<RepositoryResolutionException.MissingRequirement>();
        for (Requirement requirement : requirements) {
            if (requirement instanceof RequirementImpl) {
                RequirementImpl requirementImpl = (RequirementImpl)requirement;
                Resource owningResource = requirementImpl.getResource();
                RepositoryResource owningMassiveResource = null;
                if (owningResource instanceof ResourceImpl) {
                    owningMassiveResource = ((ResourceImpl)owningResource).getResource();
                }
                requirementResources.add(new RepositoryResolutionException.MissingRequirement(requirementImpl.getName(), owningMassiveResource));
                continue;
            }
            requirementResources.add(new RepositoryResolutionException.MissingRequirement(requirement.toString(), null));
        }
        return requirementResources;
    }

    private Collection<ProductRequirementInformation> getProductsNotFoundFromRequirements(Collection<Requirement> requirements) {
        HashSet<ProductRequirementInformation> products = new HashSet<ProductRequirementInformation>();
        for (Requirement requirement : requirements) {
            if (!(requirement instanceof ProductRequirement)) continue;
            products.addAll(((ProductRequirement)requirement).getProductInformation());
        }
        return products;
    }

    public Collection<List<RepositoryResource>> resolve(String toResolve) throws RepositoryException, RepositoryResolutionException {
        return this.resolve(Collections.singleton(toResolve));
    }
}

