/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedModuleInfo;
import com.ibm.ws.app.manager.module.internal.ClientModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ConnectorModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ContextRootUtil;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoFactoryBase;
import com.ibm.ws.app.manager.module.internal.DeployedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.EJBModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ExtendedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.WebModuleInfoImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.extended.AltDDEntryGetter;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleContainerInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.container.service.metadata.extended.NestedModuleMetaDataFactory;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.common.ModuleDeploymentDescriptor;
import com.ibm.ws.javaee.dd.connector.Connector;
import com.ibm.ws.javaee.dd.ejb.EJBJar;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class SimpleDeployedAppInfoBase
implements DeployedAppInfo {
    public ExtendedApplicationInfo appInfo;
    public final List<DeployedModuleInfoImpl> modulesDeployed = new ArrayList<DeployedModuleInfoImpl>();
    public boolean starting = false;
    public boolean started = false;
    protected final ApplicationInfoFactory appInfoFactory;
    protected final MetaDataService metaDataService;
    protected final StateChangeService stateChangeService;
    protected final ModuleClassesInfoProvider moduleClassesInfo;
    protected final List<ModuleContainerInfoBase> moduleContainerInfos = new ArrayList<ModuleContainerInfoBase>();
    protected final Map<ExtendedModuleInfo, ModuleHandler> activeModuleHandlers = new IdentityHashMap<ExtendedModuleInfo, ModuleHandler>(4);
    static final long serialVersionUID = 7078125893012250887L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected SimpleDeployedAppInfoBase(DeployedAppInfoFactoryBase factory) throws UnableToAdaptException {
        this.appInfoFactory = factory.getApplicationInfoFactory();
        this.metaDataService = factory.getMetaDataService();
        this.stateChangeService = factory.getStateChangeService();
        this.moduleClassesInfo = new ModuleClassesInfoProvider();
    }

    public void addDeployedModule(DeployedModuleInfoImpl deployedMod, List<ExtendedModuleInfo> nestedModules) {
        this.activeModuleHandlers.remove(deployedMod.getModuleInfo());
        this.modulesDeployed.add(0, deployedMod);
        if (nestedModules != null) {
            for (ExtendedModuleInfo nestedModule : nestedModules) {
                ModuleHandler moduleHandler = this.activeModuleHandlers.remove(nestedModule);
                if (moduleHandler == null) continue;
                DeployedModuleInfoImpl nestedDeployedMod = new DeployedModuleInfoImpl(moduleHandler, nestedModule);
                deployedMod.addNestedModule(nestedDeployedMod);
            }
        }
    }

    protected void deregisterApplicationMBean() {
    }

    @Override
    public void moduleMetaDataCreated(ExtendedModuleInfo moduleInfo, ModuleHandler moduleHandler, ModuleMetaData mmd) {
        this.activeModuleHandlers.put(moduleInfo, moduleHandler);
    }

    @Override
    public DeployedModuleInfo getDeployedModule(ExtendedModuleInfo moduleInfo) {
        List<DeployedModuleInfoImpl> deployedModules = this.modulesDeployed;
        for (DeployedModuleInfoImpl deployedModule : deployedModules) {
            if (deployedModule.getModuleInfo() != moduleInfo) continue;
            return deployedModule;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean uninstallApp() {
        boolean success = true;
        if (this.started) {
            try {
                this.stateChangeService.fireApplicationStopping((ApplicationInfo)this.appInfo);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"474", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopping", (Object)this);
                success = false;
            }
        }
        List<DeployedModuleInfoImpl> deployedModules = this.modulesDeployed;
        for (DeployedModuleInfoImpl deployedModule : deployedModules) {
            if (deployedModule.getNestedModules() != null) {
                for (DeployedModuleInfoImpl nestedMod : deployedModule.getNestedModules()) {
                    nestedMod.uninstallModule();
                }
            }
            success = deployedModule.uninstallModule();
        }
        if (this.starting) {
            try {
                this.stateChangeService.fireApplicationStopped((ApplicationInfo)this.appInfo);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"491", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopped", (Object)this);
                success = false;
            }
        }
        this.deregisterApplicationMBean();
        if (this.appInfo != null) {
            try {
                this.metaDataService.fireApplicationMetaDataDestroyed(this.appInfo.getMetaData());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"502", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationMetaDataDestroyed", (Object)this);
                success = false;
            }
            try {
                this.appInfoFactory.destroyApplicationInfo((ApplicationInfo)this.appInfo);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"509", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"destroyApplicationInfo", (Object)this);
                success = false;
            }
        }
        return success;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SimpleDeployedAppInfoBase.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class WebModuleContainerInfo
    extends ModuleContainerInfoBase {
        public final String contextRoot;
        public String defaultContextRoot;
        static final long serialVersionUID = -8158961796913348204L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WebModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo, String contextRoot) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.WEB_MODULE, moduleClassesInfo, WebApp.class);
            this.getWebModuleClassesInfo(moduleContainer);
            this.contextRoot = contextRoot;
            this.defaultContextRoot = this.moduleName;
        }

        @Override
        public void setModuleName(String newModuleName) {
            super.setModuleName(newModuleName);
            this.defaultContextRoot = newModuleName;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory moduleClassLoaderFactory) throws MetaDataException {
            try {
                String contextRoot = this.contextRoot;
                if (contextRoot == null) {
                    contextRoot = ContextRootUtil.getContextRoot(this.defaultContextRoot);
                }
                return new WebModuleInfoImpl(appInfo, this.moduleName, this.name, contextRoot, this.container, this.altDDEntry, this.classesContainerInfo, moduleClassLoaderFactory);
            }
            catch (UnableToAdaptException contextRoot) {
                void e;
                FFDCFilter.processException((Throwable)contextRoot, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$WebModuleContainerInfo", (String)"342", (Object)this, (Object[])new Object[]{appInfo, moduleClassLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
        }

        private void getWebModuleClassesInfo(Container moduleContainer) throws UnableToAdaptException {
            Container libContainer;
            Entry libEntry;
            Container classesContainer;
            ArrayList resolved = new ArrayList();
            Entry classesEntry = moduleContainer.getEntry("WEB-INF/classes");
            if (classesEntry != null && (classesContainer = (Container)classesEntry.adapt(Container.class)) != null) {
                ContainerInfo containerInfo = new ContainerInfo(){
                    static final long serialVersionUID = 7799089642659979422L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.WEB_INF_CLASSES;
                    }

                    public String getName() {
                        return "WEB-INF/classes";
                    }

                    public Container getContainer() {
                        return classesContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                };
                this.classesContainerInfo.add(containerInfo);
            }
            if ((libEntry = moduleContainer.getEntry("WEB-INF/lib")) != null && (libContainer = (Container)libEntry.adapt(Container.class)) != null) {
                for (Entry entry : libContainer) {
                    if (!entry.getName().toLowerCase().endsWith(".jar")) continue;
                    final String jarEntryName = entry.getName();
                    final Container jarContainer = (Container)entry.adapt(Container.class);
                    if (jarContainer == null) continue;
                    ContainerInfo containerInfo = new ContainerInfo(){
                        static final long serialVersionUID = 7721559457291290747L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public ContainerInfo.Type getType() {
                            return ContainerInfo.Type.WEB_INF_LIB;
                        }

                        public String getName() {
                            return "WEB-INF/lib/" + jarEntryName;
                        }

                        public Container getContainer() {
                            return jarContainer;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class);
                        }
                    };
                    this.classesContainerInfo.add(containerInfo);
                    ManifestClassPathUtils.addCompleteJarEntryUrls((List)this.classesContainerInfo, (Entry)entry, resolved);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WebModuleContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class ClientModuleContainerInfo
    extends ModuleContainerInfoBase {
        final String mainClassName;
        static final long serialVersionUID = 4297660662927849249L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClientModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo, String mainClass) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.CLIENT_MODULE, moduleClassesInfo, ApplicationClient.class);
            this.mainClassName = mainClass;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory moduleClassLoaderFactory) throws MetaDataException {
            try {
                return new ClientModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, this.mainClassName, moduleClassLoaderFactory);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ClientModuleContainerInfo", (String)"301", (Object)this, (Object[])new Object[]{appInfo, moduleClassLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClientModuleContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class EJBModuleContainerInfo
    extends ModuleContainerInfoBase {
        static final long serialVersionUID = 546387578045836660L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EJBModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.EJB_MODULE, moduleClassesInfo, EJBJar.class);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory moduleClassLoaderFactory) throws MetaDataException {
            try {
                return new EJBModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, moduleClassLoaderFactory);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$EJBModuleContainerInfo", (String)"278", (Object)this, (Object[])new Object[]{appInfo, moduleClassLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EJBModuleContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class ConnectorModuleContainerInfo
    extends ModuleContainerInfoBase {
        static final long serialVersionUID = -5810188939725722744L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConnectorModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.RAR_MODULE, moduleClassesInfo, Connector.class);
            this.getConnectorModuleClassesInfo(moduleContainer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory moduleClassLoaderFactory) throws MetaDataException {
            try {
                return new ConnectorModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, moduleClassLoaderFactory);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ConnectorModuleContainerInfo", (String)"222", (Object)this, (Object[])new Object[]{appInfo, moduleClassLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
        }

        private void getConnectorModuleClassesInfo(Container moduleContainer) throws UnableToAdaptException {
            for (Entry entry : moduleContainer) {
                this.getEntryClassesInfo(entry);
            }
        }

        private void getEntryClassesInfo(Entry entry) throws UnableToAdaptException {
            if (entry.getName().toLowerCase().endsWith(".jar")) {
                final String jarEntryName = entry.getName();
                final Container jarContainer = (Container)entry.adapt(Container.class);
                ContainerInfo containerInfo = new ContainerInfo(){
                    static final long serialVersionUID = 7757684124372247255L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.JAR_MODULE;
                    }

                    public String getName() {
                        return jarEntryName;
                    }

                    public Container getContainer() {
                        return jarContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                };
                this.classesContainerInfo.add(containerInfo);
                HashSet resolved = new HashSet();
                ManifestClassPathUtils.addCompleteJarEntryUrls((List)this.classesContainerInfo, (Entry)entry, resolved);
                for (Entry childEntry : jarContainer) {
                    this.getEntryClassesInfo(childEntry);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConnectorModuleContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static abstract class ModuleContainerInfoBase
    extends ExtendedContainerInfo
    implements ModuleClassesContainerInfo,
    ModuleContainerInfo {
        public final ModuleHandler moduleHandler;
        public final List<ModuleMetaDataExtender> moduleMetaDataExtenders;
        public final List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories;
        public List<DeployedModuleInfoImpl> nestedModules;
        public String moduleName;
        public final ModuleDeploymentDescriptor moduleDD;
        public ExtendedModuleInfo moduleInfo;
        static final long serialVersionUID = 8693907776607441911L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public abstract ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo var1, ModuleClassLoaderFactory var2) throws MetaDataException;

        public ModuleContainerInfoBase(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ContainerInfo.Type moduleContainerType, ModuleClassesInfoProvider moduleClassesInfo, Class<? extends ModuleDeploymentDescriptor> moduleDDClass) throws UnableToAdaptException {
            super(moduleContainerType, moduleURI, moduleContainer, altDDEntry);
            this.moduleHandler = moduleHandler;
            this.moduleMetaDataExtenders = moduleMetaDataExtenders;
            this.nestedModuleMetaDataFactories = nestedModuleMetaDataFactories;
            this.moduleDD = (ModuleDeploymentDescriptor)moduleContainer.adapt(moduleDDClass);
            this.moduleName = ModuleInfoUtils.getModuleName(this.moduleDD, moduleURI);
            this.classesContainerInfo.add(this);
            if (moduleClassesInfo != null) {
                this.classesContainerInfo.addAll(moduleClassesInfo.getClassesContainers(moduleContainer));
            }
        }

        public ModuleMetaData createModuleMetaData(ApplicationInfo appInfo, SimpleDeployedAppInfoBase deployedApp, ModuleClassLoaderFactory moduleClassLoaderFactory) throws MetaDataException {
            ExtendedModuleInfoImpl moduleInfoImpl = this.createModuleInfoImpl(appInfo, moduleClassLoaderFactory);
            this.moduleInfo = moduleInfoImpl;
            if (this.moduleInfo == null || this.moduleHandler == null) {
                return null;
            }
            ModuleMetaData mmd = this.moduleHandler.createModuleMetaData(this.moduleInfo, deployedApp);
            if (mmd != null) {
                moduleInfoImpl.setMetaData(mmd);
                for (NestedModuleMetaDataFactory nestedModuleMetaDataFactory : this.nestedModuleMetaDataFactories) {
                    nestedModuleMetaDataFactory.createdNestedModuleMetaData(this.moduleInfo);
                }
                ArrayList<ExtendedModuleInfo> nestedModules = null;
                for (ModuleMetaDataExtender moduleMetaDataExtender : this.moduleMetaDataExtenders) {
                    ExtendedModuleInfo nestedModule = moduleMetaDataExtender.extendModuleMetaData(this.moduleInfo);
                    if (nestedModule == null) continue;
                    if (nestedModules == null) {
                        nestedModules = new ArrayList<ExtendedModuleInfo>(2);
                    }
                    nestedModules.add(nestedModule);
                }
                DeployedModuleInfoImpl deployedModuleInfoImpl = new DeployedModuleInfoImpl(this.moduleHandler, this.moduleInfo);
                deployedApp.addDeployedModule(deployedModuleInfoImpl, nestedModules);
                this.nestedModules = deployedModuleInfoImpl.getNestedModules();
            }
            return mmd;
        }

        public String getModuleURI() {
            return this.getName();
        }

        public void setModuleName(String newModuleName) {
            this.moduleName = newModuleName;
        }

        public ClassLoader getClassLoader() {
            return this.moduleInfo.getClassLoader();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleContainerInfoBase.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static class ExtendedContainerInfo
    implements ContainerInfo {
        protected final ContainerInfo.Type type;
        protected final String name;
        protected final Container container;
        protected final Entry altDDEntry;
        protected final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = 7427332431485745589L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected ExtendedContainerInfo(ContainerInfo.Type type, String name, Container container, Entry altDDEntry) {
            this.type = type;
            this.name = name;
            this.container = container;
            this.altDDEntry = altDDEntry;
            if (altDDEntry != null) {
                try {
                    NonPersistentCache cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
                    cache.addToCache(AltDDEntryGetter.class, (Object)new AltDDEntryGetter(){
                        static final long serialVersionUID = 3619126260756783675L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public Entry getAltDDEntry(ContainerInfo.Type type) {
                            if (ExtendedContainerInfo.this.type == type) {
                                return ExtendedContainerInfo.this.altDDEntry;
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class);
                        }
                    });
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ExtendedContainerInfo", (String)"97", (Object)this, (Object[])new Object[]{type, name, container, altDDEntry});
                }
            }
        }

        public ContainerInfo.Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Container getContainer() {
            return this.container;
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ExtendedContainerInfo.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected static final class ModuleClassesInfoProvider {
        private final Map<String, List<ContainerInfo>> entryContainerInfosMap = new HashMap<String, List<ContainerInfo>>();
        static final long serialVersionUID = -70332790531324534L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected ModuleClassesInfoProvider() {
        }

        public List<ContainerInfo> getClassesContainers(Container moduleContainer) throws UnableToAdaptException {
            Entry moduleEntry = (Entry)moduleContainer.adapt(Entry.class);
            if (moduleEntry == null) {
                return Collections.emptyList();
            }
            String entryIdentity = ManifestClassPathUtils.createEntryIdentity((Entry)moduleEntry);
            List<ContainerInfo> containerInfos = this.entryContainerInfosMap.get(entryIdentity);
            if (containerInfos == null) {
                HashSet resolved = new HashSet();
                containerInfos = new ArrayList<ContainerInfo>();
                ManifestClassPathUtils.processMFClasspath((Entry)moduleEntry, containerInfos, resolved);
                this.entryContainerInfosMap.put(entryIdentity, containerInfos);
            }
            return containerInfos;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleClassesInfoProvider.class);
        }
    }
}

