/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.xml.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.bindings.xformat.XMLBindingMessageFormat;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class XMLMessageInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLMessageInInterceptor.class);
    static final long serialVersionUID = 127062205164013424L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public XMLMessageInInterceptor() {
        this("unmarshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public XMLMessageInInterceptor(String phase) {
        super(phase);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "<init>", new Object[]{phase});
        }
        this.addBefore(DocLiteralInInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "handleMessage", new Object[]{message});
        }
        if (this.isGET(message)) {
            LOG.fine("XMLMessageInInterceptor skipped in HTTP GET method");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "handleMessage");
            }
            return;
        }
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        XMLStreamReader xsr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (xsr == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "handleMessage");
            }
            return;
        }
        DepthXMLStreamReader reader = new DepthXMLStreamReader(xsr);
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION_ELEMENT", LOG, new Object[0]));
        }
        Exchange ex = message.getExchange();
        QName startQName = reader.getName();
        if (startQName.getLocalPart().equals("XMLFault")) {
            message.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(message);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "handleMessage");
                }
                return;
            }
        }
        BindingOperationInfo boi = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        boolean isRequestor = this.isRequestor(message);
        if (boi == null) {
            BindingInfo service = ep.getEndpointInfo().getBinding();
            boi = this.getBindingOperationInfo(isRequestor, startQName, service, xsr);
            if (boi != null) {
                ex.put(BindingOperationInfo.class, (Object)boi);
                ex.put(OperationInfo.class, (Object)boi.getOperationInfo());
                ex.setOneWay(boi.getOperationInfo().isOneWay());
            }
        } else {
            BindingMessageInfo bmi;
            BindingMessageInfo bindingMessageInfo = bmi = isRequestor ? boi.getOutput() : boi.getInput();
            if (this.hasRootNode(bmi, startQName)) {
                try {
                    xsr.nextTag();
                }
                catch (XMLStreamException xMLStreamException) {
                    FFDCFilter.processException((Throwable)xMLStreamException, (String)"org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", (String)"102", (Object)((Object)this), (Object[])new Object[]{message});
                    throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_READ_EXC", LOG, new Object[0]));
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BindingOperationInfo getBindingOperationInfo(boolean isRequestor, QName startQName, BindingInfo bi, XMLStreamReader xsr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "getBindingOperationInfo", new Object[]{isRequestor, startQName, bi, xsr});
        }
        for (BindingOperationInfo boi : bi.getOperations()) {
            MessagePartInfo p;
            BindingMessageInfo bmi = !isRequestor ? boi.getInput() : boi.getOutput();
            if (this.hasRootNode(bmi, startQName)) {
                try {
                    xsr.nextTag();
                }
                catch (XMLStreamException xMLStreamException) {
                    FFDCFilter.processException((Throwable)xMLStreamException, (String)"org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", (String)"126", (Object)((Object)this), (Object[])new Object[]{isRequestor, startQName, bi, xsr});
                    throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_READ_EXC", LOG, new Object[0]));
                }
                BindingOperationInfo bindingOperationInfo = boi;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bindingOperationInfo = bindingOperationInfo;
                    LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "getBindingOperationInfo", bindingOperationInfo);
                }
                return bindingOperationInfo;
            }
            List bodyParts = bmi.getMessageParts();
            if (bodyParts.size() != 1 || !(p = (MessagePartInfo)bodyParts.iterator().next()).getConcreteName().equals(startQName)) continue;
            BindingOperationInfo bindingOperationInfo = boi;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bindingOperationInfo = bindingOperationInfo;
                LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "getBindingOperationInfo", bindingOperationInfo);
            }
            return bindingOperationInfo;
        }
        for (BindingOperationInfo boi : bi.getOperations()) {
            if (!startQName.equals(boi.getName())) continue;
            try {
                xsr.nextTag();
            }
            catch (XMLStreamException bmi) {
                FFDCFilter.processException((Throwable)bmi, (String)"org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", (String)"145", (Object)((Object)this), (Object[])new Object[]{isRequestor, startQName, bi, xsr});
                throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_READ_EXC", LOG, new Object[0]));
            }
            BindingOperationInfo bindingOperationInfo = boi;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bindingOperationInfo = bindingOperationInfo;
                LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "getBindingOperationInfo", bindingOperationInfo);
            }
            return bindingOperationInfo;
        }
        BindingOperationInfo bindingOperationInfo = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingOperationInfo = bindingOperationInfo;
            LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "getBindingOperationInfo", bindingOperationInfo);
        }
        return bindingOperationInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean hasRootNode(BindingMessageInfo bmi, QName elName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "hasRootNode", new Object[]{bmi, elName});
        }
        XMLBindingMessageFormat xmf = (XMLBindingMessageFormat)((Object)bmi.getExtensor(XMLBindingMessageFormat.class));
        boolean bl = bmi.getMessageParts().size() != 1 && xmf != null && xmf.getRootNode().equals(elName);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor", "hasRootNode", bl);
        }
        return bl;
    }
}

