/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.cmdline;

import com.ibm.ws.kernel.boot.cmdline.UtilityMain;
import java.util.ResourceBundle;

public class Main {
    private static final int CLASS_MAJOR_VERSION_JAVA7 = 51;
    private static final int ERROR_BAD_JAVA_VERSION = 30;
    private static final int ERROR_BAD_JAVA_BITMODE = 31;

    protected static void invokeMain(String[] args) {
    }

    public static void main(String[] args) {
        String bitmode;
        String osName;
        if (Main.getClassMajorVersion() < 51) {
            Main.badVersion();
        }
        if ((osName = System.getProperty("os.name")).equals("z/OS") && (bitmode = System.getProperty("com.ibm.vm.bitmode")).equals("32")) {
            Main.badBitMode();
        }
        try {
            UtilityMain.main(args);
            System.exit(0);
        }
        catch (UnsupportedClassVersionError versionError) {
            Main.badVersion();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(30);
        }
    }

    private static void badVersion() {
        System.out.println(ResourceBundle.getBundle("com.ibm.ws.jaxrs20.tools.internal.resources.JaxRsToolsMessages").getString("error.badVersion"));
        System.exit(30);
    }

    private static void badBitMode() {
        System.out.println(ResourceBundle.getBundle("com.ibm.ws.kernel.boot.resources.LauncherMessages").getString("error.badBitmode"));
        System.exit(31);
    }

    private static int getClassMajorVersion() {
        String classVersion = System.getProperty("java.class.version");
        if (classVersion == null) {
            return 51;
        }
        int index = classVersion.indexOf(46);
        String majorVersion = index == -1 ? classVersion : classVersion.substring(0, index);
        try {
            return Integer.parseInt(majorVersion);
        }
        catch (NumberFormatException ex) {
            return 51;
        }
    }
}

