/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.LockStore;
import org.jboss.weld.context.beanstore.MapBeanStore;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.reflection.Reflections;

public class SessionMapBeanStore
extends MapBeanStore {
    private static final String LOCK_STORE_KEY = "org.jboss.weld.context.beanstore.LockStore";

    public SessionMapBeanStore(NamingScheme namingScheme, Map<String, Object> delegate) {
        super(namingScheme, delegate, delegate instanceof ConcurrentHashMap);
    }

    @Override
    public <T> ContextualInstance<T> get(BeanIdentifier id) {
        ContextualInstance instance = super.get(id);
        if (instance == null && this.isAttached()) {
            String prefixedId = this.getNamingScheme().prefix(id);
            instance = (ContextualInstance)Reflections.cast((Object)this.getAttribute(prefixedId));
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public LockStore getLockStore() {
        LockStore lockStore = this.lockStore;
        if (lockStore != null) return lockStore;
        lockStore = (LockStore)this.getAttribute(LOCK_STORE_KEY);
        if (lockStore == null) {
            Class<SessionMapBeanStore> clazz = SessionMapBeanStore.class;
            // MONITORENTER : org.jboss.weld.context.beanstore.SessionMapBeanStore.class
            lockStore = (LockStore)this.getAttribute(LOCK_STORE_KEY);
            if (lockStore == null) {
                lockStore = new LockStore();
                this.setAttribute(LOCK_STORE_KEY, lockStore);
            }
            // MONITOREXIT : clazz
        }
        this.lockStore = lockStore;
        return lockStore;
    }
}

