/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.config;

import com.ibm.ws.request.timing.config.ContextInfoPattern;
import com.ibm.ws.request.timing.config.Timing;
import java.util.HashMap;
import java.util.Map;

public class RequestTimingConfig {
    private final int sampleRate;
    private final int contextInfoRequirement;
    private final long requestThresholdMin;
    private final long requestThresholdMax;
    private final Map<String, Map<ContextInfoPattern, Timing>> requestTiming;
    private final Timing defaultRequestTiming;

    public RequestTimingConfig(int sampleRate, int contextInfoRequirement, Map<String, Map<ContextInfoPattern, Timing>> requestTiming) {
        Map<ContextInfoPattern, Timing> defaultTimingMap;
        this.sampleRate = sampleRate;
        this.contextInfoRequirement = contextInfoRequirement;
        this.requestTiming = requestTiming;
        this.requestThresholdMin = this.getReqThresholdMin();
        this.requestThresholdMax = this.getReqThresholdMax();
        this.defaultRequestTiming = this.requestTiming.containsKey("all") ? ((defaultTimingMap = this.requestTiming.get("all")).containsKey(ContextInfoPattern.ALL) ? defaultTimingMap.get(ContextInfoPattern.ALL) : null) : null;
    }

    public RequestTimingConfig() {
        this(1, 2, new HashMap<String, Map<ContextInfoPattern, Timing>>());
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getContextInfoRequirement() {
        return this.contextInfoRequirement;
    }

    public Map<String, Map<ContextInfoPattern, Timing>> getRequestTiming() {
        return this.requestTiming;
    }

    public long getRequestThresholdMin() {
        return this.requestThresholdMin;
    }

    public long getRequestThresholdMax() {
        return this.requestThresholdMax;
    }

    public long getRequestThreshold(String type, String contextInfo) {
        return this.getTiming(type, contextInfo).getRequestThreshold();
    }

    protected Timing getTiming(String type, String contextInfo) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 'type' can not be null");
        }
        if (this.requestTiming.containsKey(type)) {
            int bestMatchScore = Integer.MIN_VALUE;
            Timing bestMatch = null;
            Map<ContextInfoPattern, Timing> timingMapForType = this.requestTiming.get(type);
            for (ContextInfoPattern contextInfoPattern : timingMapForType.keySet()) {
                int score;
                if (contextInfoPattern == null || (score = contextInfoPattern.getMatchScore(contextInfo)) <= bestMatchScore) continue;
                bestMatchScore = score;
                bestMatch = timingMapForType.get(contextInfoPattern);
            }
            if (bestMatch != null) {
                return bestMatch;
            }
        }
        return this.defaultRequestTiming;
    }

    private long getReqThresholdMin() {
        long requestThreasholdMin = Long.MAX_VALUE;
        for (Map<ContextInfoPattern, Timing> typeMap : this.requestTiming.values()) {
            for (Timing t : typeMap.values()) {
                long curThreshold = t.getRequestThreshold();
                if (curThreshold <= 0L) continue;
                requestThreasholdMin = Math.min(requestThreasholdMin, curThreshold);
            }
        }
        if (requestThreasholdMin == Long.MAX_VALUE) {
            requestThreasholdMin = 0L;
        }
        return requestThreasholdMin;
    }

    private long getReqThresholdMax() {
        long requestThreasholdMax = Long.MIN_VALUE;
        for (Map<ContextInfoPattern, Timing> typeMap : this.requestTiming.values()) {
            for (Timing t : typeMap.values()) {
                requestThreasholdMax = Math.max(requestThreasholdMax, t.getRequestThreshold());
            }
        }
        return requestThreasholdMax;
    }
}

