/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.war.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.war.internal.WARDeployedAppInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ApplicationHandler.class}, property={"service.vendor=IBM", "type:String=war"})
public class WARApplicationHandlerImpl
implements ApplicationHandler<DeployedAppInfo> {
    private FutureMonitor futureMonitor;
    private DeployedAppInfoFactory deployedAppFactory;
    static final long serialVersionUID = 4622845147410944782L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Reference
    protected void setFutureMonitor(FutureMonitor fm) {
        this.futureMonitor = fm;
    }

    @Reference(target="(type=war)")
    protected void setDeployedAppFactory(DeployedAppInfoFactory factory) {
        this.deployedAppFactory = factory;
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationMonitoringInformation setUpApplicationMonitoring(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        WARDeployedAppInfo deployedApp;
        Container oldContainer = applicationInformation.getContainer();
        try {
            deployedApp = (WARDeployedAppInfo)this.deployedAppFactory.createDeployedAppInfo(applicationInformation);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.war.internal.WARApplicationHandlerImpl", (String)"51", (Object)this, (Object[])new Object[]{applicationInformation});
            throw new IllegalStateException((Throwable)e);
        }
        return deployedApp.createApplicationMonitoringInformation(oldContainer);
    }

    public Future<Boolean> install(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        Future result = this.futureMonitor.createFuture(Boolean.class);
        WARDeployedAppInfo deployedApp = (WARDeployedAppInfo)((Object)applicationInformation.getHandlerInfo());
        if (!deployedApp.deployApp(result)) {
            this.futureMonitor.setResult(result, (Object)false);
            return result;
        }
        return result;
    }

    public Future<Boolean> uninstall(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        WARDeployedAppInfo deployedApp = (WARDeployedAppInfo)((Object)applicationInformation.getHandlerInfo());
        if (deployedApp == null) {
            return this.futureMonitor.createFutureWithResult((Object)false);
        }
        boolean success = deployedApp.uninstallApp();
        return this.futureMonitor.createFutureWithResult((Object)success);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(WARApplicationHandlerImpl.class);
    }
}

