/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBus;
import com.ibm.ws.jaxrs20.client.bus.LibertyJAXRSClientBusFactory;
import com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientProxyInterceptor;
import com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientTimeOutInterceptor;
import com.ibm.ws.jaxrs20.client.security.LibertyJaxRsClientSSLOutInterceptor;
import com.ibm.ws.jaxrs20.client.security.ltpa.LibertyJaxRsClientLtpaInterceptor;
import com.ibm.ws.jaxrs20.client.security.oauth.LibertyJaxRsClientOAuthInterceptor;
import com.ibm.ws.jaxrs20.client.security.saml.PropagationHandler;
import com.ibm.ws.jaxrs20.client.util.JaxRSClientUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spec.ClientImpl;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JAXRSClientImpl
extends ClientImpl {
    protected boolean closed;
    protected Set<WebClient> baseClients = new HashSet<WebClient>();
    protected boolean hasSSLConfigInfo = false;
    private TLSConfiguration secConfig = null;
    private final Map<String, LibertyApplicationBus> busCache = new ConcurrentHashMap<String, LibertyApplicationBus>();
    static final long serialVersionUID = 6238296446021351668L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JAXRSClientImpl(Configuration config, TLSConfiguration secConfig) {
        super(config, secConfig);
        this.secConfig = secConfig;
        TLSClientParameters ttClientParams = secConfig.getTlsClientParams();
        if (secConfig.getSslContext() != null || ttClientParams.getTrustManagers() != null && ttClientParams.getTrustManagers().length > 0 && ttClientParams.getKeyManagers() != null && ttClientParams.getKeyManagers().length > 0) {
            this.hasSSLConfigInfo = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebTarget target(UriBuilder builder) {
        LibertyApplicationBus bus;
        ClientImpl.WebTargetImpl wt = (ClientImpl.WebTargetImpl)super.target(builder);
        JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
        URI uri = builder.build(new Object[0]);
        bean.setAddress(uri.toString());
        WebClient targetClient = bean.createWebClient();
        ClientConfiguration ccfg = WebClient.getConfig((Object)targetClient);
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientTimeOutInterceptor("pre-logical"));
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientProxyInterceptor("pre-logical"));
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientLtpaInterceptor());
        ccfg.getOutInterceptors().add(new LibertyJaxRsClientOAuthInterceptor());
        ccfg.getOutInterceptors().add(new PropagationHandler());
        if (!this.hasSSLConfigInfo) {
            LibertyJaxRsClientSSLOutInterceptor sslOutInterceptor = new LibertyJaxRsClientSSLOutInterceptor("pre-logical");
            sslOutInterceptor.setTLSConfiguration(this.secConfig);
            ccfg.getOutInterceptors().add(sslOutInterceptor);
        }
        String id = JaxRSClientUtil.convertURItoBusId(uri.toString());
        Map<String, LibertyApplicationBus> map = this.busCache;
        synchronized (map) {
            bus = this.busCache.get(id);
            if (bus == null) {
                bus = LibertyJAXRSClientBusFactory.getInstance().getClientScopeBus(id);
                this.busCache.put(id, bus);
            }
        }
        ccfg.setBus((Bus)bus);
        this.baseClients.add(targetClient);
        return new ClientImpl.WebTargetImpl((ClientImpl)this, wt.getUriBuilder(), wt.getConfiguration(), targetClient);
    }

    public void close() {
        super.close();
        for (WebClient wc : this.baseClients) {
            wc.close();
        }
        for (LibertyApplicationBus bus : this.busCache.values()) {
            bus.shutdown(false);
        }
        this.busCache.clear();
        this.baseClients = null;
    }

    public Map<String, LibertyApplicationBus> getBusCache() {
        return this.busCache;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JAXRSClientImpl.class);
    }
}

