/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.config.ConfigException;
import com.ibm.ws.transport.iiop.security.config.tss.TSSServiceConfigurationConfig;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.omg.CSIIOP.ServiceConfiguration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TSSUnknownServiceConfigurationConfig
extends TSSServiceConfigurationConfig {
    private final int syntax;
    private final byte[] name;
    static final long serialVersionUID = -6331495681002618432L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TSSUnknownServiceConfigurationConfig(int syntax, byte[] name) {
        this.syntax = syntax;
        this.name = Arrays.copyOf(name, name.length);
    }

    @Override
    public ServiceConfiguration generateServiceConfiguration() throws ConfigException {
        ServiceConfiguration config = new ServiceConfiguration();
        config.syntax = this.syntax;
        config.name = this.name;
        return config;
    }

    @Override
    @FFDCIgnore(value={UnsupportedEncodingException.class})
    void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("TSSUnknownServiceConfigurationConfig: [\n");
        buf.append(moreSpaces).append("syntax VMCID : ").append(Integer.toHexString(this.syntax >> 12)).append("\n");
        buf.append(moreSpaces).append("syntax organization-scoped syntax identifier : ").append(Integer.toHexString(this.syntax & 0xFFF)).append("\n");
        try {
            buf.append(moreSpaces).append("name: ").append(Arrays.asList(new byte[][]{this.name})).append(" (").append(new String(this.name, "ISO-8859-1")).append(")\n");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        buf.append(spaces).append("]\n");
    }

    public int getSyntax() {
        return this.syntax;
    }

    public byte[] getName() {
        return Arrays.copyOf(this.name, this.name.length);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSUnknownServiceConfigurationConfig.class);
    }
}

