/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.asn1.pkcs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.asn1.ASN1Encodable;
import com.ibm.ws.transport.iiop.asn1.ASN1EncodableVector;
import com.ibm.ws.transport.iiop.asn1.ASN1InputStream;
import com.ibm.ws.transport.iiop.asn1.ASN1OctetString;
import com.ibm.ws.transport.iiop.asn1.ASN1Sequence;
import com.ibm.ws.transport.iiop.asn1.ASN1Set;
import com.ibm.ws.transport.iiop.asn1.ASN1TaggedObject;
import com.ibm.ws.transport.iiop.asn1.DERInteger;
import com.ibm.ws.transport.iiop.asn1.DERObject;
import com.ibm.ws.transport.iiop.asn1.DEROctetString;
import com.ibm.ws.transport.iiop.asn1.DERSequence;
import com.ibm.ws.transport.iiop.asn1.DERTaggedObject;
import com.ibm.ws.transport.iiop.asn1.x509.AlgorithmIdentifier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PrivateKeyInfo
extends ASN1Encodable {
    private DERObject privKey;
    private AlgorithmIdentifier algId;
    private ASN1Set attributes;
    static final long serialVersionUID = -9018008828121597052L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static PrivateKeyInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PrivateKeyInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static PrivateKeyInfo getInstance(Object obj) {
        if (obj instanceof PrivateKeyInfo) {
            return (PrivateKeyInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PrivateKeyInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public PrivateKeyInfo(AlgorithmIdentifier algId, DERObject privateKey) {
        this.privKey = privateKey;
        this.algId = algId;
    }

    /*
     * WARNING - void declaration
     */
    public PrivateKeyInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        BigInteger version = ((DERInteger)e.nextElement()).getValue();
        if (version.intValue() != 0) {
            throw new IllegalArgumentException("wrong version for private key info");
        }
        this.algId = new AlgorithmIdentifier((ASN1Sequence)e.nextElement());
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(((ASN1OctetString)e.nextElement()).getOctets());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            this.privKey = aIn.readObject();
        }
        catch (IOException bIn) {
            void ex;
            FFDCFilter.processException((Throwable)bIn, (String)"com.ibm.ws.transport.iiop.asn1.pkcs.PrivateKeyInfo", (String)"94", (Object)this, (Object[])new Object[]{seq});
            throw new IllegalArgumentException("Error recoverying private key from sequence", (Throwable)ex);
        }
        if (e.hasMoreElements()) {
            this.attributes = ASN1Set.getInstance((ASN1TaggedObject)e.nextElement(), false);
        }
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public DERObject getPrivateKey() {
        return this.privKey;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(0));
        v.add(this.algId);
        v.add(new DEROctetString(this.privKey));
        if (this.attributes != null) {
            v.add(new DERTaggedObject(false, 0, this.attributes));
        }
        return new DERSequence(v);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(PrivateKeyInfo.class);
    }
}

