/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.osgi.internal;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ejbcontainer.osgi.BeanRuntime;
import com.ibm.ws.ejbcontainer.osgi.EJBRuntimeVersion;
import com.ibm.ws.ejbcontainer.osgi.MDBRuntime;
import com.ibm.ws.ejbcontainer.osgi.ManagedBeanRuntime;
import com.ibm.ws.ejbcontainer.osgi.SessionBeanRuntime;
import com.ibm.ws.ejbcontainer.osgi.internal.BeanInitDataImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.BeanMergeData;
import com.ibm.ws.ejbcontainer.osgi.internal.ModuleInitDataImpl;
import com.ibm.ws.ejbcontainer.osgi.internal.ModuleMergeData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.commonbnd.RefBindingsGroup;
import com.ibm.ws.javaee.dd.ejb.ActivationConfig;
import com.ibm.ws.javaee.dd.ejb.ActivationConfigProperty;
import com.ibm.ws.javaee.dd.ejb.ComponentViewableBean;
import com.ibm.ws.javaee.dd.ejb.DependsOn;
import com.ibm.ws.javaee.dd.ejb.EJBJar;
import com.ibm.ws.javaee.dd.ejb.Entity;
import com.ibm.ws.javaee.dd.ejb.Interceptor;
import com.ibm.ws.javaee.dd.ejb.Session;
import com.ibm.ws.javaee.dd.ejbbnd.EJBJarBnd;
import com.ibm.ws.javaee.dd.ejbbnd.EnterpriseBean;
import com.ibm.ws.javaee.dd.ejbext.EJBJarExt;
import com.ibm.ws.javaee.dd.managedbean.ManagedBeanBnd;
import com.ibm.ws.metadata.ejb.BeanInitData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.info.MethodInfo;
import com.ibm.wsspi.anno.service.AnnotationService_Service;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.ManagedBean;
import javax.ejb.Local;
import javax.ejb.LocalBean;
import javax.ejb.LocalHome;
import javax.ejb.MessageDriven;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.Schedule;
import javax.ejb.Schedules;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.Interceptors;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ModuleInitDataFactory.class})
public class ModuleInitDataFactory {
    private static final TraceComponent tc = Tr.register(ModuleInitDataFactory.class);
    private static final String[] KIND_ELEMENT_DISPLAY_NAMES = new String[3];
    private static final String[] TYPE_TO_ANNOTATION_DISPLAY_NAMES;
    private static final String[] TYPE_TO_SESSION_TYPE_VALUES;
    private static final int[] SESSION_TYPE_TO_BEAN_TYPE;
    private static final int[] ENTITY_PERSISTENCE_TYPE_TO_BEAN_TYPE;
    private static final int[] ENTITY_CMP_VERSION_TO_BEAN_CMP_VERSION;
    private static final Version DEFAULT_VERSION;
    private static final String REFERENCE_ANNOTATION_SERVICE = "annoService";
    private static final String REFERENCE_J2EE_NAME_FACTORY = "j2eeNameFactory";
    private static final String REFERENCE_SESSION_BEAN_RUNTIME = "sessionBeanRuntime";
    private static final String REFERENCE_MDB_RUNTIME = "mdbRuntime";
    private static final String REFERENCE_MANAGED_BEAN_RUNTIME = "managedBeanRuntime";
    private final AtomicServiceReference<AnnotationService_Service> annoServiceSRRef = new AtomicServiceReference("annoService");
    private final AtomicServiceReference<J2EENameFactory> j2eeNameFactorySRRef = new AtomicServiceReference("j2eeNameFactory");
    private final AtomicServiceReference<SessionBeanRuntime> sessionBeanRuntimeSRRef = new AtomicServiceReference("sessionBeanRuntime");
    private final AtomicServiceReference<MDBRuntime> mdbRuntimeSRRef = new AtomicServiceReference("mdbRuntime");
    private final AtomicServiceReference<ManagedBeanRuntime> managedBeanRuntimeSRRef = new AtomicServiceReference("managedBeanRuntime");
    private Version runtimeVersion = DEFAULT_VERSION;
    static final long serialVersionUID = -2559675299337556419L;

    @Activate
    protected void activate(ComponentContext context) {
        this.annoServiceSRRef.activate(context);
        this.j2eeNameFactorySRRef.activate(context);
        this.sessionBeanRuntimeSRRef.activate(context);
        this.mdbRuntimeSRRef.activate(context);
        this.managedBeanRuntimeSRRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.annoServiceSRRef.deactivate(context);
        this.j2eeNameFactorySRRef.deactivate(context);
        this.sessionBeanRuntimeSRRef.deactivate(context);
        this.mdbRuntimeSRRef.deactivate(context);
        this.managedBeanRuntimeSRRef.deactivate(context);
    }

    @Reference(service=EJBRuntimeVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEJBRuntimeVersion(ServiceReference<EJBRuntimeVersion> ref) {
        this.runtimeVersion = Version.parseVersion((String)((String)ref.getProperty("version")));
    }

    protected void unsetEJBRuntimeVersion(ServiceReference<EJBRuntimeVersion> ref) {
        this.runtimeVersion = DEFAULT_VERSION;
    }

    @Reference(name="annoService", service=AnnotationService_Service.class)
    protected void setAnnoService(ServiceReference<AnnotationService_Service> ref) {
        this.annoServiceSRRef.setReference(ref);
    }

    protected void unsetAnnoService(ServiceReference<AnnotationService_Service> ref) {
        this.annoServiceSRRef.unsetReference(ref);
    }

    @Reference(name="j2eeNameFactory", service=J2EENameFactory.class)
    protected void setJ2eeNameFactory(ServiceReference<J2EENameFactory> ref) {
        this.j2eeNameFactorySRRef.setReference(ref);
    }

    protected void unsetJ2eeNameFactory(ServiceReference<J2EENameFactory> ref) {
        this.j2eeNameFactorySRRef.unsetReference(ref);
    }

    @Reference(name="sessionBeanRuntime", service=SessionBeanRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setSessionBeanRuntime(ServiceReference<SessionBeanRuntime> ref) {
        this.sessionBeanRuntimeSRRef.setReference(ref);
    }

    protected void unsetSessionBeanRuntime(ServiceReference<SessionBeanRuntime> ref) {
        this.sessionBeanRuntimeSRRef.unsetReference(ref);
    }

    @Reference(name="mdbRuntime", service=MDBRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setMDBRuntime(ServiceReference<MDBRuntime> ref) {
        this.mdbRuntimeSRRef.setReference(ref);
    }

    protected void unsetMDBRuntime(ServiceReference<MDBRuntime> ref) {
        this.mdbRuntimeSRRef.unsetReference(ref);
    }

    @Reference(name="managedBeanRuntime", service=ManagedBeanRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedBeanRuntime(ServiceReference<ManagedBeanRuntime> ref) {
        this.managedBeanRuntimeSRRef.setReference(ref);
    }

    protected void unsetManagedBeanRuntime(ServiceReference<ManagedBeanRuntime> ref) {
        this.managedBeanRuntimeSRRef.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    ModuleInitDataImpl createModuleInitData(Container container2, ClassLoader classLoader, String modName, String modLogicalName, String appName, AnnotationTargets_Targets annoTargets, InfoStore infoStore, boolean defaultMetadataComplete) throws EJBConfigurationException {
        SessionBeanRuntime sessionBeanRuntime = (SessionBeanRuntime)this.sessionBeanRuntimeSRRef.getService();
        MDBRuntime mdbRuntime = (MDBRuntime)this.mdbRuntimeSRRef.getService();
        EJBJar ejbJar = null;
        if (sessionBeanRuntime != null || mdbRuntime != null) {
            try {
                ejbJar = (EJBJar)container2.adapt(EJBJar.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.ejbcontainer.osgi.internal.ModuleInitDataFactory", (String)"279", (Object)this, (Object[])new Object[]{container2, classLoader, modName, modLogicalName, appName, annoTargets, infoStore, defaultMetadataComplete});
                throw new EJBConfigurationException((Throwable)e);
            }
        }
        J2EENameFactory j2eeNameFactory = (J2EENameFactory)this.j2eeNameFactorySRRef.getService();
        ModuleInitDataImpl mid = new ModuleInitDataImpl(modName, appName, ejbJar == null ? 30 : ejbJar.getVersionID(), sessionBeanRuntime, mdbRuntime, (ManagedBeanRuntime)this.managedBeanRuntimeSRRef.getService());
        mid.container = container2;
        mid.ivLogicalName = modLogicalName;
        mid.ivJ2EEName = j2eeNameFactory.create(mid.ivAppName, mid.ivName, null);
        mid.ivEJBJar = ejbJar;
        ModuleMergeData modMergeData = new ModuleMergeData(mid, container2, annoTargets, infoStore);
        if (mid.ivEJBJar == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"mid.ivEJBJar == null", (Object[])new Object[0]);
            }
            mid.ivMetadataComplete = defaultMetadataComplete;
        } else {
            mid.ivMetadataComplete = mid.ivEJBJar.getVersionID() < 30 || mid.ivEJBJar.isMetadataComplete();
            com.ibm.ws.javaee.dd.ejb.Interceptors interceptors = mid.ivEJBJar.getInterceptors();
            if (interceptors != null) {
                for (Interceptor interceptor : interceptors.getInterceptorList()) {
                    mid.addEJBInterceptor(interceptor.getInterceptorClassName());
                }
            }
            block15: for (com.ibm.ws.javaee.dd.ejb.EnterpriseBean enterpriseBean : mid.ivEJBJar.getEnterpriseBeans()) {
                String name = enterpriseBean.getName();
                if (modMergeData.getBeanMergeData(name) != null) {
                    Tr.error((TraceComponent)tc, (String)"DUPLICATE_EJB_CNTR4100E", (Object[])new Object[]{name});
                    modMergeData.error();
                    continue;
                }
                BeanMergeData beanMergeData = modMergeData.createBeanMergeDataFromXML(name, enterpriseBean.getEjbClassName());
                BeanInitDataImpl bid2 = beanMergeData.getBeanInitData();
                bid2.ivEnterpriseBean = enterpriseBean;
                switch (enterpriseBean.getKindValue()) {
                    case 0: {
                        DependsOn dependsOn;
                        Session session = (Session)enterpriseBean;
                        beanMergeData.setType(SESSION_TYPE_TO_BEAN_TYPE[1 + session.getSessionTypeValue()], mid.sessionBeanRuntime);
                        this.processComponentViewableBean(bid2, (ComponentViewableBean)session);
                        for (String interfaceName : session.getRemoteBusinessInterfaceNames()) {
                            beanMergeData.addRemoteBusinessInterfaceName(interfaceName);
                        }
                        for (String interfaceName : session.getLocalBusinessInterfaceNames()) {
                            beanMergeData.addLocalBusinessInterfaceName(interfaceName);
                        }
                        bid2.ivLocalBean = session.isLocalBean();
                        bid2.ivWebServiceEndpointInterfaceName = session.getServiceEndpointInterfaceName();
                        int tranType = session.getTransactionTypeValue();
                        if (tranType != -1) {
                            beanMergeData.setBeanManagedTransaction(tranType == 0);
                        }
                        bid2.ivHasScheduleTimers = !session.getTimers().isEmpty();
                        if (session.isSetInitOnStartup()) {
                            beanMergeData.setStartup(session.isInitOnStartup());
                        }
                        if ((dependsOn = session.getDependsOn()) != null) {
                            bid2.ivDependsOn = new LinkedHashSet<String>(dependsOn.getEjbName());
                        }
                        if (session.getTimeoutMethod() != null) {
                            mid.ivHasTimers = true;
                        }
                        if (!session.isSetPassivationCapable()) continue block15;
                        beanMergeData.setPassivationCapable(session.isPassivationCapable());
                        continue block15;
                    }
                    case 2: {
                        int tranType;
                        com.ibm.ws.javaee.dd.ejb.MessageDriven messageDriven = (com.ibm.ws.javaee.dd.ejb.MessageDriven)enterpriseBean;
                        beanMergeData.setType(7, mid.mdbRuntime);
                        bid2.ivMessageListenerInterfaceName = messageDriven.getMessagingTypeName();
                        ActivationConfig activationConfig = messageDriven.getActivationConfigValue();
                        bid2.ivActivationConfigProperties = new Properties();
                        if (activationConfig != null) {
                            for (ActivationConfigProperty property : activationConfig.getConfigProperties()) {
                                bid2.ivActivationConfigProperties.put(property.getName(), property.getValue());
                            }
                        }
                        if ((tranType = messageDriven.getTransactionTypeValue()) != -1) {
                            beanMergeData.setBeanManagedTransaction(tranType == 0);
                        }
                        bid2.ivHasScheduleTimers = !messageDriven.getTimers().isEmpty();
                        if (messageDriven.getTimeoutMethod() == null) continue block15;
                        mid.ivHasTimers = true;
                        continue block15;
                    }
                    case 1: {
                        Entity entity = (Entity)enterpriseBean;
                        beanMergeData.setType(ENTITY_PERSISTENCE_TYPE_TO_BEAN_TYPE[entity.getPersistenceTypeValue()], null);
                        this.processComponentViewableBean(bid2, (ComponentViewableBean)entity);
                        bid2.ivCMPVersion = ENTITY_CMP_VERSION_TO_BEAN_CMP_VERSION[1 + entity.getCMPVersionValue()];
                        bid2.ivHasScheduleTimers = false;
                        continue block15;
                    }
                }
                throw new IllegalStateException("unknown kind " + enterpriseBean.getKindValue() + ": " + enterpriseBean);
            }
        }
        if (!mid.ivMetadataComplete || modMergeData.isManagedBeanEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing annotations : mid.ivMetadataComplete=" + mid.ivMetadataComplete), (Object[])new Object[0]);
            }
            AnnotationTargets_Targets targets = modMergeData.getAnnotationTargets();
            infoStore = modMergeData.getInfoStore();
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            if (!mid.ivMetadataComplete && modMergeData.isEJBEnabled()) {
                linkedHashSet.addAll(targets.getAnnotatedClasses(Stateless.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                linkedHashSet.addAll(targets.getAnnotatedClasses(Stateful.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                linkedHashSet.addAll(targets.getAnnotatedClasses(Singleton.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
                linkedHashSet.addAll(targets.getAnnotatedClasses(MessageDriven.class.getName(), AnnotationTargets_Targets.POLICY_SEED));
            }
            if (modMergeData.isManagedBeanEnabled()) {
                linkedHashSet.addAll(targets.getAnnotatedClasses(ManagedBean.class.getName(), AnnotationTargets_Targets.POLICY_ALL_EXCEPT_EXTERNAL));
            }
            for (String className : linkedHashSet) {
                ClassInfo classInfo = infoStore.getDelayableClassInfo(className);
                this.mergeComponentDefiningAnnotations(classInfo, null, modMergeData, mid.ivMetadataComplete);
            }
        }
        for (BeanMergeData beanMergeData : modMergeData.getBeans()) {
            BeanInitDataImpl beanInitDataImpl = beanMergeData.getBeanInitData();
            if (beanInitDataImpl.ivClassName == null) {
                Tr.error((TraceComponent)tc, (String)"UNSPECIFIED_CLASS_CNTR4101E", (Object[])new Object[]{beanInitDataImpl.ivName});
                modMergeData.error();
                continue;
            }
            if (!mid.ivMetadataComplete && beanMergeData.getClassInfo().isArtificial()) {
                Tr.error((TraceComponent)tc, (String)"INVALID_CLASS_CNTR4115E", (Object[])new Object[]{beanInitDataImpl.ivClassName, beanInitDataImpl.ivName});
                beanMergeData.getModuleMergeData().error();
                continue;
            }
            if (beanInitDataImpl.ivType == 1) {
                if (!mid.ivMetadataComplete) {
                    this.mergeComponentDefiningAnnotations(beanMergeData.getClassInfo(), beanMergeData, modMergeData, false);
                }
                if (beanInitDataImpl.ivType == 1) {
                    Tr.error((TraceComponent)tc, (String)"UNSPECIFIED_SESSION_TYPE_CNTR4102E", (Object[])new Object[]{beanInitDataImpl.ivName});
                    modMergeData.error();
                    continue;
                }
            }
            switch (beanInitDataImpl.ivType) {
                case 2: 
                case 3: 
                case 4: {
                    if (mid.ivMetadataComplete) break;
                    this.mergeSessionInterfaces(beanMergeData);
                    this.mergeTransactionManagement(beanMergeData);
                    this.mergeSingleton(beanMergeData);
                    this.mergeScheduleTimers(beanMergeData);
                    break;
                }
                case 7: {
                    if (mid.ivMetadataComplete) break;
                    this.mergeMessagingInterface(beanMergeData);
                    this.mergeTransactionManagement(beanMergeData);
                    this.mergeScheduleTimers(beanMergeData);
                    break;
                }
                case 8: {
                    beanInitDataImpl.ivLocalBean = true;
                    beanInitDataImpl.ivHasScheduleTimers = Boolean.FALSE;
                    beanMergeData.setBeanManagedTransaction(true);
                    break;
                }
            }
            beanMergeData.merge();
            Collection<String> remoteBusiness = beanMergeData.getRemoteBusinessInterfaceNames();
            Collection<String> localBusiness = beanMergeData.getLocalBusinessInterfaceNames();
            if (remoteBusiness.isEmpty() || localBusiness.isEmpty()) continue;
            HashSet<String> localBusinessSet = new HashSet<String>(localBusiness);
            for (String interfaceName : remoteBusiness) {
                if (!localBusinessSet.contains(interfaceName)) continue;
                Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_INTERFACE_TYPE_CNTR4110E", (Object[])new Object[]{beanInitDataImpl.ivName, interfaceName});
                beanMergeData.getModuleMergeData().error();
            }
        }
        if (modMergeData.hasErrors()) {
            throw new EJBConfigurationException("Errors occurred processing EJB metadata");
        }
        try {
            BeanInitDataImpl bid;
            if (modMergeData.isEJBEnabled()) {
                mid.ejbJarExtension = (EJBJarExt)container2.adapt(EJBJarExt.class);
                if (mid.ejbJarExtension != null) {
                    Map beanExts = this.getExtensions(mid.ejbJarExtension.getEnterpriseBeans());
                    for (BeanMergeData beanMergeData : modMergeData.getBeans()) {
                        BeanInitDataImpl bid3 = beanMergeData.getBeanInitData();
                        if (bid3.ivType == 8) continue;
                        bid3.enterpriseBeanExt = (com.ibm.ws.javaee.dd.ejbext.EnterpriseBean)beanExts.remove(bid3.getName());
                    }
                    for (Map.Entry entry : beanExts.entrySet()) {
                        String elementName = entry.getValue() instanceof com.ibm.ws.javaee.dd.ejbext.Session ? "<session>" : "<message-driven>";
                        Tr.warning((TraceComponent)tc, (String)"ORPHAN_EXTENSION_ENTRY_CNTR4112W", (Object[])new Object[]{elementName, mid.ivLogicalName, entry.getKey()});
                    }
                }
                mid.ejbJarBinding = (EJBJarBnd)container2.adapt(EJBJarBnd.class);
                if (mid.ejbJarBinding != null) {
                    Map beanBnds = this.getBindings(mid.ejbJarBinding.getEnterpriseBeans());
                    for (BeanMergeData beanMergeData : modMergeData.getBeans()) {
                        bid = beanMergeData.getBeanInitData();
                        if (bid.ivType == 8) continue;
                        bid.beanBnd = (RefBindingsGroup)beanBnds.get(bid.getName());
                    }
                    HashMap<String, com.ibm.ws.javaee.dd.commonbnd.Interceptor> hashMap = new HashMap<String, com.ibm.ws.javaee.dd.commonbnd.Interceptor>();
                    for (com.ibm.ws.javaee.dd.commonbnd.Interceptor interceptorBnd : mid.ejbJarBinding.getInterceptors()) {
                        hashMap.put(interceptorBnd.getClassName(), interceptorBnd);
                    }
                    mid.ejbJarInterceptorBindings = hashMap;
                }
            }
            if (modMergeData.isManagedBeanEnabled()) {
                mid.managedBeanBinding = (ManagedBeanBnd)container2.adapt(ManagedBeanBnd.class);
                if (mid.managedBeanBinding != null) {
                    Map managedBeanBindings = this.getManagedBeanBindings(mid.managedBeanBinding.getManagedBeans());
                    for (BeanMergeData beanMergeData : modMergeData.getBeans()) {
                        bid = beanMergeData.getBeanInitData();
                        if (bid.ivType != 8) continue;
                        bid.beanBnd = (RefBindingsGroup)managedBeanBindings.get(bid.ivClassName);
                    }
                    HashMap<String, com.ibm.ws.javaee.dd.commonbnd.Interceptor> hashMap = new HashMap<String, com.ibm.ws.javaee.dd.commonbnd.Interceptor>();
                    for (com.ibm.ws.javaee.dd.commonbnd.Interceptor interceptorBnd : mid.managedBeanBinding.getInterceptors()) {
                        hashMap.put(interceptorBnd.getClassName(), interceptorBnd);
                    }
                    mid.managedBeanInterceptorBindings = hashMap;
                }
            }
        }
        catch (UnableToAdaptException managedBeanBindings) {
            void e;
            FFDCFilter.processException((Throwable)managedBeanBindings, (String)"com.ibm.ws.ejbcontainer.osgi.internal.ModuleInitDataFactory", (String)"600", (Object)this, (Object[])new Object[]{container2, classLoader, modName, modLogicalName, appName, annoTargets, infoStore, defaultMetadataComplete});
            throw new EJBConfigurationException((Throwable)e);
        }
        if (mid.ivHasTimers == null) {
            boolean hasTimers = false;
            for (BeanMergeData beanMergeData : modMergeData.getBeans()) {
                Boolean hasScheduleTimers = beanMergeData.getBeanInitData().ivHasScheduleTimers;
                if (hasScheduleTimers == null || !hasScheduleTimers.booleanValue()) continue;
                hasTimers = true;
                break;
            }
            if (!hasTimers) {
                for (BeanMergeData beanMergeData : modMergeData.getBeans()) {
                    if (beanMergeData.getBeanInitData().ivType == 8 || !beanMergeData.getClassInfo().isInstanceOf(TimedObject.class)) continue;
                    hasTimers = true;
                    break;
                }
                if (!hasTimers && !mid.ivMetadataComplete) {
                    block30: for (BeanMergeData beanMergeData : modMergeData.getBeans()) {
                        if (beanMergeData.getBeanInitData().ivType == 8) continue;
                        for (MethodInfo methodInfo : beanMergeData.getClassInfo().getMethods()) {
                            if (!methodInfo.isAnnotationPresent(Timeout.class.getName())) continue;
                            hasTimers = true;
                            break block30;
                        }
                    }
                }
            }
            mid.ivHasTimers = hasTimers;
        }
        for (BeanMergeData beanMergeData : modMergeData.getBeans()) {
            BeanInitDataImpl beanInitDataImpl = beanMergeData.getBeanInitData();
            beanInitDataImpl.ivJ2EEName = j2eeNameFactory.create(mid.ivAppName, mid.ivName, beanInitDataImpl.ivName);
            mid.addBean(beanInitDataImpl);
            if (mid.ivMetadataComplete && beanInitDataImpl.ivType != 8) continue;
            this.processInterceptorAnnotation(beanMergeData.getClassInfo(), beanInitDataImpl, mid);
        }
        mid.ivClassLoader = classLoader;
        return mid;
    }

    private void processComponentViewableBean(BeanInitData bid, ComponentViewableBean bean) {
        bid.ivRemoteHomeInterfaceName = bean.getHomeInterfaceName();
        bid.ivRemoteInterfaceName = bean.getRemoteInterfaceName();
        bid.ivLocalHomeInterfaceName = bean.getLocalHomeInterfaceName();
        bid.ivLocalInterfaceName = bean.getLocalInterfaceName();
    }

    private void processInterceptorAnnotation(ClassInfo classInfo, BeanInitData bid, ModuleInitDataImpl mid) {
        block4: {
            List interceptors;
            AnnotationInfo interceptorsInfo = classInfo.getAnnotation(Interceptors.class);
            if (interceptorsInfo == null || (interceptors = interceptorsInfo.getArrayValue("value")) == null || interceptors.isEmpty()) break block4;
            if (bid.ivType == 8) {
                for (AnnotationValue interceptorValue : interceptors) {
                    mid.addMBInterceptor(interceptorValue.getClassNameValue());
                }
            } else {
                for (AnnotationValue interceptorValue : interceptors) {
                    mid.addEJBInterceptor(interceptorValue.getClassNameValue());
                }
            }
        }
    }

    private void mergeComponentDefiningAnnotations(ClassInfo classInfo, BeanMergeData beanMergeData, ModuleMergeData modData, boolean metadataComplete) {
        AnnotationInfo managedBeanAnn;
        if (!metadataComplete && modData.isEJBEnabled()) {
            AnnotationInfo messageDrivenAnn;
            AnnotationInfo singletonAnn;
            AnnotationInfo statefulAnn;
            SessionBeanRuntime sessionBeanRuntime = modData.getSessionBeanRuntime();
            MDBRuntime mdbRuntime = modData.getMDBRuntime();
            AnnotationInfo statelessAnn = classInfo.getAnnotation(Stateless.class);
            if (statelessAnn != null) {
                this.mergeComponentDefiningAnnotation(classInfo, statelessAnn, 0, 3, sessionBeanRuntime, beanMergeData, modData);
            }
            if ((statefulAnn = classInfo.getAnnotation(Stateful.class)) != null) {
                BeanMergeData newBeanMergeData = this.mergeComponentDefiningAnnotation(classInfo, statefulAnn, 0, 4, sessionBeanRuntime, beanMergeData, modData);
                if (beanMergeData == null) {
                    this.mergePassivationCapable(newBeanMergeData, statefulAnn);
                }
            }
            if ((singletonAnn = classInfo.getAnnotation(Singleton.class)) != null) {
                this.mergeComponentDefiningAnnotation(classInfo, singletonAnn, 0, 2, sessionBeanRuntime, beanMergeData, modData);
            }
            if ((messageDrivenAnn = classInfo.getAnnotation(MessageDriven.class)) != null) {
                BeanMergeData newBeanMergeData = this.mergeComponentDefiningAnnotation(classInfo, messageDrivenAnn, 2, 7, mdbRuntime, beanMergeData, modData);
                if (beanMergeData == null) {
                    this.mergeMessagingInterface(newBeanMergeData, messageDrivenAnn);
                    this.mergeActivationConfigProperties(newBeanMergeData, messageDrivenAnn);
                }
            }
        }
        if (modData.isManagedBeanEnabled() && (managedBeanAnn = classInfo.getAnnotation(ManagedBean.class)) != null && !modData.containsBeanMergeDataForClass(classInfo.getName())) {
            this.mergeComponentDefiningAnnotation(classInfo, managedBeanAnn, 0, 8, modData.getManagedBeanRuntime(), beanMergeData, modData);
        }
    }

    private BeanMergeData mergeComponentDefiningAnnotation(ClassInfo classInfo, AnnotationInfo compDefAnn, int kind, int type, BeanRuntime beanRuntime, BeanMergeData beanMergeData, ModuleMergeData modData) {
        if (beanMergeData != null) {
            this.mergeComponentDefiningAnnotationType(beanMergeData, type, beanRuntime, modData);
            return beanMergeData;
        }
        String name = type == 8 ? this.getManagedBeansInternalEJBName(classInfo, compDefAnn) : this.getComponentName(classInfo, compDefAnn);
        String className = classInfo.getName();
        beanMergeData = modData.getBeanMergeData(name);
        if (beanMergeData == null) {
            beanMergeData = modData.createBeanMergeDataFromAnnotation(name, classInfo);
            beanMergeData.setTypeFromAnnotation(type, beanRuntime);
        } else {
            boolean validClass;
            BeanInitDataImpl bid = beanMergeData.getBeanInitData();
            if (bid.ivClassName == null) {
                beanMergeData.setClassNameFromAnnotation(className);
                validClass = true;
            } else if (!bid.ivClassName.equals(className)) {
                if (beanMergeData.isClassNameFromAnnotation()) {
                    Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_CLASS_ANN_ANN_CNTR4106E", (Object[])new Object[]{bid.ivName, TYPE_TO_ANNOTATION_DISPLAY_NAMES[bid.ivType], bid.ivClassName, TYPE_TO_ANNOTATION_DISPLAY_NAMES[type], className});
                } else {
                    Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_CLASS_XML_ANN_CNTR4114E", (Object[])new Object[]{bid.ivName, bid.ivClassName, TYPE_TO_ANNOTATION_DISPLAY_NAMES[type], className});
                }
                modData.error();
                validClass = false;
            } else {
                validClass = true;
            }
            if (validClass) {
                if (bid.ivEnterpriseBean != null && kind != bid.ivEnterpriseBean.getKindValue()) {
                    Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_KIND_CNTR4103E", (Object[])new Object[]{bid.ivName, KIND_ELEMENT_DISPLAY_NAMES[bid.ivEnterpriseBean.getKindValue()], TYPE_TO_ANNOTATION_DISPLAY_NAMES[type], classInfo.getName()});
                    modData.error();
                } else {
                    this.mergeComponentDefiningAnnotationType(beanMergeData, type, beanRuntime, modData);
                }
            }
        }
        return beanMergeData;
    }

    private void mergeComponentDefiningAnnotationType(BeanMergeData beanMergeData, int type, BeanRuntime beanRuntime, ModuleMergeData modData) {
        BeanInitDataImpl bid = beanMergeData.getBeanInitData();
        if (bid.ivType == 1) {
            beanMergeData.setTypeFromAnnotation(type, beanRuntime);
        } else if (type != bid.ivType) {
            if (beanMergeData.isTypeFromAnnotation()) {
                Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_ANN_TYPE_CNTR4104E", (Object[])new Object[]{bid.ivName, TYPE_TO_ANNOTATION_DISPLAY_NAMES[bid.ivType], TYPE_TO_ANNOTATION_DISPLAY_NAMES[type], bid.ivClassName});
            } else {
                Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_SESSION_TYPE_CNTR4105E", (Object[])new Object[]{bid.ivName, TYPE_TO_SESSION_TYPE_VALUES[bid.ivType], TYPE_TO_ANNOTATION_DISPLAY_NAMES[type], bid.ivClassName});
            }
            modData.error();
        }
    }

    private static String getStringValue(AnnotationInfo ann, String name) {
        String value;
        AnnotationValue annValue = ann.getValue(name);
        if (annValue != null && !(value = annValue.getStringValue()).isEmpty()) {
            return value;
        }
        return null;
    }

    private String getComponentName(ClassInfo classInfo, AnnotationInfo compDefAnn) {
        int index;
        String name = this.getManagedBeansName(classInfo);
        if (name == null && (name = ModuleInitDataFactory.getStringValue(compDefAnn, "name")) == null && (index = Math.max((name = classInfo.getName()).lastIndexOf(46), name.lastIndexOf(36))) != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private String getManagedBeansName(ClassInfo classInfo) {
        AnnotationInfo ann = classInfo.getAnnotation(ManagedBean.class);
        return ann == null ? null : ModuleInitDataFactory.getStringValue(ann, "value");
    }

    private String getManagedBeansInternalEJBName(ClassInfo classInfo, AnnotationInfo managedBeanAnn) {
        String name = ModuleInitDataFactory.getStringValue(managedBeanAnn, "value");
        if (name == null) {
            name = '$' + classInfo.getName();
        }
        return name;
    }

    @ManualTrace
    private void mergeSessionInterfaces(BeanMergeData beanMergeData) {
        AnnotationInfo ann;
        BeanInitDataImpl bid = beanMergeData.getBeanInitData();
        ClassInfo classInfo = beanMergeData.getClassInfo();
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mergeSessionInterfaces", (Object[])new Object[]{bid.ivName, bid.ivClassName});
        }
        if (bid.ivRemoteHomeInterfaceName == null && (ann = classInfo.getAnnotation(RemoteHome.class)) != null) {
            bid.ivRemoteHomeInterfaceName = ann.getClassNameValue("value");
        }
        if (bid.ivLocalHomeInterfaceName == null && (ann = classInfo.getAnnotation(LocalHome.class)) != null) {
            bid.ivLocalHomeInterfaceName = ann.getClassNameValue("value");
        }
        Boolean implementsAreRemote = null;
        for (Class annClass : new Class[]{Remote.class, Local.class}) {
            List interfaces;
            boolean remote = annClass == Remote.class;
            AnnotationInfo ann2 = classInfo.getAnnotation(annClass.asSubclass(Annotation.class));
            List list = interfaces = ann2 == null ? null : ann2.getArrayValue("value");
            if (interfaces == null) continue;
            if (interfaces.isEmpty()) {
                if (implementsAreRemote == null) {
                    implementsAreRemote = remote;
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"INCOMPATIBLE_DEFAULT_BUSINESS_INTERFACE_TYPE_CNTR4107E", (Object[])new Object[]{classInfo.getName(), bid.ivName});
                beanMergeData.getModuleMergeData().error();
                continue;
            }
            for (AnnotationValue interfaceValue : interfaces) {
                String interfaceName = interfaceValue.getClassNameValue();
                if (remote) {
                    beanMergeData.addRemoteBusinessInterfaceName(interfaceName);
                    continue;
                }
                beanMergeData.addLocalBusinessInterfaceName(interfaceName);
            }
        }
        Set<String> eligibleInterfaceNames = this.getEligibleInterfaceNames(classInfo);
        if (implementsAreRemote != null && eligibleInterfaceNames.isEmpty()) {
            String annDisplayName = implementsAreRemote != false ? "@Remote" : "@Local";
            Tr.error((TraceComponent)tc, (String)"DEFAULT_IMPLEMENTS_NONE_CNTR4108E", (Object[])new Object[]{annDisplayName, classInfo.getName(), bid.ivName});
            beanMergeData.getModuleMergeData().error();
        }
        for (ClassInfo interfaceInfo : classInfo.getInterfaces()) {
            String interfaceName = interfaceInfo.getName();
            if (!eligibleInterfaceNames.contains(interfaceName)) continue;
            for (Class annClass : new Class[]{Remote.class, Local.class}) {
                List interfaces;
                boolean remote = annClass == Remote.class;
                AnnotationInfo ann3 = interfaceInfo.getAnnotation(annClass.asSubclass(Annotation.class));
                List list = interfaces = ann3 == null ? null : ann3.getArrayValue("value");
                if (interfaces == null) continue;
                if (!interfaces.isEmpty()) {
                    Tr.error((TraceComponent)tc, (String)"IMPLEMENTS_INTERFACE_TYPE_VALUE_CNTR4111E", (Object[])new Object[]{remote ? "@Remote" : "@Local", interfaceName, classInfo.getName(), bid.ivName});
                    beanMergeData.getModuleMergeData().error();
                }
                if (remote) {
                    beanMergeData.addRemoteBusinessInterfaceName(interfaceName);
                    continue;
                }
                beanMergeData.addLocalBusinessInterfaceName(interfaceName);
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"checked interfaces", (Object[])new Object[]{"interfaces=" + classInfo.getInterfaceNames(), "eligibleInterfaces=" + eligibleInterfaceNames});
        }
        if (!bid.ivLocalBean) {
            bid.ivLocalBean = classInfo.isAnnotationPresent(LocalBean.class.getName());
        }
        boolean bl = bid.ivWebServiceEndpoint = classInfo.isAnnotationPresent("javax.jws.WebService") || classInfo.isAnnotationPresent("javax.xml.ws.WebServiceProvider");
        if (beanMergeData.getRemoteBusinessInterfaceNames().isEmpty() && beanMergeData.getLocalBusinessInterfaceNames().isEmpty() && !bid.ivLocalBean) {
            if (eligibleInterfaceNames.isEmpty()) {
                if (bid.ivRemoteHomeInterfaceName == null && bid.ivLocalHomeInterfaceName == null && bid.ivWebServiceEndpointInterfaceName == null && !bid.ivWebServiceEndpoint) {
                    bid.ivLocalBean = true;
                }
            } else {
                for (String interfaceName : eligibleInterfaceNames) {
                    if (implementsAreRemote != null && implementsAreRemote.booleanValue()) {
                        beanMergeData.addRemoteBusinessInterfaceName(interfaceName);
                        continue;
                    }
                    beanMergeData.addLocalBusinessInterfaceName(interfaceName);
                }
            }
        } else if (this.isEmptyAnnotationIgnoresExplicitInterfaces() && implementsAreRemote != null && eligibleInterfaceNames.size() == 1) {
            String interfaceName = eligibleInterfaceNames.iterator().next();
            if (implementsAreRemote.booleanValue()) {
                if (!beanMergeData.getLocalBusinessInterfaceNames().contains(interfaceName)) {
                    beanMergeData.addRemoteBusinessInterfaceName(interfaceName);
                }
            } else if (!beanMergeData.getRemoteBusinessInterfaceNames().contains(interfaceName)) {
                beanMergeData.addLocalBusinessInterfaceName(interfaceName);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mergeSessionInterfaces", (Object)new Object[]{"remoteHome=" + bid.ivRemoteHomeInterfaceName, "localHome=" + bid.ivLocalHomeInterfaceName, "localBean=" + bid.ivLocalBean, "remoteBusiness=" + beanMergeData.getRemoteBusinessInterfaceNames(), "localBusiness=" + beanMergeData.getLocalBusinessInterfaceNames(), "webServiceEndpoint=" + bid.ivWebServiceEndpoint, "webServiceEndpointName=" + bid.ivWebServiceEndpointInterfaceName});
        }
    }

    boolean isEmptyAnnotationIgnoresExplicitInterfaces() {
        return this.runtimeVersion.compareTo(EJBRuntimeVersion.VERSION_3_2) < 0;
    }

    private Set<String> getEligibleInterfaceNames(ClassInfo classInfo) {
        LinkedHashSet<String> eligibleInterfaceNames = new LinkedHashSet<String>();
        for (String interfaceName : classInfo.getInterfaceNames()) {
            if (this.isExcludedInterface(interfaceName)) continue;
            eligibleInterfaceNames.add(interfaceName);
        }
        return eligibleInterfaceNames;
    }

    private boolean isExcludedInterface(String name) {
        return name.equals(Serializable.class.getName()) || name.equals(Externalizable.class.getName()) || name.startsWith("javax.ejb.");
    }

    private void mergeTransactionManagement(BeanMergeData beanMergeData) {
        AnnotationInfo ann;
        if (!beanMergeData.isSetBeanManagedTransaction() && (ann = beanMergeData.getClassInfo().getAnnotation(TransactionManagement.class)) != null) {
            beanMergeData.setBeanManagedTransaction(TransactionManagementType.BEAN.name().equals(ann.getEnumValue("value")));
        }
    }

    private void mergeSingleton(BeanMergeData beanMergeData) {
        AnnotationInfo dependsOnAnn;
        BeanInitDataImpl bid = beanMergeData.getBeanInitData();
        if (!beanMergeData.isSetStartup() && beanMergeData.getClassInfo().isAnnotationPresent(Startup.class.getName())) {
            bid.ivStartup = true;
        }
        if (bid.ivDependsOn == null && (dependsOnAnn = beanMergeData.getClassInfo().getAnnotation(javax.ejb.DependsOn.class)) != null) {
            bid.ivDependsOn = new LinkedHashSet<String>();
            for (AnnotationValue dependsOnValue : dependsOnAnn.getArrayValue("value")) {
                bid.ivDependsOn.add(dependsOnValue.getStringValue());
            }
        }
    }

    private void mergeScheduleTimers(BeanMergeData beanMergeData) {
        BeanInitDataImpl bid = beanMergeData.getBeanInitData();
        if (bid.ivHasScheduleTimers == null || !bid.ivHasScheduleTimers.booleanValue()) {
            boolean hasScheduleTimer = false;
            for (MethodInfo methodInfo : beanMergeData.getClassInfo().getMethods()) {
                if (!methodInfo.isAnnotationPresent(Schedule.class.getName()) && !methodInfo.isAnnotationPresent(Schedules.class.getName())) continue;
                hasScheduleTimer = true;
                break;
            }
            bid.ivHasScheduleTimers = hasScheduleTimer;
        }
    }

    private void mergePassivationCapable(BeanMergeData beanMergeData, AnnotationInfo compDefAnn) {
        Boolean passivationCapable;
        if (!beanMergeData.isSetPassivationCapable() && this.runtimeVersion.compareTo(EJBRuntimeVersion.VERSION_3_2) >= 0 && (passivationCapable = compDefAnn.getBoolean("passivationCapable")) != null) {
            beanMergeData.getBeanInitData().ivPassivationCapable = passivationCapable;
        }
    }

    private void mergeMessagingInterface(BeanMergeData beanMergeData, AnnotationInfo compDefAnn) {
        String className;
        BeanInitDataImpl bid = beanMergeData.getBeanInitData();
        if (bid.ivMessageListenerInterfaceName == null && !(className = compDefAnn.getClassNameValue("messageListenerInterface")).equals("java.lang.Object")) {
            bid.ivMessageListenerInterfaceName = className;
        }
    }

    private void mergeMessagingInterface(BeanMergeData beanMergeData) {
        BeanInitDataImpl bid = beanMergeData.getBeanInitData();
        if (bid.ivMessageListenerInterfaceName == null) {
            for (ClassInfo superclassInfo = beanMergeData.getClassInfo(); superclassInfo != null && !superclassInfo.getName().equals(Object.class.getName()); superclassInfo = superclassInfo.getSuperclass()) {
                Set<String> eligibleInterfaceNames = this.getEligibleInterfaceNames(superclassInfo);
                if (eligibleInterfaceNames.isEmpty()) continue;
                if (eligibleInterfaceNames.size() != 1) break;
                bid.ivMessageListenerInterfaceName = eligibleInterfaceNames.iterator().next();
                break;
            }
        }
    }

    private void mergeActivationConfigProperties(BeanMergeData beanMergeData, AnnotationInfo compDefAnn) {
        Properties properties = new Properties();
        for (AnnotationValue propertyValue : compDefAnn.getArrayValue("activationConfig")) {
            AnnotationInfo property = propertyValue.getAnnotationValue();
            String name = ModuleInitDataFactory.getStringValue(property, "propertyName");
            String value = ModuleInitDataFactory.getStringValue(property, "propertyValue");
            if (name == null || value == null) continue;
            properties.put(name, value);
        }
        BeanInitDataImpl bid = beanMergeData.getBeanInitData();
        if (bid.ivActivationConfigProperties != null) {
            properties.putAll((Map<?, ?>)bid.ivActivationConfigProperties);
        }
        bid.ivActivationConfigProperties = properties;
    }

    private <T extends com.ibm.ws.javaee.dd.ejbext.EnterpriseBean> Map<String, T> getExtensions(List<T> beans) {
        HashMap<String, com.ibm.ws.javaee.dd.ejbext.EnterpriseBean> beanMap = new HashMap<String, com.ibm.ws.javaee.dd.ejbext.EnterpriseBean>();
        for (com.ibm.ws.javaee.dd.ejbext.EnterpriseBean eb : beans) {
            beanMap.put(eb.getName(), eb);
        }
        return beanMap;
    }

    private <T extends EnterpriseBean> Map<String, T> getBindings(List<T> beans) {
        HashMap<String, EnterpriseBean> beanMap = new HashMap<String, EnterpriseBean>();
        for (EnterpriseBean eb : beans) {
            beanMap.put(eb.getName(), eb);
        }
        return beanMap;
    }

    private <T extends com.ibm.ws.javaee.dd.managedbean.ManagedBean> Map<String, T> getManagedBeanBindings(List<T> beans) {
        HashMap<String, com.ibm.ws.javaee.dd.managedbean.ManagedBean> beanMap = new HashMap<String, com.ibm.ws.javaee.dd.managedbean.ManagedBean>();
        for (com.ibm.ws.javaee.dd.managedbean.ManagedBean managedBean : beans) {
            beanMap.put(managedBean.getClazz(), managedBean);
        }
        return beanMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        ModuleInitDataFactory.KIND_ELEMENT_DISPLAY_NAMES[0] = "<session>";
        ModuleInitDataFactory.KIND_ELEMENT_DISPLAY_NAMES[2] = "<message-driven>";
        ModuleInitDataFactory.KIND_ELEMENT_DISPLAY_NAMES[1] = "<entity>";
        TYPE_TO_ANNOTATION_DISPLAY_NAMES = new String[8];
        ModuleInitDataFactory.TYPE_TO_ANNOTATION_DISPLAY_NAMES[3] = "@Stateless";
        ModuleInitDataFactory.TYPE_TO_ANNOTATION_DISPLAY_NAMES[4] = "@Stateful";
        ModuleInitDataFactory.TYPE_TO_ANNOTATION_DISPLAY_NAMES[2] = "@Singleton";
        ModuleInitDataFactory.TYPE_TO_ANNOTATION_DISPLAY_NAMES[7] = "@MessageDriven";
        TYPE_TO_SESSION_TYPE_VALUES = new String[5];
        ModuleInitDataFactory.TYPE_TO_SESSION_TYPE_VALUES[3] = "Stateless";
        ModuleInitDataFactory.TYPE_TO_SESSION_TYPE_VALUES[4] = "Stateful";
        ModuleInitDataFactory.TYPE_TO_SESSION_TYPE_VALUES[2] = "Singleton";
        SESSION_TYPE_TO_BEAN_TYPE = new int[4];
        ModuleInitDataFactory.SESSION_TYPE_TO_BEAN_TYPE[0] = 1;
        ModuleInitDataFactory.SESSION_TYPE_TO_BEAN_TYPE[1] = 4;
        ModuleInitDataFactory.SESSION_TYPE_TO_BEAN_TYPE[2] = 3;
        ModuleInitDataFactory.SESSION_TYPE_TO_BEAN_TYPE[3] = 2;
        ENTITY_PERSISTENCE_TYPE_TO_BEAN_TYPE = new int[2];
        ModuleInitDataFactory.ENTITY_PERSISTENCE_TYPE_TO_BEAN_TYPE[0] = 5;
        ModuleInitDataFactory.ENTITY_PERSISTENCE_TYPE_TO_BEAN_TYPE[1] = 6;
        ENTITY_CMP_VERSION_TO_BEAN_CMP_VERSION = new int[3];
        ModuleInitDataFactory.ENTITY_CMP_VERSION_TO_BEAN_CMP_VERSION[0] = 0;
        ModuleInitDataFactory.ENTITY_CMP_VERSION_TO_BEAN_CMP_VERSION[1] = 1;
        ModuleInitDataFactory.ENTITY_CMP_VERSION_TO_BEAN_CMP_VERSION[2] = 2;
        DEFAULT_VERSION = EJBRuntimeVersion.VERSION_3_1;
    }
}

