/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.annotation;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationHelper {
    WebApp wrapper = null;
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.annotation");
    protected static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.annotation.AnnotationHelper";
    private ConcurrentHashMap<Object, ManagedObject> cdiCreationContextMap = new ConcurrentHashMap();

    public AnnotationHelper(WebApp wrapWithThis) {
        this.wrapper = wrapWithThis;
    }

    public ManagedObject inject(Object obj, boolean delayPostConstruct) throws RuntimeException {
        ManagedObject mo = null;
        Throwable th = null;
        try {
            if (this.wrapper != null) {
                mo = !delayPostConstruct ? this.wrapper.injectAndPostConstruct(obj) : this.wrapper.inject(obj);
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inject", "injection not attempted because wrapper is null ");
            }
        }
        catch (InjectionException e) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inject", "caught injection exception: " + (Object)((Object)e));
            }
            if (!delayPostConstruct) {
                th = e;
            }
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inject", "caught runtime exception: " + e);
            }
            if (!delayPostConstruct) {
                th = e;
            }
            throw e;
        }
        if (!delayPostConstruct && th != null && WCCustomProperties.THROW_POSTCONSTRUCT_EXCEPTION) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inject", "doPostConstruct exceptions are re-thrown as RuntimeException");
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
        return mo;
    }

    public ManagedObject inject(Object obj) throws RuntimeException {
        return this.inject(obj, false);
    }

    public ManagedObject inject(Class<?> Klass, boolean delayPostConstruct) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "inject(Class<?>,boolean)", "class = " + Klass.getName() + ", delayPostConstruct = " + delayPostConstruct);
        }
        ManagedObject mo = null;
        Throwable th = null;
        try {
            if (this.wrapper != null) {
                mo = !delayPostConstruct ? this.wrapper.injectAndPostConstruct(Klass) : this.wrapper.inject(Klass);
            } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inject", "injection not attempted because wrapper is null ");
            }
        }
        catch (InjectionException e) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inject", "caught injection exception: " + (Object)((Object)e));
            }
            if (!delayPostConstruct) {
                th = e;
            }
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inject", "caught runtime exception: " + e);
            }
            if (!delayPostConstruct) {
                th = e;
            }
            throw e;
        }
        if (!delayPostConstruct && th != null && WCCustomProperties.THROW_POSTCONSTRUCT_EXCEPTION) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "inject", "doPostConstruct exceptions are re-thrown as RuntimeException");
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "inject(Class<?>,boolean)");
        }
        return mo;
    }

    public ManagedObject inject(Class<?> klass) {
        return this.inject(klass, false);
    }

    public void doPostConstruct(Object obj) {
    }

    public void doDelayedPostConstruct(Object obj) {
        Throwable t = this.wrapper.invokeAnnotTypeOnObjectAndHierarchy(obj, WebApp.ANNOT_TYPE.POST_CONSTRUCT);
        if (null != t && WCCustomProperties.THROW_POSTCONSTRUCT_EXCEPTION) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "doDelayedPostConstruct", "Exception caught during post construct processing: " + t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "doDelayedPostConstruct", t);
        }
    }

    public void doPreDestroy(Object obj) {
        block5: {
            try {
                if (this.wrapper != null) {
                    this.wrapper.performPreDestroy(obj);
                } else if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "doPreDestroy", "doPreDestroy not attempted because wrapper is null ");
                }
            }
            catch (Throwable t) {
                if (!com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block5;
                logger.logp(Level.FINE, CLASS_NAME, "doPreDestroy", "doPreDestroy caught throwable: " + t);
            }
        }
    }

    public void addTagHandlerToCdiMap(Object o, ManagedObject mo) {
        if (o == null || mo == null) {
            throw new IllegalArgumentException("Neither the tag nor the managed object may be null");
        }
        this.cdiCreationContextMap.put(o, mo);
    }

    public void cleanUpTagHandlerFromCdiMap(Object o) {
        ManagedObject mo = this.cdiCreationContextMap.remove(o);
        if (mo != null) {
            mo.release();
        }
    }
}

