/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.mbeans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.httpsession.SessionManager;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.ws.webcontainer.osgi.mbeans.PluginGenerator;
import com.ibm.ws.webserver.plugin.runtime.interfaces.PluginUtilityConfigGenerator;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.webcontainer.osgi.mbeans.GeneratePluginConfig;
import java.io.File;
import java.util.Map;
import javax.management.StandardMBean;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class GeneratePluginConfigMBean
extends StandardMBean
implements GeneratePluginConfig,
com.ibm.websphere.webcontainer.GeneratePluginConfigMBean,
PluginUtilityConfigGenerator {
    private static final String DEFAULT_SERVER_NAME = "defaultServer";
    private static final TraceComponent tc = Tr.register(GeneratePluginConfigMBean.class);
    private ModuleRuntimeContainer webContainer;
    private SessionManager smgr;
    private DynamicVirtualHostManager dynVhostMgr;
    protected WsLocationAdmin locMgr;
    private Map<String, Object> config = null;
    private BundleContext bundleContext = null;
    private volatile PluginGenerator pluginGenerator = null;
    static final String CFG_CONNECT_TIMEOUT = "connectTimeout";
    static final String CFG_SERVER_IO_TIMEOUT = "serverIOTimeout";
    static final String CFG_EXTENDED_HANDSHAKE = "extendedHandshake";
    static final String CFG_WAIT_FOR_CONTINUE = "waitForContinue";
    static final String ATTRIBUTE_NAME_CONNECT_TIMEOUT = "ConnectTimeout";
    static final String ATTRIBUTE_NAME_SERVER_IO_TIMEOUT = "IoTimeout";
    static final String ATTRIBUTE_NAME_EXTENDED_HANDSHAKE = "ExtendedHandshake";
    static final String ATTRIBUTE_NAME_WAIT_FOR_CONTINUE = "WaitForContinue";

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public GeneratePluginConfigMBean() {
        super(GeneratePluginConfig.class, false);
    }

    protected void activate(BundleContext context, Map<String, Object> config) {
        this.bundleContext = context;
        this.config = config;
        this.modified(config);
    }

    protected void deactivate(ComponentContext context) {
        this.config = null;
    }

    protected void modified(Map<String, Object> properties) {
        this.config = properties;
        this.pluginGenerator = null;
    }

    @Override
    public void generateDefaultPluginConfig() {
        this.generatePluginConfig(null, DEFAULT_SERVER_NAME);
    }

    @Override
    public void generatePluginConfig(String root, String serverName) {
        this.generatePluginConfig(root, serverName, false, null);
    }

    public synchronized void generatePluginConfig(String root, String serverName, boolean utilityRequest, File writeDirectory) {
        block3: {
            try {
                PluginGenerator generator = this.pluginGenerator;
                if (generator == null) {
                    generator = this.pluginGenerator = new PluginGenerator(this.config, this.locMgr, this.bundleContext);
                }
                generator.generateXML(root, serverName, (WebContainer)this.webContainer, this.smgr, this.dynVhostMgr, this.locMgr, utilityRequest, writeDirectory);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"generatePluginConfig");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block3;
                Tr.event((TraceComponent)tc, (String)("Error generate plugin xml: " + t.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public void setWebContainer(ModuleRuntimeContainer ref) {
        this.webContainer = ref;
    }

    public void unsetWebContainer(ModuleRuntimeContainer ref) {
    }

    public void setSessionManager(SessionManager ref) {
        this.smgr = ref;
    }

    public void unsetSessionManager(SessionManager ref) {
    }

    protected void setLocationService(WsLocationAdmin ref) {
        this.locMgr = ref;
    }

    protected void unsetLocationService(WsLocationAdmin ref) {
    }

    protected void setVirtualHostMgr(DynamicVirtualHostManager vhostMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setVirtualHostMgr : DynamicVirtualHost set : " + vhostMgr.toString()), (Object[])new Object[0]);
        }
        this.dynVhostMgr = vhostMgr;
    }

    protected void unsetVirtualHostMgr(DynamicVirtualHostManager vhostMgr) {
    }

    @Override
    public long getConnectTimeout() {
        if (this.config != null) {
            return (Long)this.config.get(CFG_CONNECT_TIMEOUT);
        }
        return 0L;
    }

    @Override
    public long getIoTimeout() {
        if (this.config != null) {
            return (Long)this.config.get(CFG_SERVER_IO_TIMEOUT);
        }
        return 0L;
    }

    @Override
    public boolean getExtendedHandshake() {
        if (this.config != null) {
            return (Boolean)this.config.get(CFG_EXTENDED_HANDSHAKE);
        }
        return false;
    }

    @Override
    public boolean getWaitForContinue() {
        if (this.config != null) {
            return (Boolean)this.config.get(CFG_WAIT_FOR_CONTINUE);
        }
        return false;
    }

    public void generatePluginConfig(String serverName, File writeDirectory) {
        this.generatePluginConfig(null, serverName, true, writeDirectory);
    }

    public PluginUtilityConfigGenerator.Types getPluginConfigType() {
        return PluginUtilityConfigGenerator.Types.WEBCONTAINER;
    }
}

