/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.filter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.servlet.filter.ChainedRequest;
import com.ibm.websphere.servlet.response.StoredResponse;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ChainedResponse
extends StoredResponse {
    private static final long serialVersionUID = 3256438097326520118L;
    private static final String AUTO_XFER_HEADERS_ATTR = "com.ibm.websphere.servlet.filter.ChainedResponse.auto_transfer_headers";
    private HttpServletRequest _req;
    private HttpServletResponse _resp;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ChainedResponse(HttpServletRequest req, HttpServletResponse resp) {
        this._req = req;
        this._resp = resp;
        this.setResponse((ServletResponse)resp);
    }

    public HttpServletRequest getChainedRequest() throws IOException, ServletException {
        if (super.containsError()) {
            throw super.getError();
        }
        ChainedRequest req = new ChainedRequest(this, this._req);
        Hashtable headers = this.getAutoTransferringHeaders();
        Enumeration names = headers.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = (String)headers.get(name);
            req.setHeader(name, value);
        }
        Collection headerNames = this.getHeaderNames();
        for (String name : headerNames) {
            String value = this.getHeader(name);
            req.setHeader(name, value);
        }
        return req;
    }

    @Override
    public String encodeRedirectURL(String url) {
        return this._resp.encodeRedirectURL(url);
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return this._resp.encodeRedirectUrl(url);
    }

    @Override
    public String encodeURL(String url) {
        return this._resp.encodeURL(url);
    }

    @Override
    public String encodeUrl(String url) {
        return this._resp.encodeUrl(url);
    }

    public void setAutoTransferringHeader(String name, String value) {
        Hashtable headers = this.getAutoTransferringHeaders();
        headers.put(name, value);
    }

    public HttpServletResponse getProxiedHttpServletResponse() {
        return this._resp;
    }

    private Hashtable getAutoTransferringHeaders() {
        Hashtable headers = (Hashtable)this._req.getAttribute(AUTO_XFER_HEADERS_ATTR);
        if (headers == null) {
            headers = new Hashtable();
            this._req.setAttribute(AUTO_XFER_HEADERS_ATTR, headers);
        }
        return headers;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ChainedResponse.class);
    }
}

