/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.channelfw;

import com.ibm.websphere.endpoint.EndPointInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class EndPointInfo
extends StandardMBean
implements EndPointInfoMBean {
    private static final TraceComponent tc = Tr.register(EndPointInfo.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private final String name;
    private final String host;
    private final int port;

    public EndPointInfo(String name, String host, int port) throws NotCompliantMBeanException {
        super(EndPointInfoMBean.class, false);
        if (null == name || 0 == name.length()) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
        if (null == host || 0 == host.length()) {
            throw new IllegalArgumentException("Invalid host: " + host);
        }
        this.name = name;
        this.host = host;
        this.port = port;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created: " + this), (Object[])new Object[0]);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EndPoint ").append(this.getName()).append('=');
        sb.append(this.getHost()).append(':').append(this.getPort());
        return sb.toString();
    }
}

