/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.jca.adapter.WSXAResource;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.TransactionException;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.impl.WSStateManager;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.SecurityException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class WSRdbXaResourceImpl
implements WSXAResource,
FFDCSelfIntrospectable {
    private XAResource ivXaRes;
    private final WSRdbManagedConnectionImpl ivManagedConnection;
    private final WSStateManager ivStateManager;
    Xid ivXid;
    private final AtomicReference<DSConfig> dsConfig;
    private static final Class<?> currClass = WSRdbXaResourceImpl.class;
    private static final TraceComponent tc = Tr.register(currClass, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public WSRdbXaResourceImpl(XAResource xaRes, WSRdbManagedConnectionImpl mc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{xaRes, mc});
        }
        this.ivXaRes = xaRes;
        this.ivManagedConnection = mc;
        this.ivStateManager = mc.stateMgr;
        this.dsConfig = mc.mcf.dsConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid), onePhase ? "ONE PHASE" : "TWO PHASE"});
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object[])new Object[]{this.ivManagedConnection});
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
            throw new XAException(-7);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String cId = null;
            try {
                cId = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException x) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object[])new Object[]{x});
            }
            if (cId != null) {
                StringBuffer stbuf = new StringBuffer(200);
                stbuf.append("Correlator: DB2, ID: ");
                stbuf.append(cId);
                if (xid != null) {
                    stbuf.append("Transaction ID : ");
                    stbuf.append(xid);
                }
                stbuf.append("COMMIT");
                Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
            }
        }
        if (this.dsConfig.get().enableMultithreadedAccessDetection) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        this.ivManagedConnection.wasLazilyEnlisted = false;
        if (this.ivXid == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"XAResource.start was never issued; allowing commit for recovery.", (Object[])new Object[0]);
            }
            try {
                this.ivStateManager.setState(9);
            }
            catch (TransactionException te) {
                FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", (String)"120", (Object)this);
                XAException xae = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.commit", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                this.traceXAException(xae, currClass);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)xae);
                }
                throw xae;
            }
            this.ivXid = xid;
        } else if (!xid.equals(this.ivXid)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Xid does not match.", (Object[])new Object[]{"XAResource.start:  ", AdapterUtil.toString(this.ivXid), "XAResource.commit: ", AdapterUtil.toString(xid)});
            }
            XAException xaX = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "commit", AdapterUtil.toString(xid)}, -4);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)xaX);
            }
            throw xaX;
        }
        WSManagedConnectionFactoryImpl mcf = this.ivManagedConnection.mcf;
        long oracleRACLastStale = mcf.oracleRACLastStale.get();
        if (!onePhase && oracleRACLastStale > 0L) {
            long timeSinceLastStale = System.currentTimeMillis() - oracleRACLastStale;
            if (timeSinceLastStale > mcf.oracleRACXARetryDelay && mcf.oracleRACLastStale.compareAndSet(oracleRACLastStale, 0L)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Time since last stale, " + timeSinceLastStale + " ms, exceeds the oracleRACXARetryDelay. Allowing commit."), (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Time since last stale, " + timeSinceLastStale + " ms, falls within the oracleRACXARetryDelay. Deferring commit."), (Object[])new Object[0]);
                }
                XAException x = AdapterUtil.createXAException("ORACLE_RAC_RETRY", new Object[]{"XAResource.commit", timeSinceLastStale, mcf.oracleRACXARetryDelay}, 4);
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)x);
                }
                throw x;
            }
        }
        this.ivXid = null;
        try {
            this.ivXaRes.commit(xid, onePhase);
            this.ivStateManager.setState(7);
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", (String)"113", (Object)this);
            XAException xae = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.commit", this.ivManagedConnection.getTransactionStateAsString()}, -6);
            this.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)xae);
            }
            throw xae;
        }
        catch (XAException xae) {
            if (this.ivStateManager.getState() == 6 && xae.errorCode == -4) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"XA resource got XAER_NOTA (-4) during recovery. This happens when the XA resource previously committed successfully.", (Object[])new Object[]{this.ivManagedConnection.mcf.helper.getXAExceptionContents(xae)});
                }
            } else {
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", (String)"126", (Object)this);
                this.traceXAException(xae, currClass);
            }
            this.checkXAException(xae);
            if (xae.errorCode == 7 || xae.errorCode == 8 || xae.errorCode == 5 || xae.errorCode == 6) {
                try {
                    this.ivStateManager.setState(13);
                }
                catch (TransactionException te) {
                    FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.commit", (String)"142", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_WARNING", (Object[])new Object[]{"Exception setting the transaction state to WSStateManager.HEURISTIC_END from ", this.ivManagedConnection.getTransactionStateAsString(), te});
                }
            } else if (xae.errorCode == -4 && xae.getCause() instanceof XAException && ((XAException)xae.getCause()).errorCode == 102) {
                try {
                    this.ivStateManager.setState(6);
                }
                catch (TransactionException tranX) {
                    FFDCFilter.processException((Throwable)((Object)tranX), (String)(this.getClass().getName() + ".commit"), (String)"341", (Object)this);
                    XAException x = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.commit", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                    this.traceXAException(x, currClass);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)x);
                    }
                    throw x;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)xae);
            }
            throw xae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String cId = null;
            try {
                cId = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException x) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object[])new Object[]{x});
            }
            if (cId != null) {
                StringBuffer stbuf = new StringBuffer(200);
                stbuf.append("Correlator: DB2, ID: ");
                stbuf.append(cId);
                if (xid != null) {
                    stbuf.append("Transaction ID : ");
                    stbuf.append(xid);
                }
                stbuf.append("COMMIT");
                Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    protected final void end() throws XAException {
        this.end(this.ivXid, 0x20000000);
    }

    public void end(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceEndFlagString(flags)});
        }
        if (this.ivManagedConnection._mcStale) {
            XAException x = new XAException(-7);
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"end", (Object)new Object[]{"MC is stale throwing XAER_RMFAIL", this.ivManagedConnection});
            }
            throw x;
        }
        if (!xid.equals(this.ivXid)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Xid does not match.", (Object[])new Object[]{"XAResource.start: ", AdapterUtil.toString(this.ivXid), "XAResource.end:   ", AdapterUtil.toString(xid)});
            }
            XAException xaX = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "end", AdapterUtil.toString(xid)}, -4);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"end", (Object)xaX);
            }
            throw xaX;
        }
        try {
            this.ivStateManager.setState(5);
            this.ivXaRes.end(xid, flags);
            if (this.ivManagedConnection.helper.xaEndResetsAutoCommit) {
                this.ivManagedConnection.refreshCachedAutoCommit();
            }
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", (String)"228", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"XAResource.end()", this.ivManagedConnection.getTransactionStateAsString()});
            try {
                this.ivXaRes.rollback(xid);
            }
            catch (XAException eatXA) {
                FFDCFilter.processException((Throwable)eatXA, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", (String)"236", (Object)this);
                this.traceXAException(eatXA, currClass);
            }
            XAException xae = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.end", this.ivManagedConnection.getTransactionStateAsString()}, 100);
            this.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String cId = null;
                try {
                    cId = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
                }
                catch (SQLException x) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in rollback during xa end fails, exception is: ", (Object[])new Object[]{x});
                }
                if (cId != null) {
                    StringBuffer stbuf = new StringBuffer(200);
                    stbuf.append("Correlator: DB2, ID: ");
                    stbuf.append(cId);
                    stbuf.append("Transaction ID : ");
                    stbuf.append(xid);
                    stbuf.append("ROLLBACK");
                    Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"end", (Object)"Exception");
            }
            throw xae;
        }
        catch (XAException xae) {
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.end", (String)"438", (Object)this);
            this.checkXAException(xae);
            try {
                this.ivStateManager.setState(6);
            }
            catch (TransactionException te1) {
                Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object[])new Object[]{"Error setting the state to XA_END_FAIL from ", this.ivManagedConnection.getTransactionStateAsString(), te1});
            }
            this.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"end", (Object)xae);
            }
            throw xae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"forget", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid)});
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object[])new Object[]{this.ivManagedConnection});
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
            throw new XAException(-7);
        }
        if (this.ivXid == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"XAResource.start was never issued; allowing to forget for recovery.", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && !xid.equals(this.ivXid) && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Xid does not match.", (Object[])new Object[]{"XAResource.start:  ", AdapterUtil.toString(this.ivXid), "XAResource.forget: ", AdapterUtil.toString(xid)});
        }
        try {
            this.ivXaRes.forget(xid);
            this.ivStateManager.setState(10);
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.forget", (String)"284", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"XAResource.forget()", this.ivManagedConnection.getTransactionStateAsString()});
            this.traceXAException(new XAException(105), currClass);
        }
        catch (XAException xaE) {
            FFDCFilter.processException((Throwable)xaE, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.forget", (String)"489", (Object)this);
            this.traceXAException(xaE, currClass);
            this.checkXAException(xaE);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"forget", (Object)xaE);
            }
            throw xaE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"forget");
        }
    }

    public final ManagedConnection getManagedConnection() {
        return this.ivManagedConnection;
    }

    public final int getTransactionTimeout() throws XAException {
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object[])new Object[]{this.ivManagedConnection});
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
            throw new XAException(-7);
        }
        return this.ivXaRes.getTransactionTimeout();
    }

    public final String[] introspectSelf() {
        return this.ivManagedConnection.introspectSelf();
    }

    void introspectThisClassOnly(FFDCLogger info) {
        info.createFFDCHeader(this);
        info.append("ManagedConnection:", this.ivManagedConnection);
        info.append("Underlying XAResource Object: " + AdapterUtil.toString(this.ivXaRes), this.ivXaRes);
        info.append("Xid: ", AdapterUtil.toString(this.ivXid));
    }

    public final boolean isSameRM(XAResource xaRes) throws XAException {
        WSRdbXaResourceImpl inputXA;
        boolean isSame = false;
        try {
            inputXA = (WSRdbXaResourceImpl)((Object)xaRes);
        }
        catch (ClassCastException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"The Input XAResource is not the same type as the current XAResource", (Object[])new Object[]{xaRes});
            }
            return isSame;
        }
        isSame = this.ivXaRes.isSameRM(inputXA.ivXaRes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"isSameRM?", (Object[])new Object[]{xaRes, isSame ? Boolean.TRUE : Boolean.FALSE});
        }
        return isSame;
    }

    public int prepare(Xid xid) throws XAException {
        int returnValue;
        block14: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid)});
            }
            if (this.ivManagedConnection._mcStale) {
                Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
                XAException x = new XAException(-7);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)new Object[]{"MC is stale throwing XAER_RMFAIL", this.ivManagedConnection});
                }
                throw x;
            }
            if (!xid.equals(this.ivXid)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Xid does not match.", (Object[])new Object[]{"XAResource.start:   ", AdapterUtil.toString(this.ivXid), "XAResource.prepare: ", AdapterUtil.toString(xid)});
                }
                XAException xaX = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "prepare", AdapterUtil.toString(xid)}, -4);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)xaX);
                }
                throw xaX;
            }
            try {
                returnValue = this.ivXaRes.prepare(xid);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"xa.prepare() status:", (Object[])new Object[]{AdapterUtil.getXAResourceVoteString(returnValue), AdapterUtil.toString(xid)});
                }
                if (returnValue != 3) break block14;
                try {
                    this.ivManagedConnection.wasLazilyEnlisted = false;
                    this.ivStateManager.setState(14);
                }
                catch (TransactionException te) {
                    FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.prepare", (String)"373", (Object)this);
                    XAException xae = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.prepare", this.ivManagedConnection.getTransactionStateAsString()}, 105);
                    this.traceXAException(xae, currClass);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)xae);
                    }
                    throw xae;
                }
            }
            catch (XAException xae) {
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.prepare", (String)"386", (Object)this);
                this.traceXAException(xae, currClass);
                this.checkXAException(xae);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)"Exception");
                }
                throw xae;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)returnValue);
        }
        return returnValue;
    }

    public Xid[] recover(int flag) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"recover", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.getXAResourceRecoverFlagString(flag)});
        }
        if (this.ivManagedConnection._mcStale) {
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
            XAException x = new XAException(-7);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)new Object[]{"MC is stale throwing XAER_RMFAIL", this.ivManagedConnection});
            }
            throw x;
        }
        Xid[] xids = null;
        try {
            xids = this.ivXaRes.recover(flag);
            if (xids == null || xids.length == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"No oustanding transactions to recover.  Transaction state does not change.", (Object[])new Object[0]);
                }
            } else {
                this.ivStateManager.setState(9);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Outstanding transactions to recover.  Transaction state is changing to " + this.ivManagedConnection.getTransactionStateAsString()), (Object[])new Object[0]);
                }
            }
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.recover", (String)"438", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_WARNING", (Object[])new Object[]{"Exception setting the transaction state to WSStateManager.XA_RECOVER from ", this.ivManagedConnection.getTransactionStateAsString(), te});
        }
        catch (XAException xae) {
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.recover", (String)"444", (Object)this);
            this.traceXAException(xae, currClass);
            this.checkXAException(xae);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)"Exception");
            }
            throw xae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)xids);
        }
        return xids;
    }

    protected final void rollback() throws XAException {
        this.rollback(this.ivXid);
    }

    public void rollback(Xid xid) throws XAException {
        XAException throwX;
        block34: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid)});
            }
            this.ivManagedConnection.wasLazilyEnlisted = false;
            if (this.ivManagedConnection._mcStale) {
                Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
                XAException x = new XAException(-7);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)new Object[]{"MC is stale throwing XAER_RMFAIL", this.ivManagedConnection});
                }
                throw x;
            }
            if (this.ivXid == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"XAResource.start was never issued; allowing rollback for recovery.", (Object[])new Object[0]);
                }
                try {
                    this.ivStateManager.setState(9);
                }
                catch (TransactionException te) {
                    FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", (String)"614", (Object)this);
                    XAException xae = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.rollback", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                    this.traceXAException(xae, currClass);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)xae);
                    }
                    throw xae;
                }
                this.ivXid = xid;
            } else if (!xid.equals(this.ivXid)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Xid does not match.", (Object[])new Object[]{"XAResource.start:    ", AdapterUtil.toString(this.ivXid), "XAResource.rollback: ", AdapterUtil.toString(xid)});
                }
                XAException xaX = AdapterUtil.createXAException("XID_MISMATCH", new Object[]{AdapterUtil.toString(this.ivXid), "rollback", AdapterUtil.toString(xid)}, -4);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)xaX);
                }
                throw xaX;
            }
            WSManagedConnectionFactoryImpl mcf = this.ivManagedConnection.mcf;
            long oracleRACLastStale = mcf.oracleRACLastStale.get();
            if (oracleRACLastStale > 0L) {
                long timeSinceLastStale = System.currentTimeMillis() - oracleRACLastStale;
                if (timeSinceLastStale > mcf.oracleRACXARetryDelay && mcf.oracleRACLastStale.compareAndSet(oracleRACLastStale, 0L)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Time since last stale, " + timeSinceLastStale + " ms, exceeds the oracleRACXARetryDelay. Allowing rollback."), (Object[])new Object[0]);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Time since last stale, " + timeSinceLastStale + " ms, falls within the oracleRACXARetryDelay. Deferring rollback."), (Object[])new Object[0]);
                    }
                    XAException x = AdapterUtil.createXAException("ORACLE_RAC_RETRY", new Object[]{"XAResource.rollback", timeSinceLastStale, mcf.oracleRACXARetryDelay}, 4);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)x);
                    }
                    throw x;
                }
            }
            boolean doChangeState = true;
            throwX = null;
            try {
                this.ivXaRes.rollback(xid);
            }
            catch (XAException xae) {
                FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", (String)"524", (Object)this);
                this.traceXAException(xae, currClass);
                this.checkXAException(xae);
                if (xae.errorCode == 7 || xae.errorCode == 8 || xae.errorCode == 5 || xae.errorCode == 6) {
                    doChangeState = false;
                    try {
                        this.ivStateManager.setState(13);
                    }
                    catch (TransactionException te) {
                        FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", (String)"540", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_WARNING", (Object[])new Object[]{"Exception setting the transaction state to WSStateManager.HEURISTIC_END from ", this.ivManagedConnection.getTransactionStateAsString(), te});
                    }
                }
                throwX = xae;
            }
            if (doChangeState && !this.ivManagedConnection.isAborted()) {
                try {
                    this.ivStateManager.setState(8);
                }
                catch (TransactionException te) {
                    FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.rollback", (String)"510", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"XAResource.rollback()", this.ivManagedConnection.getTransactionStateAsString()});
                    XAException xae = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.rollback", this.ivManagedConnection.getTransactionStateAsString()}, -6);
                    this.traceXAException(xae, currClass);
                    if (throwX != null) break block34;
                    throwX = xae;
                }
            }
        }
        this.ivXid = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String cId = null;
            try {
                cId = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException x) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in rollback, exception is: ", (Object[])new Object[]{x});
            }
            if (cId != null) {
                StringBuffer stbuf = new StringBuffer(200);
                stbuf.append("Correlator: DB2, ID: ");
                stbuf.append(cId);
                if (xid != null) {
                    stbuf.append("Transaction ID : ");
                    stbuf.append(xid);
                }
                stbuf.append(" ROLLBACK");
                Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
            }
        }
        if (throwX != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", throwX);
            }
            throw throwX;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    public final boolean setTransactionTimeout(int seconds) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object[])new Object[]{seconds});
        }
        if (this.ivManagedConnection._mcStale) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale throwing XAER_RMFAIL", (Object[])new Object[]{this.ivManagedConnection});
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
            throw new XAException(-7);
        }
        return this.ivXaRes.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object[])new Object[]{this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceStartFlagString(flags)});
        }
        if (this.ivManagedConnection._mcStale) {
            Tr.error((TraceComponent)tc, (String)"INVALID_CONNECTION", (Object[])new Object[0]);
            XAException x = new XAException(-7);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{"MC is stale throwing XAER_RMFAIL", this.ivManagedConnection});
            }
            throw x;
        }
        if (this.dsConfig.get().enableMultithreadedAccessDetection) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        this.ivXid = xid;
        try {
            this.ivXaRes.start(xid, flags);
            this.ivStateManager.setState(4);
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)((Object)te), (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", (String)"615", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object[])new Object[]{"XAResource.start()", this.ivManagedConnection.getTransactionStateAsString()});
            try {
                this.ivXaRes.end(xid, 0);
                this.ivXaRes.rollback(xid);
            }
            catch (XAException eatXA) {
                FFDCFilter.processException((Throwable)eatXA, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", (String)"624", (Object)this);
                this.traceXAException(eatXA, currClass);
            }
            XAException xae = AdapterUtil.createXAException("INVALID_TX_STATE", new Object[]{"XAResource.start", this.ivManagedConnection.getTransactionStateAsString()}, 105);
            this.traceXAException(xae, currClass);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)"Exception");
            }
            throw xae;
        }
        catch (XAException xae) {
            FFDCFilter.processException((Throwable)xae, (String)"com.ibm.ws.rsadapter.spi.WSRdbXaResourceImpl.start", (String)"639", (Object)this);
            this.traceXAException(xae, currClass);
            this.checkXAException(xae);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)"Exception");
            }
            throw xae;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String cId = null;
            try {
                cId = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException x) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"got an exception trying to get the correlator in rollback, exception is: ", (Object[])new Object[]{x});
            }
            if (cId != null) {
                StringBuffer stbuf = new StringBuffer(200);
                stbuf.append("Correlator: DB2, ID: ");
                stbuf.append(cId);
                if (xid != null) {
                    stbuf.append("Transaction ID : ");
                    stbuf.append(xid);
                }
                stbuf.append(" BEGIN");
                Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public final XAException traceXAException(XAException xae, Class<?> callerClass) {
        String detailedMessage = this.ivManagedConnection.mcf.helper.getXAExceptionContents(xae);
        Tr.error((TraceComponent)tc, (String)"DISPLAY_XAEX_CONTENT", (Object[])new Object[]{detailedMessage});
        Tr.error((TraceComponent)tc, (String)"THROW_XAEXCEPTION", (Object[])new Object[]{AdapterUtil.getXAExceptionCodeString(xae.errorCode), xae.getMessage()});
        return xae;
    }

    private void checkXAException(XAException xae) {
        ResourceException dsae;
        SQLException cause;
        boolean containsCause;
        boolean authError;
        boolean connError;
        block19: {
            connError = false;
            authError = false;
            containsCause = false;
            cause = null;
            dsae = null;
            try {
                cause = (SQLException)xae.getCause();
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block19;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"cause is not an SQLException so it will stay null", (Object[])new Object[0]);
            }
        }
        if (cause != null) {
            containsCause = true;
            dsae = AdapterUtil.translateSQLException(cause, this.ivManagedConnection, true, currClass);
            if (dsae instanceof SecurityException) {
                authError = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Authorization Exception is chanined to the XAException", (Object[])new Object[0]);
                }
            } else if (this.ivManagedConnection.helper.isConnectionError(cause)) {
                connError = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Stale connection error is chanined to the XAException", (Object[])new Object[0]);
                }
            }
        }
        switch (xae.errorCode) {
            case -7: {
                if (containsCause) break;
                connError = true;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug((Object)this, (TraceComponent)tc, (String)"XAER_RMFAIL connection error occurred", (Object[])new Object[0]);
                break;
            }
        }
        if (connError || authError) {
            try {
                if (connError && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("fire normal connection error occurred event for XAResource " + this), (Object[])new Object[0]);
                }
                if (authError && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("fire Single connection error occurred event for XAResource " + this), (Object[])new Object[0]);
                }
                this.ivManagedConnection.processConnectionErrorOccurredEvent(null, containsCause ? cause : xae);
            }
            catch (NullPointerException nullX) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Handle CLOSED or INACTIVE. Not sending CONNECTION_ERROR_OCCURRED. (caller, mc)", (Object[])new Object[]{this, this.ivManagedConnection});
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("XAException was not a connection error for XAResource " + this), (Object[])new Object[0]);
        }
    }
}

