/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jca.cm.AppDefinedResourceFactory;
import com.ibm.ws.jca.cm.ConnectionManagerService;
import com.ibm.ws.jca.cm.ConnectorService;
import com.ibm.ws.jdbc.DataSourceService;
import com.ibm.ws.jdbc.internal.DataSourceDef;
import com.ibm.ws.jdbc.internal.PropertyService;
import com.ibm.ws.kernel.service.util.PrivHelper;
import com.ibm.ws.resource.ResourceFactory;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

public class DataSourceResourceFactoryBuilder
implements ResourceFactoryBuilder {
    private static final String BASE_PROPERTIES_KEY = "properties.0.";
    private static final TraceComponent tc = Tr.register(DataSourceResourceFactoryBuilder.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String CONFIG_DISPLAY_ID = "config.displayId";
    private static final String CONFIG_SOURCE = "config.source";
    private static final String FILE = "file";
    private static final String ID = "id";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configAdmin");
    private ConnectorService connectorSvc;

    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"activate", (Object[])new Object[]{context});
        }
        this.configAdminRef.activate(context);
    }

    public ResourceFactory createResourceFactory(Map<String, Object> props) throws Exception {
        Object value;
        String recoveryAuthDataRef;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createResourceFactory", (Object[])new Object[]{PropertyService.hidePasswords(props)});
        }
        Hashtable<String, String> cmSvcProps = new Hashtable<String, String>();
        Hashtable<String, Object> dsSvcProps = new Hashtable<String, Object>();
        Hashtable<String, Object> driverProps = new Hashtable<String, Object>();
        HashMap<String, Object> vendorProps = new HashMap<String, Object>();
        VariableRegistry variableRegistry = this.connectorSvc.getVariableRegistry();
        for (Map.Entry<String, Object> prop : props.entrySet()) {
            Object value2 = prop.getValue();
            if (value2 instanceof String) {
                value2 = variableRegistry.resolveString((String)value2);
            }
            vendorProps.put(prop.getKey(), value2);
        }
        String application = (String)vendorProps.remove("application");
        String declaringApplication = (String)vendorProps.remove("declaringApplication");
        String module = (String)vendorProps.remove("module");
        String component = (String)vendorProps.remove("component");
        String jndiName = (String)vendorProps.remove("jndiName");
        String dataSourceID = DataSourceResourceFactoryBuilder.getDataSourceID(application, module, component, jndiName);
        String conManagerID = dataSourceID + '/' + "connectionManager";
        String jdbcDriverID = dataSourceID + '/' + "jdbcDriver";
        String conManagerFilter = FilterUtils.createPropertyFilter((String)ID, (String)conManagerID);
        String jdbcDriverFilter = FilterUtils.createPropertyFilter((String)ID, (String)jdbcDriverID);
        StringBuilder filter = new StringBuilder(FilterUtils.createPropertyFilter((String)ID, (String)dataSourceID));
        filter.insert(filter.length() - 1, '*');
        if (!this.removeExistingConfigurations(filter.toString())) {
            throw new IllegalArgumentException(dataSourceID);
        }
        cmSvcProps.put(ID, conManagerID);
        cmSvcProps.put(CONFIG_DISPLAY_ID, conManagerID);
        driverProps.put(ID, jdbcDriverID);
        driverProps.put(CONFIG_DISPLAY_ID, jdbcDriverID);
        dsSvcProps.put(ID, dataSourceID);
        dsSvcProps.put(CONFIG_DISPLAY_ID, dataSourceID);
        dsSvcProps.put("jndiName", jndiName);
        dsSvcProps.put("jndiName.unique", dataSourceID);
        dsSvcProps.put("connectionManager.target", conManagerFilter);
        dsSvcProps.put("driver.target", jdbcDriverFilter);
        dsSvcProps.put("connectionManager.cardinality.minimum", 1);
        String containerAuthDataRef = (String)vendorProps.remove("containerAuthDataRef");
        if (containerAuthDataRef != null) {
            String authDataFilter = FilterUtils.createPropertyFilter((String)ID, (String)containerAuthDataRef);
            dsSvcProps.put("containerAuthData.target", authDataFilter);
            dsSvcProps.put("containerAuthData.cardinality.minimum", 1);
        }
        if ((recoveryAuthDataRef = (String)vendorProps.remove("recoveryAuthDataRef")) != null) {
            String authDataFilter = FilterUtils.createPropertyFilter((String)ID, (String)recoveryAuthDataRef);
            dsSvcProps.put("recoveryAuthData.target", authDataFilter);
            dsSvcProps.put("recoveryAuthData.cardinality.minimum", 1);
        }
        if (application != null) {
            dsSvcProps.put("application", application);
            if (module != null) {
                dsSvcProps.put("module", module);
                if (component != null) {
                    dsSvcProps.put("component", component);
                }
            }
        }
        for (String name : ConnectionManagerService.CONNECTION_MANAGER_PROPS) {
            value = vendorProps.remove(name);
            if (value == null) continue;
            cmSvcProps.put(name, (String)value);
        }
        for (String name : DSConfig.DATA_SOURCE_PROPS) {
            value = vendorProps.remove(name);
            if (value == null) continue;
            dsSvcProps.put(name, value);
        }
        BundleContext bundleContext = PrivHelper.getBundleContext((Bundle)FrameworkUtil.getBundle(DataSourceResourceFactoryBuilder.class));
        String className = (String)vendorProps.remove(DataSourceDef.className.name());
        this.updateWithLibraries(bundleContext, application, declaringApplication, className, driverProps, dsSvcProps);
        value = vendorProps.remove(DataSourceDef.initialPoolSize.name());
        if (value != null && (Integer)value > 0) {
            ConnectorService.logMessage((Level)Level.INFO, (String)"IGNORE_FEATURE_J2CA0240", (Object[])new Object[]{DataSourceDef.initialPoolSize.name(), jndiName});
        }
        if ((value = vendorProps.remove(DataSourceDef.maxStatements.name())) != null) {
            Integer maxPoolSize = (Integer)cmSvcProps.get(DataSourceDef.maxPoolSize.name());
            int stmtCacheSize = maxPoolSize == null || maxPoolSize <= 0 ? 0 : (Integer)value / maxPoolSize;
            dsSvcProps.put("statementCacheSize", stmtCacheSize);
        }
        String url = (String)vendorProps.remove(DataSourceDef.url.name());
        if (vendorProps.containsKey(DataSourceDef.databaseName.name()) || vendorProps.containsKey(DataSourceDef.portNumber.name())) {
            url = null;
        }
        if (!vendorProps.containsKey(DataSourceDef.serverName.name())) {
            if (url != null) {
                vendorProps.put("URL", url);
            } else if (!className.startsWith("org.apache.derby.jdbc.Embedded")) {
                vendorProps.put(DataSourceDef.serverName.name(), "localhost");
            }
        }
        PropertyService.parseDurationProperties(vendorProps, className, this.connectorSvc);
        PropertyService.parsePasswordProperties(vendorProps);
        for (Map.Entry entry : vendorProps.entrySet()) {
            dsSvcProps.put(BASE_PROPERTIES_KEY + (String)entry.getKey(), entry.getValue());
        }
        StringBuilder dsFilter = new StringBuilder(200);
        dsFilter.append("(&").append(FilterUtils.createPropertyFilter((String)ID, (String)dataSourceID));
        dsFilter.append(FilterUtils.createPropertyFilter((String)"objectClass", (String)DataSourceService.class.getName())).append(")");
        AppDefinedResourceFactory factory = new AppDefinedResourceFactory((ResourceFactoryBuilder)this, bundleContext, dataSourceID, dsFilter.toString(), declaringApplication);
        ConfigurationAdmin configAdmin = null;
        try {
            String bundleLocation = bundleContext.getBundle().getLocation();
            String jcaBundleLocation = PrivHelper.getBundleContext((Bundle)FrameworkUtil.getBundle(ConnectorService.class)).getBundle().getLocation();
            configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
            Configuration conMgrConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jca.connectionManager", jcaBundleLocation);
            conMgrConfig.update(cmSvcProps);
            dsSvcProps.put("connectionManagerRef", new String[]{conMgrConfig.getPid()});
            Configuration driverConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jdbc.jdbcDriver", bundleLocation);
            driverConfig.update(driverProps);
            dsSvcProps.put("jdbcDriverRef", new String[]{driverConfig.getPid()});
            Configuration dsSvcConfig = configAdmin.createFactoryConfiguration("com.ibm.ws.jdbc.dataSource", bundleLocation);
            dsSvcConfig.update(dsSvcProps);
        }
        catch (Exception x) {
            factory.destroy();
            throw x;
        }
        catch (Error x) {
            factory.destroy();
            throw x;
        }
        finally {
            if (configAdmin != null) {
                bundleContext.ungetService(this.configAdminRef.getReference());
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createResourceFactory", (Object)factory);
        }
        return factory;
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{context});
        }
        this.configAdminRef.deactivate(context);
    }

    private static final String getDataSourceID(String application, String module, String component, String jndiName) {
        StringBuilder sb = new StringBuilder(jndiName.length() + 80);
        if (application != null) {
            sb.append("application").append('[').append(application).append(']').append('/');
            if (module != null) {
                sb.append("module").append('[').append(module).append(']').append('/');
                if (component != null) {
                    sb.append("component").append('[').append(component).append(']').append('/');
                }
            }
        }
        return sb.append("dataSource").append('[').append(jndiName).append(']').toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeExistingConfigurations(String filter) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        BundleContext bundleContext = PrivHelper.getBundleContext((Bundle)FrameworkUtil.getBundle(DataSourceResourceFactoryBuilder.class));
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
        try {
            Configuration[] existingConfigurations = configAdmin.listConfigurations(filter);
            if (existingConfigurations != null) {
                for (Configuration config : existingConfigurations) {
                    Dictionary cfgProps = config.getProperties();
                    if (cfgProps != null && FILE.equals(cfgProps.get(CONFIG_SOURCE))) {
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"configuration found in server.xml: ", (Object[])new Object[]{config.getPid()});
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"removing", (Object[])new Object[]{config.getPid()});
                    }
                    config.delete();
                }
            }
        }
        finally {
            bundleContext.ungetService(this.configAdminRef.getReference());
        }
        return true;
    }

    protected void setConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.setReference(ref);
    }

    protected void setConnectorService(ConnectorService svc) {
        this.connectorSvc = svc;
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unsetConfigAdmin", (Object[])new Object[]{ref});
        }
        this.configAdminRef.unsetReference(ref);
    }

    protected void unsetConnectorService(ConnectorService svc) {
        this.connectorSvc = null;
    }

    /*
     * Exception decompiling
     */
    private final void updateWithLibraries(BundleContext bundleContext, String applicationName, String declaringApplication, String className, Hashtable<String, Object> driverProps, Hashtable<String, Object> dsSvcProps) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

