/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIDoubleStatistic;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class DoubleStatisticImpl
extends StatisticImpl
implements SPIDoubleStatistic {
    private static final long serialVersionUID = -8967426759755629774L;
    protected double count = 0.0;
    protected DoubleStatisticImpl baseValue = null;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DoubleStatisticImpl(int dataId) {
        super(dataId);
    }

    public DoubleStatisticImpl(int dataId, double count, long startTime, long lastSampleTime) {
        super(dataId, null, null, null, startTime, lastSampleTime);
        this.count = count;
    }

    public DoubleStatisticImpl(int id, String name, String unit, String description, long startTime, long lastSampleTime) {
        super(id, name, unit, description, startTime, lastSampleTime);
    }

    @Override
    public int getStatisticType() {
        return 2;
    }

    @Override
    public WSStatistic copy() {
        DoubleStatisticImpl copy = new DoubleStatisticImpl(this.id, this.count, this.startTime, this.lastSampleTime);
        copy.baseValue = this.baseValue;
        return copy;
    }

    @Override
    public void reset() {
        this.reset(true);
    }

    @Override
    public void reset(boolean resetAll) {
        if (resetAll) {
            super.reset();
        }
        this.count = 0.0;
    }

    @Override
    public void set(double count, long startTime, long lastSampleTime) {
        this.count = count;
        this.startTime = startTime;
        this.lastSampleTime = lastSampleTime;
    }

    @Override
    public double getDouble() {
        if (this.baseValue == null) {
            return this.count;
        }
        return this.count - this.baseValue.getDouble();
    }

    @Override
    public void combine(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        DoubleStatisticImpl other = (DoubleStatisticImpl)otherStat;
        this.count += other.count;
    }

    @Override
    public void setDouble(double value) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        this.count = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += 1.0;
        } else {
            DoubleStatisticImpl doubleStatisticImpl = this;
            synchronized (doubleStatisticImpl) {
                this.count += 1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(double val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += val;
        } else {
            DoubleStatisticImpl doubleStatisticImpl = this;
            synchronized (doubleStatisticImpl) {
                this.count += val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrement() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= 1.0;
        } else {
            DoubleStatisticImpl doubleStatisticImpl = this;
            synchronized (doubleStatisticImpl) {
                this.count -= 1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrement(double val) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= val;
        } else {
            DoubleStatisticImpl doubleStatisticImpl = this;
            synchronized (doubleStatisticImpl) {
                this.count -= val;
            }
        }
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuffer str = new StringBuffer(super.toString(""));
        str.append(", type=").append("DoubleStatistic");
        str.append(", count=").append(this.count);
        return str.toString();
    }

    @Override
    public String toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<DS");
        res.append(" id=\"");
        res.append(this.id);
        res.append("\" sT=\"");
        res.append(this.startTime);
        res.append("\" lST=\"");
        res.append(this.lastSampleTime);
        res.append("\" ct=\"");
        res.append(this.count);
        res.append("\">\n");
        res.append("</DS>");
        return res.toString();
    }

    @Override
    public void update(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return;
        }
        DoubleStatisticImpl other = (DoubleStatisticImpl)otherStat;
        if (this.baseValue == null) {
            this.count = other.getDouble();
            this.startTime = other.getStartTime();
        } else {
            this.count = other.count - this.baseValue.count;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.lastSampleTime = other.lastSampleTime;
    }

    @Override
    public WSStatistic delta(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        DoubleStatisticImpl other = (DoubleStatisticImpl)otherStat;
        DoubleStatisticImpl newData = new DoubleStatisticImpl(this.id);
        newData.count = this.count - other.getDouble();
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    @Override
    public WSStatistic rateOfChange(WSStatistic otherStat) {
        if (!this.validate(otherStat)) {
            return null;
        }
        DoubleStatisticImpl other = (DoubleStatisticImpl)otherStat;
        DoubleStatisticImpl newData = new DoubleStatisticImpl(this.id);
        long timeDiff = (this.lastSampleTime - other.lastSampleTime) / 1000L;
        if (timeDiff == 0L) {
            return null;
        }
        newData.count = (this.count - other.count) / (double)timeDiff;
        newData.startTime = this.startTime;
        newData.lastSampleTime = this.lastSampleTime;
        return newData;
    }

    @Override
    public void resetOnClient(WSStatistic other) {
        if (other == null) {
            if (this.baseValue == null) {
                this.baseValue = new DoubleStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (this.validate(other)) {
            this.baseValue = (DoubleStatisticImpl)other;
            this.update(this.baseValue);
        }
    }

    private boolean validate(WSStatistic other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof DoubleStatisticImpl)) {
            return false;
        }
        return other.getId() == this.id;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DoubleStatisticImpl.class);
    }
}

