/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitors.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class JvmMonitorHelper {
    private final MemoryMXBean mmx = ManagementFactory.getMemoryMXBean();
    private final List<GarbageCollectorMXBean> gmx = ManagementFactory.getGarbageCollectorMXBeans();
    private final GarbageCollectorMXBean firstGCMBean = this.gmx.get(0);
    private final RuntimeMXBean rmx = ManagementFactory.getRuntimeMXBean();
    private final OperatingSystemMXBean osmx;
    MBeanServer mBeanServer;
    ObjectName operatingSystemMbean;
    String OS_ATTRIBUTE_PROCESS_CPU_TIME = "ProcessCpuTime";
    private long currElapsedCPUTime = 0L;
    private long currElapsedRealTime = 0L;
    private long lastElapsedRealTime = 0L;
    private long lastElapsedCPUTime = 0L;
    private int cpuNSFactor = 1;
    static final long serialVersionUID = 4804114196325853995L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JvmMonitorHelper() {
        if (this.rmx.getVmVendor().equalsIgnoreCase("IBM Corporation")) {
            this.cpuNSFactor = 100;
        }
        this.osmx = ManagementFactory.getOperatingSystemMXBean();
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.operatingSystemMbean = new ObjectName("java.lang", "type", "OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"JvmMonitorHelper<init>");
        }
    }

    public long getCommitedHeapMemoryUsage() {
        MemoryUsage mu = this.mmx.getHeapMemoryUsage();
        return mu.getCommitted();
    }

    public long getInitHeapMemorySettings() {
        MemoryUsage mu = this.mmx.getHeapMemoryUsage();
        return mu.getInit();
    }

    public long getMaxHeapMemorySettings() {
        MemoryUsage mu = this.mmx.getHeapMemoryUsage();
        return mu.getMax();
    }

    public long getUsedHeapMemoryUsage() {
        MemoryUsage mu = this.mmx.getHeapMemoryUsage();
        return mu.getUsed();
    }

    public long getGCCollectionCount() {
        return this.firstGCMBean.getCollectionCount();
    }

    public long getGCCollectionTime() {
        return this.firstGCMBean.getCollectionTime();
    }

    public long getUptime() {
        return this.rmx.getUptime();
    }

    public double getCPU() {
        double cpuUsage = -1.0;
        long processCpuTime = -1L;
        try {
            if (this.operatingSystemMbean != null) {
                processCpuTime = (Long)this.mBeanServer.getAttribute(this.operatingSystemMbean, this.OS_ATTRIBUTE_PROCESS_CPU_TIME);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getCPU");
        }
        if (processCpuTime != -1L) {
            try {
                this.currElapsedCPUTime = processCpuTime;
                this.currElapsedRealTime = System.nanoTime();
                long d1 = this.currElapsedRealTime - this.lastElapsedRealTime;
                long d2 = this.currElapsedCPUTime - this.lastElapsedCPUTime;
                cpuUsage = (double)d2 / (double)d1;
                int processors = this.osmx.getAvailableProcessors();
                cpuUsage = cpuUsage / (double)processors * (double)this.cpuNSFactor * 100.0;
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getCPU");
            }
            this.lastElapsedRealTime = this.currElapsedRealTime;
            this.lastElapsedCPUTime = this.currElapsedCPUTime;
        }
        return cpuUsage;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JvmMonitorHelper.class);
    }
}

