/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.ConfiguredRepository;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.RepositoryConfig;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.security.wim.adapter.urbridge.URBridge;
import com.ibm.ws.security.wim.util.StringUtil;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.wsspi.security.wim.CustomRepository;
import com.ibm.wsspi.security.wim.exception.InitializationException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueNameException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.Root;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RepositoryManager {
    public static final String CLASSNAME = RepositoryManager.class.getName();
    public static final String ACTION_READ = "READ";
    public static final String ACTION_CREATE = "CREATE";
    public static final String ACTION_UPDATE = "UPDATE";
    public static final String ACTION_DELETE = "DELETE";
    private static final TraceComponent tc = Tr.register(RepositoryManager.class);
    private static final String KEY_REGISTRY = "userRegistry";
    private static final String BASE_ENTRY = "registryBaseEntry";
    private final VMMService vmmService;
    private final Map<String, RepositoryHolder> repositories = new ConcurrentHashMap<String, RepositoryHolder>();
    static final long serialVersionUID = 6545483619979091802L;

    public RepositoryManager(VMMService service) {
        this.vmmService = service;
    }

    void addConfiguredRepository(String repositoryId, ConfiguredRepository configuredRepository) {
        ConfiguredRepositoryHolder repositoryHolder = new ConfiguredRepositoryHolder(repositoryId, configuredRepository);
        this.repositories.put(repositoryId, repositoryHolder);
    }

    void addCustomRepository(String repositoryId, CustomRepository customRepository) {
        CustomRepositoryHolder repositoryHolder = new CustomRepositoryHolder(repositoryId, customRepository);
        this.repositories.put(repositoryId, repositoryHolder);
    }

    void addUserRegistry(UserRegistry userRegistry) {
        try {
            URBridgeHolder repositoryHolder = new URBridgeHolder(userRegistry, this.vmmService.getConfigManager());
            this.repositories.put(userRegistry.getRealm(), repositoryHolder);
        }
        catch (InitializationException initializationException) {
            FFDCFilter.processException((Throwable)initializationException, (String)"com.ibm.ws.security.wim.RepositoryManager", (String)"445", (Object)this, (Object[])new Object[]{userRegistry});
        }
    }

    void removeRepositoryHolder(String id) {
        RepositoryHolder repositoryHolder = this.repositories.remove(id);
        if (repositoryHolder != null) {
            repositoryHolder.clear();
        }
    }

    public Repository getRepository(String instanceId) throws WIMException {
        RepositoryHolder repositoryHolder = this.repositories.get(instanceId);
        if (repositoryHolder != null) {
            return repositoryHolder.getRepository();
        }
        return null;
    }

    private String getRealm(Object ur) {
        if (ur instanceof UserRegistry) {
            return ((UserRegistry)ur).getRealm();
        }
        return null;
    }

    public Repository getTargetRepository(String uniqueName) throws WIMException {
        String reposId = this.getRepositoryIdByUniqueName(uniqueName);
        Repository repos = this.getRepository(reposId);
        return repos;
    }

    public String getRepositoryId(String uniqueName) throws WIMException {
        String reposId = this.getRepositoryIdByUniqueName(uniqueName);
        return reposId;
    }

    protected String getRepositoryIdByUniqueName(String uniqueName) throws WIMException {
        boolean isDn;
        boolean bl = isDn = UniqueNameHelper.isDN(uniqueName) != null;
        if (isDn) {
            uniqueName = UniqueNameHelper.getValidUniqueName(uniqueName).trim();
        }
        for (Map.Entry<String, RepositoryHolder> entry : this.repositories.entrySet()) {
            if (!entry.getValue().isUniqueNameForRepository(uniqueName, isDn)) continue;
            return entry.getKey();
        }
        throw new InvalidUniqueNameException("ENTITY_NOT_IN_REALM_SCOPE", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_IN_REALM_SCOPE", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName, (Object)"defined")));
    }

    public Map<String, List<String>> getRepositoriesBaseEntries() {
        HashMap<String, List<String>> reposNodesMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, RepositoryHolder> entry : this.repositories.entrySet()) {
            reposNodesMap.put(entry.getKey(), new ArrayList<String>(entry.getValue().getRepositoryBaseEntries().keySet()));
        }
        return reposNodesMap;
    }

    public Map<String, String> getRepositoryBaseEntries(String reposId) throws WIMException {
        RepositoryHolder repositoryHolder = this.repositories.get(reposId);
        if (repositoryHolder != null) {
            return repositoryHolder.getRepositoryBaseEntries();
        }
        return Collections.emptyMap();
    }

    public List<String> getRepoIds() throws WIMException {
        return new ArrayList<String>(this.repositories.keySet());
    }

    public int getNumberOfRepositories() throws WIMException {
        return this.getRepoIds().size();
    }

    public static boolean matchBaseEntryIgnoreCase(List<String> baseEntries, String baseEntry) {
        boolean result = false;
        if (baseEntries != null && baseEntry != null) {
            for (int i = 0; i < baseEntries.size(); ++i) {
                if (!baseEntry.equalsIgnoreCase(baseEntries.get(i))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isPropertyJoin() {
        return false;
    }

    public boolean isEntryJoin() {
        return false;
    }

    public Map<String, List<String>> getBaseEntriesForRepos(String[] realmBaseEntries) throws WIMException {
        HashMap<String, List<String>> reposBaseEntries = new HashMap<String, List<String>>();
        for (String baseEntryName : realmBaseEntries) {
            String reposId = this.getRepositoryIdByUniqueName(baseEntryName);
            ArrayList<String> baseEntryList = (ArrayList<String>)reposBaseEntries.get(reposId);
            if (baseEntryList == null) {
                baseEntryList = new ArrayList<String>();
            }
            baseEntryList.add(baseEntryName);
            reposBaseEntries.put(reposId, baseEntryList);
        }
        return reposBaseEntries;
    }

    public boolean isReadOnly(String reposId) throws WIMException {
        return false;
    }

    public boolean isSortingSupported(String reposId) {
        return false;
    }

    private Map<String, Set<String>> getRepositoriesForGroup() {
        HashMap<String, Set<String>> repositoriesForGroup = new HashMap<String, Set<String>>();
        for (Map.Entry<String, RepositoryHolder> entry : this.repositories.entrySet()) {
            repositoriesForGroup.put(entry.getKey(), entry.getValue().getRepositoryGroups());
        }
        return repositoriesForGroup;
    }

    public boolean isCrossRepositoryGroupMembership(String reposID) throws WIMException {
        String grpReposUUID;
        Map<String, Set<String>> repositoriesForGroup = this.getRepositoriesForGroup();
        int numOfReposForGrp = repositoriesForGroup.get(reposID).size();
        if (numOfReposForGrp > 1) {
            return true;
        }
        return numOfReposForGrp == 1 && !reposID.equals(grpReposUUID = repositoriesForGroup.get(reposID).iterator().next());
    }

    public Set<String> getRepositoriesForGroupMembership(String repositoryId) throws WIMException {
        RepositoryHolder repositoryHolder = this.repositories.get(repositoryId);
        if (repositoryHolder != null) {
            return repositoryHolder.getRepositoryGroups();
        }
        return null;
    }

    private Map<String, Set<String>> getRepositoriesForGroupMembers() {
        HashMap<String, Set<String>> groupToRepositoryId = new HashMap<String, Set<String>>();
        for (Map.Entry<String, RepositoryHolder> entry : this.repositories.entrySet()) {
            String repositoryid = entry.getKey();
            Set<String> groups = entry.getValue().getRepositoryGroups();
            for (String group : groups) {
                HashSet<String> repositoryIds = (HashSet<String>)groupToRepositoryId.get(group);
                if (repositoryIds == null) {
                    repositoryIds = new HashSet<String>();
                    groupToRepositoryId.put(group, repositoryIds);
                }
                repositoryIds.add(repositoryid);
            }
        }
        return groupToRepositoryId;
    }

    public boolean canGroupAcceptMember(String grpReposId, String mbrReposId) {
        Set<String> mbrReposIdSet;
        Map<String, Set<String>> repositoriesForGroupMembers = this.getRepositoriesForGroupMembers();
        if (repositoriesForGroupMembers != null && (mbrReposIdSet = repositoriesForGroupMembers.get(grpReposId)) != null) {
            return mbrReposIdSet.contains(mbrReposId);
        }
        return false;
    }

    public void clearAllCachedURRepositories() {
        for (RepositoryHolder repositoryHolder : this.repositories.values()) {
            repositoryHolder.clear();
        }
    }

    @FFDCIgnore(value={Exception.class})
    public List<String> getFederationUREntityType(String data) {
        for (RepositoryHolder rh : this.repositories.values()) {
            Object result2;
            if (!(rh instanceof URBridgeHolder)) continue;
            UserRegistry ur = ((URBridgeHolder)rh).ur;
            try {
                result2 = ur.getUsers(data, 1);
                if (result2 != null && result2.getList().size() > 0) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("PersonAccount");
                    returnValue.add(data);
                    return returnValue;
                }
            }
            catch (Exception result2) {
                // empty catch block
            }
            try {
                result2 = ur.getGroups(data, 1);
                if (result2 != null && result2.getList().size() > 0) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("Group");
                    returnValue.add(data);
                    return returnValue;
                }
            }
            catch (Exception result3) {
                // empty catch block
            }
            try {
                result2 = ur.getUserSecurityName(data);
                if (result2 != null) {
                    ArrayList<String> returnValue = new ArrayList<String>();
                    returnValue.add("PersonAccount");
                    returnValue.add((String)result2);
                    return returnValue;
                }
            }
            catch (Exception result4) {
                // empty catch block
            }
            try {
                result2 = ur.getGroupSecurityName(data);
                if (result2 == null) continue;
                ArrayList<String> returnValue = new ArrayList<String>();
                returnValue.add("Group");
                returnValue.add((String)result2);
                return returnValue;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class CustomRepositoryHolder
    extends AbstractRepositoryHolder {
        private final CustomRepositoryAdapter repository;
        static final long serialVersionUID = 209857637792465751L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CustomRepositoryHolder(String repositoryId, CustomRepository customRepository) {
            super(repositoryId);
            this.repository = new CustomRepositoryAdapter(repositoryId, customRepository);
        }

        @Override
        public Repository getRepository() {
            return this.repository;
        }

        @Override
        protected RepositoryConfig getRepositoryConfig() {
            return this.repository;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(CustomRepositoryHolder.class);
        }

        @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
        @InjectedFFDC
        private static class CustomRepositoryAdapter
        implements Repository,
        RepositoryConfig {
            private final String repositoryId;
            private final CustomRepository customRepository;
            static final long serialVersionUID = -1602699711856307021L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public CustomRepositoryAdapter(String repositoryId, CustomRepository customRepository) {
                this.repositoryId = repositoryId;
                this.customRepository = customRepository;
            }

            @Override
            public boolean isReadOnly() {
                return false;
            }

            @Override
            public void resetConfig() {
            }

            @Override
            public String getReposId() {
                return this.repositoryId;
            }

            @Override
            public Map<String, String> getRepositoryBaseEntries() {
                return this.customRepository.getRepositoryBaseEntries();
            }

            @Override
            public String[] getRepositoriesForGroups() {
                String[] repos = this.customRepository.getRepositoriesForGroups();
                if (repos == null) {
                    repos = new String[]{this.repositoryId};
                }
                return repos;
            }

            @Override
            public Root get(Root root) throws WIMException {
                return this.setRepositoryId(this.customRepository.get(root));
            }

            @Override
            public Root search(Root root) throws WIMException {
                return this.setRepositoryId(this.customRepository.search(root));
            }

            @Override
            public Root login(Root root) throws WIMException {
                return this.setRepositoryId(this.customRepository.login(root));
            }

            @Override
            public String getRealm() {
                return this.customRepository.getRealm();
            }

            @Override
            public Root delete(Root root) throws WIMException {
                return this.setRepositoryId(this.customRepository.delete(root));
            }

            @Override
            public Root create(Root root) throws WIMException {
                return this.setRepositoryId(this.customRepository.create(root));
            }

            @Override
            public Root update(Root root) throws WIMException {
                return this.setRepositoryId(this.customRepository.update(root));
            }

            private Root setRepositoryId(Root root) {
                for (Entity entity : root.getEntities()) {
                    IdentifierType identifier = entity.getIdentifier();
                    if (identifier == null) continue;
                    identifier.setRepositoryId(this.repositoryId);
                }
                return root;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(CustomRepositoryAdapter.class);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ConfiguredRepositoryHolder
    extends AbstractRepositoryHolder {
        private final ConfiguredRepository configuredRepository;
        static final long serialVersionUID = 3531594580385014828L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConfiguredRepositoryHolder(String repositoryId, ConfiguredRepository configuredRepository) {
            super(repositoryId);
            this.configuredRepository = configuredRepository;
        }

        @Override
        public Repository getRepository() {
            return this.configuredRepository;
        }

        @Override
        protected RepositoryConfig getRepositoryConfig() {
            return this.configuredRepository;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConfiguredRepositoryHolder.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static abstract class AbstractRepositoryHolder
    implements RepositoryHolder {
        private final String repositoryId;
        static final long serialVersionUID = -6325205163454239717L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AbstractRepositoryHolder(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        @Override
        public Repository getRepository() throws WIMException {
            return null;
        }

        protected abstract RepositoryConfig getRepositoryConfig();

        @Override
        public void clear() {
        }

        @Override
        public Map<String, String> getRepositoryBaseEntries() {
            return this.getRepositoryConfig().getRepositoryBaseEntries();
        }

        @Override
        public Set<String> getRepositoryGroups() {
            String[] repositoriesForGroups = this.getRepositoryConfig().getRepositoriesForGroups();
            if (repositoriesForGroups != null && repositoriesForGroups.length > 0) {
                return new HashSet<String>(Arrays.asList(repositoriesForGroups));
            }
            return Collections.emptySet();
        }

        @Override
        public boolean isUniqueNameForRepository(String uniqueName, boolean isDn) throws WIMException {
            if (isDn) {
                Set<String> baseEntryList = this.getRepositoryBaseEntries().keySet();
                if (baseEntryList.size() == 0) {
                    throw new WIMException("MISSING_BASE_ENTRY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_BASE_ENTRY", (Object[])WIMMessageHelper.generateMsgParms((Object)this.repositoryId)));
                }
                int uLength = uniqueName.length();
                for (String baseEntry : baseEntryList) {
                    int nodeLength = baseEntry.length();
                    if (nodeLength == 0) {
                        return true;
                    }
                    if (uLength == nodeLength && uniqueName.equalsIgnoreCase(baseEntry)) {
                        return true;
                    }
                    if (uLength <= nodeLength || !StringUtil.endsWithIgnoreCase(uniqueName, "," + baseEntry)) continue;
                    return true;
                }
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AbstractRepositoryHolder.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class URBridgeHolder
    implements RepositoryHolder {
        private final String baseEntry;
        private final UserRegistry ur;
        private URBridge urBridge;
        private final Map<String, String> baseEntries;
        static final long serialVersionUID = 6830297939219723126L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public URBridgeHolder(UserRegistry ur, ConfigManager configManager) throws InitializationException {
            String realm = ur.getRealm();
            this.baseEntry = "o=" + realm;
            this.ur = ur;
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(RepositoryManager.KEY_REGISTRY, ur);
            properties.put("config.id", realm);
            properties.put(RepositoryManager.BASE_ENTRY, this.baseEntry);
            this.baseEntries = Collections.singletonMap(this.baseEntry, realm);
            this.urBridge = new URBridge(properties, ur, configManager);
        }

        @Override
        public Repository getRepository() {
            return this.urBridge;
        }

        @Override
        public void clear() {
            if (this.urBridge != null) {
                this.urBridge.stopCacheThreads();
            }
            this.urBridge = null;
        }

        @Override
        public Map<String, String> getRepositoryBaseEntries() {
            return this.baseEntries;
        }

        @Override
        public Set<String> getRepositoryGroups() {
            return Collections.singleton(this.urBridge.getRealm());
        }

        @Override
        public boolean isUniqueNameForRepository(String uniqueName, boolean isDn) {
            return this.baseEntry.equals(uniqueName) || this.isUserInRealm(uniqueName);
        }

        @FFDCIgnore(value={Exception.class})
        private boolean isUserInRealm(String uniqueName) {
            SearchResult result2;
            try {
                result2 = this.ur.getUsers(uniqueName, 1);
                if (result2 != null && result2.getList().size() > 0) {
                    return true;
                }
            }
            catch (Exception result2) {
                // empty catch block
            }
            try {
                result2 = this.ur.getGroups(uniqueName, 1);
                if (result2 != null && result2.getList().size() > 0) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(URBridgeHolder.class);
        }
    }

    static interface RepositoryHolder {
        public Repository getRepository() throws WIMException;

        public void clear();

        public Map<String, String> getRepositoryBaseEntries();

        public Set<String> getRepositoryGroups();

        public boolean isUniqueNameForRepository(String var1, boolean var2) throws WIMException;
    }
}

