/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.security.wim.ProfileServiceLite;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.websphere.security.wim.ras.WIMTraceHelper;
import com.ibm.websphere.security.wim.util.PasswordUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.FactoryManager;
import com.ibm.ws.security.wim.PageCacheEntry;
import com.ibm.ws.security.wim.ProfileManagerMetadataMapper;
import com.ibm.ws.security.wim.PropertyManager;
import com.ibm.ws.security.wim.Repository;
import com.ibm.ws.security.wim.RepositoryManager;
import com.ibm.ws.security.wim.env.ICacheUtil;
import com.ibm.ws.security.wim.util.ControlsHelper;
import com.ibm.ws.security.wim.util.SortHandler;
import com.ibm.ws.security.wim.util.StringUtil;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.ws.security.wim.xpath.FederationLogicalNode;
import com.ibm.ws.security.wim.xpath.FederationParenthesisNode;
import com.ibm.ws.security.wim.xpath.ParenthesisNode;
import com.ibm.ws.security.wim.xpath.ParseException;
import com.ibm.ws.security.wim.xpath.TokenMgrError;
import com.ibm.ws.security.wim.xpath.WIMXPathInterpreter;
import com.ibm.ws.security.wim.xpath.mapping.datatype.LogicalNode;
import com.ibm.ws.security.wim.xpath.mapping.datatype.PropertyNode;
import com.ibm.ws.security.wim.xpath.mapping.datatype.XPathNode;
import com.ibm.wsspi.security.wim.exception.AttributeNotSupportedException;
import com.ibm.wsspi.security.wim.exception.CertificateMapFailedException;
import com.ibm.wsspi.security.wim.exception.CertificateMapNotSupportedException;
import com.ibm.wsspi.security.wim.exception.ChangeControlException;
import com.ibm.wsspi.security.wim.exception.DefaultParentNotFoundException;
import com.ibm.wsspi.security.wim.exception.DuplicateLogonIdException;
import com.ibm.wsspi.security.wim.exception.EntityIdentifierNotSpecifiedException;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.EntityNotInRealmScopeException;
import com.ibm.wsspi.security.wim.exception.EntityTypeNotSupportedException;
import com.ibm.wsspi.security.wim.exception.InvalidIdentifierException;
import com.ibm.wsspi.security.wim.exception.InvalidUniqueIdException;
import com.ibm.wsspi.security.wim.exception.MaxResultsExceededException;
import com.ibm.wsspi.security.wim.exception.MissingSearchControlException;
import com.ibm.wsspi.security.wim.exception.OperationNotSupportedException;
import com.ibm.wsspi.security.wim.exception.PasswordCheckFailedException;
import com.ibm.wsspi.security.wim.exception.SearchControlException;
import com.ibm.wsspi.security.wim.exception.SortControlException;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import com.ibm.wsspi.security.wim.model.CacheControl;
import com.ibm.wsspi.security.wim.model.ChangeControl;
import com.ibm.wsspi.security.wim.model.ChangeResponseControl;
import com.ibm.wsspi.security.wim.model.CheckGroupMembershipControl;
import com.ibm.wsspi.security.wim.model.CheckPointType;
import com.ibm.wsspi.security.wim.model.Context;
import com.ibm.wsspi.security.wim.model.Control;
import com.ibm.wsspi.security.wim.model.DeleteControl;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.ExternalNameControl;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.GroupControl;
import com.ibm.wsspi.security.wim.model.GroupMemberControl;
import com.ibm.wsspi.security.wim.model.GroupMembershipControl;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import com.ibm.wsspi.security.wim.model.LoginAccount;
import com.ibm.wsspi.security.wim.model.LoginControl;
import com.ibm.wsspi.security.wim.model.PageControl;
import com.ibm.wsspi.security.wim.model.PageResponseControl;
import com.ibm.wsspi.security.wim.model.Root;
import com.ibm.wsspi.security.wim.model.SearchControl;
import com.ibm.wsspi.security.wim.model.SearchResponseControl;
import com.ibm.wsspi.security.wim.model.SortControl;
import com.ibm.wsspi.security.wim.model.SortKeyType;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ProfileManager
implements ProfileServiceLite {
    private static final TraceComponent tc = Tr.register(ProfileManager.class);
    private static final char GET = 'g';
    private static final char SEARCH = 's';
    private static final char LOGIN = 'l';
    private static final char DELETE = 'd';
    private static final char CREATE = 'c';
    private static final char UPDATE = 'u';
    private static final String DELETE_EMITTER = "delete";
    private static final String REPOS = "REPOS";
    private static final String LA = "LA";
    private ICacheUtil pagingSearchCache = null;
    private int maxTotalPagingSearchResults = 1000;
    private long pagingSearchResultsCacheTimeOut = 30000L;
    private ConfigManager configMgr;
    private final RepositoryManager repositoryManager;
    PropertyManager propMgr = new PropertyManager();
    static final long serialVersionUID = -1560762834020672112L;

    ProfileManager(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configMgr = configManager;
    }

    private ConfigManager getConfigManager() {
        return this.configMgr;
    }

    private RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @Trivial
    public Root get(Root root) throws WIMException {
        String METHODNAME = "get";
        return this.genericProfileManagerMethod("get", 'g', root);
    }

    @Trivial
    public Root login(Root root) throws WIMException {
        String METHODNAME = "login";
        return this.genericProfileManagerMethod("login", 'l', root);
    }

    @Trivial
    public Root search(Root root) throws WIMException {
        String METHODNAME = "search";
        return this.genericProfileManagerMethod("search", 's', root);
    }

    @Trivial
    @FFDCIgnore(value={WIMException.class})
    private Root genericProfileManagerMethod(String METHODNAME, char METHODTYPE, Root root) throws WIMException {
        Root adapterRoot = null;
        switch (METHODTYPE) {
            case 'l': {
                adapterRoot = this.loginImpl(root);
                break;
            }
            case 's': {
                adapterRoot = this.searchImpl(root);
                break;
            }
            case 'd': {
                adapterRoot = this.deleteImpl(root);
                break;
            }
            case 'g': {
                adapterRoot = this.getImpl(root);
                break;
            }
            case 'c': {
                adapterRoot = this.createImpl(root);
                break;
            }
            case 'u': {
                adapterRoot = this.updateImpl(root);
                break;
            }
        }
        return adapterRoot;
    }

    /*
     * WARNING - void declaration
     */
    private Root getImpl(Root inRoot) throws WIMException {
        void var18_30;
        String METHODNAME = "getImpl(Root inRoot)";
        if (inRoot == null) {
            return null;
        }
        Map<String, Control> ctrlMap = ControlsHelper.getControlMap(inRoot);
        boolean isAllowOperationIfReposDown = false;
        boolean trustEntityType = false;
        List contexts = inRoot.getContexts();
        for (Context contextInput : contexts) {
            String key = contextInput.getKey();
            if (key != null && "allowOperationIfReposDown".equals(key)) {
                isAllowOperationIfReposDown = Boolean.parseBoolean(String.valueOf(contextInput.getValue()));
            }
            if (key == null || !"trustEntityType".equals(key)) continue;
            trustEntityType = Boolean.parseBoolean(String.valueOf(contextInput.getValue()));
        }
        HashSet<String> failureRepositoryIds = new HashSet<String>();
        CheckGroupMembershipControl chkGrpMembershipCtl = (CheckGroupMembershipControl)ctrlMap.get("CheckGroupMembershipControl");
        Root retRoot = new Root();
        List entities = inRoot.getEntities();
        HashMap<String, Root> inputDataGraphes = new HashMap<String, Root>();
        HashMap<String, Root> specialDataGraphes = new HashMap<String, Root>();
        HashMap<String, Root> returnedDataGraphes = new HashMap<String, Root>();
        int index = 0;
        for (Object entity : entities) {
            String realmName;
            String repositoryId;
            String realEntityType;
            ++index;
            String string = entity.getTypeName();
            IdentifierType identifierType = entity.getIdentifier();
            if (identifierType == null) {
                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IDENTIFIER_NOT_SPECIFIED", null));
            }
            String uniqueId = identifierType.getUniqueId();
            String uniqueName = identifierType.getUniqueName();
            String federationEntityType = null;
            if (uniqueName != null) {
                if (UniqueNameHelper.isDN(uniqueName) != null) {
                    uniqueName = UniqueNameHelper.formatUniqueName(uniqueName);
                    identifierType.setUniqueName(uniqueName);
                } else {
                    List<String> entityData = this.repositoryManager.getFederationUREntityType(uniqueName);
                    if (entityData != null) {
                        trustEntityType = true;
                        federationEntityType = entityData.get(0);
                        uniqueName = entityData.get(1);
                        entity.getIdentifier().setUniqueName(uniqueName);
                    } else {
                        return new Root();
                    }
                }
            }
            if (!(uniqueId != null && uniqueId.trim().length() != 0 || uniqueName != null && uniqueName.trim().length() != 0)) {
                String externalName = identifierType.getExternalName();
                if (externalName != null && externalName.length() > 0) {
                    ExternalNameControl extNameCtrl = (ExternalNameControl)ctrlMap.get("ExternalNameControl");
                    if (extNameCtrl != null) {
                        Root sRoot = null;
                        String key = "ExternalNameControl-" + index;
                        if (specialDataGraphes.containsKey(key)) continue;
                        sRoot = new Root();
                        sRoot.getEntities().add(entity);
                        sRoot.getControls().addAll(inRoot.getControls());
                        specialDataGraphes.put(key, sRoot);
                        continue;
                    }
                    throw new WIMApplicationException("EXTERNAL_NAME_CONTROL_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"EXTERNAL_NAME_CONTROL_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)externalName)));
                }
                throw new InvalidIdentifierException("INVALID_IDENTIFIER", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_IDENTIFIER", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId, (Object)uniqueName)));
            }
            if (trustEntityType) {
                realEntityType = federationEntityType == null ? entity.getTypeName() : federationEntityType;
                repositoryId = this.getRepositoryManager().getRepositoryId(uniqueName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Client entity type will be trusted: " + realEntityType), (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Client entity type will NOT be trusted: " + string), (Object[])new Object[0]);
                }
                Entity realEntity = this.retrieveEntity(null, identifierType, isAllowOperationIfReposDown, failureRepositoryIds);
                realEntityType = realEntity.getTypeName();
                uniqueName = identifierType.getUniqueName();
                repositoryId = identifierType.getRepositoryId();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Entity type retrieved from repository: " + realEntityType), (Object[])new Object[0]);
                }
            }
            if (chkGrpMembershipCtl != null) {
                Group group;
                block44: {
                    group = null;
                    try {
                        group = (Group)entity;
                    }
                    catch (ClassCastException key) {
                        FFDCFilter.processException((Throwable)key, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"377", (Object)this, (Object[])new Object[]{inRoot});
                        if (!tc.isDebugEnabled()) break block44;
                        Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Entity is not a group or its subtype"), (Object[])new Object[0]);
                    }
                }
                if (group != null) {
                    List mbrs = group.getMembers();
                    this.setExtIdAndRepositoryIdForEntities(mbrs, repositoryId, isAllowOperationIfReposDown, failureRepositoryIds);
                }
            }
            if ((realmName = this.getRealmName(inRoot)) != null && !this.getConfigManager().isUniqueNameInRealm(uniqueName, realmName) && UniqueNameHelper.isDN(uniqueName) != null) {
                throw new EntityNotInRealmScopeException("ENTITY_NOT_IN_REALM_SCOPE", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_IN_REALM_SCOPE", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName, (Object)realmName)));
            }
            Root sRoot = null;
            sRoot = !inputDataGraphes.containsKey(repositoryId) ? new Root() : (Root)inputDataGraphes.get(repositoryId);
            sRoot.getEntities().add(entity);
            sRoot.getControls().addAll(inRoot.getControls());
            sRoot.getContexts().addAll(inRoot.getContexts());
            inputDataGraphes.put(repositoryId, sRoot);
        }
        Set specialDataGraphesEntrySet = specialDataGraphes.entrySet();
        for (Map.Entry entry : specialDataGraphesEntrySet) {
            String string = (String)entry.getKey();
            if (!string.startsWith("ExternalNameControl")) continue;
            Root rRoot = (Root)entry.getValue();
            String realmName = this.getRealmName(rRoot);
            List extEntities = rRoot.getEntities();
            Entity entity = (Entity)extEntities.get(0);
            IdentifierType identifier = entity.getIdentifier();
            String externalName = identifier.getExternalName();
            List<String> potentialRepositories = this.getReposForExternalName(externalName, realmName);
            Root retSRoot = null;
            String reposId = null;
            for (int i = 0; i < potentialRepositories.size(); ++i) {
                block45: {
                    try {
                        reposId = potentialRepositories.get(i);
                        retSRoot = this.repositoryManager.getRepository(reposId).get(rRoot);
                    }
                    catch (EntityNotFoundException entityNotFoundException) {
                        void e;
                        FFDCFilter.processException((Throwable)entityNotFoundException, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"464", (Object)this, (Object[])new Object[]{inRoot});
                        if (!tc.isDebugEnabled()) break block45;
                        Tr.debug((TraceComponent)tc, (String)(METHODNAME + " IGNORE: exception [" + e.getMessage() + "] on repository [" + reposId + "]"), (Object[])new Object[0]);
                    }
                    catch (WIMException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"467", (Object)this, (Object[])new Object[]{inRoot});
                        if (tc.isDebugEnabled()) {
                            void we;
                            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " IGNORE: exception [" + we.getMessage() + "] on repository [" + reposId + "]"), (Object[])new Object[0]);
                        }
                        failureRepositoryIds.add(reposId);
                        continue;
                    }
                }
                if (retSRoot == null) continue;
                this.prepareDataGraphForCaller(retSRoot, null, null, isAllowOperationIfReposDown, failureRepositoryIds);
                returnedDataGraphes.put(string, retSRoot);
                break;
            }
            if (retSRoot != null) continue;
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)externalName)));
        }
        Set inputDataGraphesEntrySet = inputDataGraphes.entrySet();
        for (Map.Entry entry : inputDataGraphesEntrySet) {
            CacheControl clearCacheCtrl;
            GroupMembershipControl ctrl;
            String key = (String)entry.getKey();
            Root dgRoot = (Root)entry.getValue();
            Root retDgRoot = null;
            try {
                retDgRoot = this.getRepositoryManager().getRepository(key).get(dgRoot);
            }
            catch (Exception entity) {
                void e;
                FFDCFilter.processException((Throwable)entity, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"499", (Object)this, (Object[])new Object[]{inRoot});
                if (!isAllowOperationIfReposDown) {
                    if (e instanceof WIMException) {
                        throw (WIMException)e;
                    }
                    throw new WIMException((Throwable)e);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(METHODNAME + " IGNORE: exception [" + e.getMessage() + "] on repository [" + key + "]"), (Object[])new Object[0]);
                }
                failureRepositoryIds.add(key);
                continue;
            }
            if (ctrlMap.containsKey("GroupMembershipControl")) {
                ctrl = (GroupMembershipControl)ctrlMap.get("GroupMembershipControl");
                clearCacheCtrl = null;
                if (ctrlMap.containsKey("CacheControl")) {
                    clearCacheCtrl = (CacheControl)ctrlMap.get("CacheControl");
                }
                this.groupMembershipLookup(retDgRoot, key, (GroupControl)ctrl, isAllowOperationIfReposDown, failureRepositoryIds, clearCacheCtrl);
            }
            if (ctrlMap.containsKey("GroupMemberControl")) {
                ctrl = (GroupMemberControl)ctrlMap.get("GroupMemberControl");
                clearCacheCtrl = null;
                if (ctrlMap.containsKey("CacheControl")) {
                    clearCacheCtrl = (CacheControl)ctrlMap.get("CacheControl");
                }
                this.groupMembershipLookup(retDgRoot, key, (GroupControl)ctrl, isAllowOperationIfReposDown, failureRepositoryIds, clearCacheCtrl);
            }
            this.prepareDataGraphForCaller(retDgRoot, null, null, isAllowOperationIfReposDown, failureRepositoryIds);
            returnedDataGraphes.put(key, retDgRoot);
        }
        List[] listArray = new List[returnedDataGraphes.size()];
        index = 0;
        for (Root dgRoot : returnedDataGraphes.values()) {
            listArray[index++] = dgRoot.getEntities();
            List ctrls = dgRoot.getControls();
            List contxs = dgRoot.getContexts();
            retRoot.getControls().addAll(ctrls);
            retRoot.getContexts().addAll(contxs);
        }
        List<Entity> list = this.mergeEntitiesList(listArray);
        SortControl sortCtrl = (SortControl)ctrlMap.get("SortControl");
        if (sortCtrl != null) {
            List sortKeys = sortCtrl.getSortKeys();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)WIMTraceHelper.printObjectArray((Object[])new Object[]{sortKeys}), (Object[])new Object[0]);
            }
            if (sortKeys == null || sortKeys.size() == 0) {
                throw new SortControlException("MISSING_SORT_KEY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_SORT_KEY", null));
            }
            SortHandler sortHandler = new SortHandler(sortCtrl);
            List<Entity> list2 = sortHandler.sortEntities(list);
        }
        retRoot.getEntities().clear();
        retRoot.getEntities().addAll(var18_30);
        this.unsetExternalId(retRoot);
        if (isAllowOperationIfReposDown) {
            Context context = new Context();
            retRoot.getContexts().add(context);
            context.setKey("failureRepositoryIDs");
            context.setValue(failureRepositoryIds);
        }
        return retRoot;
    }

    @Trivial
    private void unsetExternalId(Root root) {
        List entities;
        if (root != null && (entities = root.getEntities()) != null) {
            for (Entity entity : entities) {
                IdentifierType identifier = entity.getIdentifier();
                if (identifier == null) continue;
                identifier.setExternalId(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Root searchImpl(Root inRoot) throws WIMException {
        Context context;
        String METHODNAME = "searchImpl(Root inRoot)";
        List<Entity> mergedEnts = null;
        Root retRootDO = null;
        boolean bFirstChangeSearchCall = false;
        ChangeResponseControl[] changeResponseCtrls = null;
        boolean isURBrigeResult = false;
        if (this.getRepositoryManager() == null) {
            throw new WIMException("No Repositories found");
        }
        int numOfRepos = this.getRepositoryManager().getNumberOfRepositories();
        Map<String, List<String>> reposSearchBases = new HashMap<String, List<String>>();
        Root returnDO = null;
        Map<String, Control> ctrlMap = ControlsHelper.getControlMap(inRoot);
        int searchCountLimit = 0;
        int searchLimit = 0;
        int pageSize = 0;
        int startIndex = 0;
        String cacheKey = null;
        boolean isAllowOperationIfReposDown = false;
        boolean setByContext = false;
        HashSet<String> failureRepositoryIds = new HashSet<String>();
        List contexts = inRoot.getContexts();
        if (contexts != null && contexts.size() > 0) {
            for (Context contextInput : contexts) {
                String key = contextInput.getKey();
                if (key == null || !"allowOperationIfReposDown".equals(key)) continue;
                isAllowOperationIfReposDown = (Boolean)contextInput.getValue();
                setByContext = true;
            }
        }
        boolean bChangeSearch = true;
        SearchControl searchControl = (SearchControl)ctrlMap.get("ChangeControl");
        if (searchControl == null) {
            bChangeSearch = false;
            searchControl = (SearchControl)ctrlMap.get("SearchControl");
        } else {
            List checkpoint = ((ChangeControl)searchControl).getCheckPoint();
            if (checkpoint.size() == 0) {
                bFirstChangeSearchCall = true;
            }
        }
        PageControl pageControl = (PageControl)ctrlMap.get("PageControl");
        SortControl sortControl = (SortControl)ctrlMap.get("SortControl");
        if (pageControl != null && searchControl != null) {
            cacheKey = this.getPageCacheKey(searchControl, sortControl);
        }
        if (searchControl == null && pageControl == null) {
            throw new MissingSearchControlException("MISSING_SEARCH_CONTROL", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_SEARCH_CONTROL", null));
        }
        if (pageControl != null && searchControl != null && this.pagingSearchCache != null && this.pagingSearchCache.containsKey(cacheKey)) {
            pageSize = pageControl.getSize();
            startIndex = pageControl.getStartIndex();
            PageCacheEntry entry = (PageCacheEntry)this.pagingSearchCache.get(cacheKey);
            int size = 0;
            Root cachedRootDO = null;
            ArrayList<Entity> entities = null;
            if (entry != null && (cachedRootDO = entry.getDataObject()) != null && (entities = cachedRootDO.getEntities()) != null) {
                size = entities.size();
            }
            if (pageSize == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(METHODNAME + " clean up the paging cache entry"), (Object[])new Object[0]);
                }
                this.pagingSearchCache.invalidate(cacheKey);
                returnDO = new Root();
            } else {
                returnDO = new Root();
                ArrayList<Entity> retDOEntities = null;
                if (size > pageSize) {
                    if (startIndex < entities.size()) {
                        retDOEntities = new ArrayList<Entity>();
                        int loopTo = startIndex + pageSize;
                        loopTo = loopTo < entities.size() ? loopTo : entities.size();
                        for (int i = startIndex; i < loopTo; ++i) {
                            Entity ent = (Entity)entities.get(i);
                            retDOEntities.add(ent);
                        }
                    }
                } else {
                    retDOEntities = entities;
                    this.pagingSearchCache.invalidate(cacheKey);
                }
                if (retDOEntities != null) {
                    returnDO.getEntities().addAll(retDOEntities);
                }
                PageResponseControl respPageCtrl = new PageResponseControl();
                returnDO.getControls().add(respPageCtrl);
                respPageCtrl.setTotalSize(entities.size());
            }
            this.unsetExternalId(returnDO);
            return returnDO;
        }
        if (searchControl != null) {
            if (sortControl != null) {
                List sortKeys = sortControl.getSortKeys();
                List propNames = searchControl.getProperties();
                for (SortKeyType sortKey : sortKeys) {
                    String propName = sortKey.getPropertyName();
                    if (propNames.contains(propName)) continue;
                    propNames.add(propName);
                }
            }
            if ((searchCountLimit = searchControl.getCountLimit()) < 0) {
                return new Root();
            }
            if (searchCountLimit > 0) {
                searchControl.setCountLimit(searchCountLimit + 1);
            } else {
                searchControl.setCountLimit(this.getConfigManager().getMaxSearchResults() + 1);
            }
            searchLimit = searchControl.getSearchLimit();
            if (searchLimit < 0) {
                throw new SearchControlException("INCORRECT_SEARCH_LIMIT", Tr.formatMessage((TraceComponent)tc, (String)"INCORRECT_SEARCH_LIMIT", (Object[])WIMMessageHelper.generateMsgParms((Object)searchLimit)));
            }
            long timeLimit = searchControl.getTimeLimit();
            if (searchCountLimit > 0 && pageControl != null) {
                throw new SearchControlException("CANNOT_SPECIFY_COUNT_LIMIT", Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_SPECIFY_COUNT_LIMIT", null));
            }
            if (timeLimit <= 0L) {
                searchControl.setTimeLimit(this.getConfigManager().getSearchTimeOut());
            }
            List searchBases = searchControl.getSearchBases();
            if (bChangeSearch) {
                List changeTypes = ((ChangeControl)searchControl).getChangeTypes();
                ProfileManager.validateChangeTypes(changeTypes);
            }
            String realm = this.getRealmName(inRoot);
            if (!setByContext) {
                isAllowOperationIfReposDown = this.getConfigManager().isAllowOpIfRepoDown(realm);
            }
            boolean isSearchBaseSet = false;
            if (searchBases.size() > 0) {
                reposSearchBases = this.divideSearchBases(searchBases, realm, reposSearchBases);
                isSearchBaseSet = true;
            } else {
                reposSearchBases = this.getSearchBasesFromRealm(realm, reposSearchBases);
            }
            mergedEnts = null;
            if (this.getRepositoryManager().isPropertyJoin()) {
                String searchExpr = searchControl.getExpression();
                if (!(bFirstChangeSearchCall || searchExpr != null && searchExpr.length() != 0)) {
                    throw new SearchControlException("MISSING_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_SEARCH_EXPRESSION", null));
                }
                List props = searchControl.getProperties();
                boolean returnSubTypes = searchControl.isReturnSubType();
                List<String> entityTypes = this.getConfigManager().getSupportedEntityTypes();
                List[] reposEntities = new List[numOfRepos];
                changeResponseCtrls = new ChangeResponseControl[numOfRepos];
                String exceptionMessage = "";
                Boolean propFound = false;
                List<String> reposIds = this.getRepositoryManager().getRepoIds();
                for (int i = 0; i < reposIds.size(); ++i) {
                    short nodeType;
                    List<String> entTypes;
                    XPathNode node;
                    Root search_resultDO;
                    String reposId;
                    block77: {
                        reposId = reposIds.get(i);
                        if (reposSearchBases != null) {
                            List<String> srchBases = reposSearchBases.get(reposId);
                            if (srchBases != null && srchBases.size() > 0) {
                                searchControl.getSearchBases().clear();
                                searchControl.getSearchBases().addAll(srchBases);
                                if (isSearchBaseSet) {
                                    Context context2 = new Context();
                                    inRoot.getContexts().add(context2);
                                    context2.setKey("realm");
                                    context2.setValue((Object)"n/a");
                                }
                            } else {
                                if (numOfRepos != 1) continue;
                                searchControl.getSearchBases().clear();
                            }
                        }
                        search_resultDO = null;
                        node = null;
                        entTypes = null;
                        if (searchExpr != null) {
                            WIMXPathInterpreter parser = new WIMXPathInterpreter(new StringReader(searchExpr));
                            ProfileManagerMetadataMapper mapper = new ProfileManagerMetadataMapper(reposId, entityTypes);
                            try {
                                node = parser.parse(mapper);
                                entTypes = parser.getEntityTypes();
                                propFound = true;
                                break block77;
                            }
                            catch (AttributeNotSupportedException attributeNotSupportedException) {
                                void anse;
                                FFDCFilter.processException((Throwable)attributeNotSupportedException, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"859", (Object)this, (Object[])new Object[]{inRoot});
                                exceptionMessage = anse.getMessage();
                                continue;
                            }
                            catch (ParseException anse) {
                                void pe;
                                FFDCFilter.processException((Throwable)anse, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"862", (Object)this, (Object[])new Object[]{inRoot});
                                throw new SearchControlException("SEARCH_EXPRESSION_ERROR", Tr.formatMessage((TraceComponent)tc, (String)"SEARCH_EXPRESSION_ERROR", (Object[])WIMMessageHelper.generateMsgParms((Object)pe.getMessage())));
                            }
                            catch (TokenMgrError pe) {
                                FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"867", (Object)this, (Object[])new Object[]{inRoot});
                                throw new SearchControlException("INVALID_SEARCH_EXPRESSION", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_SEARCH_EXPRESSION", (Object[])WIMMessageHelper.generateMsgParms((Object)searchExpr)));
                            }
                        }
                        propFound = true;
                    }
                    HashMap<String, List<String>> returnProps = this.validateAndDivideReturnProperties(entTypes, props, reposId, returnSubTypes);
                    search_resultDO = node != null && ((nodeType = node.getNodeType()) == 4 || nodeType == 8) ? this.splitSearch(reposId, entTypes, node, inRoot, returnProps, isAllowOperationIfReposDown, failureRepositoryIds) : this.propertyJoinSearch(reposId, node, inRoot, returnProps, isAllowOperationIfReposDown, failureRepositoryIds);
                    if (search_resultDO == null) continue;
                    reposEntities[i] = search_resultDO.getEntities();
                    Map<String, Control> responseCtrlMap = ControlsHelper.getControlMap(search_resultDO);
                    changeResponseCtrls[i] = (ChangeResponseControl)responseCtrlMap.get("ChangeResponseControl");
                }
                if (!propFound.booleanValue()) {
                    throw new SearchControlException("SEARCH_EXPRESSION_ERROR", Tr.formatMessage((TraceComponent)tc, (String)"SEARCH_EXPRESSION_ERROR", (Object[])WIMMessageHelper.generateMsgParms((Object)exceptionMessage)));
                }
                mergedEnts = this.mergeRepositoryEntities(reposEntities, isAllowOperationIfReposDown, failureRepositoryIds);
            } else {
                List[] reposEntities = new List[numOfRepos];
                changeResponseCtrls = new ChangeResponseControl[numOfRepos];
                List<String> reposIds = this.getRepositoryManager().getRepoIds();
                for (int i = 0; i < reposIds.size(); ++i) {
                    String reposId = reposIds.get(i);
                    if (reposSearchBases != null) {
                        Map<String, Control> responseCtrlMap;
                        List ents;
                        Root result;
                        List<String> srchBases = reposSearchBases.get(reposId);
                        if (srchBases != null && srchBases.size() > 0) {
                            searchControl.getSearchBases().clear();
                            searchControl.getSearchBases().addAll(srchBases);
                            if (isSearchBaseSet) {
                                Context context3 = new Context();
                                inRoot.getContexts().add(context3);
                                context3.setKey("realm");
                                context3.setValue((Object)"n/a");
                            }
                            result = this.searchRepository(reposId, inRoot, null, isAllowOperationIfReposDown, failureRepositoryIds);
                            isURBrigeResult = this.isURBridgeResult(result);
                            if (result == null) continue;
                            ents = result.getEntities();
                            if (ents != null) {
                                reposEntities[i] = ents;
                            }
                            responseCtrlMap = ControlsHelper.getControlMap(result);
                            changeResponseCtrls[i] = (ChangeResponseControl)responseCtrlMap.get("ChangeResponseControl");
                            continue;
                        }
                        if (numOfRepos != 1) continue;
                        searchControl.getSearchBases().clear();
                        result = this.searchRepository(reposId, inRoot, null, isAllowOperationIfReposDown, failureRepositoryIds);
                        isURBrigeResult = this.isURBridgeResult(result);
                        if (result == null) continue;
                        ents = result.getEntities();
                        if (ents != null) {
                            reposEntities[i] = ents;
                        }
                        responseCtrlMap = ControlsHelper.getControlMap(result);
                        changeResponseCtrls[i] = (ChangeResponseControl)responseCtrlMap.get("ChangeResponseControl");
                        continue;
                    }
                    Root result = this.searchRepository(reposId, inRoot, null, isAllowOperationIfReposDown, failureRepositoryIds);
                    isURBrigeResult = this.isURBridgeResult(result);
                    if (result == null) continue;
                    List ents = result.getEntities();
                    if (ents != null) {
                        reposEntities[i] = ents;
                    }
                    Map<String, Control> responseCtrlMap = ControlsHelper.getControlMap(result);
                    changeResponseCtrls[i] = (ChangeResponseControl)responseCtrlMap.get("ChangeResponseControl");
                }
                mergedEnts = this.mergeRepositoryEntities(reposEntities, isAllowOperationIfReposDown, failureRepositoryIds);
            }
        }
        retRootDO = new Root();
        int reEntitySize = mergedEnts.size();
        if (searchLimit <= 0) {
            searchLimit = this.getConfigManager().getMaxSearchResults();
        } else if (this.getConfigManager().getMaxSearchResults() > 0) {
            int n = searchLimit = this.getConfigManager().getMaxSearchResults() > searchLimit ? searchLimit : this.getConfigManager().getMaxSearchResults();
        }
        if (searchLimit > 0 && reEntitySize > searchLimit) {
            throw new MaxResultsExceededException("EXCEED_MAX_TOTAL_SEARCH_LIMIT", Tr.formatMessage((TraceComponent)tc, (String)"EXCEED_MAX_TOTAL_SEARCH_LIMIT", (Object[])WIMMessageHelper.generateMsgParms((Object)Integer.toString(reEntitySize), (Object)Integer.toString(searchLimit))));
        }
        if (bChangeSearch && changeResponseCtrls != null && changeResponseCtrls.length > 0) {
            ChangeResponseControl changeResponseCtrl = new ChangeResponseControl();
            retRootDO.getControls().add(changeResponseCtrl);
            for (int i = 0; i < changeResponseCtrls.length; ++i) {
                CheckPointType reposCheckPoint;
                if (changeResponseCtrls[i] == null || (reposCheckPoint = (CheckPointType)changeResponseCtrls[i].getCheckPoint().get(0)).getRepositoryCheckPoint() == null) continue;
                changeResponseCtrl.getCheckPoint().add(reposCheckPoint);
            }
        }
        if (searchCountLimit > 0 && searchCountLimit < reEntitySize) {
            reEntitySize = searchCountLimit;
            SearchResponseControl srchResponseCtrl = new SearchResponseControl();
            srchResponseCtrl.setHasMoreResults(true);
            retRootDO.getControls().add(srchResponseCtrl);
        }
        ArrayList<Entity> processedEnts = new ArrayList<Entity>();
        for (Entity entity : mergedEnts) {
            String qualifiedEntityType = entity.getTypeName();
            this.processReferenceProperty(entity, qualifiedEntityType, true, isAllowOperationIfReposDown, failureRepositoryIds);
            processedEnts.add(entity);
        }
        List<Entity> returnEntities = null;
        if (sortControl != null) {
            List sortKeys = sortControl.getSortKeys();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)WIMTraceHelper.printObjectArray((Object[])new Object[]{sortKeys}), (Object[])new Object[0]);
            }
            if (sortKeys == null || sortKeys.size() == 0) {
                throw new SortControlException("MISSING_SORT_KEY", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_SORT_KEY", null));
            }
            SortHandler sortHandler = new SortHandler(sortControl);
            returnEntities = sortHandler.sortEntities(processedEnts);
        } else {
            returnEntities = processedEnts;
        }
        if (pageControl != null) {
            pageSize = pageControl.getSize();
            startIndex = pageControl.getStartIndex();
        }
        if (pageSize > 0 && FactoryManager.getCacheUtil().isCacheAvailable()) {
            if (this.pagingSearchCache == null) {
                this.maxTotalPagingSearchResults = this.getConfigManager().getPageCacheSize();
                this.pagingSearchResultsCacheTimeOut = this.getConfigManager().getPageCacheTimeOut();
                this.pagingSearchCache = FactoryManager.getCacheUtil().initialize(this.maxTotalPagingSearchResults, this.maxTotalPagingSearchResults, this.pagingSearchResultsCacheTimeOut);
            }
            if (this.pagingSearchCache != null) {
                Root cachedRootDO = new Root();
                if (reEntitySize > pageSize) {
                    if (startIndex < returnEntities.size()) {
                        List retDOEntities = retRootDO.getEntities();
                        int loopTo = startIndex + pageSize;
                        loopTo = loopTo < returnEntities.size() ? loopTo : returnEntities.size();
                        for (int i = startIndex; i < loopTo; ++i) {
                            retDOEntities.add(returnEntities.get(i));
                        }
                    }
                } else {
                    retRootDO.getEntities().addAll(returnEntities);
                }
                cachedRootDO.getEntities().addAll(returnEntities);
                PageCacheEntry entry = new PageCacheEntry(reEntitySize, cachedRootDO);
                this.pagingSearchCache.put(cacheKey, entry);
                PageResponseControl respPageCtrl = new PageResponseControl();
                retRootDO.getControls().add(respPageCtrl);
                respPageCtrl.setTotalSize(reEntitySize);
            }
        } else if (pageControl != null && pageSize == 0) {
            returnEntities.clear();
        }
        if (pageControl == null) {
            retRootDO.getEntities().addAll(returnEntities);
        }
        this.unsetExternalId(retRootDO);
        if (isAllowOperationIfReposDown) {
            context = new Context();
            retRootDO.getContexts().add(context);
            context.setKey("failureRepositoryIDs");
            context.setValue(failureRepositoryIds);
        }
        if (isURBrigeResult) {
            context = new Context();
            context.setKey("isURBridgeResult");
            context.setValue((Object)"true");
            retRootDO.getContexts().add(context);
        }
        return retRootDO;
    }

    /*
     * WARNING - void declaration
     */
    private Root searchRepository(String reposId, Root inputRootDO, HashMap<String, List<String>> returnProps, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        String METHODNAME = "searchRepository";
        Root returnDO = null;
        List ents = null;
        List<String> reposProps = null;
        Object laProps = null;
        boolean bChangeSearch = true;
        Map<String, Control> ctrlMap = ControlsHelper.getControlMap(inputRootDO);
        SearchControl srchCtrl = (SearchControl)ctrlMap.get("ChangeControl");
        if (srchCtrl == null) {
            srchCtrl = (SearchControl)ctrlMap.get("SearchControl");
            bChangeSearch = false;
        }
        if (returnProps != null) {
            reposProps = returnProps.get(REPOS);
            if (reposProps != null) {
                srchCtrl.getProperties().addAll(reposProps);
            } else {
                srchCtrl.getProperties().clear();
            }
        }
        try {
            if (bChangeSearch) {
                boolean bChangeLogSupport = this.isConfigChangeLogSupportEnabled(reposId);
                if (bChangeLogSupport) {
                    Root searchDO = this.keepCheckPointForReposOnly(inputRootDO, reposId);
                    returnDO = this.getRepositoryManager().getRepository(reposId).search(searchDO);
                } else {
                    returnDO = new Root();
                    ChangeResponseControl changeResponseCtrl = new ChangeResponseControl();
                    returnDO.getControls().add(changeResponseCtrl);
                    CheckPointType checkPointDO = new CheckPointType();
                    checkPointDO.setRepositoryId(reposId);
                    changeResponseCtrl.getCheckPoint().add(checkPointDO);
                }
            } else {
                returnDO = this.getRepositoryManager().getRepository(reposId).search(inputRootDO);
            }
        }
        catch (Exception bChangeLogSupport) {
            void e;
            FFDCFilter.processException((Throwable)bChangeLogSupport, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"1142", (Object)this, (Object[])new Object[]{reposId, inputRootDO, returnProps, isAllowOperationIfReposDown, failureRepositoryIds});
            if (!isAllowOperationIfReposDown) {
                if (e instanceof WIMException) {
                    throw (WIMException)e;
                }
                throw new WIMException((Throwable)e);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(METHODNAME + " IGNORE: exception [" + e.getMessage() + "] on repository [" + reposId + "]"), (Object[])new Object[0]);
            }
            failureRepositoryIds.add(reposId);
        }
        if (returnDO != null) {
            ents = returnDO.getEntities();
        }
        if (returnDO != null && (ents = returnDO.getEntities()) != null && ents.size() > 0) {
            for (int j = 0; j < ents.size(); ++j) {
                IdentifierType entIdDO = ((Entity)ents.get(j)).getIdentifier();
                String extId = entIdDO.getExternalId();
                entIdDO.setRepositoryId(reposId);
                if (this.getRepositoryManager().isEntryJoin()) continue;
                entIdDO.setUniqueId(extId);
            }
        }
        if (tc.isDebugEnabled()) {
            if (ents != null) {
                Tr.debug((TraceComponent)tc, (String)(METHODNAME + " returning " + ents.size() + " entities"), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)(METHODNAME + " returning null"), (Object[])new Object[0]);
            }
        }
        return returnDO;
    }

    @Trivial
    private Root keepCheckPointForReposOnly(Root searchDO, String reposId) {
        Root retDO = new Root();
        Map<String, Control> ctrlsMap = ControlsHelper.getControlMap(searchDO);
        ChangeControl changeCtrl = (ChangeControl)ctrlsMap.get("ChangeControl");
        ChangeControl returnChangeControl = new ChangeControl();
        CheckPointType returnCheckPoint = new CheckPointType();
        returnChangeControl.getCheckPoint().add(returnCheckPoint);
        retDO.getControls().add(returnChangeControl);
        List checkPointList = changeCtrl.getCheckPoint();
        if (checkPointList != null) {
            for (CheckPointType checkPointDO : checkPointList) {
                if (!checkPointDO.getRepositoryId().equals(reposId)) continue;
                returnCheckPoint.setRepositoryCheckPoint(checkPointDO.getRepositoryCheckPoint());
                returnCheckPoint.setRepositoryId(checkPointDO.getRepositoryId());
            }
        }
        return retDO;
    }

    @Trivial
    private List<Entity> mergeRepositoryEntities(List<Entity>[] reposEntities, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) {
        ArrayList<Entity> mergedEntities = null;
        if (reposEntities != null && reposEntities.length > 0) {
            mergedEntities = new ArrayList<Entity>();
            for (int j = 0; j < reposEntities.length; ++j) {
                if (reposEntities[j] == null || this.getRepositoryManager().isEntryJoin()) continue;
                mergedEntities.addAll(reposEntities[j]);
            }
        }
        return mergedEntities;
    }

    private Root propertyJoinSearch(String reposId, XPathNode node, Root inputRootDO, HashMap<String, List<String>> returnProps, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        boolean inRepos = true;
        if (node != null) {
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 1: {
                    inRepos = ((LogicalNode)node).isPropertyInRepository();
                    break;
                }
                case 2: {
                    inRepos = ((ParenthesisNode)node).isPropertyInRepository();
                    break;
                }
                case 0: {
                    inRepos = ((PropertyNode)node).isPropertyInRepository();
                    break;
                }
            }
        }
        Root result = null;
        if (inRepos) {
            result = this.searchRepository(reposId, inputRootDO, returnProps, isAllowOperationIfReposDown, failureRepositoryIds);
        }
        return result;
    }

    private Root splitSearch(String reposId, List<String> entityTypes, XPathNode node, Root inputRootDO, HashMap<String, List<String>> returnProps, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        Root search_resultDO = null;
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 8: {
                node = (XPathNode)((FederationParenthesisNode)node).getChild();
                search_resultDO = this.splitSearch(reposId, entityTypes, node, inputRootDO, returnProps, isAllowOperationIfReposDown, failureRepositoryIds);
                break;
            }
            case 4: {
                FederationLogicalNode fNode = (FederationLogicalNode)node;
                XPathNode leftChild = (XPathNode)fNode.getLeftChild();
                XPathNode rightChild = (XPathNode)fNode.getRightChild();
                String operator = fNode.getOperator();
                Root leftDO = this.splitSearch(reposId, entityTypes, leftChild, inputRootDO, returnProps, isAllowOperationIfReposDown, failureRepositoryIds);
                Root rightDO = this.splitSearch(reposId, entityTypes, rightChild, inputRootDO, returnProps, isAllowOperationIfReposDown, failureRepositoryIds);
                if (operator.equals("or")) {
                    search_resultDO = leftDO;
                    List leftEnts = leftDO.getEntities();
                    ArrayList<String> leftUniqueNames = new ArrayList<String>(leftEnts.size());
                    for (Object ent : leftEnts) {
                        String uniqueName;
                        IdentifierType id = ent.getIdentifier();
                        if (id == null || (uniqueName = id.getUniqueName()) == null) continue;
                        leftUniqueNames.add(uniqueName.toLowerCase());
                    }
                    List rightEnts = rightDO.getEntities();
                    for (Entity ent : rightEnts) {
                        String uniqueName;
                        IdentifierType id = ent.getIdentifier();
                        if (id == null || (uniqueName = id.getUniqueName()) == null || leftUniqueNames.contains(uniqueName.toLowerCase())) continue;
                        search_resultDO.getEntities().add(ent);
                    }
                } else {
                    IdentifierType id;
                    Entity ent;
                    List leftEnts = leftDO.getEntities();
                    ArrayList<String> leftUniqueNames = new ArrayList<String>(leftEnts.size());
                    for (int i = 0; i < leftEnts.size(); ++i) {
                        Entity ent2 = (Entity)leftEnts.get(i);
                        IdentifierType id2 = ent2.getIdentifier();
                        if (id2 == null) continue;
                        String uniqueName = id2.getUniqueName();
                        if (uniqueName != null) {
                            leftUniqueNames.add(uniqueName.toLowerCase());
                            continue;
                        }
                        leftEnts.remove(i);
                        --i;
                    }
                    List rightEnts = rightDO.getEntities();
                    ArrayList<String> rightUniqueNames = new ArrayList<String>(rightEnts.size());
                    for (int i = 0; i < rightEnts.size(); ++i) {
                        Entity ent3 = (Entity)rightEnts.get(i);
                        IdentifierType id3 = ent3.getIdentifier();
                        if (id3 == null) continue;
                        String uniqueName = id3.getUniqueName();
                        if (uniqueName != null) {
                            rightUniqueNames.add(uniqueName.toLowerCase());
                            continue;
                        }
                        rightEnts.remove(i);
                        --i;
                    }
                    if (leftEnts.size() < rightEnts.size()) {
                        search_resultDO = leftDO;
                        List searchEnts = search_resultDO.getEntities();
                        for (int j = 0; j < searchEnts.size(); ++j) {
                            String uniqueName;
                            ent = (Entity)searchEnts.get(j);
                            id = ent.getIdentifier();
                            if (id == null || rightUniqueNames.contains((uniqueName = id.getUniqueName()).toLowerCase())) continue;
                            searchEnts.remove(j);
                            --j;
                        }
                    } else {
                        search_resultDO = rightDO;
                        List searchEnts = search_resultDO.getEntities();
                        for (int j = 0; j < searchEnts.size(); ++j) {
                            String uniqueName;
                            ent = (Entity)searchEnts.get(j);
                            id = ent.getIdentifier();
                            if (id == null || leftUniqueNames.contains((uniqueName = id.getUniqueName()).toLowerCase())) continue;
                            searchEnts.remove(j);
                            --j;
                        }
                    }
                }
                break;
            }
            default: {
                inputRootDO = this.prepareSearchExpression(entityTypes, node, inputRootDO);
                search_resultDO = this.propertyJoinSearch(reposId, node, inputRootDO, returnProps, isAllowOperationIfReposDown, failureRepositoryIds);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)WIMTraceHelper.printObjectArray((Object[])new Object[]{search_resultDO}), (Object[])new Object[0]);
        }
        return search_resultDO;
    }

    private Root prepareSearchExpression(List<String> entityTypes, XPathNode node, Root inputRootDO) {
        String searchEntityTypeTemplate = "@xsi:type='%ENTITYTYPE%'";
        String leftBracket = "(";
        String rightBracket = ")";
        String and = " and ";
        String or = " or ";
        String ExpressionTemplate = "(%SEARCH_STRING%)";
        StringBuffer srchExpr = new StringBuffer();
        StringBuffer entExpr = new StringBuffer();
        StringBuffer condExpr = new StringBuffer();
        if (inputRootDO != null && node != null && entityTypes != null) {
            String entType;
            if (entityTypes.size() == 1) {
                entType = searchEntityTypeTemplate.replaceFirst("%ENTITYTYPE%", entityTypes.get(0));
                entExpr.append(entType);
            } else if (entityTypes.size() > 1) {
                entExpr.append(leftBracket);
                entType = searchEntityTypeTemplate.replaceFirst("%ENTITYTYPE%", entityTypes.get(0));
                entExpr.append(entType);
                for (int i = 1; i < entityTypes.size(); ++i) {
                    entExpr.append(or);
                    entType = searchEntityTypeTemplate.replaceFirst("%ENTITYTYPE%", entityTypes.get(i));
                    entExpr.append(entType);
                }
                entExpr.append(rightBracket);
            }
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 2: {
                    node = (XPathNode)((ParenthesisNode)node).getChild();
                }
            }
            this.nodeToString(condExpr, node);
            srchExpr.append(entExpr);
            srchExpr.append(and);
            String cExpr = ExpressionTemplate.replaceFirst("%SEARCH_STRING%", condExpr.toString());
            srchExpr.append(cExpr);
            Map<String, Control> ctrlMap = ControlsHelper.getControlMap(inputRootDO);
            SearchControl searchControl = (SearchControl)ctrlMap.get("SearchControl");
            searchControl.setExpression(srchExpr.toString());
        }
        return inputRootDO;
    }

    private StringBuffer nodeToString(StringBuffer searchExpr, XPathNode node) {
        if (node != null && searchExpr != null) {
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 1: {
                    searchExpr = this.nodeToString(searchExpr, (XPathNode)((LogicalNode)node).getLeftChild());
                    searchExpr.append(" " + ((LogicalNode)node).getOperator() + " ");
                    searchExpr = this.nodeToString(searchExpr, (XPathNode)((LogicalNode)node).getRightChild());
                    break;
                }
                case 2: {
                    searchExpr = this.nodeToString(searchExpr, (XPathNode)((ParenthesisNode)node).getChild());
                    break;
                }
                case 0: {
                    searchExpr.append(node.toString());
                    break;
                }
            }
        }
        return searchExpr;
    }

    private HashMap<String, List<String>> validateAndDivideReturnProperties(List<String> entityTypes, List<String> props, String reposId, boolean returnSubTypes) {
        String METHODNAME = "validateAndDivideReturnProperties";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)WIMTraceHelper.printObjectArray((Object[])new Object[]{entityTypes, props, reposId}), (Object[])new Object[0]);
        }
        HashMap<String, List<String>> returnProps = new HashMap<String, List<String>>();
        ArrayList<String> reposProps = new ArrayList<String>(props);
        ArrayList<String> laProps = new ArrayList<String>(props);
        if (entityTypes != null && returnSubTypes) {
            ArrayList subTypes = new ArrayList();
            for (int k = 0; k < entityTypes.size(); ++k) {
                HashSet types = Entity.getSubEntityTypes((String)entityTypes.get(k));
                if (types == null) continue;
                subTypes.addAll(types);
            }
            entityTypes.addAll(subTypes);
        }
        Set<String> laSupportedPropNames = this.propMgr.getLookAsidePropertyNameSet(entityTypes);
        Set<String> reposSupportedPropNames = this.propMgr.getRepositoryPropertyNameSet(reposId, entityTypes);
        ArrayList<String> reposRemovePropNames = new ArrayList<String>();
        for (int i = 0; i < reposProps.size(); ++i) {
            String propName = (String)reposProps.get(i);
            if (!reposSupportedPropNames.contains(propName) && !propName.equals("*")) {
                reposRemovePropNames.add(propName);
                continue;
            }
            if (!propName.equals("*")) continue;
            reposProps.clear();
            reposProps.add("*");
            laProps.clear();
            laProps.add("*");
            returnProps.put(REPOS, reposProps);
            returnProps.put(LA, laProps);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(METHODNAME + " propName=" + "*" + ", returnProps=" + returnProps), (Object[])new Object[0]);
            }
            return returnProps;
        }
        reposProps.removeAll(reposRemovePropNames);
        ArrayList<String> laRemovePropNames = new ArrayList<String>();
        for (int i = 0; i < laProps.size() && laSupportedPropNames != null; ++i) {
            String propName = (String)laProps.get(i);
            if (laSupportedPropNames.contains(propName)) continue;
            laRemovePropNames.add(propName);
        }
        laProps.removeAll(laRemovePropNames);
        returnProps.put(REPOS, reposProps);
        returnProps.put(LA, laProps);
        return returnProps;
    }

    @Trivial
    private static void validateChangeTypes(List<String> changeTypes) throws ChangeControlException {
        String curChangeType = null;
        for (int i = 0; i < changeTypes.size(); ++i) {
            curChangeType = changeTypes.get(i);
            if ("add".equals(curChangeType) || DELETE_EMITTER.equals(curChangeType) || "rename".equals(curChangeType) || "modify".equals(curChangeType) || "*".equals(curChangeType)) continue;
            throw new ChangeControlException("INVALID_CHANGETYPE", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_CHANGETYPE", (Object[])WIMMessageHelper.generateMsgParms((Object)curChangeType)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={PasswordCheckFailedException.class, Exception.class})
    private Root loginImpl(Root inRoot) throws WIMException {
        Map<String, Control> ctrlMap;
        String METHODNAME = "loginImpl";
        if (inRoot == null) {
            return null;
        }
        Root result = null;
        Root root = inRoot;
        HashMap<String, Integer> exceptions = new HashMap<String, Integer>();
        Throwable exp = null;
        LoginControl ctrl = null;
        String reposId = null;
        String principalName = null;
        byte[] pwd = null;
        boolean isAllowOperationIfReposDown = false;
        HashSet<String> failureRepositoryIds = new HashSet<String>();
        int certExceptionCount = 0;
        List entities = root.getEntities();
        if (entities.size() == 0) {
            throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_ENTITY_DATA_OBJECT", null));
        }
        if (entities.size() > 1) {
            throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ACTION_MULTIPLE_ENTITIES_SPECIFIED", null));
        }
        LoginAccount personAccount = (LoginAccount)entities.get(0);
        principalName = personAccount.getPrincipalName();
        pwd = personAccount.getPassword();
        if (personAccount.getCertificate().size() == 0 && principalName == null) {
            throw new PasswordCheckFailedException("MISSING_OR_EMPTY_PRINCIPAL_NAME", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_OR_EMPTY_PRINCIPAL_NAME", null));
        }
        List contexts = root.getContexts();
        if (contexts != null && contexts.size() > 0) {
            for (Context contextInput : contexts) {
                String key = contextInput.getKey();
                if (key == null || !"allowOperationIfReposDown".equals(key)) continue;
                isAllowOperationIfReposDown = (Boolean)contextInput.getValue();
            }
        }
        if ((ctrl = (LoginControl)(ctrlMap = ControlsHelper.getControlMap(inRoot)).get("LoginControl")) == null) {
            ctrl = new LoginControl();
            inRoot.getControls().add(ctrl);
        }
        List searchBases = ctrl.getSearchBases();
        String realm = this.getRealmName(root);
        Map<String, List<String>> reposSearchBases = new HashMap<String, List<String>>();
        reposSearchBases = searchBases.size() > 0 ? this.divideSearchBases(searchBases, realm, reposSearchBases) : this.getSearchBasesFromRealm(realm, reposSearchBases);
        try {
            List<String> reposIds = this.getRepositoryManager().getRepoIds();
            for (int i = 0; i < reposIds.size(); ++i) {
                List<String> srchBases;
                reposId = reposIds.get(i);
                if (reposSearchBases == null || (srchBases = reposSearchBases.get(reposId)) == null || srchBases.size() <= 0) continue;
                try {
                    Root inputRoot = inRoot;
                    Map<String, Control> cMap = ControlsHelper.getControlMap(inputRoot);
                    LoginControl lCtrl = (LoginControl)cMap.get("LoginControl");
                    lCtrl.getSearchBases().clear();
                    lCtrl.getSearchBases().addAll(srchBases);
                    Root retRoot = this.getRepositoryManager().getRepository(reposId).login(inputRoot);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("loginImpl after calling adapter [" + reposId + "]"), (Object[])new Object[0]);
                    }
                    if (result == null) {
                        if (retRoot.getEntities().size() > 0) {
                            result = retRoot;
                        }
                        continue;
                    }
                    if (retRoot.getEntities().size() <= 0) continue;
                    if (tc.isErrorEnabled()) {
                        Tr.error((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)principalName));
                    }
                    throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)principalName)));
                }
                catch (PasswordCheckFailedException e) {
                    String msgKey = e.getMessageKey();
                    if ("PRINCIPAL_NOT_FOUND".equals(msgKey)) continue;
                    if ("MISSING_OR_EMPTY_PRINCIPAL_NAME".equals(msgKey)) {
                        throw e;
                    }
                    if ("MULTIPLE_PRINCIPALS_FOUND".equals(msgKey)) {
                        throw e;
                    }
                    exp = e;
                    this.recordLoginException((WIMException)((Object)e), exceptions);
                    continue;
                }
                catch (CertificateMapFailedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"1647", (Object)this, (Object[])new Object[]{inRoot});
                    exp = e;
                    this.recordLoginException((WIMException)((Object)e), exceptions);
                    continue;
                }
                catch (CertificateMapNotSupportedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"1650", (Object)this, (Object[])new Object[]{inRoot});
                    exp = e;
                    this.recordLoginException((WIMException)((Object)e), exceptions);
                    ++certExceptionCount;
                    continue;
                }
                catch (Exception e) {
                    exp = new WIMException((Throwable)e);
                    if (e instanceof DuplicateLogonIdException) {
                        throw (DuplicateLogonIdException)e;
                    }
                    if (!isAllowOperationIfReposDown) {
                        throw exp;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("loginImpl IGNORE: exception [" + exp.getMessage() + "] on repository [" + reposId + "]"), (Object[])new Object[0]);
                    }
                    failureRepositoryIds.add(reposId);
                }
            }
        }
        finally {
            PasswordUtil.erasePassword((byte[])pwd);
        }
        int countedException = exceptions.size();
        if (result == null && 0 == countedException) {
            if (exceptions.containsKey("AUTHENTICATION_WITH_CERT_NOT_SUPPORTED")) {
                if (certExceptionCount == this.getRepositoryManager().getNumberOfRepositories()) {
                    throw new CertificateMapNotSupportedException("AUTHENTICATE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"AUTHENTICATE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)"the specified certificate")));
                }
                throw new CertificateMapFailedException("CERTIFICATE_MAP_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"CERTIFICATE_MAP_FAILED", null));
            }
            if (personAccount.getCertificate().size() > 0 && principalName == null) {
                principalName = "extracted from certificate";
            }
            throw new PasswordCheckFailedException("PRINCIPAL_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"PRINCIPAL_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)principalName)));
        }
        if (countedException == 1) {
            if (exceptions.containsKey("AUTHENTICATION_WITH_CERT_NOT_SUPPORTED") && certExceptionCount != this.getRepositoryManager().getNumberOfRepositories()) {
                throw new CertificateMapFailedException("CERTIFICATE_MAP_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"CERTIFICATE_MAP_FAILED", null));
            }
            throw exp;
        }
        if (countedException > 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("loginImpl countedException > 1 [" + countedException + "]"), (Object[])new Object[0]);
            }
            throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)principalName)));
        }
        if (countedException == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"loginImpl login successful.", (Object[])new Object[0]);
            }
        } else if (countedException >= 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"loginImpl result != null && countedException >= 1", (Object[])new Object[0]);
            }
            if (exceptions.containsKey("AUTHENTICATION_WITH_CERT_NOT_SUPPORTED")) {
                if (certExceptionCount == this.getRepositoryManager().getNumberOfRepositories()) {
                    throw new CertificateMapNotSupportedException("AUTHENTICATE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"AUTHENTICATE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)"the specified certificate")));
                }
                throw new CertificateMapFailedException("CERTIFICATE_MAP_FAILED", Tr.formatMessage((TraceComponent)tc, (String)"CERTIFICATE_MAP_FAILED", null));
            }
            throw new DuplicateLogonIdException("MULTIPLE_PRINCIPALS_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"MULTIPLE_PRINCIPALS_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)principalName)));
        }
        this.prepareDataGraphForCaller(result, null, null, isAllowOperationIfReposDown, failureRepositoryIds);
        if (isAllowOperationIfReposDown) {
            Context context = new Context();
            result.getContexts().add(context);
            context.setKey("failureRepositoryIDs");
            context.setValue(failureRepositoryIds);
        }
        return result;
    }

    @Trivial
    private void recordLoginException(WIMException e, Map<String, Integer> container) {
        String METHODNAME = "recordLoginException";
        String key = e.getMessageKey();
        if (container.containsKey(key)) {
            int value = container.get(key) + 1;
            container.put(key, value);
        } else {
            container.put(key, 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " record exception [" + key + "]"), (Object[])new Object[0]);
        }
    }

    Map<String, List<String>> getSearchBasesFromRealm(String realmName, Map<String, List<String>> reposSearchBases) throws WIMException {
        Map<String, List<String>> baseMap = null;
        if (realmName != null && this.getConfigManager().getRealmConfig(realmName) != null) {
            String[] realmBaseEntries = this.getConfigManager().getRealmConfig(realmName).getParticipatingBaseEntries();
            if (realmBaseEntries == null || realmBaseEntries.length == 0) {
                throw new WIMException("MISSING_BASE_ENTRY_IN_REALM", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_BASE_ENTRY_IN_REALM", (Object[])WIMMessageHelper.generateMsgParms((Object)realmName)));
            }
            baseMap = this.getRepositoryManager().getBaseEntriesForRepos(realmBaseEntries);
        }
        reposSearchBases = baseMap == null ? this.getRepositoryManager().getRepositoriesBaseEntries() : baseMap;
        return reposSearchBases;
    }

    private Map<String, List<String>> divideSearchBases(List<String> searchBases, String vrealmName, Map<String, List<String>> reposSearchBases) throws WIMException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)WIMTraceHelper.printObjectArray((Object[])new Object[]{searchBases, vrealmName, reposSearchBases}), (Object[])new Object[0]);
        }
        for (String searchBase : searchBases) {
            if (searchBase == null) continue;
            if (!this.getConfigManager().isUniqueNameInRealm(searchBase, vrealmName)) {
                throw new WIMApplicationException("NON_EXISTING_SEARCH_BASE", Tr.formatMessage((TraceComponent)tc, (String)"NON_EXISTING_SEARCH_BASE", (Object[])WIMMessageHelper.generateMsgParms((Object)searchBase)));
            }
            String reposId = this.getRepositoryManager().getRepositoryIdByUniqueName(searchBase);
            List<String> searchBaseList = reposSearchBases.get(reposId);
            if (searchBaseList == null) {
                searchBaseList = new ArrayList<String>();
            }
            searchBaseList.add(searchBase);
            reposSearchBases.put(reposId, searchBaseList);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)WIMTraceHelper.printObjectArray((Object[])new Object[]{reposSearchBases}), (Object[])new Object[0]);
        }
        return reposSearchBases;
    }

    private List<Entity> mergeEntitiesList(List<Entity>[] retEntities) {
        ArrayList<Entity> mergedEntities = new ArrayList<Entity>();
        for (int j = 0; j < retEntities.length; ++j) {
            if (retEntities[j] == null) continue;
            mergedEntities.addAll(retEntities[j]);
        }
        return mergedEntities;
    }

    private Entity retrieveEntity(String repositoryId, IdentifierType identifier, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        String METHODNAME = "retrieveEntity";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " (" + repositoryId + ", " + identifier + ", " + isAllowOperationIfReposDown + ", " + failureRepositoryIds + ")"), (Object[])new Object[0]);
        }
        Entity retEntDO = null;
        String uniqueId = identifier.getUniqueId();
        String uniqueName = identifier.getUniqueName();
        if (!(uniqueId != null && uniqueId.length() != 0 || uniqueName != null && uniqueName.length() != 0)) {
            throw new InvalidIdentifierException("INVALID_IDENTIFIER", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_IDENTIFIER", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId, (Object)uniqueName)));
        }
        if (uniqueName != null) {
            uniqueName = UniqueNameHelper.formatUniqueName(uniqueName);
            identifier.setUniqueName(uniqueName);
        }
        retEntDO = this.retrieveEntityFromRepository(repositoryId, identifier, isAllowOperationIfReposDown, failureRepositoryIds);
        return retEntDO;
    }

    @FFDCIgnore(value={ClassCastException.class})
    private void prepareDataGraphForCaller(Root root, String uid, String uName, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        List entities;
        String METHODNAME = "prepareDataGraphForCaller";
        if (root != null && (entities = root.getEntities()) != null) {
            for (Entity entity : entities) {
                List grps;
                IdentifierType id;
                List mbrs;
                Group group;
                block8: {
                    String type = entity.getTypeName();
                    IdentifierType identifier = entity.getIdentifier();
                    if (identifier != null) {
                        this.prepareForCaller(identifier, type, uid, uName, isAllowOperationIfReposDown, failureRepositoryIds);
                    }
                    this.processReferenceProperty(entity, type, true, isAllowOperationIfReposDown, failureRepositoryIds);
                    group = null;
                    try {
                        group = (Group)entity;
                    }
                    catch (ClassCastException e) {
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug((TraceComponent)tc, (String)(METHODNAME + " Entity is not a group or its subtype"), (Object[])new Object[0]);
                    }
                }
                if (group != null && (mbrs = group.getMembers()) != null) {
                    for (Entity mbr : mbrs) {
                        String mbrType = entity.getTypeName();
                        id = mbr.getIdentifier();
                        this.prepareForCaller(id, mbrType, null, null, isAllowOperationIfReposDown, failureRepositoryIds);
                        this.processReferenceProperty(mbr, mbrType, true, isAllowOperationIfReposDown, failureRepositoryIds);
                    }
                }
                if ((grps = entity.getGroups()) == null) continue;
                for (Group grp : grps) {
                    String grpType = entity.getTypeName();
                    id = grp.getIdentifier();
                    this.prepareForCaller(id, grpType, null, null, isAllowOperationIfReposDown, failureRepositoryIds);
                    if (this.propMgr.getReferencePropertyNameSet(grpType) == null) continue;
                    this.processReferenceProperty((Entity)grp, grpType, true, isAllowOperationIfReposDown, failureRepositoryIds);
                }
            }
        }
    }

    private void prepareForCaller(IdentifierType id, String qualifiedEntityType, String uid, String uName, boolean isIgnoreRepositoryErrors, Set<String> failureRepositoryIds) throws WIMException {
        String METHODNAME = "prepareForCaller";
        if (id != null) {
            String externalId = id.getExternalId();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(METHODNAME + " prepare identifier for caller, set [uniqueId=" + externalId + "]"), (Object[])new Object[0]);
            }
            if (externalId != null) {
                id.setUniqueId(externalId);
            }
            id.setExternalId(null);
        }
    }

    private void processReferenceProperty(Entity entity, String qualifiedEntityType, boolean read, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        Set<String> refPropNames = this.propMgr.getReferencePropertyNameSet(qualifiedEntityType);
        if (refPropNames != null) {
            for (String qualifiedPropName : refPropNames) {
                String prop = entity.getDataType(qualifiedPropName);
                if (prop == null || !entity.isSet(prop)) continue;
                if (entity.get(qualifiedPropName) instanceof List) {
                    List ids = (List)entity.get(prop);
                    for (int i = 0; i < ids.size(); ++i) {
                        this.processIdentifier((IdentifierType)ids.get(i), read, isAllowOperationIfReposDown, failureRepositoryIds);
                    }
                    continue;
                }
                IdentifierType id = entity.getIdentifier();
                this.processIdentifier(id, read, isAllowOperationIfReposDown, failureRepositoryIds);
            }
        }
        if (tc.isDebugEnabled()) {
            // empty if block
        }
    }

    private void processIdentifier(IdentifierType id, boolean fromSPI, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        if (tc.isDebugEnabled()) {
            // empty if block
        }
        String extId = id.getExternalId();
        if (fromSPI) {
            if (extId != null) {
                id.setUniqueId(extId);
            }
            id.setExternalId(null);
        } else {
            this.retrieveEntityFromRepository(null, id, isAllowOperationIfReposDown, failureRepositoryIds);
        }
        if (tc.isDebugEnabled()) {
            // empty if block
        }
    }

    /*
     * WARNING - void declaration
     */
    private Entity retrieveEntityFromRepository(String repositoryId, IdentifierType identifier, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        String METHODNAME = "retrieveEntityFromRepository";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " (" + repositoryId + ", " + identifier + ", " + isAllowOperationIfReposDown + ", " + failureRepositoryIds + ")"), (Object[])new Object[0]);
        }
        Entity retEntDO = null;
        Root root = new Root();
        String extId = identifier.getExternalId();
        String extName = identifier.getExternalName();
        String uniqueId = identifier.getUniqueId();
        String uniqueName = identifier.getUniqueName();
        if (!(uniqueId != null && uniqueId.length() != 0 || uniqueName != null && uniqueName.length() != 0)) {
            throw new InvalidIdentifierException("INVALID_IDENTIFIER", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_IDENTIFIER", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId, (Object)uniqueName)));
        }
        if (retEntDO == null) {
            Entity inEntDO = new Entity();
            root.getEntities().add(inEntDO);
            IdentifierType idDO = new IdentifierType();
            inEntDO.setIdentifier(idDO);
            if (extId != null) {
                idDO.setExternalId(extId);
            } else {
                idDO.setExternalId(uniqueId);
            }
            idDO.setExternalName(extName);
            idDO.setUniqueName(uniqueName);
            if (uniqueId != null && repositoryId == null) {
                List<String> reposIds = this.getRepositoryManager().getRepoIds();
                for (int i = 0; i < reposIds.size() && retEntDO == null; ++i) {
                    String reposId = reposIds.get(i);
                    try {
                        List entList;
                        Root retRoot = this.getRepositoryManager().getRepository(reposId).get(root);
                        if (retRoot == null || (entList = retRoot.getEntities()).size() < 1) continue;
                        retEntDO = (Entity)entList.get(0);
                        continue;
                    }
                    catch (EntityNotFoundException retRoot) {
                        FFDCFilter.processException((Throwable)retRoot, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"2056", (Object)this, (Object[])new Object[]{repositoryId, identifier, isAllowOperationIfReposDown, failureRepositoryIds});
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)(METHODNAME + " EntityNotFoundException[reposId=" + reposId + "] - " + uniqueId), (Object[])new Object[0]);
                        continue;
                    }
                    catch (WIMSystemException e) {
                        void wse;
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"2060", (Object)this, (Object[])new Object[]{repositoryId, identifier, isAllowOperationIfReposDown, failureRepositoryIds});
                        String message = wse.getMessage();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " WSE message = " + message), (Object[])new Object[0]);
                        }
                        if (message != null && message.contains("CWIML4520E") && message.contains("javax.naming.InvalidNameException")) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " WIMSystemException [reposId=" + reposId + "] - " + message), (Object[])new Object[0]);
                            continue;
                        }
                        throw wse;
                    }
                    catch (Exception wse) {
                        FFDCFilter.processException((Throwable)wse, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"2071", (Object)this, (Object[])new Object[]{repositoryId, identifier, isAllowOperationIfReposDown, failureRepositoryIds});
                        if (!isAllowOperationIfReposDown) {
                            if (e instanceof WIMException) {
                                throw (WIMException)e;
                            }
                            throw new WIMException((Throwable)e);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " IGNORE: exception [" + e.getMessage() + "] when retrieve entity from repository [" + reposId + "]"), (Object[])new Object[0]);
                        }
                        failureRepositoryIds.add(reposId);
                    }
                }
            } else {
                List entList;
                Root retRoot;
                if (repositoryId == null) {
                    repositoryId = this.getRepositoryManager().getRepositoryId(uniqueName);
                }
                if ((retRoot = this.getRepositoryManager().getRepository(repositoryId).get(root)) != null && (entList = retRoot.getEntities()).size() >= 1) {
                    retEntDO = (Entity)entList.get(0);
                }
            }
        }
        if (retEntDO == null) {
            String id = null;
            id = uniqueId != null ? uniqueId : uniqueName;
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)id)));
        }
        IdentifierType idDO = retEntDO.getIdentifier();
        identifier.setExternalId(idDO.getExternalId());
        identifier.setExternalName(idDO.getExternalName());
        identifier.setUniqueId(idDO.getUniqueId());
        identifier.setUniqueName(idDO.getUniqueName());
        identifier.setRepositoryId(idDO.getRepositoryId());
        return retEntDO;
    }

    private List<? extends Entity> setExtIdAndRepositoryIdForEntities(List<? extends Entity> members, String targetReposId, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        if (members == null) {
            return null;
        }
        for (Entity entity : members) {
            IdentifierType mbrEntIdDO = entity.getIdentifier();
            if (mbrEntIdDO == null) {
                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IDENTIFIER_NOT_SPECIFIED", (Object[])new Object[0]));
            }
            String uniqueId = mbrEntIdDO.getUniqueId();
            String uniqueName = mbrEntIdDO.getUniqueName();
            String extId = null;
            String reposUUID = null;
            String uName = null;
            if (this.getRepositoryManager().getNumberOfRepositories() == 1) {
                if (uniqueId != null) {
                    extId = uniqueId;
                    reposUUID = targetReposId;
                }
            } else {
                IdentifierType idDO = this.getIdentifierByUniqueIdOrUniqueName(uniqueId, uniqueName, isAllowOperationIfReposDown, failureRepositoryIds);
                if (idDO != null) {
                    extId = idDO.getExternalId();
                    reposUUID = idDO.getRepositoryId();
                    uName = idDO.getUniqueName();
                }
            }
            if (extId != null) {
                mbrEntIdDO.setExternalId(extId);
            }
            if (reposUUID != null) {
                mbrEntIdDO.setRepositoryId(reposUUID);
            }
            if (uName == null) continue;
            mbrEntIdDO.setUniqueName(uName);
        }
        return members;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IdentifierType getIdentifierByUniqueIdOrUniqueName(String uniqueId, String uniqueName, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        boolean found;
        WIMException ex;
        IdentifierType idDO;
        block8: {
            IdentifierType tempIdDO;
            Entity tempEntityDO;
            Root tempDO;
            block7: {
                String METHODNAME = "getIdentifierByUniqueIdOrUniqueName";
                idDO = null;
                ex = null;
                found = false;
                tempDO = new Root();
                tempEntityDO = new Entity();
                tempIdDO = new IdentifierType();
                tempEntityDO.setIdentifier(tempIdDO);
                tempDO.getEntities().add(tempEntityDO);
                if (uniqueName == null) break block7;
                String reposId = this.getRepositoryManager().getRepositoryIdByUniqueName(uniqueName);
                tempIdDO.setUniqueName(uniqueName);
                Root retRootDO = this.getRepositoryManager().getTargetRepository(reposId).get(tempDO);
                if (retRootDO == null) break block8;
                List pes = retRootDO.getEntities();
                if (pes == null) throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName)));
                Entity ent = (Entity)pes.get(0);
                if (ent == null || (idDO = ent.getIdentifier()) == null) break block8;
                found = true;
                break block8;
            }
            int i = 0;
            List<String> reposIds = this.getRepositoryManager().getRepoIds();
            String reposId = null;
            while (i < reposIds.size() && !found) {
                reposId = reposIds.get(i);
                tempDO = new Root();
                tempEntityDO = new Entity();
                tempIdDO = new IdentifierType();
                tempEntityDO.setIdentifier(tempIdDO);
                tempDO.getEntities().add(tempEntityDO);
                if (uniqueId != null) {
                    tempIdDO.setUniqueId(uniqueId);
                }
                try {
                    Entity ent;
                    List pes;
                    Root retRootDO = this.getRepositoryManager().getRepository(reposId).get(tempDO);
                    if (retRootDO == null || (pes = retRootDO.getEntities()) == null || (ent = (Entity)pes.get(0)) == null || (idDO = ent.getIdentifier()) == null) continue;
                    found = true;
                }
                catch (EntityNotFoundException retRootDO) {
                    void e;
                    FFDCFilter.processException((Throwable)retRootDO, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"2248", (Object)this, (Object[])new Object[]{uniqueId, uniqueName, isAllowOperationIfReposDown, failureRepositoryIds});
                    ++i;
                    ex = e;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"2251", (Object)this, (Object[])new Object[]{uniqueId, uniqueName, isAllowOperationIfReposDown, failureRepositoryIds});
                    WIMException we = null;
                    we = e instanceof WIMException ? (WIMException)((Object)e) : new WIMException((Throwable)e);
                    if (!isAllowOperationIfReposDown) {
                        throw we;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getIdentifierByUniqueIdOrUniqueName IGNORE: exception [" + e.getMessage() + "] on repository [" + reposId + "]"), (Object[])new Object[0]);
                    }
                    failureRepositoryIds.add(reposId);
                    ex = we;
                }
            }
        }
        if (found || ex == null) return idDO;
        throw ex;
    }

    private String getRealmName(Root root) {
        String value = null;
        List contexts = root.getContexts();
        if (contexts == null || contexts.size() == 0) {
            if (this.getConfigManager() != null) {
                value = this.getConfigManager().getDefaultRealmName();
            }
        } else {
            for (int i = 0; i < contexts.size() && (value == null || value.length() == 0); ++i) {
                Context context = (Context)contexts.get(i);
                String key = context.getKey();
                if (key == null || !"realm".equals(key)) continue;
                value = (String)context.getValue();
            }
            if (value == null) {
                value = this.getConfigManager().getDefaultRealmName();
            }
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private void groupMembershipLookup(Root root, String repositoryId, GroupControl ctrl, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds, CacheControl clearCacheCtrl) throws WIMException {
        String METHODNAME = "groupMembershipLookup";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " repositoryId=" + repositoryId), (Object[])new Object[0]);
        }
        int level = ctrl.getLevel();
        if (root != null) {
            List entities = root.getEntities();
            for (Entity entity : entities) {
                IdentifierType id = entity.getIdentifier();
                if (!(ctrl instanceof GroupMembershipControl)) continue;
                List groups = entity.getGroups();
                ArrayList<IdentifierType> groupIDS = new ArrayList<IdentifierType>();
                groupIDS.add(id);
                if (level == 0) {
                    for (int j = 0; j < groups.size(); ++j) {
                        Group grp = (Group)groups.get(j);
                        groupIDS.add(grp.getIdentifier());
                    }
                }
                for (String targetId : this.getRepositoryManager().getRepositoriesForGroupMembership(repositoryId)) {
                    if (targetId.equals(repositoryId)) continue;
                    for (IdentifierType tempGrp : groupIDS) {
                        Root newRoot = new Root();
                        IdentifierType newId = new IdentifierType();
                        Entity newEntity = new Entity();
                        newEntity.setIdentifier(newId);
                        newRoot.getEntities().add(newEntity);
                        newId.setUniqueId(tempGrp.getUniqueId());
                        newId.setUniqueName(tempGrp.getUniqueName());
                        newId.setRepositoryId(tempGrp.getRepositoryId());
                        newId.setExternalId(tempGrp.getExternalId());
                        newId.setExternalName(tempGrp.getExternalName());
                        newRoot.getControls().add(ctrl);
                        if (clearCacheCtrl != null) {
                            newRoot.getControls().add(clearCacheCtrl);
                        }
                        try {
                            Root retRoot = this.getRepositoryManager().getRepository(targetId).get(newRoot);
                            if (retRoot == null) continue;
                            List retEntities = retRoot.getEntities();
                            Entity retEntity = (Entity)retEntities.get(0);
                            List grps = retEntity.getGroups();
                            List totalGroups = entity.getGroups();
                            for (Group newGroup : grps) {
                                boolean duplicateGroup = false;
                                IdentifierType newIdentifier = newGroup.getIdentifier();
                                for (Group group : totalGroups) {
                                    IdentifierType identifier = group.getIdentifier();
                                    if (!this.isIdentifierEqual(identifier, newIdentifier)) continue;
                                    duplicateGroup = true;
                                    break;
                                }
                                if (duplicateGroup) continue;
                                totalGroups.add(newGroup);
                            }
                        }
                        catch (Exception retRoot) {
                            void e;
                            FFDCFilter.processException((Throwable)retRoot, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"2373", (Object)this, (Object[])new Object[]{root, repositoryId, ctrl, isAllowOperationIfReposDown, failureRepositoryIds, clearCacheCtrl});
                            if (!isAllowOperationIfReposDown) {
                                if (e instanceof WIMException) {
                                    throw (WIMException)e;
                                }
                                throw new WIMException((Throwable)e);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(METHODNAME + " IGNORE: exception [" + e.getMessage() + "] on repository [" + targetId + "]"), (Object[])new Object[0]);
                            }
                            failureRepositoryIds.add(targetId);
                        }
                    }
                }
            }
        }
    }

    private boolean isIdentifierEqual(IdentifierType targetId, IdentifierType id) {
        boolean result = false;
        if (targetId.getUniqueId() != null && targetId.getUniqueId().equals(id.getUniqueId())) {
            result = true;
        } else if (targetId.getUniqueName() != null && targetId.getUniqueName().equals(id.getUniqueName())) {
            result = true;
        } else if (targetId.getExternalId() != null && targetId.getExternalId().equals(id.getExternalId())) {
            result = true;
        } else if (targetId.getExternalName() != null && targetId.getExternalName().equals(id.getExternalName())) {
            result = true;
        }
        return result;
    }

    private boolean isConfigChangeLogSupportEnabled(String reposId) throws WIMException {
        return false;
    }

    public String getRealmName() throws WIMException {
        String realmName = null;
        List<String> repoIds = this.getRepositoryManager().getRepoIds();
        if (repoIds != null && repoIds.size() > 0) {
            Repository repository = this.getRepositoryManager().getRepository(repoIds.get(0));
            realmName = repository.getRealm();
        }
        return realmName;
    }

    public List<String> getReposForExternalName(String externalName, String realmName) throws WIMException {
        List<String> reposIds;
        if ((externalName = UniqueNameHelper.getValidUniqueName(externalName)) == null || externalName.trim().equals("")) {
            return Collections.emptyList();
        }
        int uLength = externalName.length();
        String[] realmBaseEntries = null;
        if (this.getConfigManager() != null && this.getConfigManager().getRealmConfig(realmName) != null) {
            realmBaseEntries = this.getConfigManager().getRealmConfig(realmName).getParticipatingBaseEntries();
        }
        if ((reposIds = this.repositoryManager.getRepoIds()) == null || realmBaseEntries == null) {
            return Collections.emptyList();
        }
        ArrayList<String> potentialRepos = new ArrayList<String>();
        List<String> realmBases = Arrays.asList(realmBaseEntries);
        block0: for (String repoId : reposIds) {
            Map<String, String> baseEntryies = this.repositoryManager.getRepositoryBaseEntries(repoId);
            for (Map.Entry<String, String> entry : baseEntryies.entrySet()) {
                if (!realmBases.contains(entry.getKey())) continue;
                String baseDN = entry.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("baseDN = " + baseDN), (Object[])new Object[0]);
                }
                if (baseDN == null) continue;
                String reposNodeName = baseDN;
                if (reposNodeName.trim().equals("")) {
                    potentialRepos.add(repoId);
                }
                if ((reposNodeName = UniqueNameHelper.getValidUniqueName(reposNodeName)) == null || reposNodeName.length() <= 0) continue;
                int nodeLength = reposNodeName.length();
                if (uLength == nodeLength && externalName.equalsIgnoreCase(reposNodeName)) {
                    potentialRepos.add(0, repoId);
                    continue block0;
                }
                if (uLength <= nodeLength || !StringUtil.endsWithIgnoreCase(externalName, "," + reposNodeName)) continue;
                potentialRepos.add(0, repoId);
                continue block0;
            }
        }
        return potentialRepos;
    }

    public Root delete(Root root) throws WIMException {
        String METHODNAME = DELETE_EMITTER;
        return this.genericProfileManagerMethod(DELETE_EMITTER, 'd', root);
    }

    public Root deleteImpl(Root root) throws WIMException {
        String realmName;
        IdentifierType identifier;
        String METHODNAME = "deleteImpl";
        if (root == null) {
            return null;
        }
        AuditManager auditManager = new AuditManager();
        this.isReferenceToLoggedInUser(root);
        boolean returnDeleted = false;
        List entities = root.getEntities();
        if (entities.size() == 0) {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), DELETE_EMITTER, null, null, this.getRealmName(root), root, Integer.valueOf("201")});
            throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_ENTITY_DATA_OBJECT", (Object[])WIMMessageHelper.generateMsgParms((Object)DELETE_EMITTER)));
        }
        if (entities.size() > 1) {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), DELETE_EMITTER, null, null, this.getRealmName(root), root, Integer.valueOf("202")});
            throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ACTION_MULTIPLE_ENTITIES_SPECIFIED", (Object[])WIMMessageHelper.generateMsgParms((Object)"DELETE")));
        }
        Entity entity = (Entity)entities.get(0);
        Map<String, Control> ctrlMap = ControlsHelper.getControlMap(root);
        DeleteControl deleteCtrl = (DeleteControl)ctrlMap.get("DeleteControl");
        if (deleteCtrl != null) {
            returnDeleted = deleteCtrl.isReturnDeleted();
        }
        if ((identifier = entity.getIdentifier()) == null) {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), DELETE_EMITTER, null, null, this.getRealmName(root), root, Integer.valueOf("203")});
            throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IDENTIFIER_NOT_SPECIFIED", (Object[])new Object[0]));
        }
        String repositoryId = identifier.getRepositoryId();
        String uniqueName = identifier.getUniqueName();
        if (repositoryId == null) {
            repositoryId = this.getRepositoryManager().getRepositoryId(uniqueName);
        }
        if ((realmName = this.getRealmName(root)) != null && !this.getConfigManager().isUniqueNameInRealm(uniqueName, realmName)) {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), DELETE_EMITTER, repositoryId, uniqueName, realmName, root, Integer.valueOf("204")});
            throw new EntityNotInRealmScopeException("ENTITY_NOT_IN_REALM_SCOPE", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_IN_REALM_SCOPE", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName, (Object)realmName)));
        }
        auditManager.setRepositoryId(repositoryId);
        auditManager.setRepositoryRealm(realmName);
        auditManager.setRepositoryUniqueName(uniqueName);
        Root retRoot = this.repositoryManager.getRepository(repositoryId).delete(root);
        if (retRoot != null) {
            retRoot = this.postDelete(retRoot, repositoryId, returnDeleted);
        }
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), DELETE_EMITTER, repositoryId, uniqueName, realmName, retRoot, Integer.valueOf("200")});
        return retRoot;
    }

    private Root postDelete(Root retRoot, String repositoryId, boolean returnDeleted) throws WIMException {
        return retRoot;
    }

    public Root create(Root root) throws WIMException {
        String METHODNAME = "create";
        return this.genericProfileManagerMethod("create", 'c', root);
    }

    public Root createImpl(Root root) throws WIMException {
        String extId;
        Group group;
        List<? extends Entity> members;
        String entityUniqueName;
        List<String> baseEntries;
        List<String> repos;
        Root created = null;
        String targetReposId = null;
        String realmName = this.getRealmName(root);
        List entities = root.getEntities();
        if (entities == null) {
            return null;
        }
        AuditManager auditManager = new AuditManager();
        if (entities.size() == 0) {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, null, this.getRealmName(root), created, Integer.valueOf("201")});
            throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_ENTITY_DATA_OBJECT", (Object[])WIMMessageHelper.generateMsgParms((Object)"CREATE")));
        }
        if (entities.size() > 1) {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, null, this.getRealmName(root), created, Integer.valueOf("202")});
            throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ACTION_MULTIPLE_ENTITIES_SPECIFIED", (Object[])WIMMessageHelper.generateMsgParms((Object)"CREATE")));
        }
        Entity entity = (Entity)entities.get(0);
        String qualifiedEntityType = entity.getTypeName();
        this.checkCreateAndModifyTimeStamp(qualifiedEntityType, entity);
        Entity parent = null;
        String parentDN = null;
        parent = entity.getParent();
        if (parent != null) {
            if (parent.isSetIdentifier()) {
                String parentID;
                parentDN = parent.getIdentifier().getUniqueName();
                if (parentDN == null && (parentID = parent.getIdentifier().getUniqueId()) != null && ((parentDN = this.getUniqueNameByUniqueId(parentID, false, null)) == null || parentDN.length() == 0)) {
                    if (entity != null && entity.getIdentifier() != null) {
                        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("205")});
                    } else {
                        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, null, realmName, created, Integer.valueOf("205")});
                    }
                    throw new InvalidUniqueIdException("INVALID_PARENT_UNIQUE_ID", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_PARENT_UNIQUE_ID", (Object[])WIMMessageHelper.generateMsgParms((Object)parentID)));
                }
            } else {
                if (entity != null && entity.getIdentifier() != null) {
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("205")});
                } else {
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, null, realmName, created, Integer.valueOf("205")});
                }
                throw new InvalidUniqueIdException("INVALID_PARENT_UNIQUE_ID", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_PARENT_UNIQUE_ID", (Object[])WIMMessageHelper.generateMsgParms(null)));
            }
        }
        if (parentDN == null) {
            parentDN = this.configMgr.getDefaultParentForEntityInRealm(qualifiedEntityType, realmName);
        }
        if (parentDN == null && (repos = this.repositoryManager.getRepoIds()) != null && repos.size() == 1 && (baseEntries = this.repositoryManager.getRepositoriesBaseEntries().get(repos.get(0))) != null && baseEntries.size() == 1) {
            parentDN = baseEntries.get(0);
        }
        if (parentDN == null) {
            if (entity != null && entity.getIdentifier() != null) {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("206")});
            } else {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, null, realmName, created, Integer.valueOf("206")});
            }
            throw new DefaultParentNotFoundException("DEFAULT_PARENT_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"DEFAULT_PARENT_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)qualifiedEntityType, (Object)realmName)));
        }
        if (!this.getConfigManager().isUniqueNameInRealm(parentDN, realmName)) {
            if (entity != null && entity.getIdentifier() != null) {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("204")});
            } else {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, null, realmName, created, Integer.valueOf("204")});
            }
            throw new EntityNotInRealmScopeException("ENTITY_NOT_IN_REALM_SCOPE", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_IN_REALM_SCOPE", (Object[])WIMMessageHelper.generateMsgParms((Object)parentDN, (Object)realmName)));
        }
        parentDN = UniqueNameHelper.formatUniqueName(parentDN);
        if (parent == null) {
            parent = new Entity();
            entity.setParent(parent);
            IdentifierType id = new IdentifierType();
            parent.setIdentifier(id);
        }
        if (!(entity.getIdentifier() == null || (entityUniqueName = entity.getIdentifier().getUniqueName()) == null || parentDN == null || entityUniqueName.length() >= parentDN.length() && entityUniqueName.endsWith(parentDN))) {
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("205")});
            throw new InvalidUniqueIdException("INVALID_PARENT_UNIQUE_ID", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_PARENT_UNIQUE_ID", (Object[])WIMMessageHelper.generateMsgParms((Object)parentDN)));
        }
        parent.getIdentifier().setUniqueName(parentDN);
        entity.setParent(parent);
        if (this.repositoryManager.getNumberOfRepositories() > 1) {
            if (targetReposId == null) {
                targetReposId = this.repositoryManager.getRepositoryIdByUniqueName(parentDN);
            }
        } else {
            targetReposId = this.repositoryManager.getRepoIds().get(0);
        }
        if ((qualifiedEntityType.equals("Group") || entity.getSuperTypes().contains("Group")) && (members = (group = (Group)entity).getMembers()) != null && members.size() > 0 && (members = this.setExtIdAndRepositoryIdForEntities(members, targetReposId, false, null)) != null && members.size() > 0) {
            for (int i = 0; i < members.size(); ++i) {
                Entity mbrDO = members.get(i);
                IdentifierType memberId = mbrDO.getIdentifier();
                String reposId = this.retrieveTargetRepository(memberId);
                boolean crossRepos = this.repositoryManager.canGroupAcceptMember(targetReposId, reposId);
                if (crossRepos || targetReposId.equalsIgnoreCase(reposId)) continue;
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("207")});
                throw new OperationNotSupportedException("MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", (Object[])WIMMessageHelper.generateMsgParms((Object)"CREATE")));
            }
        }
        List groups = entity.getGroups();
        List<Group> realGroups = null;
        if (groups != null && groups.size() > 0) {
            realGroups = this.separateGroups(groups, targetReposId);
        }
        if (realGroups != null) {
            entity.unset("groups");
            entity.getGroups().addAll(realGroups);
        }
        if (!"PersonAccount".equalsIgnoreCase(qualifiedEntityType) && !"Group".equalsIgnoreCase(qualifiedEntityType)) {
            if (entity != null && entity.getIdentifier() != null) {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("208")});
            } else {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, null, realmName, created, Integer.valueOf("208")});
            }
            throw new EntityTypeNotSupportedException("ENTITY_TYPE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_TYPE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)qualifiedEntityType)));
        }
        if (entity.getIdentifier() == null || entity.getIdentifier().getUniqueName() == null) {
            if (entity != null && entity.getIdentifier() != null) {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("203")});
            } else {
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, null, realmName, created, Integer.valueOf("203")});
            }
            throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IDENTIFIER_NOT_SPECIFIED", (Object[])new Object[0]));
        }
        String uniqueName = entity.getIdentifier().getUniqueName();
        this.processReferenceProperty(entity, qualifiedEntityType, false, false, null);
        if (uniqueName != null) {
            auditManager.setRepositoryId(targetReposId);
            auditManager.setRepositoryRealm(realmName);
            auditManager.setRepositoryUniqueName(uniqueName);
            created = this.repositoryManager.getRepository(targetReposId).create(root);
        }
        if (created == null) {
            return null;
        }
        Entity ent = (Entity)created.getEntities().get(0);
        IdentifierType entId = ent.getIdentifier();
        String uuid = extId = entId.getExternalId();
        entId.setUniqueId(uuid);
        entId.setRepositoryId(targetReposId);
        if (groups != null && groups.size() > 0) {
            for (Group group2 : groups) {
                IdentifierType grpId = group2.getIdentifier();
                String grpReposId = grpId.getRepositoryId();
                if (targetReposId.equals(grpReposId)) continue;
                if (this.repositoryManager.isCrossRepositoryGroupMembership(targetReposId)) {
                    Root newRoot = new Root();
                    Group grpEntity = new Group();
                    newRoot.getEntities().add(grpEntity);
                    grpEntity.setIdentifier(grpId);
                    Entity mbrEnt = new Entity();
                    grpEntity.getMembers().add(mbrEnt);
                    mbrEnt.setIdentifier(entId);
                    GroupMemberControl grpMbrCtrl = new GroupMemberControl();
                    newRoot.getControls().add(grpMbrCtrl);
                    this.update(newRoot);
                    continue;
                }
                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, entity.getIdentifier().getUniqueName(), realmName, created, Integer.valueOf("207")});
                throw new OperationNotSupportedException("MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", (Object[])WIMMessageHelper.generateMsgParms((Object)targetReposId)));
            }
        }
        this.unsetExternalId(created);
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "create", targetReposId, uniqueName, realmName, created, Integer.valueOf("200")});
        return created;
    }

    private void isReferenceToLoggedInUser(Root root) throws WIMApplicationException {
        if (root.getEntities().size() == 0) {
            return;
        }
        Entity entity = (Entity)root.getEntities().get(0);
        IdentifierType identifier = entity.getIdentifier();
        if (identifier == null) {
            return;
        }
        String uName = identifier.getUniqueName();
        String loggedInUniqueName = this.getCallerUniqueName();
        if (uName != null && uName.equalsIgnoreCase(loggedInUniqueName)) {
            throw new WIMApplicationException("CANNOT_DELETE_LOGGED_IN_USER", Tr.formatMessage((TraceComponent)tc, (String)"CANNOT_DELETE_LOGGED_IN_USER", (Object[])WIMMessageHelper.generateMsgParms((Object)uName)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getCallerUniqueName() throws WIMApplicationException {
        String uniqueName = null;
        Subject subject = null;
        WSCredential cred = null;
        try {
            subject = WSSubject.getRunAsSubject();
            if (subject == null) {
                subject = WSSubject.getCallerSubject();
            }
            if (subject != null) {
                Iterator<WSCredential> iter = subject.getPublicCredentials(WSCredential.class).iterator();
                if (iter.hasNext()) {
                    cred = iter.next();
                }
                if (null == cred) {
                    throw new WIMApplicationException("AUTH_SUBJECT_CRED_FAILURE", Tr.formatMessage((TraceComponent)tc, (String)"AUTH_SUBJECT_CRED_FAILURE", (Object[])new Object[0]));
                }
            } else {
                throw new WIMApplicationException("AUTH_SUBJECT_FAILURE", Tr.formatMessage((TraceComponent)tc, (String)"AUTH_SUBJECT_FAILURE", (Object[])new Object[0]));
            }
            uniqueName = cred.getUniqueSecurityName();
            if (null == uniqueName) {
                throw new WIMApplicationException("AUTH_SUBJECT_CRED_FAILURE", Tr.formatMessage((TraceComponent)tc, (String)"AUTH_SUBJECT_CRED_FAILURE", (Object[])new Object[0]));
            }
        }
        catch (Exception iter) {
            void excp;
            FFDCFilter.processException((Throwable)iter, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"2984", (Object)this, (Object[])new Object[0]);
            if ("AUTH_SUBJECT_FAILURE".equals(excp.getMessage())) {
                throw new WIMApplicationException("AUTH_SUBJECT_FAILURE", Tr.formatMessage((TraceComponent)tc, (String)"AUTH_SUBJECT_FAILURE", (Object[])new Object[0]));
            }
            throw new WIMApplicationException("AUTH_SUBJECT_CRED_FAILURE", Tr.formatMessage((TraceComponent)tc, (String)"AUTH_SUBJECT_CRED_FAILURE", (Object[])new Object[0]));
        }
        return uniqueName;
    }

    private String retrieveTargetRepository(IdentifierType id) throws WIMException {
        String result = null;
        String uniqueId = id.getUniqueId();
        String uniqueName = id.getUniqueName();
        if (uniqueId != null && uniqueId.trim().length() != 0) {
            result = id.getRepositoryId();
            if (result == null) {
                this.retrieveEntity(null, id, false, null);
            }
            result = id.getRepositoryId();
        } else {
            result = this.repositoryManager.getRepositoryIdByUniqueName(uniqueName);
        }
        return result;
    }

    private List<Group> separateGroups(List<Group> groups, String targetReposId) throws WIMException {
        groups = this.setExtIdAndRepositoryIdForEntities(groups, targetReposId, false, null);
        ArrayList<Group> retGroups = new ArrayList<Group>();
        if (this.repositoryManager.getNumberOfRepositories() > 1 && groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                String reposId;
                Group grp = groups.get(i);
                IdentifierType grpId = grp.getIdentifier();
                if (grpId == null) {
                    throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IDENTIFIER_NOT_SPECIFIED", (Object[])WIMMessageHelper.generateMsgParms((Object)grp)));
                }
                String uniqueName = grpId.getUniqueName();
                if (uniqueName == null || !(reposId = this.repositoryManager.getRepositoryIdByUniqueName(uniqueName)).equals(targetReposId)) continue;
                retGroups.add(grp);
                groups.remove(i);
                --i;
            }
        } else if (groups != null) {
            retGroups.addAll(groups);
            groups.clear();
        }
        return retGroups;
    }

    private void checkCreateAndModifyTimeStamp(String qualifiedEntityType, Entity entity) throws WIMException {
    }

    @FFDCIgnore(value={EntityNotFoundException.class, Exception.class})
    private String getUniqueNameByUniqueId(String uniqueId, boolean isAllowOperationIfReposDown, Set<String> failureRepositoryIds) throws WIMException {
        String METHODNAME = "getUniqueNameByUniqueId";
        String uniqueName = null;
        boolean found = false;
        int i = 0;
        Root temp = new Root();
        Entity entity = new Entity();
        IdentifierType id = new IdentifierType();
        id.setExternalId(uniqueId);
        entity.setIdentifier(id);
        temp.getEntities().add(entity);
        List<String> repositoryIds = this.repositoryManager.getRepoIds();
        while (i < repositoryIds.size() && !found) {
            try {
                IdentifierType entityId;
                Entity ent;
                List pes;
                Root returnedRoot = this.repositoryManager.getRepository(repositoryIds.get(i)).get(temp);
                if (returnedRoot == null || (pes = returnedRoot.getEntities()) == null || (ent = (Entity)pes.get(0)) == null || (entityId = ent.getIdentifier()) == null) continue;
                uniqueName = entityId.getUniqueName();
                found = true;
            }
            catch (EntityNotFoundException e) {
                ++i;
            }
            catch (Exception e) {
                if (!isAllowOperationIfReposDown) {
                    if (e instanceof WIMException) {
                        throw (WIMException)((Object)e);
                    }
                    throw new WIMException((Throwable)e);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getUniqueNameByUniqueId IGNORE: exception [" + e.getMessage() + "] on repository [" + repositoryIds.get(i) + "]"), (Object[])new Object[0]);
                }
                failureRepositoryIds.add(repositoryIds.get(i));
                ++i;
            }
        }
        return uniqueName;
    }

    public Root update(Root rootDO) throws WIMException {
        String METHODNAME = "update";
        return this.genericProfileManagerMethod("update", 'u', rootDO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={EntityNotFoundException.class, InvalidIdentifierException.class, OperationNotSupportedException.class})
    public Root updateImpl(Root root) throws WIMException {
        List inputGrps;
        String realmName;
        String uniqueName;
        boolean updateCrossRepos;
        String repositoryId;
        Root retRoot;
        AuditManager auditManager;
        block39: {
            String reposId;
            int i;
            block38: {
                List entities;
                block36: {
                    List entities2;
                    block35: {
                        block37: {
                            block33: {
                                String cacheMode;
                                block34: {
                                    String METHODNAME = "updateImpl";
                                    if (root == null) {
                                        return null;
                                    }
                                    auditManager = new AuditManager();
                                    retRoot = null;
                                    repositoryId = null;
                                    Object laRetRoot = null;
                                    updateCrossRepos = true;
                                    Map<String, Control> ctrlMap = ControlsHelper.getControlMap(root);
                                    CacheControl cacheCtrl = (CacheControl)ctrlMap.get("CacheControl");
                                    if (cacheCtrl == null) break block33;
                                    cacheMode = cacheCtrl.getMode();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("updateImpl Cache Control is passed with mode " + cacheMode), (Object[])new Object[0]);
                                    }
                                    if (cacheMode == null || !"clearAll".equalsIgnoreCase(cacheMode)) break block34;
                                    entities2 = root.getEntities();
                                    break block35;
                                }
                                if (cacheMode == null || !"clearEntity".equalsIgnoreCase(cacheMode)) return null;
                                entities = root.getEntities();
                                break block36;
                            }
                            List entities3 = root.getEntities();
                            if (entities3.size() == 0) {
                                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", repositoryId, null, this.getRealmName(root), root, Integer.valueOf("201")});
                                throw new EntityNotFoundException("MISSING_ENTITY_DATA_OBJECT", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_ENTITY_DATA_OBJECT", (Object[])WIMMessageHelper.generateMsgParms((Object)"DELETE")));
                            }
                            if (entities3.size() > 1) {
                                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", repositoryId, null, this.getRealmName(root), root, Integer.valueOf("202")});
                                throw new OperationNotSupportedException("ACTION_MULTIPLE_ENTITIES_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ACTION_MULTIPLE_ENTITIES_SPECIFIED", (Object[])WIMMessageHelper.generateMsgParms((Object)"DELETE")));
                            }
                            Entity entity = (Entity)entities3.get(0);
                            String entityType = entity.getTypeName();
                            IdentifierType identifier = entity.getIdentifier();
                            if (identifier == null) {
                                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", repositoryId, null, this.getRealmName(root), root, Integer.valueOf("203")});
                                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IDENTIFIER_NOT_SPECIFIED", (Object[])new Object[0]));
                            }
                            Entity realEntity = entity;
                            if (!(identifier.isSet("externalId") && identifier.isSet("externalName") && identifier.isSet("repositoryId"))) {
                                realEntity = this.retrieveEntity(identifier.getRepositoryId(), identifier, false, null);
                            }
                            repositoryId = identifier.getRepositoryId();
                            String realEntityType = realEntity.getTypeName();
                            String uniqueId = identifier.getUniqueId();
                            uniqueName = identifier.getUniqueName();
                            realmName = this.getRealmName(root);
                            if (realmName != null && !this.getConfigManager().isUniqueNameInRealm(uniqueName, realmName)) {
                                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", repositoryId, uniqueName, realmName, root, Integer.valueOf("204")});
                                throw new EntityNotInRealmScopeException("ENTITY_NOT_IN_REALM_SCOPE", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_IN_REALM_SCOPE", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName, (Object)realmName)));
                            }
                            this.checkCreateAndModifyTimeStamp(realEntityType, entity);
                            this.processReferenceProperty(entity, entityType, false, false, null);
                            if (realEntity.getSuperTypes() != null && realEntity.getSuperTypes().contains("Group")) {
                                this.setExtIdAndRepositoryIdForEntities(((Group)entity).getMembers(), repositoryId, false, null);
                                List inputMbrs = ((Group)entity).getMembers();
                                if (inputMbrs != null && inputMbrs.size() > 0) {
                                    for (i = 0; i < inputMbrs.size(); ++i) {
                                        Entity member = (Entity)inputMbrs.get(i);
                                        IdentifierType memberId = member.getIdentifier();
                                        reposId = this.retrieveTargetRepository(memberId);
                                        boolean crossRepos = this.repositoryManager.canGroupAcceptMember(repositoryId, reposId);
                                        if (!crossRepos && !repositoryId.equalsIgnoreCase(reposId)) {
                                            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", repositoryId, uniqueName, realmName, root, Integer.valueOf("207")});
                                            throw new OperationNotSupportedException("MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", (Object[])WIMMessageHelper.generateMsgParms((Object)reposId)));
                                        }
                                        if (updateCrossRepos) {
                                            // empty if block
                                        }
                                        updateCrossRepos = false;
                                    }
                                }
                            }
                            if ((inputGrps = entity.getGroups()) == null || inputGrps.size() <= 0) break block37;
                            if (!this.repositoryManager.isCrossRepositoryGroupMembership(repositoryId)) break block38;
                            updateCrossRepos = true;
                            this.setExtIdAndRepositoryIdForEntities(entities3, repositoryId, false, null);
                            HashMap<String, ArrayList<Group>> grps = new HashMap<String, ArrayList<Group>>();
                            for (int i2 = 0; i2 < inputGrps.size(); ++i2) {
                                Group group = (Group)inputGrps.get(i2);
                                IdentifierType inputId = group.getIdentifier();
                                String reposId2 = this.retrieveTargetRepository(inputId);
                                ArrayList<Group> reposGrps = (ArrayList<Group>)grps.get(reposId2);
                                if (reposGrps == null) {
                                    reposGrps = new ArrayList<Group>();
                                }
                                reposGrps.add(group);
                                grps.put(reposId2, reposGrps);
                            }
                            Iterator iter = grps.keySet().iterator();
                            List reposGrps = (List)grps.get(repositoryId);
                            if (reposGrps == null) {
                                entity.unset("groups");
                            } else {
                                entity.getGroups().addAll(reposGrps);
                            }
                            retRoot = this.repositoryManager.getRepository(repositoryId).update(root);
                            for (String targetId : this.repositoryManager.getRepositoriesForGroupMembership(repositoryId)) {
                                if (targetId.equals(repositoryId) || (reposGrps = (List)grps.get(targetId)) == null || reposGrps.size() <= 0) continue;
                                Root inputRoot = new Root();
                                entity.getGroups().addAll(reposGrps);
                                inputRoot.getEntities().add(entity);
                                Root root2 = this.repositoryManager.getRepository(targetId).update(inputRoot);
                            }
                            break block39;
                        }
                        updateCrossRepos = false;
                        break block39;
                    }
                    for (int i3 = 0; i3 < entities2.size(); ++i3) {
                        Entity entity = (Entity)entities2.get(i3);
                        IdentifierType id = entity.getIdentifier();
                        repositoryId = id.getRepositoryId();
                        if (repositoryId != null && repositoryId.trim().length() > 0) {
                            if (repositoryId.equalsIgnoreCase(LA)) continue;
                            this.repositoryManager.getRepository(repositoryId).update(root);
                            continue;
                        }
                        int numberOfRepositories = this.repositoryManager.getNumberOfRepositories();
                        for (int reposIndex = 0; reposIndex < numberOfRepositories; ++reposIndex) {
                            try {
                                Repository repo = this.repositoryManager.getRepository(this.repositoryManager.getRepoIds().get(reposIndex));
                                repo.update(root);
                                continue;
                            }
                            catch (EntityNotFoundException e) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)"updateImpl Exception in clear cache", (Object[])WIMMessageHelper.generateMsgParms((Object)e.getMessage()));
                                continue;
                            }
                            catch (InvalidIdentifierException e) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)"updateImpl Exception in clear cache", (Object[])WIMMessageHelper.generateMsgParms((Object)e.getMessage()));
                                continue;
                            }
                            catch (OperationNotSupportedException e) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)"updateImpl Exception in clear cache", (Object[])WIMMessageHelper.generateMsgParms((Object)e.getMessage()));
                                continue;
                            }
                            catch (WIMApplicationException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.ProfileManager", (String)"3198", (Object)this, (Object[])new Object[]{root});
                                String messageKey = e.getMessageKey();
                                if (!"CANNOT_WRITE_TO_READ_ONLY_REPOSITORY".equalsIgnoreCase(messageKey)) {
                                    throw e;
                                }
                                Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", repositoryId, null, this.getRealmName(root), root, Integer.valueOf("209")});
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)"updateImpl Exception in clear cache", (Object[])WIMMessageHelper.generateMsgParms((Object)e.getMessage()));
                            }
                        }
                    }
                    return null;
                }
                for (int i4 = 0; i4 < entities.size(); ++i4) {
                    Entity entity = (Entity)entities.get(i4);
                    IdentifierType id = entity.getIdentifier();
                    repositoryId = id.getRepositoryId();
                    if (repositoryId == null || repositoryId.trim().length() <= 0) continue;
                    Root tempRoot = new Root();
                    tempRoot.getEntities().add(entity);
                    CacheControl ctlDO = new CacheControl();
                    ctlDO.setMode("clearEntity");
                    if (!repositoryId.equalsIgnoreCase(LA)) {
                        this.repositoryManager.getRepository(repositoryId).update(tempRoot);
                    }
                    for (String targetId : this.repositoryManager.getRepositoriesForGroupMembership(repositoryId)) {
                        if (targetId.equals(repositoryId)) continue;
                        this.repositoryManager.getRepository(targetId).update(tempRoot);
                    }
                }
                return null;
            }
            for (i = 0; i < inputGrps.size(); ++i) {
                Group group = (Group)inputGrps.get(i);
                IdentifierType groupId = group.getIdentifier();
                reposId = this.retrieveTargetRepository(groupId);
                if (!repositoryId.equalsIgnoreCase(reposId)) {
                    Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", repositoryId, uniqueName, realmName, root, Integer.valueOf("207")});
                    throw new OperationNotSupportedException("MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", Tr.formatMessage((TraceComponent)tc, (String)"MISSING_REPOSITORIES_FOR_GROUPS_CONFIGURATION", (Object[])WIMMessageHelper.generateMsgParms((Object)reposId)));
                }
                if (updateCrossRepos) {
                    // empty if block
                }
                updateCrossRepos = false;
            }
        }
        if (!updateCrossRepos) {
            this.setUniqueName(inputGrps);
            auditManager.setRepositoryId(repositoryId);
            auditManager.setRepositoryRealm(realmName);
            auditManager.setRepositoryUniqueName(uniqueName);
            retRoot = this.repositoryManager.getRepository(repositoryId).update(root);
        }
        Audit.audit((Audit.EventID)Audit.EventID.SECURITY_MEMBER_MGMT_01, (Object[])new Object[]{auditManager.getRESTRequest(), "update", repositoryId, uniqueName, realmName, retRoot, Integer.valueOf("200")});
        return retRoot;
    }

    private List<Group> setUniqueName(List<Group> inputGrps) throws WIMException {
        if (inputGrps == null) {
            return null;
        }
        for (int i = 0; i < inputGrps.size(); ++i) {
            Group mbrEntDO = inputGrps.get(i);
            IdentifierType mbrEntIdDO = mbrEntDO.getIdentifier();
            if (mbrEntIdDO == null) {
                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IDENTIFIER_NOT_SPECIFIED", (Object[])WIMMessageHelper.generateMsgParms((Object)mbrEntDO)));
            }
            String uniqueId = mbrEntIdDO.getUniqueId();
            String uniqueName = mbrEntIdDO.getUniqueName();
            if (uniqueName != null) continue;
            if (uniqueId == null) {
                throw new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_IDENTIFIER_NOT_SPECIFIED", (Object[])WIMMessageHelper.generateMsgParms((Object)mbrEntDO)));
            }
            uniqueName = this.getUniqueNameByUniqueId(uniqueId, false, null);
            if (uniqueName == null) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueId)));
            }
            mbrEntIdDO.setUniqueName(uniqueName);
        }
        return inputGrps;
    }

    private String getPageCacheKey(SearchControl searchControl, SortControl sortControl) {
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(searchControl.getExpression());
        cacheKey.append("|");
        List properties = searchControl.getProperties();
        if (properties != null) {
            for (String property : properties) {
                cacheKey.append("|");
                cacheKey.append(property);
            }
        }
        cacheKey.append("|");
        if (sortControl != null) {
            List sortKeys = sortControl.getSortKeys();
            for (SortKeyType sortKey : sortKeys) {
                cacheKey.append(sortKey.getPropertyName());
                cacheKey.append("|");
                cacheKey.append(sortKey.isAscendingOrder());
                cacheKey.append("|");
            }
        }
        return cacheKey.toString();
    }

    private boolean isURBridgeResult(Root returnRoot) {
        if (returnRoot != null && !returnRoot.getEntities().isEmpty()) {
            List contexts = returnRoot.getContexts();
            for (Context context : contexts) {
                String key = context.getKey();
                if (key == null || !"isURBridgeResult".equals(key) || !"true".equalsIgnoreCase((String)context.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

