/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.internal.ExecutorServiceImpl;
import com.ibm.ws.threading.internal.IntervalTask;
import com.ibm.ws.threading.internal.ThroughputDistribution;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadPoolExecutor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ThreadPoolController {
    private static final TraceComponent tc = Tr.register(ThreadPoolController.class);
    static final long INTERVAL = 1500L;
    static final int MAX_INTERVALS_WITHOUT_CHANGE = 5;
    static final double EMPTY_QUEUE_SHRINK_MAGIC_PER_INTERVAL = 0.04;
    static final double NON_EMPTY_QUEUE_GROW_MAGIC_PER_INTERVAL = 0.02;
    static final int IDLE_INTERVALS_BEFORE_PAUSE = 3;
    static final int MAX_OUTLIER_AFTER_CHANGE_BEFORE_RESET = 3;
    static final int MAX_THREADS_TO_BREAK_HANG = 1000;
    final ExecutorServiceImpl executorService;
    LastAction lastAction = LastAction.NONE;
    final Timer timer = new Timer("Executor Service Control Timer", true);
    IntervalTask activeTask = null;
    boolean paused = false;
    long lastTimerPop = 0L;
    long previousCompleted = 0L;
    double previousThroughput = 0.0;
    int consecutiveQueueEmptyCount = 0;
    int consecutiveNoAdjustment = 0;
    int consecutiveOutlierAfterAdjustment = 0;
    int consecutiveIdleCount = 0;
    int maxThreads = Integer.MAX_VALUE;
    int coreThreads = ThreadPoolController.getDefaultCoreThreadSize();
    ThreadPoolExecutor threadPool;
    ThroughputDistribution[] threadStats = new ThroughputDistribution[0];
    private int poolSizeWhenHangDetected = -1;
    private int hangIntervalCounter = 0;
    static final long serialVersionUID = -4660281053535413674L;

    private static int getDefaultCoreThreadSize() {
        return Math.max(Runtime.getRuntime().availableProcessors() / 2 - 1, 3);
    }

    ThreadPoolController(ExecutorServiceImpl executorService) {
        this.executorService = executorService;
    }

    void resetStatistics(boolean clearHistory) {
        this.lastTimerPop = System.currentTimeMillis();
        this.previousCompleted = this.threadPool == null ? 0L : this.threadPool.getCompletedTaskCount();
        this.previousThroughput = 0.0;
        this.consecutiveQueueEmptyCount = 0;
        this.consecutiveNoAdjustment = 0;
        this.consecutiveOutlierAfterAdjustment = 0;
        this.consecutiveIdleCount = 0;
        if (clearHistory) {
            this.threadStats = new ThroughputDistribution[0];
        }
        this.lastAction = LastAction.NONE;
    }

    void resetThreadPool() {
        if (this.threadPool == null) {
            return;
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int factor = 2500 * availableProcessors / Math.max(1, (int)this.previousThroughput);
        factor = Math.min(factor, 4);
        factor = Math.max(factor, 2);
        int newThreads = Math.min(factor * availableProcessors, this.maxThreads);
        newThreads = Math.max(newThreads, this.coreThreads);
        this.setPoolSize(newThreads);
        this.resetStatistics(true);
    }

    synchronized void activate(ThreadPoolExecutor pool) {
        this.threadPool = pool;
        this.coreThreads = pool.getCorePoolSize();
        this.maxThreads = pool.getMaximumPoolSize();
        this.resetStatistics(true);
        this.activeTask = new IntervalTask(this);
        this.timer.schedule((TimerTask)this.activeTask, 1500L, 1500L);
    }

    synchronized void deactivate() {
        this.paused = false;
        if (this.activeTask != null) {
            this.activeTask.cancel();
            this.activeTask = null;
        }
        this.threadPool = null;
        this.coreThreads = ThreadPoolController.getDefaultCoreThreadSize();
        this.maxThreads = Integer.MAX_VALUE;
    }

    synchronized void pause() {
        this.paused = true;
        if (this.activeTask != null) {
            this.activeTask.cancel();
            this.activeTask = null;
        }
    }

    @Trivial
    void resumeIfPaused() {
        if (this.paused) {
            this.resume();
        }
    }

    synchronized void resume() {
        this.paused = false;
        if (this.activeTask == null) {
            this.activeTask = new IntervalTask(this);
            this.timer.schedule((TimerTask)this.activeTask, 1500L, 1500L);
        }
    }

    synchronized void setCoreThreads(int coreThreads) {
        this.coreThreads = coreThreads;
    }

    synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    ThroughputDistribution getThroughputDistribution(int activeThreads) {
        if (activeThreads >= this.threadStats.length) {
            this.threadStats = Arrays.copyOf(this.threadStats, activeThreads + 1);
        }
        if (this.threadStats[activeThreads] == null) {
            this.threadStats[activeThreads] = new ThroughputDistribution();
        }
        return this.threadStats[activeThreads];
    }

    boolean manageIdlePool(ThreadPoolExecutor threadPool, long intervalCompleted) {
        this.consecutiveIdleCount = intervalCompleted == 0L && threadPool.getActiveCount() == 0 ? ++this.consecutiveIdleCount : 0;
        if (this.consecutiveIdleCount >= 3) {
            this.pause();
            this.lastAction = LastAction.PAUSE;
            return true;
        }
        return false;
    }

    boolean handleOutliers(ThroughputDistribution distribution, double throughput) {
        boolean currentIsOutlier;
        if (throughput < 0.0) {
            this.resetStatistics(false);
            return true;
        }
        if (throughput == 0.0) {
            return false;
        }
        double zScore = distribution.getZScore(throughput);
        boolean bl = currentIsOutlier = zScore <= -3.0 || zScore >= 3.0;
        if (currentIsOutlier) {
            distribution.reset(throughput);
        }
        if (this.lastAction != LastAction.NONE && currentIsOutlier) {
            ++this.consecutiveOutlierAfterAdjustment;
        } else if (this.lastAction != LastAction.NONE) {
            this.consecutiveOutlierAfterAdjustment = 0;
        }
        if (this.consecutiveOutlierAfterAdjustment >= 3) {
            this.resetThreadPool();
            return true;
        }
        return false;
    }

    double getShrinkScore(int poolSize, boolean queueEmpty, double forecast, double throughput) {
        double shrinkScore;
        ThroughputDistribution shrinkStats = this.getThroughputDistribution(poolSize - 1);
        if (!queueEmpty || poolSize <= this.coreThreads) {
            this.consecutiveQueueEmptyCount = 0;
        } else if (this.lastAction != LastAction.SHRINK) {
            ++this.consecutiveQueueEmptyCount;
        }
        double shrinkMagic = Math.min((double)this.consecutiveQueueEmptyCount, 12.5) * 0.04;
        if (this.consecutiveQueueEmptyCount > 0 && this.lastAction == LastAction.SHRINK && throughput < this.previousThroughput) {
            shrinkMagic = 0.0;
        }
        if ((shrinkScore = shrinkStats.getProbabilityGreaterThan(forecast) + shrinkMagic) <= 0.5 || poolSize <= this.coreThreads) {
            shrinkScore = 0.0;
        }
        return shrinkScore;
    }

    double getGrowScore(int poolSize, boolean queueEmpty, double forecast, double throughput) {
        ThroughputDistribution growStats = this.getThroughputDistribution(poolSize + 1);
        double growScore = growStats.getProbabilityGreaterThan(forecast);
        ThroughputDistribution currentStats = this.getThroughputDistribution(poolSize);
        if (growScore < 0.5 && currentStats.getProbabilityGreaterThan(growStats.getMovingAverage()) >= 0.5) {
            growScore = 0.0;
        }
        if (poolSize >= this.maxThreads) {
            growScore = 0.0;
        }
        return growScore;
    }

    int forceVariation(int poolSize, int calculatedAdjustment, long intervalCompleted) {
        this.consecutiveNoAdjustment = calculatedAdjustment == 0 && intervalCompleted != 0L ? ++this.consecutiveNoAdjustment : 0;
        int forcedAdjustment = calculatedAdjustment;
        if (this.consecutiveNoAdjustment >= 5) {
            this.consecutiveNoAdjustment = 0;
            if (this.flipCoin() && poolSize < this.maxThreads) {
                forcedAdjustment = 1;
            } else if (poolSize > this.coreThreads) {
                forcedAdjustment = -1;
            }
        }
        return forcedAdjustment;
    }

    boolean flipCoin() {
        return Math.random() >= 0.5;
    }

    int adjustPoolSize(int poolSize, int poolAdjustment) {
        if (this.threadPool == null) {
            return poolSize;
        }
        int newPoolSize = poolSize + poolAdjustment;
        this.lastAction = poolAdjustment == 0 ? LastAction.NONE : (poolAdjustment < 0 ? LastAction.SHRINK : LastAction.GROW);
        if (poolAdjustment != 0) {
            this.setPoolSize(newPoolSize);
        }
        return newPoolSize;
    }

    synchronized String evaluateInterval() {
        if (this.threadPool == null) {
            return "threadPool == null";
        }
        int poolSize = this.threadPool.getPoolSize();
        if (poolSize < this.coreThreads) {
            return "poolSize < coreThreads";
        }
        long currentTime = System.currentTimeMillis();
        long completedWork = this.threadPool.getCompletedTaskCount();
        long deltaTime = Math.max(currentTime - this.lastTimerPop, 1500L);
        long deltaCompleted = completedWork - this.previousCompleted;
        double throughput = 1000.0 * (double)deltaCompleted / (double)deltaTime;
        boolean queueEmpty = this.threadPool.getQueue().isEmpty();
        if (this.manageIdlePool(this.threadPool, deltaCompleted)) {
            return "monitoring paused";
        }
        if (poolSize <= 0) {
            return "poolSize <= 0";
        }
        ThroughputDistribution currentStats = this.getThroughputDistribution(poolSize);
        if (this.handleOutliers(currentStats, throughput)) {
            return "aberrant workload";
        }
        if (this.resolveHang()) {
            return "action take to resolve hang";
        }
        if (!queueEmpty || throughput > 0.0 && throughput >= currentStats.getMovingAverage()) {
            currentStats.addDataPoint(throughput);
        }
        double forecast = currentStats.getMovingAverage();
        double shrinkScore = this.getShrinkScore(poolSize, queueEmpty, forecast, throughput);
        double growScore = this.getGrowScore(poolSize, queueEmpty, forecast, throughput);
        int poolAdjustment = 0;
        if (growScore > shrinkScore) {
            poolAdjustment = 1;
        } else if (shrinkScore > growScore) {
            poolAdjustment = -1;
        }
        poolAdjustment = this.forceVariation(poolSize, poolAdjustment, deltaCompleted);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Interval data", (Object[])new Object[]{this.toIntervalData(throughput, forecast, shrinkScore, growScore, queueEmpty, poolSize, poolAdjustment)});
        }
        this.adjustPoolSize(poolSize, poolAdjustment);
        this.lastTimerPop = currentTime;
        this.previousCompleted = completedWork;
        this.previousThroughput = throughput;
        return "";
    }

    @Trivial
    private String toIntervalData(double throughput, double forecast, double shrinkScore, double growScore, boolean queueEmpty, int poolSize, int poolAdjustment) {
        ThroughputDistribution distribution;
        int i;
        int RANGE = 25;
        StringBuilder sb = new StringBuilder();
        sb.append("\nThroughput:");
        sb.append(String.format(" previous = %.6f", this.previousThroughput));
        sb.append(String.format(" current = %.6f", throughput));
        sb.append(String.format(" forecast = %.6f", forecast));
        sb.append("\nHeuristics:");
        sb.append(String.format(" queueEmpty = %5s", Boolean.toString(queueEmpty)));
        sb.append(String.format(" consecutiveQueueEmptyCount = %2d", this.consecutiveQueueEmptyCount));
        sb.append(String.format(" consecutiveNoAdjustment = %2d", this.consecutiveNoAdjustment));
        sb.append("\nOutliers:  ");
        sb.append(String.format(" consecutiveOutlierAfterAdjustment = %2d", this.consecutiveOutlierAfterAdjustment));
        sb.append("\nAttraction:");
        sb.append(String.format(" shrinkScore = %.6f", shrinkScore));
        sb.append(String.format(" growScore = %.6f", growScore));
        sb.append(String.format(" lastAction = %s", new Object[]{this.lastAction}));
        sb.append("\nStatistics:\n");
        for (i = Math.max(0, poolSize - 25); i < poolSize; ++i) {
            distribution = this.getThroughputDistribution(i);
            sb.append(String.format("   %3d threads: %s%n", i, String.valueOf(distribution)));
        }
        for (i = poolSize; i < poolSize + 25 && i < this.threadStats.length; ++i) {
            distribution = this.getThroughputDistribution(i);
            sb.append(String.format("%s%3d threads: %s%n", i == poolSize ? "-->" : "   ", i, String.valueOf(distribution)));
        }
        if (poolAdjustment == 0) {
            sb.append("### No pool adjustment ###");
        } else if (poolAdjustment < 0) {
            sb.append("--- Shrinking to " + (poolSize + poolAdjustment) + " ---");
        } else {
            sb.append("+++ Growing to " + (poolSize + poolAdjustment) + " +++");
        }
        return sb.toString();
    }

    private boolean resolveHang() {
        boolean actionTaken = false;
        if (this.threadPool.getCompletedTaskCount() == this.previousCompleted && !this.threadPool.getQueue().isEmpty()) {
            int poolSize = this.threadPool.getPoolSize();
            if (this.poolSizeWhenHangDetected < 0) {
                this.poolSizeWhenHangDetected = poolSize;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Executor hang detected at poolSize=" + this.poolSizeWhenHangDetected), (Object[])new Object[]{this.threadPool});
                }
            }
            if (poolSize < this.maxThreads && poolSize < 1000) {
                this.setPoolSize(++poolSize);
                actionTaken = true;
            } else if (this.hangIntervalCounter == 1 && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"unbreakableExecutorHang", (Object[])new Object[]{this.poolSizeWhenHangDetected, poolSize});
            }
            ++this.hangIntervalCounter;
        } else {
            this.poolSizeWhenHangDetected = -1;
            this.hangIntervalCounter = 0;
        }
        return actionTaken;
    }

    private void setPoolSize(int newPoolSize) {
        if (newPoolSize < this.threadPool.getCorePoolSize()) {
            this.threadPool.setCorePoolSize(newPoolSize);
            this.threadPool.setMaximumPoolSize(newPoolSize);
        } else {
            this.threadPool.setMaximumPoolSize(newPoolSize);
            this.threadPool.setCorePoolSize(newPoolSize);
        }
    }

    synchronized void introspect(PrintWriter out) {
        String INDENT = "  ";
        out.println(this.getClass().getName());
        out.println("  coreThreads = " + this.coreThreads);
        out.println("  maxThreads = " + this.maxThreads);
        out.println("  paused = " + this.paused);
        out.println("  hangIntervalCounter = " + this.hangIntervalCounter);
        out.println("  poolSizeWhenHangDetected = " + this.poolSizeWhenHangDetected);
        out.println("  lastAction = " + (Object)((Object)this.lastAction));
        out.println("  lastTimerPop = " + this.lastTimerPop);
        out.println("  previousCompleted = " + this.previousCompleted);
        out.println("  consecutiveIdleCount = " + this.consecutiveIdleCount);
        out.println("  consecutiveNoAdjustment = " + this.consecutiveNoAdjustment);
        out.println("  consecutiveOutlierAfterAdjustment = " + this.consecutiveOutlierAfterAdjustment);
        out.println("  consecutiveQueueEmptyCount = " + this.consecutiveQueueEmptyCount);
        out.println("  threadPool");
        out.println("    poolSize = " + this.threadPool.getPoolSize());
        out.println("    activeCount = " + this.threadPool.getActiveCount());
        out.println("    corePoolSize = " + this.threadPool.getCorePoolSize());
        out.println("    maxPoolSize = " + this.threadPool.getMaximumPoolSize());
        out.println("    largestPoolSize = " + this.threadPool.getLargestPoolSize());
        out.println("    completedTaskCount = " + this.threadPool.getCompletedTaskCount());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static final class LastAction
    extends Enum<LastAction> {
        public static final /* enum */ LastAction NONE;
        public static final /* enum */ LastAction GROW;
        public static final /* enum */ LastAction SHRINK;
        public static final /* enum */ LastAction PAUSE;
        private static final /* synthetic */ LastAction[] $VALUES;
        static final long serialVersionUID = -3685291953106078876L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static LastAction[] values() {
            return (LastAction[])$VALUES.clone();
        }

        public static LastAction valueOf(String name) {
            return Enum.valueOf(LastAction.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LastAction.class);
            NONE = new LastAction();
            GROW = new LastAction();
            SHRINK = new LastAction();
            PAUSE = new LastAction();
            $VALUES = new LastAction[]{NONE, GROW, SHRINK, PAUSE};
        }
    }
}

