/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs7;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.EntityIdentifier;
import com.ibm.security.pkcs7.IssuerAndSerialNumber;
import com.ibm.security.pkcs7.MailListKeyIdentifier;
import com.ibm.security.pkcs7.RecipientIdentifier;
import com.ibm.security.pkcs7.RecipientKeyIdentifier;
import com.ibm.security.pkcs7.SubjectKeyIdentifier;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.SmudgedBytes;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;

public final class RecipientInfo
extends PKCSDerObject
implements Cloneable {
    private static final byte TAG_RKEY = 0;
    private static final byte TAG_MLKEY = 1;
    private static final String ISSUER = "com.ibm.security.pkcs7.IssuerAndSerialNumber";
    private static final String RKEYID = "com.ibm.security.pkcs7.RecipientKeyIdentifier";
    private static final String MLKEYID = "com.ibm.security.pkcs7.MailListKeyIdentifier";
    private static final String SKEYID = "com.ibm.security.pkcs7.SubjectKeyIdentifier";
    private BigInteger version;
    private IssuerAndSerialNumber recipientIdIssuer;
    private RecipientKeyIdentifier recipientIdRKeyId;
    private MailListKeyIdentifier recipientIdMLKeyId;
    private IssuerAndSerialNumber originatorCertIssuer;
    private byte[] originatorCertSKeyId;
    private AlgorithmId keyEncryptionAlgorithm;
    private SmudgedBytes encryptedKey;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs7.RecipientInfo";
    private volatile int cachedHashVal;

    public RecipientInfo(byte[] der) throws IOException {
        super(der);
        this.cachedHashVal = 0;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RecipientInfo", (Object)der);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(byte[] der, String provider) throws IOException {
        super(der, provider);
        this.cachedHashVal = 0;
        if (debug != null) {
            debug.entry(16384L, className, "RecipientInfo", der, provider);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(byte[] key, Certificate cert) throws IOException, PKCSException {
        this(key, cert, null);
        if (debug != null) {
            debug.entry(16384L, className, "RecipientInfo", key, cert);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(byte[] key, Certificate cert, String provider) throws IOException, PKCSException {
        super(provider);
        this.cachedHashVal = 0;
        if (debug != null) {
            Object[] parms = new Object[]{key, cert, provider};
            debug.entry(16384L, (Object)className, "RecipientInfo", parms);
        }
        X509Certificate x509cert = (X509Certificate)cert;
        X500Name xname = null;
        if (x509cert instanceof X509CertImpl) {
            xname = (X500Name)((X509CertImpl)x509cert).getIssuerDN();
        } else {
            X500Principal princ = x509cert.getIssuerX500Principal();
            xname = new X500Name(princ.getEncoded());
        }
        this.recipientIdIssuer = new IssuerAndSerialNumber(xname, x509cert.getSerialNumber(), provider);
        this.recipientIdRKeyId = null;
        this.recipientIdMLKeyId = null;
        this.originatorCertIssuer = null;
        this.originatorCertSKeyId = null;
        try {
            this.encryptKey(key, cert);
            this.keyEncryptionAlgorithm = AlgorithmId.get(cert.getPublicKey().getAlgorithm());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "RecipientInfo", e2);
            }
            throw new PKCSException(e2, "Key encryption error (" + e2.toString() + ")");
        }
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(RecipientIdentifier rid, EntityIdentifier ei, AlgorithmId alg, byte[] key) {
        this(rid, ei, alg, key, null);
        if (debug != null) {
            Object[] parms = new Object[]{rid, ei, alg, key};
            debug.entry(16384L, (Object)className, "RecipientInfo", parms);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public RecipientInfo(RecipientIdentifier rid, EntityIdentifier ei, AlgorithmId alg, byte[] key, String provider) {
        block14: {
            block15: {
                Class<?> cls;
                String classname;
                super(provider);
                this.cachedHashVal = 0;
                if (debug != null) {
                    Object[] parms = new Object[]{rid, ei, alg, key, provider};
                    debug.entry(16384L, (Object)className, "RecipientInfo", parms);
                }
                if ((classname = (cls = rid.getClass()).getName()).equals(ISSUER)) {
                    this.recipientIdIssuer = (IssuerAndSerialNumber)rid;
                    this.recipientIdRKeyId = null;
                    this.recipientIdMLKeyId = null;
                } else if (classname.equals(RKEYID)) {
                    this.recipientIdIssuer = null;
                    this.recipientIdRKeyId = (RecipientKeyIdentifier)rid;
                    this.recipientIdMLKeyId = null;
                } else if (classname.equals(MLKEYID)) {
                    this.recipientIdIssuer = null;
                    this.recipientIdRKeyId = null;
                    this.recipientIdMLKeyId = (MailListKeyIdentifier)rid;
                } else {
                    if (debug != null) {
                        debug.text(16384L, className, "RecipientInfo", "Invalid RecipientIdentifier");
                    }
                    throw new IllegalArgumentException("Invalid RecipientIdentifier");
                }
                if (ei == null) break block15;
                cls = ei.getClass();
                classname = cls.getName();
                if (classname.equals(ISSUER)) {
                    this.originatorCertIssuer = (IssuerAndSerialNumber)ei;
                    this.originatorCertSKeyId = null;
                    break block14;
                } else if (classname.equals(SKEYID)) {
                    this.originatorCertIssuer = null;
                    SubjectKeyIdentifier ski = (SubjectKeyIdentifier)ei;
                    this.originatorCertSKeyId = ski.getIdentifier();
                    break block14;
                } else {
                    if (debug != null) {
                        debug.text(16384L, className, "RecipientInfo", "Invalid EntityIdentifier");
                    }
                    throw new IllegalArgumentException("Invalid EntityIdentifier");
                }
            }
            this.originatorCertIssuer = null;
            this.originatorCertSKeyId = null;
        }
        this.keyEncryptionAlgorithm = alg;
        this.setEncryptedKeyValue(key);
        this.calculateVersion();
        if (debug != null) {
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(String filename, boolean base64) throws IOException {
        super(filename, base64);
        this.cachedHashVal = 0;
        if (debug != null) {
            debug.entry(16384L, className, "RecipientInfo", filename, new Boolean(base64));
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    public RecipientInfo(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        this.cachedHashVal = 0;
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "RecipientInfo", parms);
            debug.exit(16384L, className, "RecipientInfo");
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        DerOutputStream derout;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putInteger(this.version);
        if (this.recipientIdIssuer != null) {
            this.recipientIdIssuer.encode(bytes);
        } else if (this.recipientIdRKeyId != null) {
            derout = new DerOutputStream();
            this.recipientIdRKeyId.encode(derout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derout);
        } else if (this.recipientIdMLKeyId != null) {
            derout = new DerOutputStream();
            this.recipientIdMLKeyId.encode(derout);
            bytes.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derout);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "encode", "RecipientInfo encoding error");
            }
            throw new IOException("RecipientInfo encoding error");
        }
        if (this.originatorCertIssuer != null) {
            derout = new DerOutputStream();
            this.originatorCertIssuer.encode(derout);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)0), derout);
        } else if (this.originatorCertSKeyId != null) {
            derout = new DerOutputStream();
            derout.putOctetString(this.originatorCertSKeyId);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)0), derout);
        }
        this.keyEncryptionAlgorithm.encode(bytes);
        bytes.putOctetString(this.getEncryptedKeyValue());
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "RecipientInfo parsing error");
            }
            throw new IOException("RecipientInfo parsing error");
        }
        this.version = encoding.getData().getInteger();
        if (this.version.intValue() != 0 && this.version.intValue() != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "RecipientInfo version must be zero or two");
            }
            throw new IOException("RecipientInfo version must be zero or two");
        }
        int tag = encoding.getData().peekByte();
        DerValue der = encoding.getData().getDerValue();
        if (tag == 48) {
            this.recipientIdIssuer = new IssuerAndSerialNumber(der.toByteArray(), this.provider);
            this.recipientIdRKeyId = null;
            this.recipientIdMLKeyId = null;
        } else if ((byte)tag == -96) {
            der.resetTag((byte)48);
            this.recipientIdIssuer = null;
            this.recipientIdRKeyId = new RecipientKeyIdentifier(der.toByteArray(), this.provider);
            this.recipientIdMLKeyId = null;
        } else if ((byte)tag == -95) {
            der.resetTag((byte)48);
            this.recipientIdIssuer = null;
            this.recipientIdRKeyId = null;
            this.recipientIdMLKeyId = new MailListKeyIdentifier(der.toByteArray(), this.provider);
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "RecipientInfo parsing error");
            }
            throw new IOException("RecipientInfo parsing error");
        }
        boolean gotOriginatorCert = false;
        der = encoding.getData().getDerValue();
        if (der.isContextSpecific()) {
            DerValue newder = der.getData().getDerValue();
            if (newder.getTag() == 48) {
                this.originatorCertIssuer = new IssuerAndSerialNumber(newder.toByteArray(), this.provider);
                this.originatorCertSKeyId = null;
            } else if (newder.getTag() == 4) {
                this.originatorCertIssuer = null;
                this.originatorCertSKeyId = newder.getOctetString();
            } else {
                this.originatorCertIssuer = null;
                this.originatorCertSKeyId = null;
            }
            gotOriginatorCert = true;
        }
        this.keyEncryptionAlgorithm = gotOriginatorCert ? AlgorithmId.parse(encoding.getData().getDerValue()) : AlgorithmId.parse(der);
        this.setEncryptedKeyValue(encoding.getData().getOctetString());
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (other == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof RecipientInfo)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((RecipientInfo)other)));
            }
            return this.equals((RecipientInfo)other);
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((RecipientInfo)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", e2);
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashVal == 0) {
            try {
                DerOutputStream thisOut = new DerOutputStream();
                this.encode(thisOut);
                this.cachedHashVal = Arrays.hashCode(thisOut.toByteArray());
            }
            catch (Exception e2) {
                return 0;
            }
        }
        return this.cachedHashVal;
    }

    @Override
    public String toString() {
        HexDumpEncoder hexDump = new HexDumpEncoder();
        String out = "";
        out = out + "\tversion: " + this.version.intValue();
        out = out + "\r\n\trecipient identifier: \r\n";
        if (this.recipientIdIssuer != null) {
            out = out + this.recipientIdIssuer;
        } else if (this.recipientIdRKeyId != null) {
            out = out + this.recipientIdRKeyId;
        } else if (this.recipientIdMLKeyId != null) {
            out = out + this.recipientIdMLKeyId;
        }
        out = out + "\r\n\toriginator certificate: ";
        if (this.originatorCertIssuer == null && this.originatorCertSKeyId == null) {
            out = out + "null";
        } else if (this.originatorCertIssuer != null) {
            out = out + "\r\n" + this.originatorCertIssuer;
        } else if (this.originatorCertSKeyId != null) {
            out = out + "\r\n" + hexDump.encode(this.originatorCertSKeyId);
        }
        out = out + "\r\n\tkey encryption algorithm: " + this.keyEncryptionAlgorithm;
        out = out + "\r\n\tencrypted key: \r\n" + hexDump.encode(this.getEncryptedKeyValue());
        return out;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            RecipientInfo result = new RecipientInfo(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", null);
            }
            return null;
        }
    }

    public BigInteger getVersion() {
        if (debug != null) {
            debug.entry(16384L, className, "getVersion");
            debug.exit(16384L, (Object)className, "getVersion", this.version);
        }
        return this.version;
    }

    public byte[] getEncryptedKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getEncryptedKey");
        }
        if (this.encryptedKey == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEncryptedKey", null);
            }
            return null;
        }
        byte[] result = (byte[])this.getEncryptedKeyValue().clone();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEncryptedKey", result);
        }
        return result;
    }

    public AlgorithmId getKeyEncryptionAlgorithm() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyEncryptionAlgorithm");
        }
        if (this.keyEncryptionAlgorithm == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getKeyEncryptionAlgorithm", null);
            }
            return null;
        }
        AlgorithmId result = new AlgorithmId(this.keyEncryptionAlgorithm.getOID(), this.keyEncryptionAlgorithm.getParameters(), this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getKeyEncryptionAlgorithm", result);
        }
        return result;
    }

    public RecipientIdentifier getRecipientIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getRecipientIdentifier");
        }
        RecipientIdentifier result = null;
        if (this.recipientIdIssuer != null) {
            result = (RecipientIdentifier)this.recipientIdIssuer.clone();
        } else if (this.recipientIdRKeyId != null) {
            result = (RecipientIdentifier)this.recipientIdRKeyId.clone();
        } else if (this.recipientIdMLKeyId != null) {
            result = (RecipientIdentifier)this.recipientIdMLKeyId.clone();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getRecipientIdentifier", result);
        }
        return result;
    }

    public EntityIdentifier getEntityIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getEntityIdentifier");
        }
        if (this.originatorCertIssuer != null) {
            EntityIdentifier result = (EntityIdentifier)this.originatorCertIssuer.clone();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier", result);
            }
            return result;
        }
        if (this.originatorCertSKeyId != null) {
            SubjectKeyIdentifier ski = null;
            try {
                ski = new SubjectKeyIdentifier(this.provider);
                ski.setIdentifier(this.originatorCertSKeyId);
            }
            catch (PKCSException e2) {
                if (debug != null) {
                    debug.exception(16384L, className, "getEntityIdentifier", e2);
                }
                ski = null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier", ski);
            }
            return ski;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEntityIdentifier", null);
        }
        return null;
    }

    public boolean identifies(Certificate cert) throws IOException {
        BigInteger oldbigSN;
        X500Name riiname;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "identifies", cert);
        }
        if (this.recipientIdIssuer == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier_1", new Boolean(false));
            }
            return false;
        }
        X509Certificate x509cert = (X509Certificate)cert;
        Principal princ = x509cert.getIssuerDN();
        X500Name xname = new X500Name(princ.getName());
        if (!xname.equals(riiname = this.recipientIdIssuer.getIssuer())) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier_1", new Boolean(false));
            }
            return false;
        }
        BigInteger bigSN = x509cert.getSerialNumber();
        if (!bigSN.equals(oldbigSN = this.recipientIdIssuer.getSerialNumber())) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getEntityIdentifier_1", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getEntityIdentifier", new Boolean(true));
        }
        return true;
    }

    private void encryptKey(byte[] key, Certificate cert) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "encryptKey", key, cert);
        }
        PublicKey pubKey = cert.getPublicKey();
        String alg = cert.getPublicKey().getAlgorithm();
        try {
            Cipher cipher = this.provider != null ? Cipher.getInstance(alg, this.provider) : Cipher.getInstance(alg);
            cipher.init(1, pubKey);
            this.setEncryptedKeyValue(cipher.doFinal(key));
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "encryptKey", e2);
            }
            throw new PKCSException(e2, "Key encryption error (" + e2.toString() + ")");
        }
        if (debug != null) {
            debug.exit(16384L, className, "encryptKey");
        }
    }

    public byte[] decryptKey(PrivateKey key) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decryptKey", key);
        }
        try {
            String keyEncryptionAlg = this.keyEncryptionAlgorithm.getName();
            Cipher cipher = null;
            cipher = this.provider != null ? Cipher.getInstance(keyEncryptionAlg, this.provider) : Cipher.getInstance(keyEncryptionAlg);
            cipher.init(2, key);
            byte[] result = cipher.doFinal(this.getEncryptedKeyValue());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "decryptKey", result);
            }
            return result;
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(16384L, className, "decryptKey", e2);
            }
            throw new PKCSException(e2, "Key decryption error (" + e2.toString() + ")");
        }
    }

    private void calculateVersion() {
        if (debug != null) {
            debug.entry(8192L, className, "calculateVersion");
        }
        this.version = BigInteger.valueOf(2L);
        if (this.originatorCertIssuer == null && this.originatorCertSKeyId == null && this.recipientIdIssuer != null) {
            this.version = BigInteger.ZERO;
        }
        if (debug != null) {
            debug.exit(8192L, className, "calculateVersion");
        }
    }

    private void setEncryptedKeyValue(byte[] bytes) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setEncryptedKeyValue", (Object)bytes);
        }
        this.encryptedKey = new SmudgedBytes(bytes);
        if (debug != null) {
            debug.exit(8192L, className, "setEncryptedKeyValue");
        }
    }

    private byte[] getEncryptedKeyValue() {
        if (debug != null) {
            debug.entry(8192L, className, "getEncryptedKeyValue");
        }
        if (this.encryptedKey == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getEncryptedKeyValue", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getEncryptedKeyValue", this.encryptedKey.getClearText());
        }
        return this.encryptedKey.getClearText();
    }

    protected void finalize() {
        this.encryptedKey = null;
    }
}

