/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs10;

import com.ibm.misc.BASE64Decoder;
import com.ibm.misc.BASE64Encoder;
import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Locale;

public final class CertificationRequest
extends PKCSDerObject
implements Cloneable {
    private static String BEGIN_REQUEST = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static String END_REQUEST = "-----END NEW CERTIFICATE REQUEST-----";
    private CertificationRequestInfo certReqInfo;
    private AlgorithmId sigAlg;
    private byte[] signature;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs10.CertificationRequest";

    public CertificationRequest(byte[] der) throws IOException {
        super(der);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificationRequest", (Object)der);
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(byte[] der, String provname) throws IOException {
        super(der, provname);
        if (debug != null) {
            debug.entry(16384L, className, "CertificationRequest", der, provname);
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(CertificationRequestInfo certReqInfo, PrivateKey privateKey, String digest) throws NoSuchAlgorithmException, IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{certReqInfo, privateKey, digest};
            debug.entry(16384L, (Object)className, "CertificationRequest", parms);
        }
        this.certReqInfo = certReqInfo;
        try {
            this.signThis(digest, privateKey);
        }
        catch (SignatureException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "CertificationRequest", e2);
            }
            throw new PKCSException(e2, "Error signing CertificateRequest: " + e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(CertificationRequestInfo certReqInfo, PrivateKey privateKey, String digest, String provname) throws NoSuchAlgorithmException, IOException, PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{certReqInfo, privateKey, digest, provname};
            debug.entry(16384L, (Object)className, "CertificationRequest", parms);
        }
        if (provname != null) {
            ((PKCSDerObject)this).provider = new String(provname);
        }
        this.certReqInfo = certReqInfo;
        try {
            this.signThis(digest, privateKey);
        }
        catch (SignatureException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "CertificationRequest", e2);
            }
            throw new PKCSException(e2, "Error signing CertificateRequest: " + e2.toString());
        }
        if (debug != null) {
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(CertificationRequestInfo info) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificationRequest", info);
            debug.exit(16384L, className, "CertificationRequest");
        }
        this.certReqInfo = info;
    }

    public CertificationRequest(CertificationRequestInfo info, String provname) {
        super(provname);
        if (debug != null) {
            debug.entry(16384L, className, "CertificationRequest", info, provname);
            debug.exit(16384L, className, "CertificationRequest");
        }
        this.certReqInfo = info;
    }

    public CertificationRequest(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "CertificationRequest", parms);
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    public CertificationRequest(String filename, boolean base64, String provname) throws IOException {
        super(filename, base64, provname);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provname};
            debug.entry(16384L, (Object)className, "CertificationRequest", parms);
            debug.exit(16384L, className, "CertificationRequest");
        }
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", os);
        }
        if (this.sigAlg == null || this.signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Cannot encode unsigned certification request.");
            }
            throw new IOException("Cannot encode unsigned certification request.");
        }
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        this.certReqInfo.encode(bytes);
        this.sigAlg.encode(bytes);
        bytes.putBitString(this.signature);
        tmp.write((byte)48, bytes);
        os.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public CertificationRequest sign(String digest, PrivateKey key) throws PKCSException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign", digest, key);
        }
        if (digest == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "digest must be specified.");
            }
            throw new IllegalArgumentException("digest must be specified.");
        }
        if (key == null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "key must be specified.");
            }
            throw new IllegalArgumentException("key must be specified.");
        }
        if (this.signature != null) {
            if (debug != null) {
                debug.text(16384L, className, "sign", "Request is already signed.");
            }
            throw new SignatureException("Request is already signed.");
        }
        CertificationRequest certreq = new CertificationRequest(this.certReqInfo, ((PKCSDerObject)this).provider);
        certreq.signThis(digest, key);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", certreq);
        }
        return certreq;
    }

    public void verify() throws IOException, SignatureException, NoSuchAlgorithmException {
        Signature sig = null;
        if (debug != null) {
            debug.entry(16384L, className, "verify");
        }
        try {
            if (((PKCSDerObject)this).provider != null) {
                try {
                    sig = Signature.getInstance(this.sigAlg.getName(), ((PKCSDerObject)this).provider);
                }
                catch (NoSuchProviderException nspe) {
                    if (debug != null) {
                        debug.exception(16384L, className, "verify", nspe);
                    }
                    throw new IOException("provider " + ((PKCSDerObject)this).provider + " not found " + nspe);
                }
            } else {
                sig = Signature.getInstance(this.sigAlg.getName());
            }
            PublicKey key = this.certReqInfo.getSubjectPublicKeyInfo();
            sig.initVerify(key);
            byte[] info = this.getEncodedInfo();
            sig.update(info);
            if (!sig.verify(this.signature)) {
                if (debug != null) {
                    debug.text(16384L, className, "verify", "Invalid PKCS #10 signature");
                }
                throw new SignatureException("Invalid PKCS #10 signature");
            }
        }
        catch (InvalidKeyException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "verify", e2);
            }
            throw new SignatureException("Invalid key");
        }
        if (debug != null) {
            debug.exit(16384L, className, "verify");
        }
    }

    @Override
    public boolean equals(Object other) {
        DerValue otherDer;
        DerValue thisDer;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
        }
        if (this == other) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        if (!(other instanceof CertificationRequest)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        try {
            DerOutputStream thisOut = new DerOutputStream();
            DerOutputStream otherOut = new DerOutputStream();
            this.encode(thisOut);
            thisDer = new DerValue(thisOut.toByteArray());
            ((CertificationRequest)other).encode(otherOut);
            otherDer = new DerValue(otherOut.toByteArray());
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.text(16384L, className, "equals", "exception " + e2.toString());
            }
            return false;
        }
        if (!thisDer.equals(otherDer)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }

    @Override
    public int hashCode() {
        int retval = 0;
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
        }
        if (this.signature != null) {
            for (int i2 = 1; i2 < this.signature.length; ++i2) {
                retval += this.signature[i2] * i2;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "hashCode", new Integer(retval));
        }
        return retval;
    }

    public Object clone() {
        if (this.sigAlg == null || this.signature == null) {
            return new CertificationRequest(this.certReqInfo, ((PKCSDerObject)this).provider);
        }
        try {
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            return new CertificationRequest(derout.toByteArray());
        }
        catch (Exception e2) {
            return null;
        }
    }

    public CertificationRequestInfo getCertRequestInfo() {
        if (debug != null) {
            debug.entry(16384L, className, "getCertRequestInfo");
            debug.exit(16384L, (Object)className, "getCertRequestInfo", this.certReqInfo);
        }
        return this.certReqInfo;
    }

    public AlgorithmId getSignatureAlgorithm() {
        AlgorithmId algID = null;
        if (debug != null) {
            debug.entry(16384L, className, "getSignatureAlgorithm");
        }
        algID = new AlgorithmId(this.sigAlg.getOID(), ((PKCSDerObject)this).provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignatureAlgorithm", algID);
        }
        return algID;
    }

    public byte[] getSignature() {
        if (debug != null) {
            debug.entry(16384L, className, "getSignature");
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSignature", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSignature", this.signature.clone());
        }
        return (byte[])this.signature.clone();
    }

    public void print(PrintStream out) throws IOException, SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "print", out);
        }
        if (this.signature == null) {
            if (debug != null) {
                debug.text(16384L, className, "print", "CertificationRequest was not signed.");
            }
            throw new SignatureException("CertificationRequest was not signed.");
        }
        byte[] encoding = this.encode();
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            out.write((BEGIN_REQUEST + "\r\n").getBytes("8859_1"));
        }
        catch (Exception e2) {
            out.write((BEGIN_REQUEST + "\r\n").getBytes());
        }
        encoder.encodeBuffer(encoding, (OutputStream)out);
        try {
            out.write(END_REQUEST.getBytes("8859_1"));
        }
        catch (Exception e3) {
            out.write(END_REQUEST.getBytes());
        }
        if (debug != null) {
            debug.exit(16384L, className, "print");
        }
    }

    @Override
    public String toString() {
        String pubKey = null;
        try {
            pubKey = this.certReqInfo.getSubjectPublicKeyInfo().toString();
        }
        catch (Exception e2) {
            pubKey = "<UNAVAILABLE>";
        }
        String sig = null;
        if (this.signature != null) {
            HexDumpEncoder hd = new HexDumpEncoder();
            sig = hd.encodeBuffer(this.signature);
        }
        PKCSAttributes attributeSet = this.certReqInfo.getAttributes();
        return "[PKCS #10 certification request:\r\n\tsubject: <" + this.certReqInfo.getSubjectName() + ">" + "\r\n" + "\tpublic key info: " + pubKey + "\r\n" + "\tattributes: " + attributeSet.toString() + "\r\n" + "\talgorithm id: " + this.sigAlg + "\r\n" + "\tsignature:\r\n" + sig + "\r\n]";
    }

    @Override
    public void writeBASE64(String filename) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        PrintStream ps = new PrintStream(fos);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "writeBASE64", filename);
        }
        try {
            this.print(ps);
            ps.close();
        }
        catch (Exception e2) {
            ps.close();
        }
        if (debug != null) {
            debug.exit(16384L, className, "writeBASE64");
        }
    }

    @Override
    protected void decode(DerValue encoding) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", encoding);
        }
        if (encoding.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertificationRequest parsing error");
            }
            throw new IOException("CertificationRequest parsing error");
        }
        DerInputStream in = new DerInputStream(encoding.toByteArray());
        DerValue[] seq = in.getSequence(3);
        if (seq.length != 3) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "CertificationRequest length error");
            }
            throw new IOException("CertificationRequest parsing error");
        }
        byte[] data = seq[0].toByteArray();
        this.certReqInfo = new CertificationRequestInfo(data, ((PKCSDerObject)this).provider);
        this.sigAlg = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private byte[] getEncodedInfo() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "getEncodedInfo");
        }
        DerOutputStream derout = new DerOutputStream();
        this.certReqInfo.encode(derout);
        if (debug != null) {
            debug.exit(8192L, className, "getEncodedInfo");
        }
        return derout.toByteArray();
    }

    private void signThis(String digest, PrivateKey key) throws PKCSException, SignatureException {
        if (debug != null) {
            debug.entry(8192L, className, "signThis", digest, key);
        }
        if (digest == null) {
            if (debug != null) {
                debug.text(8192L, className, "signThis", "digest must be specified.");
            }
            throw new IllegalArgumentException("digest must be specified.");
        }
        if (key == null) {
            if (debug != null) {
                debug.text(8192L, className, "signThis", "key must be specified.");
            }
            throw new IllegalArgumentException("key must be specified.");
        }
        if (this.signature != null) {
            if (debug != null) {
                debug.text(8192L, className, "signThis", "Request is already signed.");
            }
            throw new SignatureException("Request is already signed.");
        }
        try {
            String sigalg = null;
            int index = digest.toUpperCase(Locale.US).indexOf("WITH");
            if (index == -1) {
                String alg = key.getAlgorithm();
                if (alg.equals("EC")) {
                    alg = "ECDSA";
                }
                sigalg = digest + "with" + alg;
            } else {
                sigalg = digest;
            }
            Signature sig = ((PKCSDerObject)this).provider != null ? Signature.getInstance(sigalg, ((PKCSDerObject)this).provider) : Signature.getInstance(sigalg);
            this.sigAlg = AlgorithmId.get(sig.getAlgorithm());
            sig.initSign(key);
            DerOutputStream derout = new DerOutputStream();
            this.certReqInfo.encode(derout);
            byte[] info = derout.toByteArray();
            sig.update(info);
            this.signature = sig.sign();
        }
        catch (Exception e2) {
            if (debug != null) {
                debug.exception(8192L, className, "signThis", e2);
            }
            throw new PKCSException(e2, "Error signing CertificateRequestInfo: " + e2.toString());
        }
        if (debug != null) {
            debug.exit(8192L, className, "signThis");
        }
    }

    @Override
    protected void readBASE64(String filename) throws IOException {
        FileInputStream fis;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "readBASE64", filename);
        }
        try {
            fis = new FileInputStream(filename);
        }
        catch (FileNotFoundException e2) {
            if (debug != null) {
                debug.exception(16384L, className, "readBASE64", e2);
            }
            throw new IOException("File " + filename + " not found.");
        }
        int numBytes = fis.available();
        byte[] contents = new byte[numBytes];
        fis.read(contents);
        fis.close();
        String crlf = "\r\n";
        byte[] crlfbytes = null;
        String pszcontents = null;
        try {
            crlfbytes = crlf.getBytes("8859_1");
            pszcontents = new String(contents, "8859_1");
        }
        catch (UnsupportedEncodingException e3) {
            crlfbytes = crlf.getBytes();
            pszcontents = new String(contents);
        }
        StringReader sreader = new StringReader(pszcontents);
        BufferedReader breader = new BufferedReader(sreader);
        String inline = null;
        boolean bbody = false;
        boolean bfooter = false;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        while ((inline = breader.readLine()) != null) {
            try {
                bos2.write(inline.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e4) {
                bos2.write(inline.getBytes());
            }
            if (inline.equals(BEGIN_REQUEST)) {
                bbody = true;
                continue;
            }
            if (inline.equals(END_REQUEST)) {
                bfooter = true;
                break;
            }
            if (!bbody) continue;
            try {
                bos.write(inline.getBytes("8859_1"));
            }
            catch (UnsupportedEncodingException e5) {
                bos.write(inline.getBytes());
            }
            bos.write(crlfbytes);
        }
        ByteArrayInputStream bais = null;
        if (!bbody && !bfooter) {
            bais = new ByteArrayInputStream(bos2.toByteArray());
        } else {
            if (!bbody) {
                if (debug != null) {
                    debug.text(16384L, className, "readBASE64", "File did not include the following header: " + BEGIN_REQUEST);
                }
                throw new IOException("File did not include the following header: " + BEGIN_REQUEST);
            }
            if (!bfooter) {
                if (debug != null) {
                    debug.text(16384L, className, "readBASE64", "File did not include the following footer: " + END_REQUEST);
                }
                throw new IOException("File did not include the following footer: " + END_REQUEST);
            }
            bais = new ByteArrayInputStream(bos.toByteArray());
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] encoding = decoder.decodeBuffer(bais);
        this.decode(encoding);
        if (debug != null) {
            debug.exit(16384L, className, "readBASE64");
        }
    }
}

