/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.injectionengine;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.injectionengine.InjectionMetaDataImpl;
import com.ibm.ws.injectionengine.InjectionProcessorManager;
import com.ibm.ws.injectionengine.InjectionProcessorProviderImpl;
import com.ibm.ws.injectionengine.InjectionScopeData;
import com.ibm.ws.injectionengine.InternalInjectionEngine;
import com.ibm.ws.injectionengine.ObjectFactoryInfoImpl;
import com.ibm.ws.injectionengine.ReferenceContextImpl;
import com.ibm.ws.injectionengine.factory.MBLinkReferenceFactoryImpl;
import com.ibm.ws.injectionengine.ffdc.Formattable;
import com.ibm.ws.injectionengine.ffdc.InjectionDiagnosticModule;
import com.ibm.ws.injectionengine.processor.DataSourceDefinitionProcessorProvider;
import com.ibm.ws.injectionengine.processor.ResourceProcessorProvider;
import com.ibm.ws.resource.ResourceFactoryBuilder;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.ws.util.dopriv.GetClassLoaderPrivileged;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import com.ibm.wsspi.injectionengine.InjectionProcessor;
import com.ibm.wsspi.injectionengine.InjectionProcessorContextImpl;
import com.ibm.wsspi.injectionengine.InjectionProcessorProvider;
import com.ibm.wsspi.injectionengine.InjectionScope;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.InternalInjectionEngineAccessor;
import com.ibm.wsspi.injectionengine.MethodMap;
import com.ibm.wsspi.injectionengine.ObjectFactoryInfo;
import com.ibm.wsspi.injectionengine.OverrideInjectionProcessor;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import com.ibm.wsspi.injectionengine.factory.EJBLinkReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.IndirectJndiLookupReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.MBLinkReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.OverrideReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.ResAutoLinkReferenceFactory;
import com.ibm.wsspi.injectionengine.factory.ResRefReferenceFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Context;
import javax.naming.spi.ObjectFactory;

public abstract class AbstractInjectionEngine
implements InternalInjectionEngine,
Formattable {
    private static final TraceComponent tc = Tr.register(AbstractInjectionEngine.class, (String)"Injection", (String)"com.ibm.wsspi.injectionengine.injection");
    private static final ThreadContextAccessor svThreadContextAccessor = ThreadContextAccessor.getThreadContextAccessor();
    private static final InjectionTarget[] EMPTY_INJECTION_TARGETS = new InjectionTarget[0];
    private static final MBLinkReferenceFactory DEFAULT_MBLinkRefFactory = new MBLinkReferenceFactoryImpl();
    protected MBLinkReferenceFactory ivMBLinkRefFactory = DEFAULT_MBLinkRefFactory;
    private final Map<Class<?>, InjectionProcessorProvider<?, ?>> ivProcessorProviders = new ConcurrentHashMap();
    private Map<Class<? extends Annotation>, Map<Class<?>, ObjectFactoryInfo>> ivObjectFactoryMap = new HashMap();
    private boolean ivObjectFactoryMapCopyOnWrite;
    private Map<Class<? extends Annotation>, Map<Class<?>, ObjectFactoryInfo>> ivNoOverrideObjectFactoryMap = new HashMap();
    private boolean ivNoOverrideObjectFactoryMapCopyOnWrite;
    private HashMap<Class<? extends Annotation>, OverrideReferenceFactory<?>[]> ivOverrideReferenceFactoryMap = new HashMap();
    private boolean ivOverrideReferenceFactoryMapCopyOnWrite;
    private boolean ivIsInitialized = false;
    private final List<InjectionMetaDataListener> metaDataListeners = new CopyOnWriteArrayList<InjectionMetaDataListener>();
    private final Set<ClassLoader> ivCheckedAnnotationClassLoaders = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private Map<ClassLoader, Set<String>> ivWarnedClassLoaderAnnotations;

    @Override
    public abstract boolean isEmbeddable();

    protected abstract IndirectJndiLookupReferenceFactory getDefaultIndirectJndiLookupReferenceFactory();

    protected abstract IndirectJndiLookupReferenceFactory getDefaultResIndirectJndiLookupReferenceFactory();

    protected abstract ResRefReferenceFactory getDefaultResRefReferenceFactory();

    protected abstract ResAutoLinkReferenceFactory getDefaultResAutoLinkReferenceFactory();

    protected abstract EJBLinkReferenceFactory getDefaultEJBLinkReferenceFactory();

    public abstract InjectionScopeData getInjectionScopeData(MetaData var1);

    public abstract ResourceFactoryBuilder getResourceFactoryBuilder(String var1) throws InjectionException;

    public void initialize() {
        InternalInjectionEngineAccessor.setInjectionEngine(this);
        InjectionDiagnosticModule dm = InjectionDiagnosticModule.instance();
        dm.initialize(this);
        dm.registerWithFFDCService();
        this.ivIsInitialized = true;
        try {
            this.registerInjectionProcessorProvider(new ResourceProcessorProvider());
            this.registerInjectionProcessorProvider(new DataSourceDefinitionProcessorProvider());
        }
        catch (InjectionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void stop() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop", (Object[])new Object[0]);
        }
        this.ivIsInitialized = false;
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    @Override
    public <A extends Annotation, AS extends Annotation> void registerInjectionProcessor(Class<? extends InjectionProcessor<A, AS>> processor, Class<A> annotation) throws InjectionException {
        if (OverrideInjectionProcessor.class.isAssignableFrom(processor)) {
            throw new IllegalArgumentException("OverrideInjectionProcessor must be registered with an InjectionProcessorProvider");
        }
        this.registerInjectionProcessorProvider(new InjectionProcessorProviderImpl(annotation, processor));
    }

    @Override
    public synchronized void registerInjectionProcessorProvider(InjectionProcessorProvider<?, ?> provider) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("registerInjectionProcessor: " + provider.getAnnotationClass() + " = " + provider), (Object[])new Object[0]);
        }
        if (!this.ivIsInitialized) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_ENGINE_SERVICE_NOT_INITIALIZED_CWNEN0006E", (Object[])new Object[0]);
            throw new InjectionException("injection engine is not initialized");
        }
        Class<?> annotationClass = provider.getAnnotationClass();
        if (this.ivProcessorProviders.get(annotationClass) != null) {
            throw new InjectionException("provider already registered for " + annotationClass.getName());
        }
        this.ivProcessorProviders.put(annotationClass, provider);
    }

    @Override
    public synchronized void unregisterInjectionProcessorProvider(InjectionProcessorProvider<?, ?> provider) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unregisterInjectionProcessorProvider: " + provider.getAnnotationClass() + " = " + provider), (Object[])new Object[0]);
        }
        if (!this.ivIsInitialized) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_ENGINE_SERVICE_NOT_INITIALIZED_CWNEN0006E", (Object[])new Object[0]);
            throw new InjectionException("injection engine is not initialized");
        }
        Class<?> annotationClass = provider.getAnnotationClass();
        if (this.ivProcessorProviders.get(annotationClass) != provider) {
            throw new InjectionException("provider not registered for " + annotationClass.getName());
        }
        this.ivProcessorProviders.remove(annotationClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InjectionProcessorContextImpl createInjectionProcessorContext() {
        InjectionProcessorContextImpl context = new InjectionProcessorContextImpl();
        AbstractInjectionEngine abstractInjectionEngine = this;
        synchronized (abstractInjectionEngine) {
            context.ivObjectFactoryMap = this.ivObjectFactoryMap;
            this.ivObjectFactoryMapCopyOnWrite = true;
            context.ivNoOverrideObjectFactoryMap = this.ivNoOverrideObjectFactoryMap;
            this.ivNoOverrideObjectFactoryMapCopyOnWrite = true;
            context.ivOverrideReferenceFactoryMap = this.ivOverrideReferenceFactoryMap;
            this.ivOverrideReferenceFactoryMapCopyOnWrite = true;
        }
        return context;
    }

    ComponentNameSpaceConfiguration createNonCompNameSpaceConfig(InjectionScope scope, J2EEName j2eeName, Context javaColonContext, InjectionProcessorContextImpl context) {
        ComponentNameSpaceConfiguration compNSConfig;
        String displayName;
        String string = displayName = j2eeName != null ? j2eeName.getComponent() : null;
        if (displayName == null) {
            displayName = scope.qualifiedName();
        }
        if ((compNSConfig = new ComponentNameSpaceConfiguration(displayName, j2eeName)).getModuleName() == null) {
            compNSConfig.setModuleDisplayName(scope.qualifiedName());
        }
        if (compNSConfig.getApplicationName() == null) {
            compNSConfig.setApplicationDisplayName(scope.qualifiedName());
        }
        compNSConfig.setJavaColonContext(javaColonContext);
        compNSConfig.setInjectionClasses(Collections.<Class<?>>emptyList());
        compNSConfig.setInjectionProcessorContext(context);
        return compNSConfig;
    }

    @Override
    public void processInjectionMetaData(HashMap<Class<?>, InjectionTarget[]> injectionTargetMap, ComponentNameSpaceConfiguration compNSConfig) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processInjectionMetaData (targets)", (Object[])new Object[0]);
        }
        InjectionProcessorContextImpl context = this.createInjectionProcessorContext();
        context.ivBindNonCompInjectionBindings = compNSConfig.isClientContainer() && compNSConfig.getClassLoader() != null;
        compNSConfig.setInjectionProcessorContext(context);
        this.processInjectionMetaData(compNSConfig, null);
        List<Class<?>> injectionClasses = compNSConfig.getInjectionClasses();
        if (injectionClasses != null && !injectionClasses.isEmpty()) {
            Map<Class<?>, List<InjectionTarget>> declaredTargets = this.getDeclaredInjectionTargets(context.ivProcessedInjectionBindings);
            boolean checkAppConfig = compNSConfig.isCheckApplicationConfiguration();
            for (Class<?> injectionClass : injectionClasses) {
                InjectionTarget[] injectionTargets = this.getInjectionTargets(declaredTargets, injectionClass, checkAppConfig);
                injectionTargetMap.put(injectionClass, injectionTargets);
            }
        }
        context.metadataProcessingComplete();
        this.notifyInjectionMetaDataListeners(null, compNSConfig);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("processInjectionMetaData: " + injectionTargetMap));
        }
    }

    protected void processInjectionMetaData(ComponentNameSpaceConfiguration compNSConfig, List<Class<?>> annotatedClasses) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("processInjectionMetaData: " + compNSConfig.toDumpString()), (Object[])new Object[0]);
        }
        if (compNSConfig.getIndirectJndiLookupReferenceFactory() == null) {
            compNSConfig.setIndirectJndiLookupReferenceFactory(this.getDefaultIndirectJndiLookupReferenceFactory());
        }
        if (compNSConfig.getResIndirectJndiLookupReferenceFactory() == null) {
            compNSConfig.setResIndirectJndiLookupReferenceFactory(this.getDefaultResIndirectJndiLookupReferenceFactory());
        }
        if (compNSConfig.getResRefReferenceFactory() == null) {
            compNSConfig.setResRefReferenceFactory(this.getDefaultResRefReferenceFactory());
        }
        if (compNSConfig.getResAutoLinkReferenceFactory() == null) {
            compNSConfig.setResAutoLinkReferenceFactory(this.getDefaultResAutoLinkReferenceFactory());
        }
        if (compNSConfig.getEJBLinkReferenceFactory() == null) {
            compNSConfig.setEJBLinkReferenceFactory(this.getDefaultEJBLinkReferenceFactory());
        }
        if (compNSConfig.getMBLinkReferenceFactory() == null) {
            compNSConfig.setMBLinkReferenceFactory(compNSConfig.isClientContainer() ? DEFAULT_MBLinkRefFactory : this.ivMBLinkRefFactory);
        }
        InjectionProcessorContextImpl context = InjectionProcessorContextImpl.get(compNSConfig);
        context.ivJavaNameSpaceContext = compNSConfig.getJavaColonContext();
        ArrayList providers = new ArrayList(this.ivProcessorProviders.values());
        InjectionProcessorManager processorManager = new InjectionProcessorManager(this, compNSConfig, context, providers);
        processorManager.processXML();
        if (annotatedClasses == null) {
            if (!compNSConfig.isMetaDataComplete()) {
                annotatedClasses = compNSConfig.getInjectionClasses();
            }
            if (annotatedClasses == null) {
                annotatedClasses = Collections.emptyList();
            }
        }
        if (!annotatedClasses.isEmpty()) {
            ClassLoader loader = compNSConfig.getClassLoader();
            if (loader != null) {
                this.checkAnnotationClasses(loader);
            }
            for (Class<Object> annotatedClass : annotatedClasses) {
                processorManager.processAnnotations(annotatedClass);
            }
        }
        processorManager.processBindings();
        if (compNSConfig.getOwningFlow() == ComponentNameSpaceConfiguration.ReferenceFlowKind.CLIENT && compNSConfig.getClassLoader() == null) {
            this.processClientInjections(compNSConfig, context);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processInjectionMetaData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAnnotationClasses(ClassLoader loader) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("checkAnnotationClasses: " + loader), (Object[])new Object[0]);
        }
        if (this.ivCheckedAnnotationClassLoaders.add(loader)) {
            for (Class<?> processorClass : this.ivProcessorProviders.keySet()) {
                Class<?> loaderClass;
                String className = processorClass.getName();
                try {
                    loaderClass = loader.loadClass(className);
                }
                catch (ClassNotFoundException ex) {
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("ignoring " + className + " : " + ex), (Object[])new Object[0]);
                    continue;
                }
                if (loaderClass == processorClass) continue;
                Set<String> warnedAnnotations = null;
                ClassLoader loaderClassLoader = loaderClass.getClassLoader();
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("loaded " + loaderClass + " from application class loader " + loaderClassLoader), (Object[])new Object[0]);
                }
                AbstractInjectionEngine abstractInjectionEngine = this;
                synchronized (abstractInjectionEngine) {
                    if (this.ivWarnedClassLoaderAnnotations == null) {
                        this.ivWarnedClassLoaderAnnotations = new WeakHashMap<ClassLoader, Set<String>>();
                    }
                    if ((warnedAnnotations = this.ivWarnedClassLoaderAnnotations.get(loaderClassLoader)) == null) {
                        warnedAnnotations = Collections.synchronizedSet(new HashSet());
                        this.ivWarnedClassLoaderAnnotations.put(loaderClassLoader, warnedAnnotations);
                    }
                }
                if (warnedAnnotations != null && !warnedAnnotations.add(className)) continue;
                CodeSource codeSource = loaderClass.getProtectionDomain().getCodeSource();
                String codeSourceLocation = codeSource == null ? null : String.valueOf(codeSource.getLocation());
                Tr.warning((TraceComponent)tc, (String)"INCOMPATIBLE_ANNOTATION_CLASS_CWNEN0070W", (Object[])new Object[]{className, codeSourceLocation});
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAnnotationClasses");
        }
    }

    protected abstract void processClientInjections(ComponentNameSpaceConfiguration var1, InjectionProcessorContextImpl var2) throws InjectionException;

    Map<Class<?>, List<InjectionTarget>> getDeclaredInjectionTargets(List<InjectionBinding<?>> resolvedInjectionBindings) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDeclaredInjectionTargets", (Object[])new Object[0]);
        }
        HashMap declaredTargets = new HashMap();
        for (InjectionBinding<?> injectionBinding : resolvedInjectionBindings) {
            List<InjectionTarget> injectionTargets;
            if (!injectionBinding.isResolved()) {
                if (!isTraceOn || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("skipping unresolved " + injectionBinding), (Object[])new Object[0]);
                continue;
            }
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("adding targets for " + Util.identity(injectionBinding) + '[' + injectionBinding.getDisplayName() + ']'), (Object[])new Object[0]);
            }
            if ((injectionTargets = InjectionProcessorContextImpl.getInjectionTargets(injectionBinding)) == null) continue;
            for (InjectionTarget target : injectionTargets) {
                ArrayList<InjectionTarget> classTargets;
                Member member = target.getMember();
                Class<?> memberClass = member.getDeclaringClass();
                if (isTraceOn && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("adding " + member), (Object[])new Object[0]);
                }
                if ((classTargets = (ArrayList<InjectionTarget>)declaredTargets.get(memberClass)) == null) {
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("creating list for " + memberClass + "/" + AccessController.doPrivileged(new GetClassLoaderPrivileged(memberClass))), (Object[])new Object[0]);
                    }
                    classTargets = new ArrayList<InjectionTarget>();
                    declaredTargets.put(memberClass, classTargets);
                }
                classTargets.add(target);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDeclaredInjectionTargets");
        }
        return declaredTargets;
    }

    InjectionTarget[] getInjectionTargets(Map<Class<?>, List<InjectionTarget>> declaredTargets, Class<?> instanceClass, boolean checkAppConfig) throws InjectionException {
        InjectionTarget[] result;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInjectionTargets: " + instanceClass + "/" + AccessController.doPrivileged(new GetClassLoaderPrivileged(instanceClass))), (Object[])new Object[0]);
        }
        LinkedHashMap<Member, InjectionTarget> injectionTargets = null;
        HashSet<Method> nonPrivateMethods = null;
        ArrayList classHierarchy = new ArrayList();
        for (Class<?> superclass = instanceClass; superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
            classHierarchy.add(superclass);
        }
        Collections.reverse(classHierarchy);
        for (int memberRound = 0; memberRound < 2; ++memberRound) {
            boolean wantFields;
            boolean bl = wantFields = memberRound == 0;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(wantFields ? "collecting fields" : "collecting methods"), (Object[])new Object[0]);
            }
            for (Class clazz : classHierarchy) {
                List<InjectionTarget> classTargets = declaredTargets.get(clazz);
                if (classTargets == null) {
                    if (!isTraceOn || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("no members for " + clazz + "/" + AccessController.doPrivileged(new GetClassLoaderPrivileged(clazz))), (Object[])new Object[0]);
                    continue;
                }
                for (InjectionTarget injectionTarget : classTargets) {
                    InjectionTarget previousTarget;
                    Member member = injectionTarget.getMember();
                    boolean isField = member instanceof Field;
                    if (wantFields != isField) continue;
                    if (!isField && !Modifier.isPrivate(member.getModifiers()) && member.getDeclaringClass() != instanceClass) {
                        if (nonPrivateMethods == null) {
                            nonPrivateMethods = new HashSet<Method>();
                            for (MethodMap.MethodInfo methodInfo : MethodMap.getAllNonPrivateMethods(instanceClass)) {
                                nonPrivateMethods.add(methodInfo.getMethod());
                            }
                        }
                        if (!nonPrivateMethods.contains(member)) {
                            if (!isTraceOn || !tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("skipping overridden " + member + " for " + Util.identity(injectionTarget.getInjectionBinding()) + '[' + injectionTarget.getInjectionBinding().getDisplayName() + ']'), (Object[])new Object[0]);
                            continue;
                        }
                    }
                    if (injectionTargets == null) {
                        injectionTargets = new LinkedHashMap<Member, InjectionTarget>();
                    }
                    if (isTraceOn && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding " + member + " for " + Util.identity(injectionTarget.getInjectionBinding()) + '[' + injectionTarget.getInjectionBinding().getDisplayName() + ']'), (Object[])new Object[0]);
                    }
                    if ((previousTarget = injectionTargets.put(member, injectionTarget)) == null) continue;
                    String memberName = member.getDeclaringClass().getName() + "." + member.getName();
                    Tr.warning((TraceComponent)tc, (String)"DUPLICATE_INJECTION_TARGETS_SPECIFIED_CWNEN0040W", (Object[])new Object[]{memberName});
                    if (!this.isValidationFailable(checkAppConfig)) continue;
                    memberName = memberName + (isField ? " field" : " method");
                    String curRefName = injectionTarget.getInjectionBinding().getDisplayName();
                    String preRefName = previousTarget.getInjectionBinding().getDisplayName();
                    throw new InjectionConfigurationException("The " + memberName + " was configured to be injected multiple times. The same injection target is associated with both the " + curRefName + " and " + preRefName + " references. The object injected is undefined.");
                }
            }
        }
        if (injectionTargets == null) {
            result = EMPTY_INJECTION_TARGETS;
        } else {
            result = new InjectionTarget[injectionTargets.size()];
            injectionTargets.values().toArray(result);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInjectionTargets: " + result.length));
        }
        return result;
    }

    @Override
    public void inject(Object objectToInject, InjectionTarget injectionTarget) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inject", (Object[])new Object[]{objectToInject, injectionTarget});
        }
        injectionTarget.inject(objectToInject, null);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"inject");
        }
    }

    @Override
    public void inject(Object objectToInject, InjectionTarget target, InjectionTargetContext targetContext) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("inject (" + Util.identity((Object)objectToInject) + ", " + target + ", " + targetContext + ")"), (Object[])new Object[0]);
        }
        target.inject(objectToInject, targetContext);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"inject");
        }
    }

    @Override
    public void notifyInjectionMetaDataListeners(ReferenceContext referenceContext, ComponentNameSpaceConfiguration compNSpaceConfiguration) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyInjectionMetaDataListeners", (Object[])new Object[0]);
        }
        InjectionMetaDataImpl injectionMetaData = new InjectionMetaDataImpl(this, compNSpaceConfiguration, referenceContext);
        for (InjectionMetaDataListener metaDataListener : this.metaDataListeners) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invoking InjectionMetaDataListener: " + metaDataListener), (Object[])new Object[0]);
            }
            metaDataListener.injectionMetaDataCreated(injectionMetaData);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyInjectionMetaDataListeners");
        }
    }

    @Override
    public void registerInjectionMetaDataListener(InjectionMetaDataListener metaDataListener) {
        if (metaDataListener == null) {
            throw new IllegalArgumentException("A null InjectionMetaDataListener cannot be registered with the injection engine.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerInjectionMetaDataListener", (Object[])new Object[]{metaDataListener.getClass().getName()});
        }
        this.metaDataListeners.add(metaDataListener);
    }

    @Override
    public void unregisterInjectionMetaDataListener(InjectionMetaDataListener metaDataListener) {
        if (metaDataListener == null) {
            throw new IllegalArgumentException("A null InjectionMetaDataListener cannot be unregistered from the injection engine.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unregisterInjectionMetaDataListener", (Object[])new Object[]{metaDataListener.getClass().getName()});
        }
        this.metaDataListeners.remove(metaDataListener);
    }

    @Override
    public void registerObjectFactory(Class<? extends Annotation> annotation, Class<?> type, Class<? extends ObjectFactory> objectFactory, boolean allowOverride) throws InjectionException {
        this.registerObjectFactory(annotation, type, objectFactory, allowOverride, null, true);
    }

    @Override
    public void registerObjectFactory(Class<? extends Annotation> annotation, Class<?> type, Class<? extends ObjectFactory> objectFactory, boolean allowOverride, Set<String> allowedAttributes, boolean refAddrNeeded) throws InjectionException {
        this.registerObjectFactoryInfo(new ObjectFactoryInfoImpl(annotation, type, objectFactory, allowOverride, allowedAttributes, refAddrNeeded));
    }

    @Override
    public void registerObjectFactoryInfo(ObjectFactoryInfo info) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("registerObjectFactoryInfo: " + info.getAnnotationClass() + " : " + info.getType() + " (override=" + info.isOverrideAllowed() + ") = " + info), (Object[])new Object[0]);
        }
        this.updateObjectFactoryInfo(info, true);
    }

    @Override
    public void unregisterObjectFactoryInfo(ObjectFactoryInfo info) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unregisterObjectFactoryInfo: " + info.getAnnotationClass() + " : " + info.getType() + " (override=" + info.isOverrideAllowed() + ") = " + info), (Object[])new Object[0]);
        }
        this.updateObjectFactoryInfo(info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObjectFactoryInfo(ObjectFactoryInfo info, boolean register) throws InjectionException {
        if (!this.ivIsInitialized) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_ENGINE_SERVICE_NOT_INITIALIZED_CWNEN0006E", (Object[])new Object[0]);
            throw new InjectionException("injection engine is not initialized");
        }
        Class<? extends Annotation> annotation = info.getAnnotationClass();
        Class<?> type = info.getType();
        Class<? extends ObjectFactory> objectFactory = info.getObjectFactoryClass();
        if (annotation == null || type == null || objectFactory == null) {
            throw new IllegalArgumentException("Null arguments are not allowed: " + annotation + ", " + type + ", " + objectFactory);
        }
        boolean allowOverride = info.isOverrideAllowed();
        AbstractInjectionEngine abstractInjectionEngine = this;
        synchronized (abstractInjectionEngine) {
            Map<Class<?>, ObjectFactoryInfo> factories;
            boolean copyOnWrite;
            Map<Class<Annotation>, Map<Class<?>, ObjectFactoryInfo>> objectFactoryMap = allowOverride ? this.ivObjectFactoryMap : this.ivNoOverrideObjectFactoryMap;
            boolean bl = copyOnWrite = allowOverride ? this.ivObjectFactoryMapCopyOnWrite : this.ivNoOverrideObjectFactoryMapCopyOnWrite;
            if (copyOnWrite) {
                HashMap newMap = new HashMap();
                for (Map.Entry<Class<Annotation>, Map<Class<?>, ObjectFactoryInfo>> entry : objectFactoryMap.entrySet()) {
                    newMap.put(entry.getKey(), new HashMap(entry.getValue()));
                }
                objectFactoryMap = newMap;
            }
            if ((factories = objectFactoryMap.get(annotation)) == null) {
                if (!register) {
                    throw new InjectionException("Object factory " + objectFactory.getName() + " not registered for the " + annotation.getName() + " annotation and the " + type.getName() + " type.");
                }
                if (!this.ivProcessorProviders.containsKey(annotation)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registerObjectFactory: An injection processor does not exist for the specified annotation: " + annotation.getName()), (Object[])new Object[0]);
                    }
                    throw new InjectionException("An injection processor does not exist for the specified annotation: " + annotation.getName());
                }
                factories = new HashMap();
                objectFactoryMap.put(annotation, factories);
            }
            if (register) {
                factories.put(type, info);
            } else {
                if (factories.get(type) != info) {
                    throw new InjectionException("Object factory " + objectFactory.getName() + " not registered for the " + annotation.getName() + " annotation and the " + type.getName() + " type.");
                }
                factories.remove(type);
            }
            if (copyOnWrite) {
                if (allowOverride) {
                    this.ivObjectFactoryMap = objectFactoryMap;
                    this.ivObjectFactoryMapCopyOnWrite = false;
                } else {
                    this.ivNoOverrideObjectFactoryMap = objectFactoryMap;
                    this.ivNoOverrideObjectFactoryMapCopyOnWrite = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Annotation> void registerOverrideReferenceFactory(Class<A> annotation, OverrideReferenceFactory<A> factory) throws InjectionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"registerOverrideReferenceFactory", (Object[])new Object[]{annotation, factory});
        }
        if (annotation == null || factory == null) {
            throw new IllegalArgumentException("Null arguments are not allowed: " + annotation + ", " + factory);
        }
        AbstractInjectionEngine abstractInjectionEngine = this;
        synchronized (abstractInjectionEngine) {
            OverrideReferenceFactory<?>[] factories;
            HashMap<Class<Annotation>, Object> map = this.ivOverrideReferenceFactoryMap;
            if (this.ivOverrideReferenceFactoryMapCopyOnWrite) {
                HashMap<Class<? extends Annotation>, OverrideReferenceFactory[]> newMap = new HashMap<Class<? extends Annotation>, OverrideReferenceFactory[]>();
                for (Map.Entry<Class<? extends Annotation>, OverrideReferenceFactory<?>[]> entry : map.entrySet()) {
                    OverrideReferenceFactory<?>[] value = entry.getValue();
                    OverrideReferenceFactory[] newValue = new OverrideReferenceFactory[value.length];
                    System.arraycopy(value, 0, newValue, 0, value.length);
                    newMap.put(entry.getKey(), newValue);
                }
                map = newMap;
            }
            if ((factories = map.get(annotation)) == null) {
                if (!this.ivProcessorProviders.containsKey(annotation)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("registerOverrideReferenceFactory: An injection processor does not exist for the specified annotation: " + annotation.getName()), (Object[])new Object[0]);
                    }
                    throw new InjectionException("An injection processor does not exist for the specified annotation: " + annotation.getName());
                }
                factories = new OverrideReferenceFactory[]{factory};
                map.put(annotation, factories);
            } else {
                OverrideReferenceFactory[] newFactories = new OverrideReferenceFactory[factories.length + 1];
                System.arraycopy(factories, 0, newFactories, 0, factories.length);
                newFactories[factories.length] = factory;
                map.put(annotation, newFactories);
            }
            if (this.ivOverrideReferenceFactoryMapCopyOnWrite) {
                this.ivOverrideReferenceFactoryMap = map;
                this.ivOverrideReferenceFactoryMapCopyOnWrite = false;
            }
        }
    }

    @Override
    public synchronized <A extends Annotation> OverrideReferenceFactory<A>[] getOverrideReferenceFactories(Class<A> klass) {
        this.ivOverrideReferenceFactoryMapCopyOnWrite = true;
        return this.ivOverrideReferenceFactoryMap.get(klass);
    }

    @Override
    public ObjectFactory getObjectFactory(String objectFactoryClassName, Class<? extends ObjectFactory> objectFactoryClass) throws InjectionException {
        try {
            if (objectFactoryClass == null) {
                ClassLoader classLoader = svThreadContextAccessor.getContextClassLoaderForUnprivileged(Thread.currentThread());
                objectFactoryClass = classLoader.loadClass(objectFactoryClassName).asSubclass(ObjectFactory.class);
            }
            return objectFactoryClass.newInstance();
        }
        catch (Throwable ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getInjectionObjectInstance", (Object[])new Object[]{ex});
            }
            Tr.error((TraceComponent)tc, (String)"OBJECT_FACTORY_CLASS_FAILED_TO_LOAD_CWNEN0024E", (Object[])new Object[]{objectFactoryClassName});
            throw new InjectionException(ex.toString(), ex);
        }
    }

    @Override
    public MBLinkReferenceFactory registerManagedBeanReferenceFactory(MBLinkReferenceFactory mbLinkRefFactory) {
        MBLinkReferenceFactory rtnFactory = DEFAULT_MBLinkRefFactory;
        this.ivMBLinkRefFactory = mbLinkRefFactory;
        return rtnFactory;
    }

    @Override
    public ReferenceContext createReferenceContext() {
        return new ReferenceContextImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatTo(IncidentStream is) {
        is.writeLine("", "");
        is.writeLine("", "*** Start InjectionEngine Dump    ---> " + Util.identity((Object)this));
        is.writeLine("", "");
        is.writeLine("", "   Default Factories : ");
        is.writeLine("", "      Indirect    = " + Util.identity((Object)this.getDefaultIndirectJndiLookupReferenceFactory()));
        is.writeLine("", "      ResIndirect = " + Util.identity((Object)this.getDefaultResIndirectJndiLookupReferenceFactory()));
        is.writeLine("", "      ResRef      = " + Util.identity((Object)this.getDefaultResRefReferenceFactory()));
        is.writeLine("", "      ResAuto     = " + Util.identity((Object)this.getDefaultResAutoLinkReferenceFactory()));
        is.writeLine("", "      EJBLink     = " + Util.identity((Object)this.getDefaultEJBLinkReferenceFactory()));
        is.writeLine("", "      MBLink      = " + Util.identity((Object)DEFAULT_MBLinkRefFactory));
        is.writeLine("", "");
        is.writeLine("", "   Actual Factories : ");
        is.writeLine("", "      " + Util.identity((Object)this.ivMBLinkRefFactory));
        is.writeLine("", "");
        is.writeLine("", "   Registered Processors : ");
        for (Map.Entry<Class<?>, InjectionProcessorProvider<?, ?>> entry : this.ivProcessorProviders.entrySet()) {
            is.writeLine("", "      " + entry.getKey().getName() + " : " + entry.getValue());
        }
        Iterator<InjectionMetaDataListener> iterator = this;
        synchronized (iterator) {
            Map<Class<?>, ObjectFactoryInfo> factories;
            is.writeLine("", "");
            is.writeLine("", "   Registered Object Factories : ");
            for (Map.Entry<Class<Annotation>, Map<Class<?>, ObjectFactoryInfo>> entry : this.ivObjectFactoryMap.entrySet()) {
                is.writeLine("", "      " + entry.getKey().getName());
                factories = entry.getValue();
                for (Map.Entry<Class<?>, ObjectFactoryInfo> entry2 : factories.entrySet()) {
                    is.writeLine("", "         " + entry2.getKey().getName() + " : " + entry2.getValue());
                }
            }
            is.writeLine("", "");
            is.writeLine("", "   Registered No-Override Object Factories : ");
            for (Map.Entry<Class<Annotation>, Map<Class<?>, ObjectFactoryInfo>> entry : this.ivNoOverrideObjectFactoryMap.entrySet()) {
                is.writeLine("", "      " + entry.getKey().getName());
                factories = entry.getValue();
                for (Map.Entry<Class<?>, ObjectFactoryInfo> entry3 : factories.entrySet()) {
                    is.writeLine("", "         " + entry3.getKey().getName() + " : " + entry3.getValue());
                }
            }
            is.writeLine("", "");
            is.writeLine("", "   Registered Override Reference Factories : ");
            for (Map.Entry<Class<? extends Annotation>, OverrideReferenceFactory<?>[]> entry : this.ivOverrideReferenceFactoryMap.entrySet()) {
                is.writeLine("", "      " + entry.getKey().getName());
                for (OverrideReferenceFactory<?> factory : entry.getValue()) {
                    is.writeLine("", "         " + Util.identity(factory));
                }
            }
        }
        is.writeLine("", "");
        is.writeLine("", "   Registered MetaDataListeners : ");
        for (InjectionMetaDataListener injectionMetaDataListener : this.metaDataListeners) {
            is.writeLine("", "      " + Util.identity((Object)injectionMetaDataListener));
        }
        is.writeLine("", "");
        is.writeLine("", "   isEmbeddable    : " + this.isEmbeddable());
        is.writeLine("", "");
        is.writeLine("", "*** InjectionEngine Dump Complete ***");
        is.writeLine("", "");
    }
}

