/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.RuntimeMetaDataProvider;
import com.ibm.tx.jta.config.DefaultConfigurationProvider;
import com.ibm.tx.jta.embeddable.TransactionSettingsProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transaction.services.LibertyRuntimeMetaDataProvider;
import com.ibm.ws.transaction.services.TransactionManagerService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.resource.ResourceFactory;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JTMConfigurationProvider
extends DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final TraceComponent tc = Tr.register(JTMConfigurationProvider.class);
    private WsLocationAdmin locationService;
    private RuntimeMetaDataProvider _runtimeMetaDataProvider;
    private static Dictionary<String, Object> _props;
    ComponentContext _cc;
    private static String logDir;
    private static final String defaultLogDir = "$(server.output.dir)/tranlog";
    private final ConcurrentServiceReferenceSet<TransactionSettingsProvider> _transactionSettingsProviders = new ConcurrentServiceReferenceSet("transactionSettingsProvider");
    private static final AtomicServiceReference<ResourceFactory> dataSourceFactoryRef;
    private static boolean _isSQLRecoveryLog;
    private ResourceFactory theDataSourceFactory = null;
    private String _recoveryIdentity = null;
    private String _recoveryGroup = null;
    private TransactionManagerService tmsRef = null;
    private byte[] _applId;
    static final long serialVersionUID = -1973730376829975847L;

    protected void activate(ComponentContext cc) {
        this._runtimeMetaDataProvider = new LibertyRuntimeMetaDataProvider(this);
        this._transactionSettingsProviders.activate(cc);
        this._cc = cc;
        _props = this._cc.getProperties();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activate  properties set to " + _props), (Object[])new Object[0]);
        }
        this.checkDataSourceRef();
        if (_isSQLRecoveryLog) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"activate  working with Tran Log in an RDBMS", (Object[])new Object[0]);
            }
            ServiceReference serviceRef = dataSourceFactoryRef.getReference();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("activate  datasourceFactory ref " + dataSourceFactoryRef + ", underlying reference: " + serviceRef), (Object[])new Object[0]);
            }
            dataSourceFactoryRef.activate(this._cc);
            if (serviceRef != null) {
                this.theDataSourceFactory = this.getDataSourceFactory();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("retrieved datasourceFactory " + this.theDataSourceFactory), (Object[])new Object[0]);
                }
                if (this.theDataSourceFactory != null && this.tmsRef != null) {
                    this.tmsRef.doStartup(this, this.theDataSourceFactory, _isSQLRecoveryLog);
                }
            }
        } else {
            this.getTransactionLogDirectory();
            if (this.tmsRef != null) {
                this.tmsRef.doStartup(this, this.theDataSourceFactory, _isSQLRecoveryLog);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activate  retrieved datasourceFactory is " + this.theDataSourceFactory), (Object[])new Object[0]);
        }
    }

    protected void deactivate(int reason, ComponentContext cc, Map<String, Object> properties) {
        this._transactionSettingsProviders.deactivate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
        }
    }

    protected void modified(Map<?, ?> newProperties) {
        _props = newProperties instanceof Dictionary ? (Dictionary<Object, Object>)((Object)newProperties) : new Hashtable(newProperties);
    }

    protected synchronized void setLocationService(WsLocationAdmin locSvc) {
        this.locationService = locSvc;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLocationService, locSvc " + locSvc), (Object[])new Object[0]);
        }
    }

    protected synchronized void unsetLocationService(WsLocationAdmin locSvc) {
        if (locSvc == this.locationService) {
            this.locationService = null;
        }
    }

    protected void setDataSourceFactory(ServiceReference<ResourceFactory> ref) {
        dataSourceFactoryRef.setReference(ref);
        if (this._cc != null) {
            this.theDataSourceFactory = (ResourceFactory)dataSourceFactoryRef.getServiceWithException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setDataSourceFactory to " + this.theDataSourceFactory), (Object[])new Object[0]);
            }
            if (this.tmsRef != null) {
                this.tmsRef.doStartup(this, this.theDataSourceFactory, _isSQLRecoveryLog);
            }
        }
    }

    protected void unsetDataSourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetDataSourceFactory, ref " + ref), (Object[])new Object[0]);
        }
        if (this.tmsRef != null) {
            this.tmsRef.doShutdown(_isSQLRecoveryLog);
        }
        dataSourceFactoryRef.unsetReference(ref);
    }

    public ConcurrentServiceReferenceSet<TransactionSettingsProvider> getTransactionSettingsProviders() {
        return this._transactionSettingsProviders;
    }

    protected void setTransactionSettingsProvider(ServiceReference<TransactionSettingsProvider> ref) {
        this._transactionSettingsProviders.addReference(ref);
    }

    protected void unsetTransactionSettingsProvider(ServiceReference<TransactionSettingsProvider> ref) {
        this._transactionSettingsProviders.removeReference(ref);
    }

    public int getClientInactivityTimeout() {
        Number num = (Number)_props.get("clientInactivityTimeout");
        return num.intValue();
    }

    public int getHeuristicRetryInterval() {
        Number num = (Number)_props.get("heuristicRetryInterval");
        return num.intValue();
    }

    public int getHeuristicRetryLimit() {
        return (Integer)_props.get("heuristicRetryWait");
    }

    public int getMaximumTransactionTimeout() {
        Number num = (Number)_props.get("propogatedOrBMTTranLifetimeTimeout");
        return num.intValue();
    }

    public int getTotalTransactionLifetimeTimeout() {
        Number num = (Number)_props.get("totalTranLifetimeTimeout");
        return num.intValue();
    }

    public Level getTraceLevel() {
        return tc.getLoggerLevel();
    }

    public String getTransactionLogDirectory() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTransactionLogDirectory working with " + logDir), (Object[])new Object[0]);
        }
        if (logDir == null) {
            logDir = this.parseTransactionLogDirectory();
        }
        return logDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServerName() {
        String serverName = "";
        JTMConfigurationProvider jTMConfigurationProvider = this;
        synchronized (jTMConfigurationProvider) {
            if (this.locationService != null) {
                serverName = this.locationService.getServerName();
            }
        }
        return serverName;
    }

    public String getHeuristicCompletionDirectionAsString() {
        return (String)_props.get("lpsHeuristicCompletion");
    }

    public int getHeuristicCompletionDirection() {
        String hcd = this.getHeuristicCompletionDirectionAsString();
        if ("COMMIT".equalsIgnoreCase(hcd)) {
            return 0;
        }
        if ("MANUAL".equalsIgnoreCase(hcd)) {
            return 2;
        }
        return 1;
    }

    public int getTransactionLogSize() {
        return (Integer)_props.get("transactionLogSize");
    }

    public int getDefaultMaximumShutdownDelay() {
        Number num = (Number)_props.get("defaultMaxShutdownDelay");
        return num.intValue();
    }

    public boolean isLoggingForHeuristicReportingEnabled() {
        return (Boolean)_props.get("enableLoggingForHeuristicReporting");
    }

    public static void setTotalTransactionLifetimeTimeout(int timeout) {
        _props.put("propogatedOrBMTTranLifetimeTimeout", timeout);
    }

    public boolean isAcceptHeuristicHazard() {
        return (Boolean)_props.get("acceptHeuristicHazard");
    }

    public boolean isRecoverOnStartup() {
        Boolean isRoS = (Boolean)_props.get("recoverOnStartup");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isRecoverOnStartup set to " + isRoS), (Object[])new Object[0]);
        }
        return isRoS;
    }

    public boolean isWaitForRecovery() {
        Boolean isWfR = (Boolean)_props.get("waitForRecovery");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isWaitForRecovery set to " + isWfR), (Object[])new Object[0]);
        }
        return isWfR;
    }

    public ResourceFactory getResourceFactory() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResourceFactory " + this.theDataSourceFactory), (Object[])new Object[0]);
        }
        return this.theDataSourceFactory;
    }

    public RuntimeMetaDataProvider getRuntimeMetaDataProvider() {
        return this._runtimeMetaDataProvider;
    }

    public String getRecoveryIdentity() {
        this._recoveryIdentity = (String)_props.get("recoveryIdentity");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRecoveryIdentity " + this._recoveryIdentity), (Object[])new Object[0]);
        }
        return this._recoveryIdentity;
    }

    public String getRecoveryGroup() {
        this._recoveryGroup = (String)_props.get("recoveryGroup");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRecoveryGroup " + this._recoveryGroup), (Object[])new Object[0]);
        }
        return this._recoveryGroup;
    }

    public void setTMS(TransactionManagerService tms) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTMS " + tms), (Object[])new Object[0]);
        }
        this.tmsRef = tms;
        if (!_isSQLRecoveryLog) {
            if (this._cc != null) {
                this.tmsRef.doStartup(this, this.theDataSourceFactory, _isSQLRecoveryLog);
            }
        } else {
            ServiceReference serviceRef = dataSourceFactoryRef.getReference();
            if (this._cc != null && serviceRef != null) {
                this.theDataSourceFactory = this.getDataSourceFactory();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("retrieved datasourceFactory " + this.theDataSourceFactory), (Object[])new Object[0]);
                }
                if (this.theDataSourceFactory != null) {
                    this.tmsRef.doStartup(this, this.theDataSourceFactory, _isSQLRecoveryLog);
                }
            }
        }
    }

    public boolean isSQLRecoveryLog() {
        return _isSQLRecoveryLog;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    private ResourceFactory getDataSourceFactory() {
        ResourceFactory dataSourceFactory;
        block3: {
            dataSourceFactory = null;
            try {
                if (dataSourceFactoryRef != null) {
                    dataSourceFactory = (ResourceFactory)dataSourceFactoryRef.getServiceWithException();
                }
            }
            catch (IllegalStateException iex) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Caught IllegalStateException, could not get the service, " + iex), (Object[])new Object[0]);
            }
        }
        return dataSourceFactory;
    }

    private void checkDataSourceRef() {
        Object configuredDSR = _props.get("dataSourceRef");
        if (configuredDSR == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dataSourceRef is not specified, log to filesys", (Object[])new Object[0]);
            }
            _isSQLRecoveryLog = false;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dataSourceRef is specified, log to RDBMS", (Object[])new Object[0]);
            }
            String suffixStr = (String)_props.get("transactionLogDBTableSuffix");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("suffixStr is " + suffixStr + ", of length " + suffixStr.length()), (Object[])new Object[0]);
            }
            if (suffixStr != null && !suffixStr.trim().isEmpty()) {
                suffixStr = suffixStr.trim();
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty,tablesuffix=" + suffixStr;
            } else {
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"logDir now set to ", (Object[])new Object[]{logDir});
            }
            _isSQLRecoveryLog = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String parseTransactionLogDirectory() {
        String configuredLogDir;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseTransactionLogDirectory working with " + _props), (Object[])new Object[0]);
        }
        if ((configuredLogDir = (String)_props.get("transactionLogDirectory")) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"using default log dir as config is null", (Object[])new Object[0]);
            }
            configuredLogDir = defaultLogDir;
        } else if (!configuredLogDir.endsWith("/")) {
            configuredLogDir = configuredLogDir + "/";
        }
        WsResource logDirResource = null;
        try {
            JTMConfigurationProvider jTMConfigurationProvider = this;
            synchronized (jTMConfigurationProvider) {
                logDirResource = this.locationService.resolveResource(configuredLogDir);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void e;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"532", (Object)((Object)this), (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("IllegalArgumentException from location service for dir string: " + configuredLogDir), (Object[])new Object[0]);
            }
            if (!configuredLogDir.equals(defaultLogDir)) {
                configuredLogDir = defaultLogDir;
                try {
                    JTMConfigurationProvider jTMConfigurationProvider = this;
                    synchronized (jTMConfigurationProvider) {
                        logDirResource = this.locationService.resolveResource(configuredLogDir);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    FFDCFilter.processException((Throwable)illegalArgumentException2, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"543", (Object)((Object)this), (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void ex;
                        Tr.debug((TraceComponent)tc, (String)("Secondary IllegalArgumentException " + ex + " from location service for dir string: " + configuredLogDir), (Object[])new Object[0]);
                    }
                    throw e;
                }
            }
            throw e;
        }
        logDir = logDirResource.toExternalURI().getPath();
        return logDir;
    }

    public void setApplId(byte[] name) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setApplId - " + Arrays.toString(name)), (Object[])new Object[0]);
        }
        this._applId = (byte[])name.clone();
    }

    public byte[] getApplId() {
        byte[] result = this._applId;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getApplId - " + Arrays.toString(result)), (Object[])new Object[0]);
        }
        return result;
    }

    public void shutDownFramework() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JTMConfigurationProvider shutDownFramework has been called", (Object[])new Object[0]);
        }
        if (this.tmsRef != null) {
            this.tmsRef.shutDownFramework();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        logDir = null;
        dataSourceFactoryRef = new AtomicServiceReference("dataSourceFactory");
        _isSQLRecoveryLog = false;
    }
}

