/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.kernel.service.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AtomicServiceReference<T> {
    private final String referenceName;
    private final AtomicReference<ReferenceTuple<T>> tuple = new AtomicReference<ReferenceTuple<Object>>(new ReferenceTuple<Object>(null, null, null));
    static final long serialVersionUID = 2226592364007985000L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AtomicServiceReference(String name) {
        this.referenceName = name;
    }

    public void activate(ComponentContext context) {
        ReferenceTuple<T> previous = null;
        ReferenceTuple<Object> newTuple = null;
        while (!this.tuple.compareAndSet(previous = this.tuple.get(), newTuple = new ReferenceTuple<Object>(context, previous.serviceRef, null))) {
        }
    }

    public void deactivate(ComponentContext context) {
        ReferenceTuple<T> previous = null;
        ReferenceTuple<Object> newTuple = null;
        while (!this.tuple.compareAndSet(previous = this.tuple.get(), newTuple = new ReferenceTuple<Object>(null, previous.serviceRef, null))) {
        }
    }

    public boolean setReference(ServiceReference<T> reference) {
        ReferenceTuple<T> previous = null;
        ReferenceTuple<Object> newTuple = null;
        do {
            previous = this.tuple.get();
        } while (reference != previous.serviceRef && !this.tuple.compareAndSet(previous, newTuple = new ReferenceTuple<Object>(previous.context, reference, null)));
        return previous.serviceRef != null;
    }

    public boolean unsetReference(ServiceReference<T> reference) {
        ReferenceTuple<T> previous = null;
        ReferenceTuple<Object> newTuple = null;
        do {
            previous = this.tuple.get();
        } while (reference == previous.serviceRef && !this.tuple.compareAndSet(previous, newTuple = new ReferenceTuple<Object>(previous.context, null, null)));
        return newTuple != null;
    }

    public ServiceReference<T> getReference() {
        ReferenceTuple<T> current = this.tuple.get();
        return current != null ? current.serviceRef : null;
    }

    public T getService() {
        return this.getService(false);
    }

    public T getServiceWithException() {
        return this.getService(true);
    }

    private T getService(boolean throwException) {
        Object svc = null;
        ReferenceTuple<T> current = null;
        ReferenceTuple<Object> newTuple = null;
        do {
            current = this.tuple.get();
            svc = current.locatedService;
            if (svc != null) break;
            if (current.context == null || current.serviceRef == null) {
                if (!throwException) break;
                throw new IllegalStateException("Required attribute is null," + this.toString());
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                final ReferenceTuple<T> finalCurrent = current;
                svc = AccessController.doPrivileged(new PrivilegedAction<T>(){
                    static final long serialVersionUID = 7705853691155443968L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public T run() {
                        return finalCurrent.context.locateService(AtomicServiceReference.this.referenceName, finalCurrent.serviceRef);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
            } else {
                svc = current.context.locateService(this.referenceName, current.serviceRef);
            }
            if (svc != null) continue;
            if (!throwException) break;
            throw new IllegalStateException("Located service is null," + this.toString());
        } while (!this.tuple.compareAndSet(current, newTuple = new ReferenceTuple<Object>(current.context, current.serviceRef, svc)));
        return (T)svc;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.referenceName + "," + this.tuple.get() + "]";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(AtomicServiceReference.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ReferenceTuple<T> {
        final ComponentContext context;
        final ServiceReference<T> serviceRef;
        final T locatedService;
        static final long serialVersionUID = 8338589844469292978L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ReferenceTuple(ComponentContext ctx, ServiceReference<T> ref, T svc) {
            this.context = ctx;
            this.serviceRef = ref;
            this.locatedService = svc;
        }

        public String toString() {
            return "ctx=" + this.context + ",ref=" + this.serviceRef + ",svc=" + this.locatedService;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ReferenceTuple.class);
        }
    }
}

