/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton.internal;

import com.ibm.websphere.collective.singleton.ElectorFactory;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collective.singleton.internal.HostSingletonElector;
import com.ibm.ws.collective.singleton.internal.LocalSingletonElector;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.extender.Elector;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ElectorFactory.class, ManagedServiceFactory.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "service.pid=com.ibm.ws.collective.singleton.hostSingleton", "scope=host"})
public class HostElectorFactory
implements ElectorFactory,
ManagedServiceFactory {
    private static final TraceComponent tc = Tr.register(HostElectorFactory.class);
    static final String CFG_KEY_SERVICE_NAME = "name";
    static final String CFG_KEY_ELECTOR_PORT = "port";
    static final String WILDCARD_SERVICE = "*";
    static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    protected ExecutorService executorService;
    private final Map<String, String> pids = new HashMap<String, String>();
    private final Map<Integer, Elector> electors = new HashMap<Integer, Elector>();
    private final Map<String, Integer> ports = new HashMap<String, Integer>();
    static final long serialVersionUID = 3262434455062253703L;

    @Reference(name="executorService", service=ExecutorService.class)
    protected void setExecutorService(ExecutorService svc) {
        this.executorService = svc;
    }

    protected void unsetExecutorService() {
        this.executorService = null;
    }

    public synchronized Elector getElector(String service) {
        Integer port = this.ports.get(service);
        if (port == null) {
            port = this.ports.get(WILDCARD_SERVICE);
        }
        return this.electors.get(port);
    }

    @Activate
    protected synchronized void activate(ComponentContext cc) {
        this.addServiceElector(WILDCARD_SERVICE, 0);
    }

    public void deleted(String pid) {
        this.pids.remove(pid);
    }

    public String getName() {
        return "HostElectorFactory";
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        String name = (String)properties.get(CFG_KEY_SERVICE_NAME);
        int port = (Integer)properties.get(CFG_KEY_ELECTOR_PORT);
        this.validateConfig(name, port);
        this.pids.put(pid, name);
        this.addServiceElector(name, port);
    }

    public synchronized void addServiceElector(String service, int port) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting host singleton service elector port: " + service + "=" + port), (Object[])new Object[0]);
        }
        this.ports.put(service, port);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Creating an elector for port " + port), (Object[])new Object[0]);
        }
        this.electors.put(port, this.createElector(port));
    }

    private void validateConfig(String service, int port) throws ConfigurationException {
        if (service.trim().isEmpty()) {
            throw new ConfigurationException(this.getConfigString(service, port), "name is empty or blank");
        }
        if (port < 0) {
            throw new ConfigurationException(this.getConfigString(service, port), "port number is negative");
        }
        if (port != 0 && this.electors.containsKey(port)) {
            throw new ConfigurationException(this.getConfigString(service, port), "duplicate port defined");
        }
    }

    private String getConfigString(String service, int port) {
        return "hostSingleton name=\"" + service + "\" port=\"" + port + "\"";
    }

    public Elector createElector(int port) {
        Object elector = port == 0 ? new LocalSingletonElector() : new HostSingletonElector(port, this.executorService);
        return elector;
    }
}

