/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.callback.IJobExecutionEndCallbackService;
import com.ibm.jbatch.container.callback.IJobExecutionStartCallbackService;
import com.ibm.jbatch.container.controller.impl.WorkUnitThreadControllerImpl;
import com.ibm.jbatch.container.execution.impl.RuntimePartitionExecution;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.ws.PartitionPlanConfig;
import com.ibm.jbatch.container.ws.PartitionReplyMsg;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import javax.batch.runtime.BatchStatus;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BatchPartitionWorkUnit
extends BatchWorkUnit {
    private PartitionPlanConfig partitionPlanConfig;
    private PartitionReplyQueue partitionReplyQueue;
    static final long serialVersionUID = 2664981398364730622L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BatchPartitionWorkUnit(IBatchKernelService batchKernelService, RuntimePartitionExecution runtimePartitionExecution, PartitionPlanConfig config, List<IJobExecutionStartCallbackService> beforeCallbacks, List<IJobExecutionEndCallbackService> afterCallbacks, PartitionReplyQueue partitionReplyQueue) {
        super(batchKernelService, runtimePartitionExecution, beforeCallbacks, afterCallbacks, true);
        this.partitionReplyQueue = partitionReplyQueue;
        this.partitionPlanConfig = config;
        this.controller = new WorkUnitThreadControllerImpl(runtimePartitionExecution, partitionReplyQueue);
    }

    @Override
    protected void markThreadCompleted() {
        super.markThreadCompleted();
        boolean finalStatusSent = ((RuntimePartitionExecution)this.getRuntimeWorkUnitExecution()).isFinalStatusSent();
        if (!finalStatusSent) {
            try {
                this.partitionReplyQueue.add(new PartitionReplyMsg(PartitionReplyMsg.PartitionReplyMsgType.PARTITION_FINAL_STATUS).setBatchStatus(BatchStatus.FAILED).setExitStatus(BatchStatus.FAILED.toString()).setPartitionPlanConfig(this.partitionPlanConfig));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.util.BatchPartitionWorkUnit", (String)"95", (Object)this, (Object[])new Object[0]);
            }
            finally {
                this.partitionReplyQueue.close();
            }
        }
    }

    public String toString() {
        if (this.partitionPlanConfig == null) {
            return "PartitionWorkUnit <not initialized>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionWorkUnit with ");
        sb.append("jobExecutionId =" + this.partitionPlanConfig.getTopLevelExecutionId());
        sb.append(",stepName =" + this.partitionPlanConfig.getStepName());
        sb.append(",partitionNumber =" + this.partitionPlanConfig.getPartitionNumber());
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BatchPartitionWorkUnit.class);
    }
}

