/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchIllegalIDPersistedException;
import com.ibm.jbatch.container.exception.BatchIllegalJobStatusTransitionException;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityV2;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntityV2;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionKey;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadInstanceKey;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepInstanceKey;
import com.ibm.jbatch.container.services.IJPAQueryHelper;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.AbstractPersistenceManager;
import com.ibm.jbatch.container.services.impl.TranSynchronization;
import com.ibm.jbatch.container.util.WSStepThreadExecutionAggregateImpl;
import com.ibm.jbatch.container.ws.BatchLocationService;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.RemotablePartitionState;
import com.ibm.jbatch.container.ws.WSPartitionStepThreadExecution;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.container.ws.impl.WSStartupRecoveryServiceImpl;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.persistence.DDLGenerationParticipant;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.persistence.PersistenceServiceUnit;
import java.io.Writer;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.jbatch.container.persistence"}, service={IPersistenceManagerService.class, DDLGenerationParticipant.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM", "service.ranking:Integer=20", "persistenceType=JPA"})
public class JPAPersistenceManagerImpl
extends AbstractPersistenceManager
implements IPersistenceManagerService,
DDLGenerationParticipant {
    private static final Logger logger = Logger.getLogger(JPAPersistenceManagerImpl.class.getName(), "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    private EmbeddableWebSphereTransactionManager tranMgr;
    private LocalTransactionCurrent localTranCurrent;
    private DatabaseStore databaseStore;
    private String databaseStoreDisplayId;
    private BatchLocationService batchLocationService;
    private ExecutorService executorService;
    private volatile PersistenceServiceUnit psu;
    private Integer executionVersion;
    private Integer instanceVersion;
    private static final int MAX_EXECUTION_VERSION = 2;
    private static final int MAX_INSTANCE_VERSION = 2;
    static final long serialVersionUID = -8253235851601212809L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JPAPersistenceManagerImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "<init>", new Object[0]);
        }
        this.executionVersion = null;
        this.instanceVersion = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(target="(component.name=com.ibm.ws.threading)")
    protected void setExecutorService(ExecutorService executorService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setExecutorService", new Object[]{executorService});
        }
        this.executorService = executorService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setExecutorService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(name="jobStore", target="(id=unbound)")
    protected void setDatabaseStore(DatabaseStore databaseStore, Map<String, Object> props) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setDatabaseStore", new Object[]{databaseStore, props});
        }
        this.databaseStore = databaseStore;
        this.databaseStoreDisplayId = (String)props.get("config.displayId");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setDatabaseStore");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setTransactionManager(EmbeddableWebSphereTransactionManager svc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setTransactionManager", new Object[]{svc});
        }
        this.tranMgr = svc;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setTransactionManager");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setLocalTransactionCurrent(LocalTransactionCurrent ltc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setLocalTransactionCurrent", new Object[]{ltc});
        }
        this.localTranCurrent = ltc;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setLocalTransactionCurrent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setBatchLocationService(BatchLocationService batchLocationService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setBatchLocationService", new Object[]{batchLocationService});
        }
        this.batchLocationService = batchLocationService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "setBatchLocationService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "activate", new Object[]{context, config});
        }
        logger.log(Level.INFO, "persistence.service.status", new Object[]{"JPA", "activated"});
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "deactivate", new Object[0]);
        }
        if (this.psu != null) {
            try {
                this.psu.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"219", (Object)this, (Object[])new Object[0]);
            }
        }
        logger.log(Level.INFO, "persistence.service.status", new Object[]{"JPA", "deactivated"});
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "deactivate");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "init", new Object[]{batchConfig});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "init");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "shutdown", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "shutdown");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PersistenceServiceUnit getPsu() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPsu", new Object[0]);
        }
        if (this.psu == null) {
            try {
                this.psu = this.createPsu();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"244", (Object)this, (Object[])new Object[0]);
                throw new BatchRuntimeException("Failed to load JPA PersistenceServiceUnit", (Throwable)e);
            }
        }
        PersistenceServiceUnit persistenceServiceUnit = this.psu;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            persistenceServiceUnit = persistenceServiceUnit;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPsu", persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PersistenceServiceUnit createPsu(int jobInstanceVersion, int jobExecutionVersion) throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", new Object[]{jobInstanceVersion, jobExecutionVersion});
        }
        PersistenceServiceUnit persistenceServiceUnit = this.databaseStore.createPersistenceServiceUnit(this.getJobInstanceEntityClass(jobInstanceVersion).getClassLoader(), new String[]{this.getJobExecutionEntityClass(jobExecutionVersion).getName(), this.getJobInstanceEntityClass(jobInstanceVersion).getName(), StepThreadExecutionEntity.class.getName(), StepThreadInstanceEntity.class.getName(), TopLevelStepExecutionEntity.class.getName(), TopLevelStepInstanceEntity.class.getName()});
        if (logger != null && logger.isLoggable(Level.FINER)) {
            persistenceServiceUnit = persistenceServiceUnit;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PersistenceServiceUnit createLatestPsu() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createLatestPsu", new Object[0]);
        }
        PersistenceServiceUnit persistenceServiceUnit = this.createPsu(2, 2);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            persistenceServiceUnit = persistenceServiceUnit;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createLatestPsu", persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Class getJobExecutionEntityClass(int jobExecutionVersion) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionEntityClass", new Object[]{jobExecutionVersion});
        }
        if (jobExecutionVersion >= 2) {
            Class<JobExecutionEntityV2> clazz = JobExecutionEntityV2.class;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                clazz = clazz;
                logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionEntityClass", clazz);
            }
            return clazz;
        }
        Class<JobExecutionEntity> clazz = JobExecutionEntity.class;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            clazz = clazz;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionEntityClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Class getJobInstanceEntityClass(int jobInstanceVersion) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceEntityClass", new Object[]{jobInstanceVersion});
        }
        if (jobInstanceVersion >= 2) {
            Class<JobInstanceEntityV2> clazz = JobInstanceEntityV2.class;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                clazz = clazz;
                logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceEntityClass", clazz);
            }
            return clazz;
        }
        Class<JobInstanceEntity> clazz = JobInstanceEntity.class;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            clazz = clazz;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceEntityClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private synchronized PersistenceServiceUnit createPsu() throws Exception {
        int executionVersion;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", new Object[0]);
        }
        if (this.psu != null) {
            PersistenceServiceUnit persistenceServiceUnit = this.psu;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                persistenceServiceUnit = persistenceServiceUnit;
                logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", persistenceServiceUnit);
            }
            return persistenceServiceUnit;
        }
        PersistenceServiceUnit retMe = this.createLatestPsu();
        int instanceVersion = this.getJobInstanceTableVersion(retMe);
        if (instanceVersion < 2) {
            logger.fine("The UPDATETIME column could not be found. The persistence service unit will exclude the V2 instance entity.");
            retMe.close();
            retMe = this.createPsu(instanceVersion, 2);
        }
        if ((executionVersion = this.getJobExecutionTableVersion(retMe)) < 2) {
            logger.fine("The JOBPARAMETERS table could not be found. The persistence service unit will exclude the V2 execution entity.");
            retMe.close();
            retMe = this.createPsu(instanceVersion, executionVersion);
        }
        new WSStartupRecoveryServiceImpl().setIPersistenceManagerService(this).setPersistenceServiceUnit(retMe).recoverLocalJobsInInflightStates();
        PersistenceServiceUnit persistenceServiceUnit = this.psu = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            persistenceServiceUnit = persistenceServiceUnit;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPsu", persistenceServiceUnit);
        }
        return persistenceServiceUnit;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getDisplayId() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getDisplayId", new Object[0]);
        }
        Pattern pattern = Pattern.compile(".*\\[(.*)\\]");
        Matcher matcher = pattern.matcher(this.databaseStoreDisplayId);
        matcher.find();
        String string = matcher.group(1);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getDisplayId", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPersistenceType() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPersistenceType", new Object[0]);
        }
        String string = "JPA";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPersistenceType", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity createJobInstance(String appName, String jobXMLName, String submitter, Date createTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobInstance", new Object[]{appName, jobXMLName, submitter, createTime});
        }
        JobInstanceEntity jobInstanceEntity = this.createJobInstance(appName, jobXMLName, null, submitter, createTime);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity createJobInstance(final String appName, final String jobXMLName, final String jsl, final String submitter, final Date createTime) {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobInstance", new Object[]{appName, jobXMLName, jsl, submitter, createTime});
            }
            em = this.getPsu().createEntityManager();
            JobInstanceEntity instance = (JobInstanceEntity)new TranRequest<JobInstanceEntity>(em){
                static final long serialVersionUID = 5317654804964555255L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstanceEntity call() {
                    JobInstanceEntity jobInstance = JPAPersistenceManagerImpl.this.instanceVersion >= 2 ? new JobInstanceEntityV2() : new JobInstanceEntity();
                    jobInstance.setAmcName(appName);
                    jobInstance.setJobXmlName(jobXMLName);
                    jobInstance.setJobXml(jsl);
                    jobInstance.setSubmitter(submitter);
                    jobInstance.setCreateTime(createTime);
                    jobInstance.setLastUpdatedTime(createTime);
                    jobInstance.setInstanceState(InstanceState.SUBMITTED);
                    jobInstance.setBatchStatus(BatchStatus.STARTING);
                    this.entityMgr.persist((Object)jobInstance);
                    return jobInstance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            }.runInNewOrExistingGlobalTran();
            this.validatePersistedJobInstanceIds(instance);
            JobInstanceEntity jobInstanceEntity2 = instance;
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity getJobInstance(long jobInstanceId) throws NoSuchJobInstanceException {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstance", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            JobInstanceEntity instance = (JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)jobInstanceId);
            if (instance == null) {
                throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
            }
            JobInstanceEntity jobInstanceEntity2 = instance;
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstance", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstanceEntity getJobInstanceFromExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        JobInstanceEntity jobInstanceEntity;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceFromExecutionId", new Object[]{jobExecutionId});
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity exec = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)jobExecutionId);
            if (exec == null) {
                throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
            }
            JobInstanceEntity jobInstanceEntity2 = exec.getJobInstance();
            jobInstanceEntity = jobInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobInstanceEntity = jobInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceFromExecutionId", jobInstanceEntity);
        }
        return jobInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(String jobName, int start, int count) {
        List list;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{jobName, start, count});
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesSortCreateTimeByJobNameQuery", JobInstanceEntity.class);
            query.setParameter("name", (Object)jobName);
            List ids = query.setFirstResult(start).setMaxResults(count).getResultList();
            if (ids == null) {
                ArrayList<JobInstanceEntity> arrayList = new ArrayList<JobInstanceEntity>();
                ArrayList<JobInstanceEntity> arrayList2 = arrayList;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    arrayList2 = arrayList2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", arrayList2);
                }
                return arrayList2;
            }
            List list2 = ids;
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(String jobName, String submitter, int start, int count) {
        List list;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{jobName, submitter, start, count});
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesSortCreateTimeByJobNameAndSubmitterQuery", JobInstanceEntity.class);
            query.setParameter("name", (Object)jobName);
            query.setParameter("submitter", (Object)submitter);
            List ids = query.setFirstResult(start).setMaxResults(count).getResultList();
            if (ids == null) {
                ArrayList<JobInstanceEntity> arrayList = new ArrayList<JobInstanceEntity>();
                ArrayList<JobInstanceEntity> arrayList2 = arrayList;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    arrayList2 = arrayList2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", arrayList2);
                }
                return arrayList2;
            }
            List list2 = ids;
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(int page, int pageSize) {
        ArrayList<JobInstanceEntity> arrayList;
        EntityManager em;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{page, pageSize});
            }
            ArrayList<JobInstanceEntity> result = new ArrayList<JobInstanceEntity>();
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesSortIdAllQuery", JobInstanceEntity.class);
            List jobList = query.setFirstResult(page * pageSize).setMaxResults(pageSize).getResultList();
            if (jobList != null) {
                for (JobInstanceEntity instance : jobList) {
                    result.add(instance);
                }
            }
            ArrayList<JobInstanceEntity> arrayList2 = result;
            arrayList = arrayList2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", arrayList);
        }
        return arrayList;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(IJPAQueryHelper queryHelper, int page, int pageSize) {
        ArrayList<JobInstanceEntity> arrayList;
        EntityManager em;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{queryHelper, page, pageSize});
            }
            ArrayList<JobInstanceEntity> result = new ArrayList<JobInstanceEntity>();
            em = this.getPsu().createEntityManager();
            String jpaQueryString = queryHelper.getQuery();
            TypedQuery query = em.createQuery(jpaQueryString, JobInstanceEntity.class);
            queryHelper.setQueryParameters((TypedQuery<JobInstanceEntity>)query);
            List jobList = query.setFirstResult(page * pageSize).setMaxResults(pageSize).getResultList();
            if (jobList != null) {
                for (JobInstanceEntity instance : jobList) {
                    result.add(instance);
                }
            }
            ArrayList<JobInstanceEntity> arrayList2 = result;
            arrayList = arrayList2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", arrayList);
        }
        return arrayList;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobInstanceEntity> getJobInstances(int page, int pageSize, String submitter) {
        ArrayList<JobInstanceEntity> arrayList;
        EntityManager em;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", new Object[]{page, pageSize, submitter});
            }
            ArrayList<JobInstanceEntity> result = new ArrayList<JobInstanceEntity>();
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstancesSortIdBySubmitterQuery", JobInstanceEntity.class);
            query.setParameter("submitter", (Object)submitter);
            List jobList = query.setFirstResult(page * pageSize).setMaxResults(pageSize).getResultList();
            if (jobList != null) {
                for (JobInstanceEntity instance : jobList) {
                    result.add(instance);
                }
            }
            ArrayList<JobInstanceEntity> arrayList2 = result;
            arrayList = arrayList2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstances", arrayList);
        }
        return arrayList;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getJobNamesSet() {
        Set<String> set;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", new Object[0]);
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobNamesSetQuery", String.class);
            List result = query.getResultList();
            if (result == null) {
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = hashSet;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    hashSet2 = hashSet2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", hashSet2);
                }
                return hashSet2;
            }
            Set<String> set2 = this.cleanUpResult(new HashSet<String>(result));
            set = set2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            set = set;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", set);
        }
        return set;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getJobNamesSet(String submitter) {
        Set<String> set;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", new Object[]{submitter});
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobNamesSetBySubmitterQuery", String.class);
            query.setParameter("submitter", (Object)submitter);
            List result = query.getResultList();
            if (result == null) {
                HashSet<String> hashSet = new HashSet<String>();
                HashSet<String> hashSet2 = hashSet;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    hashSet2 = hashSet2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", hashSet2);
                }
                return hashSet2;
            }
            Set<String> set2 = this.cleanUpResult(new HashSet<String>(result));
            set = set2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            set = set;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobNamesSet", set);
        }
        return set;
        finally {
            em.close();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Set<String> cleanUpResult(Set<String> s) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "cleanUpResult", new Object[]{s});
        }
        s.remove(null);
        Set<String> set = s;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "cleanUpResult", set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceCount(String jobName) {
        int n;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceCount", new Object[]{jobName});
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstanceCountByJobNameQuery", Long.class);
            query.setParameter("name", (Object)jobName);
            Long result = (Long)query.getSingleResult();
            if (result > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("More than MAX_INTEGER results found.");
            }
            int n2 = result.intValue();
            n = n2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceCount", n);
        }
        return n;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceCount(String jobName, String submitter) {
        int n;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceCount", new Object[]{jobName, submitter});
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobInstanceEntity.getJobInstanceCountByJobNameAndSubmitterQuery", Long.class);
            query.setParameter("name", (Object)jobName);
            query.setParameter("submitter", (Object)submitter);
            Long result = (Long)query.getSingleResult();
            if (result > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("More than MAX_INTEGER results found.");
            }
            int n2 = result.intValue();
            n = n2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceCount", n);
        }
        return n;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithInstanceState(final long jobInstanceId, final InstanceState state, final Date lastUpdated) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceState", new Object[]{jobInstanceId, state, lastUpdated});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = 2535861009111760170L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, state);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$2", (String)"628", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException((Throwable)e);
                    }
                    instance.setInstanceState(state);
                    instance.setLastUpdatedTime(lastUpdated);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(2.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceState", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithInstanceStateUponRestart(final long jobInstanceId, final InstanceState state, final Date lastUpdated) {
        JobInstance jobInstance;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceStateUponRestart", new Object[]{jobInstanceId, state, lastUpdated});
            }
            em = this.getPsu().createEntityManager();
            String BASE_UPDATE = "UPDATE JobInstanceEntity x SET x.instanceState = :instanceState,x.batchStatus = :batchStatus";
            if (this.instanceVersion >= 2) {
                BASE_UPDATE = BASE_UPDATE.replace("JobInstanceEntity", "JobInstanceEntityV2").concat(",x.lastUpdatedTime = :lastUpdatedTime");
            }
            StringBuilder query = new StringBuilder().append(BASE_UPDATE);
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("x.instanceId = :instanceId");
            whereClause.append(" AND x.instanceState IN (com.ibm.jbatch.container.ws.InstanceState.STOPPED,");
            whereClause.append(" com.ibm.jbatch.container.ws.InstanceState.FAILED)");
            query.append(" WHERE " + whereClause);
            final String FINAL_UPDATE = query.toString();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = 6486260638562009117L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, state);
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(instance, BatchStatus.STARTING);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$3", (String)"670", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException((Throwable)e);
                    }
                    Query jpaQuery = this.entityMgr.createQuery(FINAL_UPDATE);
                    jpaQuery.setParameter("instanceState", (Object)state);
                    jpaQuery.setParameter("instanceId", (Object)jobInstanceId);
                    if (JPAPersistenceManagerImpl.this.instanceVersion >= 2) {
                        jpaQuery.setParameter("lastUpdatedTime", (Object)lastUpdated);
                    }
                    jpaQuery.setParameter("batchStatus", (Object)BatchStatus.STARTING);
                    int count = jpaQuery.executeUpdate();
                    if (count <= 0) {
                        String msg = "The job instance " + jobInstanceId + " cannot be restarted because it is still in a non-final state.";
                        throw new JobRestartException(msg);
                    }
                    this.entityMgr.refresh((Object)instance);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(3.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceStateUponRestart", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceNullOutRestartOn(final long jobInstanceId) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceNullOutRestartOn", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = -4614566391082440725L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    instance.setRestartOn(null);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(4.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceNullOutRestartOn", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithRestartOn(final long jobInstanceId, final String restartOn) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithRestartOn", new Object[]{jobInstanceId, restartOn});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = -5413551347796775528L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    instance.setRestartOn(restartOn);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(5.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithRestartOn", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithJobNameAndJSL(final long jobInstanceId, final String jobName, final String jobXml) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithJobNameAndJSL", new Object[]{jobInstanceId, jobName, jobXml});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = -6959184774079052971L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    instance.setJobName(jobName);
                    instance.setJobXml(jobXml);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(6.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithJobNameAndJSL", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStarted(final long jobExecutionId, final Date startedTime) throws NoSuchJobExecutionException {
        JobExecution jobExecution;
        EntityManager em;
        block4: {
            JobExecution exec;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStarted", new Object[]{jobExecutionId, startedTime});
            }
            em = this.getPsu().createEntityManager();
            JobExecution jobExecution2 = exec = (JobExecution)new TranRequest<JobExecution>(em){
                static final long serialVersionUID = -1276537208411666816L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobExecution call() {
                    JobExecutionEntity exec = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (exec == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(exec, BatchStatus.STARTED);
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(exec.getJobInstance(), InstanceState.DISPATCHED);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$7", (String)"773", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException((Throwable)e);
                    }
                    exec.setBatchStatus(BatchStatus.STARTED);
                    exec.getJobInstance().setInstanceState(InstanceState.DISPATCHED);
                    exec.getJobInstance().setBatchStatus(BatchStatus.STARTED);
                    exec.getJobInstance().setLastUpdatedTime(startedTime);
                    exec.setStartTime(startedTime);
                    exec.setLastUpdatedTime(startedTime);
                    return exec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(7.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecution = jobExecution2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStarted", jobExecution);
        }
        return jobExecution;
        finally {
            em.close();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validatePersistedJobInstanceIds(JobInstanceEntity instance) throws com.ibm.jbatch.container.exception.PersistenceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "validatePersistedJobInstanceIds", new Object[]{instance});
        }
        if (instance.getInstanceId() <= 0L) {
            long id = instance.getInstanceId();
            com.ibm.jbatch.container.exception.PersistenceException e = new com.ibm.jbatch.container.exception.PersistenceException(new BatchIllegalIDPersistedException(Long.toString(id)));
            logger.log(Level.SEVERE, "error.invalid.persisted.job.id", new Object[]{Long.toString(id), e});
            throw e;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "validatePersistedJobInstanceIds");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validatePersistedJobExecution(JobExecutionEntity execution) throws com.ibm.jbatch.container.exception.PersistenceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "validatePersistedJobExecution", new Object[]{execution});
        }
        if (execution.getExecutionId() <= 0L) {
            long exId = execution.getExecutionId();
            com.ibm.jbatch.container.exception.PersistenceException e = new com.ibm.jbatch.container.exception.PersistenceException(new BatchIllegalIDPersistedException(Long.toString(exId)));
            logger.log(Level.SEVERE, "error.invalid.persisted.exe.id", new Object[]{Long.toString(exId), e});
            throw e;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "validatePersistedJobExecution");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void validatePersistedStepExecution(StepThreadExecutionEntity stepExecution) throws com.ibm.jbatch.container.exception.PersistenceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "validatePersistedStepExecution", new Object[]{stepExecution});
        }
        if (stepExecution.getStepExecutionId() <= 0L) {
            long stepId = stepExecution.getStepExecutionId();
            com.ibm.jbatch.container.exception.PersistenceException e = new com.ibm.jbatch.container.exception.PersistenceException(new BatchIllegalIDPersistedException(Long.toString(stepId)));
            logger.log(Level.SEVERE, "error.invalid.persisted.step.id", new Object[]{Long.toString(stepId), e});
            throw e;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "validatePersistedStepExecution");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStatusChange(final long jobExecutionId, final BatchStatus newBatchStatus, final Date updateTime) throws NoSuchJobExecutionException {
        JobExecution jobExecution;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStatusChange", new Object[]{jobExecutionId, newBatchStatus, updateTime});
            }
            em = this.getPsu().createEntityManager();
            JobExecution jobExecution2 = (JobExecution)new TranRequest<JobExecution>(em){
                static final long serialVersionUID = -8550197931221183947L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobExecution call() {
                    JobExecutionEntity exec = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (exec == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(exec, newBatchStatus);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$8", (String)"866", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException((Throwable)e);
                    }
                    exec.setBatchStatus(newBatchStatus);
                    exec.getJobInstance().setBatchStatus(newBatchStatus);
                    exec.getJobInstance().setLastUpdatedTime(updateTime);
                    exec.setLastUpdatedTime(updateTime);
                    return exec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(8.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecution = jobExecution2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStatusChange", jobExecution);
        }
        return jobExecution;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnStop(final long jobExecutionId, final Date updateTime) throws NoSuchJobExecutionException {
        JobExecution jobExecution;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStop", new Object[]{jobExecutionId, updateTime});
            }
            em = this.getPsu().createEntityManager();
            String BASE_UPDATE = "UPDATE JobExecutionEntity x SET x.batchStatus = :batchStatus, x.lastUpdatedTime = :lastUpdatedTime";
            StringBuilder query = new StringBuilder().append("UPDATE JobExecutionEntity x SET x.batchStatus = :batchStatus, x.lastUpdatedTime = :lastUpdatedTime");
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("x.jobExecId = :jobExecId");
            whereClause.append(" AND x.serverId IS NULL");
            query.append(" WHERE " + whereClause);
            final String FINAL_UPDATE = query.toString();
            JobExecution jobExecution2 = (JobExecution)new TranRequest<JobExecution>(em){
                static final long serialVersionUID = -6325116724459021970L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobExecution call() {
                    JobExecutionEntity execution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (execution == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)execution.getInstanceId());
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + execution.getInstanceId());
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(execution, BatchStatus.STOPPED);
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, InstanceState.STOPPED);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$9", (String)"910", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException((Throwable)e);
                    }
                    instance.setBatchStatus(BatchStatus.STOPPED);
                    instance.setInstanceState(InstanceState.STOPPED);
                    instance.setLastUpdatedTime(updateTime);
                    Query jpaQuery = this.entityMgr.createQuery(FINAL_UPDATE);
                    jpaQuery.setParameter("batchStatus", (Object)BatchStatus.STOPPED);
                    jpaQuery.setParameter("jobExecId", (Object)jobExecutionId);
                    jpaQuery.setParameter("lastUpdatedTime", (Object)updateTime);
                    int count = jpaQuery.executeUpdate();
                    if (count <= 0) {
                        String msg = "No job execution found for id = " + jobExecutionId + " and serverId = \"\"";
                        throw new NoSuchJobExecutionException(msg);
                    }
                    this.entityMgr.refresh((Object)execution);
                    return execution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(9.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecution = jobExecution2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnStop", jobExecution);
        }
        return jobExecution;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceOnEnd(long jobExecutionId, BatchStatus finalBatchStatus, String finalExitStatus, Date endTime) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnEnd", new Object[]{jobExecutionId, finalBatchStatus, finalExitStatus, endTime});
        }
        JobExecution jobExecution = this.updateJobExecutionAndInstanceFinalStatus(this.getPsu(), jobExecutionId, finalBatchStatus, finalExitStatus, endTime);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceOnEnd", jobExecution);
        }
        return jobExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecution updateJobExecutionAndInstanceFinalStatus(PersistenceServiceUnit psu, final long jobExecutionId, final BatchStatus finalBatchStatus, final String finalExitStatus, final Date endTime) throws NoSuchJobExecutionException {
        JobExecution jobExecution;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceFinalStatus", new Object[]{psu, jobExecutionId, finalBatchStatus, finalExitStatus, endTime});
            }
            em = psu.createEntityManager();
            JobExecution jobExecution2 = (JobExecution)new TranRequest<JobExecution>(em){
                static final long serialVersionUID = 1949493230034549230L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobExecution call() {
                    JobExecutionEntity exec = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (exec == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStatusTransitionIsValid(exec, finalBatchStatus);
                        exec.setBatchStatus(finalBatchStatus);
                        exec.getJobInstance().setBatchStatus(finalBatchStatus);
                        exec.setExitStatus(finalExitStatus);
                        exec.getJobInstance().setExitStatus(finalExitStatus);
                        exec.getJobInstance().setLastUpdatedTime(endTime);
                        if (AbstractPersistenceManager.FINAL_STATUS_SET.contains(finalBatchStatus)) {
                            InstanceState newInstanceState = InstanceState.valueOf(finalBatchStatus.toString());
                            JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(exec.getJobInstance(), newInstanceState);
                            exec.getJobInstance().setInstanceState(newInstanceState);
                        }
                        exec.setLastUpdatedTime(endTime);
                        exec.setEndTime(endTime);
                        return exec;
                    }
                    catch (BatchIllegalJobStatusTransitionException newInstanceState) {
                        void e;
                        FFDCFilter.processException((Throwable)newInstanceState, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$10", (String)"989", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException((Throwable)e);
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(10.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecution = jobExecution2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecution = jobExecution;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionAndInstanceFinalStatus", jobExecution);
        }
        return jobExecution;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity createJobExecution(final long jobInstanceId, Properties jobParameters, Date createTime) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobExecution", new Object[]{jobInstanceId, jobParameters, createTime});
        }
        final JobExecutionEntity jobExecution = this.executionVersion >= 2 ? new JobExecutionEntityV2() : new JobExecutionEntity();
        jobExecution.setCreateTime(createTime);
        jobExecution.setLastUpdatedTime(createTime);
        jobExecution.setBatchStatus(BatchStatus.STARTING);
        jobExecution.setJobParameters(jobParameters);
        jobExecution.setRestUrl(this.batchLocationService.getBatchRestUrl());
        EntityManager em = this.getPsu().createEntityManager();
        try {
            new TranRequest<Void>(em){
                static final long serialVersionUID = -3147555502601447785L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void call() {
                    JobInstanceEntity jobInstance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (jobInstance == null) {
                        throw new IllegalStateException("Didn't find JobInstanceEntity associated with value: " + jobInstanceId);
                    }
                    int currentNumExecutionsPreviously = jobInstance.getNumberOfExecutions();
                    jobExecution.setExecutionNumberForThisInstance(currentNumExecutionsPreviously);
                    jobInstance.setNumberOfExecutions(currentNumExecutionsPreviously + 1);
                    jobInstance.getJobExecutions().add(0, jobExecution);
                    jobExecution.setJobInstance(jobInstance);
                    this.entityMgr.persist((Object)jobExecution);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(11.class);
                }
            }.runInNewOrExistingGlobalTran();
            this.validatePersistedJobExecution(jobExecution);
        }
        finally {
            em.close();
        }
        JobExecutionEntity jobExecutionEntity = jobExecution;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createJobExecution", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity getJobExecution(long jobExecutionId) throws NoSuchJobExecutionException {
        JobExecutionEntity jobExecutionEntity;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecution", new Object[]{jobExecutionId});
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity exec = (JobExecutionEntity)em.find(JobExecutionEntity.class, (Object)jobExecutionId);
            if (exec == null) {
                throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
            }
            JobExecutionEntity jobExecutionEntity2 = exec;
            jobExecutionEntity = jobExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecution", jobExecutionEntity);
        }
        return jobExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobExecutionEntity> getJobExecutionsFromJobInstanceId(long jobInstanceId) throws NoSuchJobInstanceException {
        List list;
        EntityManager em;
        block8: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsFromJobInstanceId", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobExecutionEntity.getJobExecutionsMostToLeastRecentByInstanceQuery", JobExecutionEntity.class);
            query.setParameter("instanceId", (Object)jobInstanceId);
            List result = query.getResultList();
            if (result == null || result.size() == 0) {
                this.getJobInstance(jobInstanceId);
                if (result == null) {
                    ArrayList<JobExecutionEntity> arrayList = new ArrayList<JobExecutionEntity>();
                    ArrayList<JobExecutionEntity> arrayList2 = arrayList;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        arrayList2 = arrayList2;
                        logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsFromJobInstanceId", arrayList2);
                    }
                    return arrayList2;
                }
            }
            List list2 = result;
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block8;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsFromJobInstanceId", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getJobExecutionsRunning(String jobName) {
        List list;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunning", new Object[]{jobName});
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("JobExecutionEntity.getJobExecutionsByNameAndStatusesQuery", Long.class);
            query.setParameter("name", (Object)jobName);
            query.setParameter("status", (Object)RUNNING_STATUSES);
            List result = query.getResultList();
            if (result == null) {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                ArrayList<Long> arrayList2 = arrayList;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    arrayList2 = arrayList2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunning", arrayList2);
                }
                return arrayList2;
            }
            List list2 = result;
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunning", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<JobExecutionEntity> getJobExecutionsRunningLocalToServer(PersistenceServiceUnit psu) {
        List list;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunningLocalToServer", new Object[]{psu});
            }
            em = psu.createEntityManager();
            TypedQuery query = em.createNamedQuery("JobExecutionEntity.getJobExecutionsByServerIdAndStatusesQuery", JobExecutionEntity.class);
            query.setParameter("serverid", (Object)this.batchLocationService.getServerId());
            query.setParameter("status", (Object)RUNNING_STATUSES);
            List result = query.getResultList();
            if (result == null) {
                ArrayList<JobExecutionEntity> arrayList = new ArrayList<JobExecutionEntity>();
                ArrayList<JobExecutionEntity> arrayList2 = arrayList;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    arrayList2 = arrayList2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunningLocalToServer", arrayList2);
                }
                return arrayList2;
            }
            List list2 = result;
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionsRunningLocalToServer", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<RemotablePartitionEntity> getPartitionsRunningLocalToServer(PersistenceServiceUnit psu) {
        List list;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPartitionsRunningLocalToServer", new Object[]{psu});
            }
            em = psu.createEntityManager();
            TypedQuery query = em.createNamedQuery("RemotablePartitionEntity.getPartitionStepExecutionByServerIdAndStatusesQuery", RemotablePartitionEntity.class);
            query.setParameter("serverid", (Object)this.batchLocationService.getServerId());
            query.setParameter("status", (Object)RUNNING_STATUSES);
            List result = query.getResultList();
            if (result == null) {
                ArrayList<RemotablePartitionEntity> arrayList = new ArrayList<RemotablePartitionEntity>();
                ArrayList<RemotablePartitionEntity> arrayList2 = arrayList;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    arrayList2 = arrayList2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPartitionsRunningLocalToServer", arrayList2);
                }
                return arrayList2;
            }
            List list2 = result;
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getPartitionsRunningLocalToServer", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity getJobExecutionFromJobExecNum(long jobInstanceId, int jobExecNum) throws NoSuchJobInstanceException, IllegalArgumentException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionFromJobExecNum", new Object[]{jobInstanceId, jobExecNum});
        }
        EntityManager em = this.getPsu().createEntityManager();
        TypedQuery query = em.createNamedQuery("JobExecutionEntity.getJobExecutionsByJobInstanceIdAndJobExecNumberQuery", JobExecutionEntity.class);
        query.setParameter("instanceId", (Object)jobInstanceId);
        query.setParameter("jobExecNum", (Object)jobExecNum);
        List jobExec = query.getResultList();
        if (jobExec.size() > 1) {
            throw new IllegalStateException("Found more than one result for jobInstanceId: " + jobInstanceId + ", jobExecNum: " + jobExecNum);
        }
        if (jobExec == null || jobExec.size() == 0) {
            this.getJobInstance(jobInstanceId);
            throw new IllegalArgumentException("Didn't find any job execution entries at job instance id: " + jobInstanceId + ", job execution number: " + jobExecNum);
        }
        JobExecutionEntity jobExecutionEntity = (JobExecutionEntity)jobExec.get(0);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionFromJobExecNum", jobExecutionEntity);
        }
        return jobExecutionEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity updateJobExecutionLogDir(final long jobExecutionId, final String logDirPath) {
        JobExecutionEntity jobExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionLogDir", new Object[]{jobExecutionId, logDirPath});
            }
            em = this.getPsu().createEntityManager();
            JobExecutionEntity jobExecutionEntity2 = (JobExecutionEntity)new TranRequest<JobExecutionEntity>(em){
                static final long serialVersionUID = -417994431208433704L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobExecutionEntity call() {
                    JobExecutionEntity exec = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (exec == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    exec.setLogpath(logDirPath);
                    return exec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(12.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecutionEntity = jobExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionLogDir", jobExecutionEntity);
        }
        return jobExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobExecutionEntity updateJobExecutionServerIdAndRestUrl(final long jobExecutionId) {
        JobExecutionEntity jobExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionServerIdAndRestUrl", new Object[]{jobExecutionId});
            }
            em = this.getPsu().createEntityManager();
            String BASE_UPDATE = "UPDATE JobExecutionEntity x SET x.serverId = :serverId, x.restUrl = :restUrl";
            StringBuilder query = new StringBuilder().append("UPDATE JobExecutionEntity x SET x.serverId = :serverId, x.restUrl = :restUrl");
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("x.jobExecId = :jobExecId");
            whereClause.append(" AND x.batchStatus = :batchStatus");
            query.append(" WHERE " + whereClause);
            final String FINAL_UPDATE = query.toString();
            JobExecutionEntity jobExecutionEntity2 = (JobExecutionEntity)new TranRequest<JobExecutionEntity>(em){
                static final long serialVersionUID = 8572023951856453222L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public JobExecutionEntity call() {
                    JobExecutionEntity execution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (execution == null) {
                        throw new NoSuchJobExecutionException("No job execution found for id = " + jobExecutionId);
                    }
                    Query jpaQuery = this.entityMgr.createQuery(FINAL_UPDATE);
                    jpaQuery.setParameter("batchStatus", (Object)BatchStatus.STARTING);
                    jpaQuery.setParameter("jobExecId", (Object)jobExecutionId);
                    jpaQuery.setParameter("serverId", (Object)JPAPersistenceManagerImpl.this.batchLocationService.getServerId());
                    jpaQuery.setParameter("restUrl", (Object)JPAPersistenceManagerImpl.this.batchLocationService.getBatchRestUrl());
                    int count = jpaQuery.executeUpdate();
                    if (count <= 0) {
                        String msg = "No job execution found for id = " + jobExecutionId + " and status = STARTING";
                        throw new NoSuchJobExecutionException(msg);
                    }
                    this.entityMgr.refresh((Object)execution);
                    return execution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(13.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobExecutionEntity = jobExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobExecutionEntity = jobExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobExecutionServerIdAndRestUrl", jobExecutionEntity);
        }
        return jobExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity createTopLevelStepExecutionAndNewThreadInstance(final long jobExecutionId, final StepThreadInstanceKey instanceKey, final boolean isPartitioned) {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionAndNewThreadInstance", new Object[]{jobExecutionId, instanceKey, isPartitioned});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepExecutionEntity stepExecution = (TopLevelStepExecutionEntity)new TranRequest<TopLevelStepExecutionEntity>(em){
                static final long serialVersionUID = 4102479416565632685L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepExecutionEntity call() {
                    JobInstanceEntity jobInstance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)instanceKey.getJobInstance());
                    if (jobInstance == null) {
                        throw new IllegalStateException("Didn't find JobInstanceEntity associated with step thread key value: " + instanceKey.getJobInstance());
                    }
                    JobExecutionEntity jobExecution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (jobExecution == null) {
                        throw new IllegalStateException("Didn't find JobExecutionEntity associated with value: " + jobExecutionId);
                    }
                    TopLevelStepInstanceEntity stepInstance = new TopLevelStepInstanceEntity(jobInstance, instanceKey.getStepName(), isPartitioned);
                    TopLevelStepExecutionEntity stepExecution = new TopLevelStepExecutionEntity(jobExecution, instanceKey.getStepName(), isPartitioned);
                    stepInstance.setLatestStepThreadExecution(stepExecution);
                    this.entityMgr.persist((Object)stepExecution);
                    this.entityMgr.persist((Object)stepInstance);
                    return stepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(14.class);
                }
            }.runInNewOrExistingGlobalTran();
            this.validatePersistedStepExecution(stepExecution);
            TopLevelStepExecutionEntity topLevelStepExecutionEntity2 = stepExecution;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionAndNewThreadInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotablePartitionEntity updateRemotablePartitionInternalState(final long jobExecId, final String stepName, final int partitionNum, final RemotablePartitionState internalStatus) {
        RemotablePartitionEntity remotablePartitionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionInternalState", new Object[]{jobExecId, stepName, partitionNum, internalStatus});
            }
            em = this.getPsu().createEntityManager();
            RemotablePartitionEntity remotablePartitionEntity2 = (RemotablePartitionEntity)new TranRequest<RemotablePartitionEntity>(em){
                static final long serialVersionUID = 7001303224274245363L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RemotablePartitionEntity call() {
                    RemotablePartitionKey partitionKey = new RemotablePartitionKey(jobExecId, stepName, partitionNum);
                    RemotablePartitionEntity partition = (RemotablePartitionEntity)this.entityMgr.find(RemotablePartitionEntity.class, (Object)partitionKey);
                    if (partition != null) {
                        partition.setRestUrl(JPAPersistenceManagerImpl.this.batchLocationService.getBatchRestUrl());
                        partition.setServerId(JPAPersistenceManagerImpl.this.batchLocationService.getServerId());
                        partition.setInternalStatus(internalStatus);
                        partition.setLastUpdated(new Date());
                    }
                    return partition;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(15.class);
                }
            }.runInNewOrExistingGlobalTran();
            remotablePartitionEntity = remotablePartitionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            remotablePartitionEntity = remotablePartitionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionInternalState", remotablePartitionEntity);
        }
        return remotablePartitionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotablePartitionEntity createRemotablePartition(final long jobExecId, final String stepName, final int partitionNum, final RemotablePartitionState partitionState) {
        RemotablePartitionEntity remotablePartitionEntity;
        EntityManager em;
        block4: {
            RemotablePartitionEntity remotablePartition;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createRemotablePartition", new Object[]{jobExecId, stepName, partitionNum, partitionState});
            }
            em = this.getPsu().createEntityManager();
            RemotablePartitionEntity remotablePartitionEntity2 = remotablePartition = (RemotablePartitionEntity)new TranRequest<RemotablePartitionEntity>(em){
                static final long serialVersionUID = -5472223372966601651L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RemotablePartitionEntity call() {
                    JobExecutionEntity jobExecution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecId);
                    if (jobExecution == null) {
                        throw new IllegalStateException("Didn't find JobExecutionEntity associated with value: " + jobExecId);
                    }
                    RemotablePartitionEntity remotablePartition = new RemotablePartitionEntity(jobExecution, stepName, partitionNum);
                    remotablePartition.setInternalStatus(partitionState);
                    remotablePartition.setLastUpdated(new Date());
                    this.entityMgr.persist((Object)remotablePartition);
                    return remotablePartition;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(16.class);
                }
            }.runInNewOrExistingGlobalTran();
            remotablePartitionEntity = remotablePartitionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            remotablePartitionEntity = remotablePartitionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createRemotablePartition", remotablePartitionEntity);
        }
        return remotablePartitionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity createPartitionStepExecutionAndNewThreadInstance(final long jobExecutionId, final StepThreadInstanceKey instanceKey, boolean isRemoteDispatch) {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPartitionStepExecutionAndNewThreadInstance", new Object[]{jobExecutionId, instanceKey, isRemoteDispatch});
            }
            em = this.getPsu().createEntityManager();
            StepThreadExecutionEntity stepExecution = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = 4822603704889319009L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadExecutionEntity call() {
                    JobInstanceEntity jobInstance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)instanceKey.getJobInstance());
                    if (jobInstance == null) {
                        throw new IllegalStateException("Didn't find JobInstanceEntity associated with step thread key value: " + instanceKey.getJobInstance());
                    }
                    JobExecutionEntity jobExecution = (JobExecutionEntity)this.entityMgr.find(JobExecutionEntity.class, (Object)jobExecutionId);
                    if (jobExecution == null) {
                        throw new IllegalStateException("Didn't find JobExecutionEntity associated with value: " + jobExecutionId);
                    }
                    TypedQuery query = this.entityMgr.createNamedQuery("TopLevelStepExecutionEntity.getTopLevelStepExecutionByJobExecAndStepNameQuery", TopLevelStepExecutionEntity.class);
                    query.setParameter("jobExecId", (Object)jobExecutionId);
                    query.setParameter("stepName", (Object)instanceKey.getStepName());
                    TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)query.getSingleResult();
                    StepThreadInstanceEntity stepInstance = new StepThreadInstanceEntity(jobInstance, instanceKey.getStepName(), instanceKey.getPartitionNumber());
                    StepThreadExecutionEntity stepExecution = new StepThreadExecutionEntity(jobExecution, instanceKey.getStepName(), instanceKey.getPartitionNumber());
                    stepInstance.setLatestStepThreadExecution(stepExecution);
                    stepExecution.setTopLevelStepExecution(topLevelStepExecution);
                    this.entityMgr.persist((Object)stepInstance);
                    this.entityMgr.persist((Object)stepExecution);
                    return stepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(17.class);
                }
            }.runInNewOrExistingGlobalTran();
            this.validatePersistedStepExecution(stepExecution);
            StepThreadExecutionEntity stepThreadExecutionEntity2 = stepExecution;
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPartitionStepExecutionAndNewThreadInstance", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity createTopLevelStepExecutionOnRestartFromPreviousStepInstance(final long jobExecutionId, final TopLevelStepInstanceEntity stepInstance) throws NoSuchJobExecutionException {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartFromPreviousStepInstance", new Object[]{jobExecutionId, stepInstance});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepExecutionEntity stepExecution = (TopLevelStepExecutionEntity)new TranRequest<TopLevelStepExecutionEntity>(em){
                static final long serialVersionUID = -3573130030077964161L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepExecutionEntity call() {
                    JobExecutionEntity newJobExecution = JPAPersistenceManagerImpl.this.getJobExecution(jobExecutionId);
                    StepThreadExecutionEntity lastStepExecution = stepInstance.getLatestStepThreadExecution();
                    TopLevelStepExecutionEntity newStepExecution = new TopLevelStepExecutionEntity(newJobExecution, stepInstance.getStepName(), stepInstance.isPartitionedStep());
                    newStepExecution.setPersistentUserDataBytes(lastStepExecution.getPersistentUserDataBytes());
                    stepInstance.incrementStartCount();
                    stepInstance.setLatestStepThreadExecution(newStepExecution);
                    this.entityMgr.persist((Object)newStepExecution);
                    this.entityMgr.merge((Object)stepInstance);
                    return newStepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(18.class);
                }
            }.runInNewOrExistingGlobalTran();
            this.validatePersistedStepExecution(stepExecution);
            TopLevelStepExecutionEntity topLevelStepExecutionEntity2 = stepExecution;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartFromPreviousStepInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity createPartitionStepExecutionOnRestartFromPreviousStepInstance(final long jobExecutionId, final StepThreadInstanceEntity stepThreadInstance, boolean isRemoteDispatch) throws NoSuchJobExecutionException {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPartitionStepExecutionOnRestartFromPreviousStepInstance", new Object[]{jobExecutionId, stepThreadInstance, isRemoteDispatch});
            }
            em = this.getPsu().createEntityManager();
            StepThreadExecutionEntity stepExecution = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = -3682042233844259051L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadExecutionEntity call() {
                    JobExecutionEntity newJobExecution = JPAPersistenceManagerImpl.this.getJobExecution(jobExecutionId);
                    StepThreadExecutionEntity lastStepExecution = stepThreadInstance.getLatestStepThreadExecution();
                    TypedQuery query = this.entityMgr.createNamedQuery("TopLevelStepExecutionEntity.getTopLevelStepExecutionByJobExecAndStepNameQuery", TopLevelStepExecutionEntity.class);
                    query.setParameter("jobExecId", (Object)jobExecutionId);
                    query.setParameter("stepName", (Object)stepThreadInstance.getStepName());
                    TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)query.getSingleResult();
                    StepThreadExecutionEntity newStepExecution = new StepThreadExecutionEntity(newJobExecution, stepThreadInstance.getStepName(), stepThreadInstance.getPartitionNumber());
                    newStepExecution.setPersistentUserDataBytes(lastStepExecution.getPersistentUserDataBytes());
                    stepThreadInstance.setLatestStepThreadExecution(newStepExecution);
                    newStepExecution.setTopLevelStepExecution(topLevelStepExecution);
                    this.entityMgr.persist((Object)newStepExecution);
                    this.entityMgr.merge((Object)stepThreadInstance);
                    return newStepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(19.class);
                }
            }.runInNewOrExistingGlobalTran();
            this.validatePersistedStepExecution(stepExecution);
            StepThreadExecutionEntity stepThreadExecutionEntity2 = stepExecution;
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createPartitionStepExecutionOnRestartFromPreviousStepInstance", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity createTopLevelStepExecutionOnRestartAndCleanStepInstance(final long jobExecutionId, final TopLevelStepInstanceEntity stepInstance) throws NoSuchJobExecutionException {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartAndCleanStepInstance", new Object[]{jobExecutionId, stepInstance});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepExecutionEntity stepExecution = (TopLevelStepExecutionEntity)new TranRequest<TopLevelStepExecutionEntity>(em){
                static final long serialVersionUID = -2365311411691840748L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepExecutionEntity call() {
                    JobExecutionEntity newJobExecution = JPAPersistenceManagerImpl.this.getJobExecution(jobExecutionId);
                    TopLevelStepExecutionEntity newStepExecution = new TopLevelStepExecutionEntity(newJobExecution, stepInstance.getStepName(), stepInstance.isPartitionedStep());
                    stepInstance.incrementStartCount();
                    stepInstance.deleteCheckpointData();
                    stepInstance.setLatestStepThreadExecution(newStepExecution);
                    this.entityMgr.persist((Object)newStepExecution);
                    this.entityMgr.merge((Object)stepInstance);
                    return newStepExecution;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(20.class);
                }
            }.runInNewOrExistingGlobalTran();
            this.validatePersistedStepExecution(stepExecution);
            TopLevelStepExecutionEntity topLevelStepExecutionEntity2 = stepExecution;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "createTopLevelStepExecutionOnRestartAndCleanStepInstance", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadInstanceEntity getStepThreadInstance(StepThreadInstanceKey stepInstanceKey) {
        StepThreadInstanceEntity stepThreadInstanceEntity;
        EntityManager em;
        block4: {
            StepThreadInstanceEntity instance;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadInstance", new Object[]{stepInstanceKey});
            }
            em = this.getPsu().createEntityManager();
            StepThreadInstanceEntity stepThreadInstanceEntity2 = instance = (StepThreadInstanceEntity)em.find(StepThreadInstanceEntity.class, (Object)stepInstanceKey);
            stepThreadInstanceEntity = stepThreadInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadInstanceEntity = stepThreadInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadInstance", stepThreadInstanceEntity);
        }
        return stepThreadInstanceEntity;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Integer> getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions(StepThreadInstanceKey topLevelKey) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions", new Object[]{topLevelKey});
        }
        EntityManager em = this.getPsu().createEntityManager();
        TypedQuery query = em.createNamedQuery("TopLevelStepInstanceEntity.getRelatedPartitionLevelCompletedPartitionNumbersQuery", Integer.class);
        query.setParameter("instanceId", (Object)topLevelKey.getJobInstance());
        query.setParameter("stepName", (Object)topLevelKey.getStepName());
        List list = query.getResultList();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadInstancePartitionNumbersOfRelatedCompletedPartitions", list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadInstanceEntity updateStepThreadInstanceWithCheckpointData(final StepThreadInstanceEntity stepThreadInstance) {
        StepThreadInstanceEntity stepThreadInstanceEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepThreadInstanceWithCheckpointData", new Object[]{stepThreadInstance});
            }
            em = this.getPsu().createEntityManager();
            StepThreadInstanceEntity stepThreadInstanceEntity2 = (StepThreadInstanceEntity)new TranRequest<StepThreadInstanceEntity>(em){
                static final long serialVersionUID = -1716494134116237340L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadInstanceEntity call() {
                    this.entityMgr.merge((Object)stepThreadInstance);
                    return stepThreadInstance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(21.class);
                }
            }.runInNewOrExistingGlobalTran();
            stepThreadInstanceEntity = stepThreadInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadInstanceEntity = stepThreadInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepThreadInstanceWithCheckpointData", stepThreadInstanceEntity);
        }
        return stepThreadInstanceEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepInstanceEntity updateStepThreadInstanceWithPartitionPlanSize(StepThreadInstanceKey stepInstanceKey, final int numCurrentPartitions) {
        TopLevelStepInstanceEntity topLevelStepInstanceEntity;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepThreadInstanceWithPartitionPlanSize", new Object[]{stepInstanceKey, numCurrentPartitions});
            }
            em = this.getPsu().createEntityManager();
            final TopLevelStepInstanceEntity stepInstance = (TopLevelStepInstanceEntity)em.find(TopLevelStepInstanceEntity.class, (Object)stepInstanceKey);
            if (stepInstance == null) {
                throw new IllegalStateException("No step thread instance found for key = " + stepInstanceKey);
            }
            TopLevelStepInstanceEntity topLevelStepInstanceEntity2 = (TopLevelStepInstanceEntity)new TranRequest<TopLevelStepInstanceEntity>(em){
                static final long serialVersionUID = 5371124352647584981L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepInstanceEntity call() {
                    stepInstance.setPartitionPlanSize(numCurrentPartitions);
                    return stepInstance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(22.class);
                }
            }.runInNewOrExistingGlobalTran();
            topLevelStepInstanceEntity = topLevelStepInstanceEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            topLevelStepInstanceEntity = topLevelStepInstanceEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepThreadInstanceWithPartitionPlanSize", topLevelStepInstanceEntity);
        }
        return topLevelStepInstanceEntity;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void deleteStepThreadInstanceOfRelatedPartitions(final TopLevelStepInstanceKey instanceKey) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "deleteStepThreadInstanceOfRelatedPartitions", new Object[]{instanceKey});
        }
        EntityManager em = this.getPsu().createEntityManager();
        try {
            new TranRequest<Void>(em){
                static final long serialVersionUID = 8710725173033503269L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void call() {
                    TypedQuery query = this.entityMgr.createNamedQuery("TopLevelStepInstanceEntity.getRelatedPartitionLevelStepThreadInstancesQuery", StepThreadInstanceEntity.class);
                    query.setParameter("instanceId", (Object)instanceKey.getJobInstance());
                    query.setParameter("stepName", (Object)instanceKey.getStepName());
                    List relatedPartitionInstances = query.getResultList();
                    for (StepThreadInstanceEntity partitionInstance : relatedPartitionInstances) {
                        this.entityMgr.remove((Object)partitionInstance);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(23.class);
                }
            }.runInNewOrExistingGlobalTran();
        }
        finally {
            em.close();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "deleteStepThreadInstanceOfRelatedPartitions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity getStepThreadExecution(long stepExecutionId) {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecution", new Object[]{stepExecutionId});
            }
            em = this.getPsu().createEntityManager();
            StepThreadExecutionEntity stepThreadExecutionEntity2 = (StepThreadExecutionEntity)em.find(StepThreadExecutionEntity.class, (Object)stepExecutionId);
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecution", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<StepExecution> getStepExecutionsTopLevelFromJobExecutionId(long jobExecutionId) throws NoSuchJobExecutionException {
        ArrayList<StepExecution> arrayList;
        EntityManager em;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionsTopLevelFromJobExecutionId", new Object[]{jobExecutionId});
            }
            em = this.getPsu().createEntityManager();
            TypedQuery query = em.createNamedQuery("TopLevelStepExecutionEntity.getTopLevelStepExecutionsByJobExecSortByStartTimeAscQuery", StepExecution.class);
            query.setParameter("jobExecId", (Object)jobExecutionId);
            ArrayList<StepExecution> result = query.getResultList();
            if (result == null) {
                result = new ArrayList<StepExecution>();
            }
            if (result.isEmpty()) {
                this.getJobExecution(jobExecutionId);
            }
            ArrayList<StepExecution> arrayList2 = result;
            arrayList = arrayList2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block6;
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionsTopLevelFromJobExecutionId", arrayList);
        }
        return arrayList;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecutionNumberAndStepName(long jobInstanceId, int jobExecNum, String stepName) throws NoSuchJobInstanceException, IllegalArgumentException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionNumberAndStepName", new Object[]{jobInstanceId, jobExecNum, stepName});
        }
        WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
        EntityManager em = this.getPsu().createEntityManager();
        TypedQuery query = em.createNamedQuery("TopLevelStepExecutionEntity.getTopLevelStepExecutionByJobInstanceJobExecNumAndStepNameQuery", StepThreadExecutionEntity.class);
        query.setParameter("jobInstanceId", (Object)jobInstanceId);
        query.setParameter("jobExecNum", (Object)jobExecNum);
        query.setParameter("stepName", (Object)stepName);
        List stepExecs = query.getResultList();
        if (stepExecs == null || stepExecs.size() == 0) {
            this.getJobInstance(jobInstanceId);
            throw new IllegalArgumentException("Didn't find any step thread exec entries at job instance id: " + jobInstanceId + ", job execution number: " + jobExecNum + ", and stepName: " + stepName);
        }
        try {
            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)stepExecs.get(0);
            retVal.setTopLevelStepExecution(topLevelStepExecution);
        }
        catch (ClassCastException topLevelStepExecution) {
            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"1790", (Object)this, (Object[])new Object[]{jobInstanceId, jobExecNum, stepName});
            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at job instance id: " + jobInstanceId + ", job execution number: " + jobExecNum + ", and stepName: " + stepName);
        }
        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(stepExecs.subList(1, stepExecs.size())));
        WSStepThreadExecutionAggregateImpl wSStepThreadExecutionAggregateImpl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregateImpl = wSStepThreadExecutionAggregateImpl;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionNumberAndStepName", wSStepThreadExecutionAggregateImpl);
        }
        return wSStepThreadExecutionAggregateImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity updateStepExecution(final RuntimeStepExecution runtimeStepExecution) {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecution", new Object[]{runtimeStepExecution});
            }
            em = this.getPsu().createEntityManager();
            TranSynchronization tranSynch = new TranSynchronization(runtimeStepExecution);
            try {
                Transaction tran = this.tranMgr.getTransaction();
                if (tran != null) {
                    UOWCurrent uowCurrent = (UOWCurrent)this.tranMgr;
                    this.tranMgr.registerSynchronization(uowCurrent.getUOWCoord(), (Synchronization)tranSynch, 1);
                }
            }
            catch (Throwable tran) {
                void t;
                FFDCFilter.processException((Throwable)tran, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"1820", (Object)this, (Object[])new Object[]{runtimeStepExecution});
                throw new IllegalStateException("TranSync messed up! Sync = " + tranSynch + " Exception: " + t.toString());
            }
            StepThreadExecutionEntity stepThreadExecutionEntity2 = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = -8016861228189181560L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public StepThreadExecutionEntity call() {
                    StepThreadExecutionEntity stepExec = (StepThreadExecutionEntity)this.entityMgr.find(StepThreadExecutionEntity.class, (Object)runtimeStepExecution.getInternalStepThreadExecutionId());
                    if (stepExec == null) {
                        throw new IllegalStateException("StepThreadExecEntity with id =" + runtimeStepExecution.getInternalStepThreadExecutionId() + " should be persisted at this point, but didn't find.");
                    }
                    JPAPersistenceManagerImpl.this.updateStepExecutionStatusTimeStampsUserDataAndMetrics(stepExec, runtimeStepExecution);
                    return stepExec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(24.class);
                }
            }.runInNewOrExistingGlobalTran();
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecution", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RemotablePartitionEntity updateRemotablePartitionOnRecovery(PersistenceServiceUnit psu, final RemotablePartitionEntity partition) {
        RemotablePartitionEntity remotablePartitionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionOnRecovery", new Object[]{psu, partition});
            }
            em = psu.createEntityManager();
            RemotablePartitionEntity remotablePartitionEntity2 = (RemotablePartitionEntity)new TranRequest<RemotablePartitionEntity>(em){
                static final long serialVersionUID = -1982697305159743663L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public RemotablePartitionEntity call() {
                    RemotablePartitionKey key = new RemotablePartitionKey(partition);
                    RemotablePartitionEntity remotablePartition = (RemotablePartitionEntity)this.entityMgr.find(RemotablePartitionEntity.class, (Object)key);
                    remotablePartition.setLastUpdated(new Date());
                    return remotablePartition;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(25.class);
                }
            }.runInNewOrExistingGlobalTran();
            remotablePartitionEntity = remotablePartitionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            remotablePartitionEntity = remotablePartitionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateRemotablePartitionOnRecovery", remotablePartitionEntity);
        }
        return remotablePartitionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StepThreadExecutionEntity updateStepExecutionOnRecovery(PersistenceServiceUnit psu, final long stepExecutionId, final BatchStatus newStepBatchStatus, final String newStepExitStatus, final Date endTime) throws IllegalArgumentException {
        StepThreadExecutionEntity stepThreadExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecutionOnRecovery", new Object[]{psu, stepExecutionId, newStepBatchStatus, newStepExitStatus, endTime});
            }
            em = psu.createEntityManager();
            StepThreadExecutionEntity stepThreadExecutionEntity2 = (StepThreadExecutionEntity)new TranRequest<StepThreadExecutionEntity>(em){
                static final long serialVersionUID = 3865180550617972669L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public StepThreadExecutionEntity call() {
                    StepThreadExecutionEntity stepExec = (StepThreadExecutionEntity)this.entityMgr.find(StepThreadExecutionEntity.class, (Object)stepExecutionId);
                    if (stepExec == null) {
                        throw new IllegalArgumentException("StepThreadExecEntity with id =" + stepExecutionId + " should be persisted at this point, but didn't find it.");
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyThreadStatusTransitionIsValid(stepExec, newStepBatchStatus);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$26", (String)"1892", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException((Throwable)e);
                    }
                    stepExec.setBatchStatus(newStepBatchStatus);
                    stepExec.setExitStatus(newStepExitStatus);
                    stepExec.setEndTime(endTime);
                    return stepExec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(26.class);
                }
            }.runInNewOrExistingGlobalTran();
            stepThreadExecutionEntity = stepThreadExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            stepThreadExecutionEntity = stepThreadExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecutionOnRecovery", stepThreadExecutionEntity);
        }
        return stepThreadExecutionEntity;
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TopLevelStepExecutionEntity updateStepExecutionWithPartitionAggregate(final RuntimeStepExecution runtimeStepExecution) {
        TopLevelStepExecutionEntity topLevelStepExecutionEntity;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecutionWithPartitionAggregate", new Object[]{runtimeStepExecution});
            }
            em = this.getPsu().createEntityManager();
            TopLevelStepExecutionEntity topLevelStepExecutionEntity2 = (TopLevelStepExecutionEntity)new TranRequest<TopLevelStepExecutionEntity>(em){
                static final long serialVersionUID = 5803877531380529865L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public TopLevelStepExecutionEntity call() {
                    TopLevelStepExecutionEntity stepExec = (TopLevelStepExecutionEntity)this.entityMgr.find(TopLevelStepExecutionEntity.class, (Object)runtimeStepExecution.getInternalStepThreadExecutionId());
                    if (stepExec == null) {
                        throw new IllegalArgumentException("StepThreadExecEntity with id =" + runtimeStepExecution.getInternalStepThreadExecutionId() + " should be persisted at this point, but didn't find.");
                    }
                    JPAPersistenceManagerImpl.this.updateStepExecutionStatusTimeStampsUserDataAndMetrics(stepExec, runtimeStepExecution);
                    for (StepThreadExecutionEntity stepThreadExec : stepExec.getTopLevelAndPartitionStepExecutions()) {
                        if (stepThreadExec instanceof TopLevelStepExecutionEntity) continue;
                        stepExec.addMetrics(stepThreadExec);
                    }
                    return stepExec;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(27.class);
                }
            }.runInNewOrExistingGlobalTran();
            topLevelStepExecutionEntity = topLevelStepExecutionEntity2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            topLevelStepExecutionEntity = topLevelStepExecutionEntity;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateStepExecutionWithPartitionAggregate", topLevelStepExecutionEntity);
        }
        return topLevelStepExecutionEntity;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregateFromJobExecutionId(long jobExecutionId, String stepName) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionId", new Object[]{jobExecutionId, stepName});
        }
        WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
        EntityManager em = this.getPsu().createEntityManager();
        TypedQuery query = em.createNamedQuery("TopLevelStepExecutionEntity.getAllRelatedStepThreadExecsByJobExecAndStepNameSortByPartNumAscQuery", StepThreadExecutionEntity.class);
        query.setParameter("jobExecId", (Object)jobExecutionId);
        query.setParameter("stepName", (Object)stepName);
        List stepExecs = query.getResultList();
        if (stepExecs == null || stepExecs.size() == 0) {
            throw new IllegalArgumentException("Didn't find any step thread exec entries at job execution id: " + jobExecutionId + ", and stepName: " + stepName);
        }
        try {
            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)stepExecs.get(0);
            retVal.setTopLevelStepExecution(topLevelStepExecution);
        }
        catch (ClassCastException topLevelStepExecution) {
            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"1961", (Object)this, (Object[])new Object[]{jobExecutionId, stepName});
            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at job execution id: " + jobExecutionId + ", and stepName: " + stepName);
        }
        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(stepExecs.subList(1, stepExecs.size())));
        WSStepThreadExecutionAggregateImpl wSStepThreadExecutionAggregateImpl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregateImpl = wSStepThreadExecutionAggregateImpl;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregateFromJobExecutionId", wSStepThreadExecutionAggregateImpl);
        }
        return wSStepThreadExecutionAggregateImpl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSStepThreadExecutionAggregate getStepExecutionAggregate(long topLevelStepExecutionId) throws IllegalArgumentException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregate", new Object[]{topLevelStepExecutionId});
        }
        WSStepThreadExecutionAggregateImpl retVal = new WSStepThreadExecutionAggregateImpl();
        EntityManager em = this.getPsu().createEntityManager();
        TypedQuery query = em.createNamedQuery("TopLevelStepExecutionEntity.getAllRelatedStepThreadExecsSortByPartNumAscQuery", StepThreadExecutionEntity.class);
        query.setParameter("topLevelStepExecutionId", (Object)topLevelStepExecutionId);
        List stepExecs = query.getResultList();
        if (stepExecs == null || stepExecs.size() == 0) {
            throw new IllegalArgumentException("Didn't find any step thread exec entries at id: " + topLevelStepExecutionId);
        }
        try {
            TopLevelStepExecutionEntity topLevelStepExecution = (TopLevelStepExecutionEntity)stepExecs.get(0);
            retVal.setTopLevelStepExecution(topLevelStepExecution);
        }
        catch (ClassCastException topLevelStepExecution) {
            void e;
            FFDCFilter.processException((Throwable)topLevelStepExecution, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", (String)"2005", (Object)this, (Object[])new Object[]{topLevelStepExecutionId});
            throw new IllegalArgumentException("Didn't find top-level step thread exec entry at id: " + topLevelStepExecutionId, (Throwable)e);
        }
        retVal.setPartitionLevelStepExecutions(new ArrayList<WSPartitionStepThreadExecution>(stepExecs.subList(1, stepExecs.size())));
        WSStepThreadExecutionAggregateImpl wSStepThreadExecutionAggregateImpl = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            wSStepThreadExecutionAggregateImpl = wSStepThreadExecutionAggregateImpl;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepExecutionAggregate", wSStepThreadExecutionAggregateImpl);
        }
        return wSStepThreadExecutionAggregateImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<StepExecution> getStepThreadExecutionsRunning(PersistenceServiceUnit psu, long jobExecutionId) {
        List list;
        EntityManager em;
        block7: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecutionsRunning", new Object[]{psu, jobExecutionId});
            }
            em = psu.createEntityManager();
            TypedQuery query = em.createNamedQuery("StepThreadExecutionEntity.getStepThreadExecutionsByJobExecIdAndStatusesQuery", StepExecution.class);
            query.setParameter("jobExecutionId", (Object)jobExecutionId);
            query.setParameter("status", (Object)RUNNING_STATUSES);
            List result = query.getResultList();
            if (result == null) {
                ArrayList<StepExecution> arrayList = new ArrayList<StepExecution>();
                ArrayList<StepExecution> arrayList2 = arrayList;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    arrayList2 = arrayList2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecutionsRunning", arrayList2);
                }
                return arrayList2;
            }
            List list2 = result;
            list = list2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block7;
            list = list;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getStepThreadExecutionsRunning", list);
        }
        return list;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void purgeInGlassfish(String submitter) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "purgeInGlassfish", new Object[]{submitter});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "purgeInGlassfish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean purgeJobInstanceAndRelatedData(long jobInstanceId) {
        boolean bl;
        EntityManager em;
        block5: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "purgeJobInstanceAndRelatedData", new Object[]{jobInstanceId});
            }
            em = this.getPsu().createEntityManager();
            final JobInstanceEntity instance = (JobInstanceEntity)em.find(JobInstanceEntity.class, (Object)jobInstanceId);
            if (instance == null) {
                throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
            }
            new TranRequest<Void>(em){
                static final long serialVersionUID = -2283347418144856444L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void call() {
                    this.entityMgr.remove((Object)instance);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(28.class);
                }
            }.runInNewOrExistingGlobalTran();
            boolean bl2 = true;
            bl = bl2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block5;
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "purgeJobInstanceAndRelatedData", bl);
        }
        return bl;
        finally {
            em.close();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void generate(Writer out) throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "generate", new Object[]{out});
        }
        PersistenceServiceUnit ddlGen = this.createLatestPsu();
        ddlGen.generateDDL(out);
        ddlGen.close();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "generate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getDDLFileName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getDDLFileName", new Object[0]);
        }
        String string = this.databaseStoreDisplayId + "_batchPersistence";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getDDLFileName", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JobInstance updateJobInstanceWithInstanceStateAndBatchStatus(final long jobInstanceId, final InstanceState state, final BatchStatus batchStatus, final Date lastUpdated) {
        JobInstance jobInstance;
        EntityManager em;
        block4: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceStateAndBatchStatus", new Object[]{jobInstanceId, state, batchStatus, lastUpdated});
            }
            em = this.getPsu().createEntityManager();
            JobInstance jobInstance2 = (JobInstance)new TranRequest<JobInstance>(em){
                static final long serialVersionUID = -8152339603160641801L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - void declaration
                 */
                @Override
                public JobInstance call() {
                    JobInstanceEntity instance = (JobInstanceEntity)this.entityMgr.find(JobInstanceEntity.class, (Object)jobInstanceId);
                    if (instance == null) {
                        throw new NoSuchJobInstanceException("No job instance found for id = " + jobInstanceId);
                    }
                    try {
                        JPAPersistenceManagerImpl.this.verifyStateTransitionIsValid(instance, state);
                    }
                    catch (BatchIllegalJobStatusTransitionException batchIllegalJobStatusTransitionException) {
                        void e;
                        FFDCFilter.processException((Throwable)batchIllegalJobStatusTransitionException, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$29", (String)"2454", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException((Throwable)e);
                    }
                    instance.setInstanceState(state);
                    instance.setBatchStatus(batchStatus);
                    instance.setLastUpdatedTime(lastUpdated);
                    return instance;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(29.class);
                }
            }.runInNewOrExistingGlobalTran();
            jobInstance = jobInstance2;
            if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
            jobInstance = jobInstance;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "updateJobInstanceWithInstanceStateAndBatchStatus", jobInstance);
        }
        return jobInstance;
        finally {
            em.close();
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobExecutionTableVersion() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionTableVersion", new Object[0]);
        }
        int n = this.getJobExecutionTableVersion(this.getPsu());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionTableVersion", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={PersistenceException.class})
    private int getJobExecutionTableVersion(PersistenceServiceUnit psu) throws Exception {
        int n;
        block11: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionTableVersion", new Object[]{psu});
            }
            if (this.executionVersion != null) {
                int n2 = this.executionVersion;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    n2 = n2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionTableVersion", n2);
                }
                return n2;
            }
            EntityManager em = psu.createEntityManager();
            try {
                String queryString = "SELECT COUNT(e.jobParameterElements) FROM JobExecutionEntityV2 e";
                TypedQuery query = em.createQuery(queryString, Long.class);
                query.getSingleResult();
                logger.fine("The JOBPARAMETER table exists, job execution table version = 2");
                this.executionVersion = 2;
                int n3 = this.executionVersion;
                n = n3;
                if (logger == null || !logger.isLoggable(Level.FINER)) break block11;
            }
            catch (PersistenceException e) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof SQLSyntaxErrorException) || cause.getMessage() == null || !cause.getMessage().contains("JOBPARAMETER")) continue;
                    logger.fine("The JOBPARAMETER table does not exist, job execution table version = 1");
                    this.executionVersion = 1;
                    int n4 = this.executionVersion;
                    int n5 = n4;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        n5 = n5;
                        logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionTableVersion", n5);
                    }
                    return n5;
                }
                logger.fine("Unexpected exception while checking job execution table version, re-throwing");
                throw e;
            }
            finally {
                em.close();
            }
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobExecutionTableVersion", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getJobInstanceTableVersion() throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceTableVersion", new Object[0]);
        }
        int n = this.getJobInstanceTableVersion(this.getPsu());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceTableVersion", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={PersistenceException.class})
    private int getJobInstanceTableVersion(PersistenceServiceUnit psu) throws Exception {
        int n;
        block11: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceTableVersion", new Object[]{psu});
            }
            if (this.instanceVersion != null) {
                int n2 = this.instanceVersion;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    n2 = n2;
                    logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceTableVersion", n2);
                }
                return n2;
            }
            EntityManager em = psu.createEntityManager();
            try {
                String queryString = "SELECT COUNT(x.lastUpdatedTime) FROM JobInstanceEntityV2 x";
                TypedQuery query = em.createQuery(queryString, Long.class);
                query.getSingleResult();
                logger.fine("The UPDATETIME column exists, job instance table version = 2");
                this.instanceVersion = 2;
                int n3 = this.instanceVersion;
                n = n3;
                if (logger == null || !logger.isLoggable(Level.FINER)) break block11;
            }
            catch (PersistenceException e) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof SQLSyntaxErrorException) || cause.getMessage() == null || !cause.getMessage().contains("UPDATETIME")) continue;
                    logger.fine("The UPDATETIME column does not exist, job instance table version = 1");
                    this.instanceVersion = 1;
                    int n4 = this.instanceVersion;
                    int n5 = n4;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        n5 = n5;
                        logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceTableVersion", n5);
                    }
                    return n5;
                }
                logger.fine("Unexpected exception while checking job instance table version, re-throwing");
                throw e;
            }
            finally {
                em.close();
            }
            n = n;
            logger.exiting("com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl", "getJobInstanceTableVersion", n);
        }
        return n;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private abstract class TranRequest<T> {
        EntityManager entityMgr;
        boolean newTran = false;
        private LocalTransactionCoordinator suspendedLTC;
        static final long serialVersionUID = 8000910619062293170L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public TranRequest(EntityManager em) {
            this.entityMgr = em;
        }

        /*
         * WARNING - void declaration
         */
        public T runInNewOrExistingGlobalTran() {
            T retVal = null;
            try {
                this.beginOrJoinTran();
                retVal = this.call();
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2335", (Object)this, (Object[])new Object[0]);
                this.rollbackIfNewTranWasStarted((Throwable)t);
            }
            this.commitIfNewTranWasStarted();
            return retVal;
        }

        public abstract T call();

        protected void beginOrJoinTran() throws SystemException, NotSupportedException {
            int tranStatus = JPAPersistenceManagerImpl.this.tranMgr.getStatus();
            if (tranStatus == 6) {
                logger.fine("Suspending current LTC and beginning new transaction");
                this.suspendedLTC = JPAPersistenceManagerImpl.this.localTranCurrent.suspend();
                JPAPersistenceManagerImpl.this.tranMgr.begin();
                this.newTran = true;
            } else {
                if (JPAPersistenceManagerImpl.this.tranMgr.getTransaction() == null) {
                    throw new IllegalStateException("Didn't find active transaction but tranStatus = " + tranStatus);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Joining existing tran: " + JPAPersistenceManagerImpl.this.tranMgr.getTransaction());
                }
            }
            this.entityMgr.joinTransaction();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void commitIfNewTranWasStarted() {
            if (!this.newTran) {
                logger.fine("Exiting without committing previously-active transaction.");
                return;
            }
            logger.fine("Committing new transaction we started.");
            try {
                JPAPersistenceManagerImpl.this.tranMgr.commit();
            }
            catch (Throwable t) {
                try {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2376", (Object)this, (Object[])new Object[0]);
                    throw new com.ibm.jbatch.container.exception.PersistenceException(t);
                }
                catch (Throwable throwable) {
                    try {
                        this.resumeAnyExistingLTC();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        void t2;
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2381", (Object)this, (Object[])new Object[0]);
                        throw new com.ibm.jbatch.container.exception.PersistenceException("Caught throwable on resume of previous LTC.  Might mask earlier throwable, so check logs.", (Throwable)t2);
                    }
                }
            }
            try {
                this.resumeAnyExistingLTC();
                return;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2381", (Object)this, (Object[])new Object[0]);
                throw new com.ibm.jbatch.container.exception.PersistenceException("Caught throwable on resume of previous LTC.  Might mask earlier throwable, so check logs.", (Throwable)t);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void rollbackIfNewTranWasStarted(Throwable caughtThrowable) throws com.ibm.jbatch.container.exception.PersistenceException {
            if (!this.newTran) {
                logger.fine("We didn't start a new transaction so simply let the exception get thrown back.");
                throw new com.ibm.jbatch.container.exception.PersistenceException(caughtThrowable);
            }
            logger.fine("Rollback new transaction we started.");
            try {
                JPAPersistenceManagerImpl.this.tranMgr.rollback();
            }
            catch (Throwable t2) {
                try {
                    void t1;
                    FFDCFilter.processException((Throwable)t2, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2395", (Object)this, (Object[])new Object[]{caughtThrowable});
                    throw new com.ibm.jbatch.container.exception.PersistenceException("Caught throwable on rollback after previous throwable: " + caughtThrowable, (Throwable)t1);
                }
                catch (Throwable throwable) {
                    try {
                        this.resumeAnyExistingLTC();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        void t22;
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2400", (Object)this, (Object[])new Object[]{caughtThrowable});
                        throw new com.ibm.jbatch.container.exception.PersistenceException("Caught throwable on resume of previous LTC.  Original throwable: " + caughtThrowable, (Throwable)t22);
                    }
                }
            }
            try {
                this.resumeAnyExistingLTC();
                throw new com.ibm.jbatch.container.exception.PersistenceException(caughtThrowable);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.jbatch.container.services.impl.JPAPersistenceManagerImpl$TranRequest", (String)"2400", (Object)this, (Object[])new Object[]{caughtThrowable});
                throw new com.ibm.jbatch.container.exception.PersistenceException("Caught throwable on resume of previous LTC.  Original throwable: " + caughtThrowable, (Throwable)t2);
            }
        }

        protected void resumeAnyExistingLTC() {
            if (this.suspendedLTC != null) {
                JPAPersistenceManagerImpl.this.localTranCurrent.resume(this.suspendedLTC);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(TranRequest.class);
        }
    }
}

