/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax;

import com.ibm.xml.xlxp2.api.stax.JavaXNamespaceContext;
import com.ibm.xml.xlxp2.api.stax.StAXImplProperties;
import com.ibm.xml.xlxp2.api.stax.XMLStreamReaderBase;
import com.ibm.xml.xlxp2.api.stax.events.CommentImpl;
import com.ibm.xml.xlxp2.api.stax.events.EntityDeclarationImpl;
import com.ibm.xml.xlxp2.api.stax.events.NotationDeclarationImpl;
import com.ibm.xml.xlxp2.api.stax.events.ProcessingInstructionImpl;
import com.ibm.xml.xlxp2.api.stax.events.XMLEventImpl;
import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.XMLReaderFactory;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class SAXStreamReaderImpl
extends XMLStreamReaderBase
implements ContentHandler,
DTDHandler,
EntityResolver,
ErrorHandler,
LexicalHandler,
DeclHandler {
    private static final String SAX_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final String SAX_DECL_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private static final String SAX_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String SAX_EXTERNAL_PARAMETER = "http://xml.org/sax/features/external-parameter-entities";
    private static final String SAX_EXTERNAL_GENERAL = "http://xml.org/sax/features/external-general-entities";
    private static final String SAX_IS_STANDALONE = "http://xml.org/sax/features/is-standalone";
    private static final String SAX_LOCATOR2 = "http://xml.org/sax/features/use-locator2";
    private static final String SAX_ATTRIBUTES2 = "http://xml.org/sax/features/use-attributes2";
    private StAXImplProperties fProperties;
    private JavaXNamespaceContext fNamespaceContext = new JavaXNamespaceContext();
    private XMLReader fParser;
    private XMLReader fOwnParser;
    private Exception fFailure;
    private Locator fLocator;
    private Attributes fAttributes;
    private boolean fHasLocator2;
    private boolean fHasAttributes2;
    private String fURI;
    private String fLocal;
    private String fQName;
    private String fTarget;
    private String fData;
    private boolean fStartDocumentEncountered;
    private StringBuilder fCoalescedCharacters;
    private char[] fChars;
    private int fStart;
    private int fLength;
    private String fTextContent;
    private boolean fSawNSDecl;
    private boolean fInCData;
    private boolean fInDTD;
    private boolean fInDTDExternalSubset;
    private boolean fSkippedEntity;
    private int fEntityDepth;
    private HashMap<String, String> fInternalEntityDecls;

    SAXStreamReaderImpl(InputSource inputSource, XMLReader xMLReader, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        this.fNSContext = this.fNamespaceContext;
        this.fCoalescedCharacters = new StringBuilder();
        this.fInternalEntityDecls = new HashMap();
        this.setSource(inputSource, xMLReader, stAXImplProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSource(final InputSource inputSource, XMLReader xMLReader, StAXImplProperties stAXImplProperties) throws XMLStreamException {
        if (xMLReader != null) {
            this.fParser = xMLReader;
        } else {
            if (this.fOwnParser == null) {
                try {
                    this.fOwnParser = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException sAXException) {
                    throw new XMLStreamException(sAXException);
                }
            }
            this.fParser = this.fOwnParser;
        }
        this.fProperties = stAXImplProperties;
        this.fNamespaceContext.reset();
        this.fStartDocumentEncountered = false;
        this.fInputEncoding = inputSource.getEncoding();
        try {
            this.fHasAttributes2 = this.fParser.getFeature(SAX_ATTRIBUTES2);
        }
        catch (Exception exception) {
            this.fHasAttributes2 = false;
        }
        try {
            this.fHasLocator2 = this.fParser.getFeature(SAX_LOCATOR2);
        }
        catch (Exception exception) {
            this.fHasLocator2 = false;
        }
        try {
            this.fParser.setContentHandler(this);
            this.fParser.setDTDHandler(this);
            this.fParser.setErrorHandler(this);
            this.fParser.setProperty(SAX_LEXICAL_HANDLER, this);
            this.fParser.setProperty(SAX_DECL_HANDLER, this);
            this.fParser.setFeature(SAX_NAMESPACES, this.fProperties.isNamespaceAware);
            if (this.fProperties.isReplacingEntityReferences) {
                this.fParser.setFeature(SAX_EXTERNAL_PARAMETER, this.fProperties.isSupportingExternalEntities);
                this.fParser.setFeature(SAX_EXTERNAL_GENERAL, this.fProperties.isSupportingExternalEntities);
            } else {
                this.fParser.setFeature(SAX_EXTERNAL_PARAMETER, false);
                this.fParser.setFeature(SAX_EXTERNAL_GENERAL, false);
            }
            if (this.fProperties.resolver != null) {
                this.fParser.setEntityResolver(this);
            }
            SAXStreamReaderImpl sAXStreamReaderImpl = this;
            synchronized (sAXStreamReaderImpl) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SAXStreamReaderImpl.this.fParser.parse(inputSource);
                        }
                        catch (StopParsing stopParsing) {
                        }
                        catch (SAXExceptionWrapper sAXExceptionWrapper) {
                            SAXStreamReaderImpl.this.fFailure = sAXExceptionWrapper.wrap;
                        }
                        catch (Exception exception) {
                            SAXStreamReaderImpl.this.fFailure = exception;
                        }
                        SAXStreamReaderImpl.this.fParser = null;
                        SAXStreamReaderImpl sAXStreamReaderImpl = SAXStreamReaderImpl.this;
                        synchronized (sAXStreamReaderImpl) {
                            SAXStreamReaderImpl.this.notify();
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int next() throws XMLStreamException {
        if (this.fFailure != null) {
            throw new XMLStreamException(this.fFailure);
        }
        if (!this.hasNext()) {
            StAXMessageProvider.throwNoSuchElementException(StAXMessageProvider.createMessage(null, 28));
        }
        if (this.fEventType == 2) {
            this.fNamespaceContext.endScope();
        }
        this.fCoalescedCharacters.setLength(0);
        this.fChars = null;
        this.fTextContent = null;
        SAXStreamReaderImpl sAXStreamReaderImpl = this;
        synchronized (sAXStreamReaderImpl) {
            try {
                this.notify();
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.fFailure != null) {
            throw new XMLStreamException(this.fFailure);
        }
        return this.fEventType;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.fEventType != 8 && this.fParser != null;
    }

    public synchronized void close() {
        this.endParsing();
        super.close();
        this.fNamespaceContext.reset();
        this.fFailure = null;
        this.fLocator = null;
        this.fAttributes = null;
        this.fCoalescedCharacters.setLength(0);
        this.fChars = null;
        this.fTextContent = null;
        this.fSawNSDecl = false;
        this.fInCData = false;
        this.fInDTD = false;
        this.fInDTDExternalSubset = false;
        this.fEntityDepth = 0;
        this.fSkippedEntity = false;
        this.fPoolableHelper.returnToPool();
    }

    public synchronized void endParsing() {
        if (this.fParser != null) {
            this.fParser = null;
            this.notify();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isWhiteSpace() {
        if (this.fEventType == 4) {
            String string = this.getText();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == '\n' || c == '\t' || c == '\r') continue;
                return false;
            }
            return true;
        }
        return this.fEventType == 6;
    }

    public String getAttributeValue(String string, String string2) {
        super.getAttributeValue(string, string2);
        if (this.fProperties.isNamespaceAware) {
            string = string == null ? "" : string;
            return this.fAttributes.getValue(string, string2);
        }
        return this.fAttributes.getValue(string2);
    }

    public int getAttributeCount() {
        super.getAttributeCount();
        return this.fAttributes.getLength();
    }

    public QName getAttributeName(int n) {
        super.getAttributeName(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.createQName(this.fAttributes.getURI(n), this.fAttributes.getLocalName(n), this.fAttributes.getQName(n));
    }

    public String getAttributeNamespace(int n) {
        super.getAttributeNamespace(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.fProperties.isNamespaceAware) {
            return null;
        }
        String string = this.fAttributes.getURI(n);
        return "".equals(string) ? null : string;
    }

    public String getAttributeLocalName(int n) {
        super.getAttributeLocalName(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.fAttributes.getLocalName(n);
    }

    public String getAttributePrefix(int n) {
        super.getAttributePrefix(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.fProperties.isNamespaceAware) {
            return null;
        }
        String string = this.getPrefix(this.fAttributes.getLocalName(n), this.fAttributes.getQName(n), true);
        return "".equals(string) ? null : string;
    }

    public String getAttributeType(int n) {
        super.getAttributeType(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        String string = this.fAttributes.getType(n);
        return string == null ? "CDATA" : string;
    }

    public String getAttributeValue(int n) {
        super.getAttributeValue(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.fAttributes.getValue(n);
    }

    public boolean isAttributeSpecified(int n) {
        super.isAttributeSpecified(n);
        if (n >= this.getAttributeCount()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.fHasAttributes2) {
            return ((Attributes2)this.fAttributes).isSpecified(n);
        }
        return true;
    }

    public int getNamespaceCount() {
        super.getNamespaceCount();
        return this.fNamespaceContext.getNamespaceCount();
    }

    public String getNamespacePrefix(int n) {
        super.getNamespacePrefix(n);
        String string = this.fNamespaceContext.getNamespacePrefix(n);
        return "".equals(string) ? null : string;
    }

    public String getNamespaceURI(int n) {
        super.getNamespaceURI(n);
        return this.fNamespaceContext.getNamespaceURI(n);
    }

    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            if (this.fTextContent == null) {
                this.fTextContent = this.fCoalescedCharacters.length() > 0 ? this.fCoalescedCharacters.toString() : new String(this.fChars, this.fStart, this.fLength);
            }
            return this.fTextContent;
        }
        if (this.fEventType == 9) {
            if (this.fSkippedEntity) {
                return null;
            }
            return this.fTextContent;
        }
        if (this.fEventType == 11) {
            return this.fTextContent;
        }
        StAXMessageProvider.throwIllegalStateException(StAXMessageProvider.createMessage(null, 19));
        return null;
    }

    public char[] getTextCharacters() {
        super.getTextCharacters();
        int n = this.getTextLength();
        char[] cArray = ArrayAllocator.newCharArray(n);
        try {
            this.getTextCharacters(0, cArray, 0, n);
            return cArray;
        }
        catch (XMLStreamException xMLStreamException) {
            return this.getText().toCharArray();
        }
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        super.getTextCharacters(n, cArray, n2, n3);
        int n4 = this.getTextLength();
        if (n4 < n + n3) {
            n3 = n4 - n;
        }
        if (this.fTextContent == null) {
            if (this.fCoalescedCharacters.length() > 0) {
                this.fCoalescedCharacters.getChars(n, n + n3, cArray, n2);
            } else {
                System.arraycopy(this.fChars, this.fStart + n, cArray, n2, n3);
            }
        } else {
            this.getText().getChars(n, n + n3, cArray, n2);
        }
        return n3;
    }

    public int getTextLength() {
        super.getTextLength();
        if (this.fTextContent == null) {
            if (this.fCoalescedCharacters.length() > 0) {
                return this.fCoalescedCharacters.length();
            }
            return this.fLength;
        }
        return this.fTextContent.length();
    }

    public Location getLocation() {
        if (this.fLocation != null) {
            return this.fLocation;
        }
        this.fLocation = new Location(){

            public int getLineNumber() {
                return SAXStreamReaderImpl.this.fLocator == null ? -1 : SAXStreamReaderImpl.this.fLocator.getLineNumber();
            }

            public int getColumnNumber() {
                return SAXStreamReaderImpl.this.fLocator == null ? -1 : SAXStreamReaderImpl.this.fLocator.getColumnNumber();
            }

            public int getCharacterOffset() {
                return -1;
            }

            public String getPublicId() {
                return SAXStreamReaderImpl.this.fLocator == null ? null : SAXStreamReaderImpl.this.fLocator.getPublicId();
            }

            public String getSystemId() {
                return SAXStreamReaderImpl.this.fLocator == null ? null : SAXStreamReaderImpl.this.fLocator.getSystemId();
            }
        };
        return this.fLocation;
    }

    public QName getName() {
        super.getName();
        return this.createQName(this.fURI, this.fLocal, this.fQName);
    }

    public String getLocalName() {
        super.getLocalName();
        return this.fLocal;
    }

    public String getNamespaceURI() {
        super.getNamespaceURI();
        if (!this.fProperties.isNamespaceAware) {
            return null;
        }
        return "".equals(this.fURI) ? null : this.fURI;
    }

    public String getPrefix() {
        super.getPrefix();
        if (!this.fProperties.isNamespaceAware) {
            return null;
        }
        return this.getPrefix(this.fLocal, this.fQName, false);
    }

    public boolean standaloneSet() {
        super.standaloneSet();
        return this.fStandalone;
    }

    public String getPITarget() {
        super.getPITarget();
        return this.fTarget;
    }

    public String getPIData() {
        super.getPIData();
        return this.fData;
    }

    private String getPrefix(String string, String string2, boolean bl) {
        int n = string.length();
        int n2 = string2.length();
        if (n2 == n) {
            return bl ? "" : null;
        }
        return string2.substring(0, n2 - n - 1);
    }

    private QName createQName(String string, String string2, String string3) {
        String string4 = this.getPrefix(string2, string3, true);
        return new QName(string, string2, string4);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        try {
            if (this.fProperties.reporter != null) {
                this.fProperties.reporter.report(sAXParseException.getLocalizedMessage(), "RECOVERABLE_ERROR", null, this.getLocation());
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXExceptionWrapper(xMLStreamException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        try {
            if (this.fProperties.reporter != null) {
                this.fProperties.reporter.report(sAXParseException.getLocalizedMessage(), "WARNING", null, this.getLocation());
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXExceptionWrapper(xMLStreamException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.inEntity()) {
            return;
        }
        if (this.fInDTD) {
            if (!this.fInDTDExternalSubset) {
                this.fCoalescedCharacters.append("<!--");
                if (n2 > 0) {
                    this.fCoalescedCharacters.append(cArray, n, n2);
                }
                this.fCoalescedCharacters.append("-->");
            }
            this.fCommentsInDTD.add(new CommentImpl(new String(cArray, n, n2)));
            return;
        }
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        this.fEventType = 5;
        this.fChars = cArray;
        this.fStart = n;
        this.fLength = n2;
        this.waitToBeConsumed();
    }

    public void endCDATA() throws SAXException {
        if (this.inEntity()) {
            return;
        }
        this.checkForPendingStartDocument();
        this.fInCData = false;
        if (!this.fProperties.isCoalescing) {
            this.fEventType = 12;
            this.waitToBeConsumed();
        }
    }

    public void endDTD() throws SAXException {
        this.checkForPendingStartDocument();
        this.fInDTD = false;
        this.fEventType = 11;
        this.fTextContent = this.fCoalescedCharacters.length() > 0 ? this.fCoalescedCharacters.toString() : null;
        this.waitToBeConsumed();
    }

    public void endEntity(String string) throws SAXException {
        if ("[dtd]".equals(string)) {
            this.fInDTDExternalSubset = false;
        }
        if (this.fInDTD) {
            return;
        }
        if (!this.fProperties.isReplacingEntityReferences) {
            --this.fEntityDepth;
        }
    }

    public void startCDATA() throws SAXException {
        this.checkForPendingStartDocument();
        if (this.inEntity()) {
            return;
        }
        if (this.fProperties.isCoalescing) {
            // empty if block
        }
        this.fInCData = true;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.checkForPendingStartDocument();
        this.fInDTD = true;
        this.fRootName = string;
        this.fPubId = string2;
        this.fSysId = string3;
    }

    public void startEntity(String string) throws SAXException {
        this.checkForPendingStartDocument();
        if ("[dtd]".equals(string)) {
            this.fInDTDExternalSubset = true;
        }
        if (this.fInDTD) {
            return;
        }
        if (!this.fProperties.isReplacingEntityReferences) {
            if (!this.inEntity()) {
                this.checkForCoalescedCharacters();
                this.fEventType = 9;
                this.fLocal = string;
                this.fTextContent = this.fInternalEntityDecls.get(string);
                this.waitToBeConsumed();
            }
            ++this.fEntityDepth;
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        try {
            Object object = this.fProperties.resolver.resolveEntity(string, string2, null, null);
            if (object instanceof InputStream) {
                return new InputSource((InputStream)object);
            }
            return null;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXExceptionWrapper(xMLStreamException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.inEntity()) {
            return;
        }
        this.checkForPendingStartDocument();
        if (this.fInCData || this.fProperties.isCoalescing) {
            this.fEventType = 4;
            this.fCoalescedCharacters.append(cArray, n, n2);
        } else {
            this.fCoalescedCharacters.setLength(0);
            this.fEventType = 4;
            this.fChars = cArray;
            this.fStart = n;
            this.fLength = n2;
            this.waitToBeConsumed();
        }
    }

    public void endDocument() throws SAXException {
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        this.fEventType = 8;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.inEntity()) {
            return;
        }
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        this.fEventType = 2;
        this.fURI = string;
        this.fLocal = string2;
        this.fQName = string3;
        this.waitToBeConsumed();
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.inEntity()) {
            return;
        }
        this.checkForPendingStartDocument();
        if (this.fInCData || this.fProperties.isCoalescing) {
            this.fEventType = 4;
            this.fCoalescedCharacters.append(cArray, n, n2);
        } else {
            this.fCoalescedCharacters.setLength(0);
            this.fEventType = 6;
            this.fChars = cArray;
            this.fStart = n;
            this.fLength = n2;
            this.waitToBeConsumed();
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.inEntity()) {
            return;
        }
        if (this.fInDTD) {
            if (!this.fInDTDExternalSubset) {
                this.fCoalescedCharacters.append("<?");
                this.fCoalescedCharacters.append(string);
                if (string2 != null && string2.length() > 0) {
                    this.fCoalescedCharacters.append(' ').append(string2);
                }
                this.fCoalescedCharacters.append("?>");
            }
            this.fPIsInDTD.add(new ProcessingInstructionImpl(string, string2));
            return;
        }
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        this.fEventType = 3;
        this.fTarget = string;
        this.fData = string2;
        this.waitToBeConsumed();
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.inEntity()) {
            return;
        }
        this.checkForPendingStartDocument();
        if (!this.fProperties.isReplacingEntityReferences) {
            this.fSkippedEntity = true;
            this.checkForCoalescedCharacters();
            this.fEventType = 9;
            this.fLocal = string;
            this.waitToBeConsumed();
            this.fSkippedEntity = false;
        }
    }

    public void startDocument() throws SAXException {
        this.fStartDocumentEncountered = true;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.inEntity()) {
            return;
        }
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        if (!this.fSawNSDecl) {
            this.fNamespaceContext.startScope();
        } else {
            this.fSawNSDecl = false;
        }
        this.fEventType = 1;
        this.fURI = string;
        this.fLocal = string2;
        this.fQName = string3;
        this.fAttributes = attributes;
        this.waitToBeConsumed();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.inEntity()) {
            return;
        }
        this.checkForPendingStartDocument();
        this.checkForCoalescedCharacters();
        if (!this.fSawNSDecl) {
            this.fNamespaceContext.startScope();
            this.fSawNSDecl = true;
        }
        this.fNamespaceContext.declareNamespace(string, string2);
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (!this.fInDTDExternalSubset) {
            this.fCoalescedCharacters.append("<!ENTITY ");
            if (string.startsWith("%")) {
                this.fCoalescedCharacters.append("% ");
                this.fCoalescedCharacters.append(string.substring(1));
            } else {
                this.fCoalescedCharacters.append(string);
            }
            this.fCoalescedCharacters.append(" \"");
            this.fCoalescedCharacters.append(XMLEventImpl.escape(string2, 15));
            this.fCoalescedCharacters.append("\">\n");
        }
        if (string.startsWith("%")) {
            return;
        }
        this.fInternalEntityDecls.put(string, string2);
        this.fEntityDecls.add(new EntityDeclarationImpl(string, string2));
    }

    public void elementDecl(String string, String string2) throws SAXException {
        if (!this.fInDTDExternalSubset) {
            this.fCoalescedCharacters.append("<!ELEMENT ");
            this.fCoalescedCharacters.append(string);
            this.fCoalescedCharacters.append(' ');
            this.fCoalescedCharacters.append(string2);
            this.fCoalescedCharacters.append(">\n");
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (!this.fInDTDExternalSubset) {
            this.fCoalescedCharacters.append("<!ATTLIST ");
            this.fCoalescedCharacters.append(string);
            this.fCoalescedCharacters.append(' ');
            this.fCoalescedCharacters.append(string2);
            this.fCoalescedCharacters.append(' ');
            this.fCoalescedCharacters.append(string3);
            if (string4 != null) {
                this.fCoalescedCharacters.append(' ');
                this.fCoalescedCharacters.append(string4);
            }
            if (string5 != null) {
                this.fCoalescedCharacters.append(" \"");
                this.fCoalescedCharacters.append(XMLEventImpl.escape(string5, 10));
                this.fCoalescedCharacters.append('\"');
            }
            this.fCoalescedCharacters.append(">\n");
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (!this.fInDTDExternalSubset) {
            this.fCoalescedCharacters.append("<!ENTITY ");
            if (string.startsWith("%")) {
                this.fCoalescedCharacters.append("% ");
                this.fCoalescedCharacters.append(string.substring(1));
            } else {
                this.fCoalescedCharacters.append(string);
            }
            if (string2 != null) {
                this.fCoalescedCharacters.append(" PUBLIC \"");
                this.fCoalescedCharacters.append(string2);
                this.fCoalescedCharacters.append("\" ");
            } else {
                this.fCoalescedCharacters.append(" SYSTEM ");
            }
            char c = string3.indexOf(39) == -1 ? (char)'\'' : '\"';
            this.fCoalescedCharacters.append(c);
            this.fCoalescedCharacters.append(string3);
            this.fCoalescedCharacters.append(c);
            this.fCoalescedCharacters.append(">\n");
        }
        if (string.startsWith("%")) {
            return;
        }
        this.fEntityDecls.add(new EntityDeclarationImpl(string, string2, string3));
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (!this.fInDTDExternalSubset) {
            this.fCoalescedCharacters.append("<!NOTATION ");
            this.fCoalescedCharacters.append(string);
            if (string2 != null) {
                this.fCoalescedCharacters.append(" PUBLIC \"");
                this.fCoalescedCharacters.append(string2);
                this.fCoalescedCharacters.append('\"');
            }
            if (string3 != null) {
                if (string2 != null) {
                    this.fCoalescedCharacters.append(' ');
                } else {
                    this.fCoalescedCharacters.append(" SYSTEM ");
                }
                char c = string3.indexOf(39) == -1 ? (char)'\'' : '\"';
                this.fCoalescedCharacters.append(c);
                this.fCoalescedCharacters.append(string3);
                this.fCoalescedCharacters.append(c);
            }
            this.fCoalescedCharacters.append(">\n");
        }
        this.fNotationDecls.add(new NotationDeclarationImpl(string, string2, string3));
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (!this.fInDTDExternalSubset) {
            this.fCoalescedCharacters.append("<!ENTITY ");
            this.fCoalescedCharacters.append(string);
            if (string2 != null) {
                this.fCoalescedCharacters.append(" PUBLIC \"");
                this.fCoalescedCharacters.append(string2);
                this.fCoalescedCharacters.append("\" ");
            } else {
                this.fCoalescedCharacters.append(" SYSTEM ");
            }
            char c = string3.indexOf(39) == -1 ? (char)'\'' : '\"';
            this.fCoalescedCharacters.append(c);
            this.fCoalescedCharacters.append(string3);
            this.fCoalescedCharacters.append(c);
            this.fCoalescedCharacters.append(" NDATA ");
            this.fCoalescedCharacters.append(string4);
            this.fCoalescedCharacters.append(">\n");
        }
        this.fEntityDecls.add(new EntityDeclarationImpl(string, string2, string3, string4));
    }

    private boolean inEntity() {
        return this.fEntityDepth > 0;
    }

    private synchronized void checkForPendingStartDocument() {
        if (this.fStartDocumentEncountered) {
            this.fEventType = 7;
            if (this.fHasLocator2) {
                this.fVersion = ((Locator2)this.fLocator).getXMLVersion();
                this.fInputEncoding = this.fXMLEncoding = ((Locator2)this.fLocator).getEncoding();
            } else {
                this.fVersion = null;
                this.fXMLEncoding = null;
            }
            try {
                this.fStandalone = this.fParser.getFeature(SAX_IS_STANDALONE);
            }
            catch (SAXException sAXException) {
                this.fStandalone = false;
            }
            this.fStartDocumentEncountered = false;
            this.waitToBeConsumed();
        }
    }

    private synchronized void waitToBeConsumed() {
        try {
            this.notify();
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.fParser == null) {
            throw new StopParsing();
        }
    }

    private synchronized void checkForCoalescedCharacters() {
        if (this.fCoalescedCharacters.length() > 0) {
            try {
                this.notify();
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.fParser == null) {
                throw new StopParsing();
            }
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class SAXExceptionWrapper
    extends SAXException {
        private static final long serialVersionUID = -1L;
        Exception wrap;

        private SAXExceptionWrapper(Exception exception) {
            this.wrap = exception;
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static final class StopParsing
    extends RuntimeException {
        private static final long serialVersionUID = -1L;

        private StopParsing() {
        }
    }
}

