/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.dtm;

import com.ibm.xml.xlxp2.api.sax.impl.SAX2ParsedEntityFactory;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.DTDScanner;
import com.ibm.xml.xlxp2.scan.DocumentScanner;
import com.ibm.xml.xlxp2.scan.msg.MessageProvider;
import com.ibm.xml.xlxp2.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp2.scan.util.AttrList;
import com.ibm.xml.xlxp2.scan.util.NSDeclList;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import com.ibm.xml.xlxp2.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp2.scan.util.QName;
import com.ibm.xml.xlxp2.scan.util.SymbolTable;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.IOException;
import org.xml.sax.InputSource;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XLXP2DTMParser
extends DocumentScanner {
    private final SAX2ParsedEntityFactory fEntityFactory;
    private DTDScanner fDTDScanner;
    private DTMHelper fDTMHelper;

    public XLXP2DTMParser() {
        this.fEntityFactory = new SAX2ParsedEntityFactory(this.fBufferFactory);
        this.fDTDScanner = new XLXPDTDScanner(this, this.fSymbolTable, this.fEntityFactory);
        this.setDTDSupport(this.fDTDScanner);
    }

    public void setDTMHelper(DTMHelper dTMHelper) {
        this.fDTMHelper = dTMHelper;
    }

    public boolean produceStartDocumentEvent() {
        boolean bl = super.produceStartDocumentEvent();
        this.fDTMHelper.startDocumentEvent();
        return bl;
    }

    public boolean produceEndDocumentEvent() {
        boolean bl = super.produceEndDocumentEvent();
        this.fDTMHelper.endDocumentEvent();
        return bl;
    }

    public boolean produceLeafElementEvent() {
        boolean bl = super.produceLeafElementEvent();
        this.fDTMHelper.startElementEvent(this.elementType, this, this, true, this.elementValue);
        return bl;
    }

    public boolean produceStartElementEvent() {
        boolean bl = super.produceStartElementEvent();
        this.fDTMHelper.startElementEvent(this.elementType, this, this, false, null);
        return bl;
    }

    public boolean produceEndElementEvent() {
        boolean bl = super.produceEndElementEvent();
        this.fDTMHelper.endElementEvent();
        return bl;
    }

    public boolean produceCharactersEvent() {
        boolean bl = super.produceCharactersEvent();
        this.fDTMHelper.charactersEvent(this.content, false);
        return bl;
    }

    public boolean produceCDATASectionEvent() {
        boolean bl = super.produceCDATASectionEvent();
        this.fDTMHelper.charactersEvent(this.content, true);
        return bl;
    }

    public boolean produceWhitespaceEvent() {
        boolean bl = super.produceWhitespaceEvent();
        this.fDTMHelper.charactersEvent(this.content, false);
        return bl;
    }

    public boolean produceCharacterEvent() {
        boolean bl = super.produceCharacterEvent();
        this.fDTMHelper.characterEvent(this.singleCh, false);
        return bl;
    }

    public boolean producePredefinedEntityEvent() {
        boolean bl = super.producePredefinedEntityEvent();
        this.fDTMHelper.characterEvent(this.singleCh, true);
        return bl;
    }

    public boolean produceProcessingInstructionEvent() {
        boolean bl = super.produceProcessingInstructionEvent();
        this.fDTMHelper.processingInstructionEvent(this.piTarget, this.content);
        return bl;
    }

    public boolean produceCommentEvent() {
        boolean bl = super.produceCommentEvent();
        this.fDTMHelper.commentEvent(this.content);
        return bl;
    }

    public boolean produceDoctypeEvent() {
        boolean bl = super.produceDoctypeEvent();
        this.fDTMHelper.doctypeEvent(this.rootElementType == null ? "" : this.rootElementType.toString(), this.publicID == null ? "" : this.publicID.toString(), this.systemID == null ? "" : this.systemID.toString(), this.internalSubset);
        return bl;
    }

    public boolean produceStartEntityEvent() {
        boolean bl = super.produceStartEntityEvent();
        this.fDTMHelper.startEntityEvent(this.entityName == null ? "" : this.entityName.toString(), this.fDTDScanner.inExternalEntity(), this.fDTDScanner.currentBaseURI());
        return bl;
    }

    public boolean produceEndEntityEvent() {
        boolean bl = super.produceEndEntityEvent();
        this.fDTMHelper.endEntityEvent(this.entityName == null ? "" : this.entityName.toString(), this.fDTDScanner.inExternalEntity(), this.fDTDScanner.currentBaseURI());
        return bl;
    }

    public boolean produceEntityReferenceEvent() {
        boolean bl = super.produceEntityReferenceEvent();
        this.fDTMHelper.entityReferenceEvent(this.entityName == null ? "" : this.entityName.toString(), this.fDTDScanner.inExternalEntity(), this.fDTDScanner.currentBaseURI());
        return bl;
    }

    public boolean produceWarningEvent() {
        boolean bl = super.produceWarningEvent();
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.errorURI);
        String string = messageProvider.createMessage(null, this.errorCode, this.errorParamStrings);
        this.fDTMHelper.reportWarning(string);
        return bl;
    }

    public boolean produceRecoverableErrorEvent() {
        boolean bl = super.produceRecoverableErrorEvent();
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.errorURI);
        String string = messageProvider.createMessage(null, this.errorCode, this.errorParamStrings);
        this.fDTMHelper.reportRecoverableError(string);
        return bl;
    }

    public boolean produceFatalErrorEvent() {
        boolean bl = super.produceFatalErrorEvent();
        MessageProvider messageProvider = MessageProviderRegistry.getMessageProvider(this.errorURI);
        String string = messageProvider.createMessage(null, this.errorCode, this.errorParamStrings);
        this.fDTMHelper.reportFatalError(string);
        return bl;
    }

    public void reset(boolean bl) {
        super.reset(bl);
        this.fEntityFactory.reset(bl);
        this.fDTDScanner.reset(bl);
        this.fDTMHelper = null;
    }

    public void parse(InputSource inputSource) throws IOException {
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntity(inputSource);
        this.parseDocumentEntity(parsedEntity);
    }

    private void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
        this.fDTMHelper.unparsedEntityDecl(null == xMLString ? "" : xMLString.toString(), null == xMLString2 ? "" : xMLString2.toString(), xMLString3.toString(), xMLString4.toString());
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class XLXPDTDScanner
    extends DTDScanner {
        public XLXPDTDScanner(DocumentScanner documentScanner, SymbolTable symbolTable, ParsedEntityFactory parsedEntityFactory) {
            super(documentScanner, symbolTable, parsedEntityFactory);
        }

        protected void unparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
            super.unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
            ((XLXP2DTMParser)this.fScanner).unparsedEntityDecl(xMLString, xMLString2, xMLString3, xMLString4);
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2010. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static interface DTMHelper {
        public void startDocumentEvent();

        public void endDocumentEvent();

        public void startElementEvent(QName var1, NSDeclList var2, AttrList var3, boolean var4, XMLString var5);

        public void endElementEvent();

        public void charactersEvent(XMLString var1, boolean var2);

        public void characterEvent(int var1, boolean var2);

        public void processingInstructionEvent(XMLString var1, XMLString var2);

        public void commentEvent(XMLString var1);

        public void doctypeEvent(String var1, String var2, String var3, boolean var4);

        public void startEntityEvent(String var1, boolean var2, String var3);

        public void endEntityEvent(String var1, boolean var2, String var3);

        public void entityReferenceEvent(String var1, boolean var2, String var3);

        public void reportWarning(String var1);

        public void reportRecoverableError(String var1);

        public void reportFatalError(String var1);

        public void unparsedEntityDecl(String var1, String var2, String var3, String var4);
    }
}

