/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fcg.impl;

import com.ibm.fcg.FcgArrayType;
import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgBinOp;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgField;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgInterfaceType;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgReferenceType;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.FcgUnaryOp;
import com.ibm.fcg.FcgVariable;
import com.ibm.fcg.ifacecore.FcgBasicType;
import com.ibm.fcg.ifacecore.FcgVarMutableInternal;
import com.ibm.fcg.impl.FcgClassGenImpl;
import com.ibm.fcg.impl.FcgFieldGenImpl;
import com.ibm.fcg.impl.FcgRuntimeException;
import com.ibm.fcg.impl.HiddenOptions;
import com.ibm.fcg.javasrc.FcgClassGenJavaSrc;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class FinalCodeGenerator
implements FcgInstructionList {
    private static final String FCG_COMPILE_TIME_CHECKING = "fcg.compile.check";
    public static final boolean DO_COMPILE_CHECKING = !HiddenOptions.optionValueIs("fcg.compile.check", "off");
    final FcgClassGen m_classGen;
    final FcgMethodGen m_method;
    protected final CodeGenStack m_codeGenerationStack = new CodeGenStack();
    private int m_nonValueConstructsOnStack = 0;
    private final LocalVarStack m_varStack = new LocalVarStack();
    private static final boolean debug_reset = System.getProperty("com.ibm.fcg.options.stackreset", "false").compareToIgnoreCase("true") == 0;
    private static final Construct UNDEFINED = new Construct("UNDEFINED");
    private static final Construct CLASS = new Construct("CLASS");
    private static final Construct METHOD = new Construct("METHOD");
    private static final Construct IF = new Construct("IF");
    private static final Construct ELSE = new Construct("ELSE");
    private static final Construct TRYBLOCK = new Construct("TRY");
    private static final Construct CATCHBLOCK = new Construct("CATCH");
    private static final Construct SCOPEBLOCK = new Construct("SCOPE");
    private static final Construct CHOOSE = new Construct("CHOOSE");
    private static final Construct CHOOSEBLOCK = new Construct("CHOOSEBLOCK");
    protected static final Construct LOOP = new Construct("LOOP");
    private static final Construct VALUE = new Construct("VALUE");
    private static final Construct VAR_SCOPE = new Construct("LOC_VAR_SCOPE");
    private ArrayList m_comments = new ArrayList();
    private boolean m_endMethodWasCalled = false;
    private FcgMethodGen m_beginMethod2;
    protected int m_loopCount = 0;
    public static final FcgBasicType INT_LITERAL = new FcgBasicType("int literal");

    protected FinalCodeGenerator(FcgClassGen fcgClassGen) {
        this.m_classGen = fcgClassGen;
        this.m_method = null;
    }

    protected FinalCodeGenerator(FcgClassGen fcgClassGen, FcgMethodGen fcgMethodGen) {
        this.m_classGen = fcgClassGen;
        this.m_method = fcgMethodGen;
    }

    private void push(Construct construct) {
        this.m_codeGenerationStack.push(construct, null, null, this.m_varStack.numLocalVars());
        this.increaseConstructCount(construct);
    }

    private void push(Construct construct, FcgType fcgType, Object object) {
        if (DO_COMPILE_CHECKING && this.m_endMethodWasCalled) {
            FinalCodeGenerator.error("FCG: trying to add code after endMethod() was already called on an FcgInstructionList");
        }
        this.m_codeGenerationStack.push(construct, fcgType, object, this.m_varStack.numLocalVars());
        this.increaseConstructCount(construct);
    }

    private StackValue peek() {
        return this.m_codeGenerationStack.peek();
    }

    private StackValue peek(int n) {
        return this.m_codeGenerationStack.peek(n);
    }

    private StackValue pop(Construct construct) {
        if (construct == null) {
            construct = this.peek().m_constructKind;
        }
        this.decreaseConstructCount(construct);
        return this.m_codeGenerationStack.pop(construct);
    }

    private void increaseConstructCount(Construct construct) {
        if (construct != VALUE) {
            ++this.m_nonValueConstructsOnStack;
        }
    }

    private void decreaseConstructCount(Construct construct) {
        if (construct != VALUE) {
            --this.m_nonValueConstructsOnStack;
        }
    }

    protected final int getActiveNonValueConstructsCount() {
        return this.m_nonValueConstructsOnStack;
    }

    public final void comment(String string) {
        if (((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getSupressComments()) {
            return;
        }
        StackValue stackValue = this.peek();
        if (stackValue != null && stackValue.getConstructKind() == VALUE) {
            this.cacheComment(string);
            return;
        }
        this.clearCachedComments();
        this.genCode_comment(string);
    }

    private void cacheComment(String string) {
        this.m_comments.add(string);
    }

    private void clearCachedComments() {
        int n = this.m_comments.size();
        while (n-- > 0) {
            String string = (String)this.m_comments.get(0);
            this.genCode_comment(string);
            this.m_comments.remove(0);
        }
    }

    protected abstract void genCode_comment(String var1);

    public final FcgVariable defineVar(FcgType fcgType, String string, boolean bl) {
        StackValue stackValue = this.peek();
        if (fcgType == null) {
            fcgType = stackValue.getType();
        }
        FcgAttrs fcgAttrs = FcgAttrs.NONE;
        FcgVariable fcgVariable = this.m_varStack.push(string, fcgType, fcgAttrs);
        if (!bl || stackValue == null || stackValue.getType() == FcgBasicType.VOID) {
            StackValue stackValue2 = stackValue;
            this.genCode_defineLocalVariable(stackValue2, fcgVariable, null);
        } else {
            FcgType fcgType2 = stackValue.getType();
            if (fcgType != null && fcgType2 != fcgType) {
                this.convertExpr(fcgType2, fcgType);
            }
            StackValue stackValue3 = this.pop(VALUE);
            StackValue stackValue4 = null;
            this.genCode_defineLocalVariable(stackValue4, fcgVariable, stackValue3);
            stackValue3.reset();
        }
        this.clearCachedComments();
        return fcgVariable;
    }

    public final FcgVariable defineMethodParam(FcgAttrs fcgAttrs, FcgType fcgType, String string) {
        FcgVariable fcgVariable = this.m_varStack.push(string, fcgType, fcgAttrs);
        return fcgVariable;
    }

    private final FcgVariable defineCatchClauseParam(String string, FcgType fcgType, FcgAttrs fcgAttrs) {
        FcgVariable fcgVariable = this.defineVar(fcgType, string, false);
        return fcgVariable;
    }

    protected abstract void genCode_defineLocalVariable(StackValue var1, FcgVariable var2, StackValue var3);

    private void undefinelVar() {
        StackValue stackValue = this.peek();
        FcgVariable fcgVariable = this.m_varStack.peek();
        this.genCode_undefineLocalVariable(stackValue, fcgVariable);
        this.m_varStack.pop(fcgVariable.getName());
    }

    protected abstract void genCode_undefineLocalVariable(StackValue var1, FcgVariable var2);

    public final FcgVariable defineConstVar(FcgType fcgType, String string) {
        StackValue stackValue = this.peek();
        if (fcgType == null) {
            fcgType = stackValue.getType();
        }
        FcgAttrs fcgAttrs = FcgAttrs.FINAL;
        FcgVariable fcgVariable = this.m_varStack.push(string, fcgType, fcgAttrs);
        if (stackValue == null || stackValue.getType() == FcgBasicType.VOID) {
            StackValue stackValue2 = stackValue;
            this.genCode_defineLocalVariable(stackValue2, fcgVariable, null);
        } else {
            StackValue stackValue3 = this.pop(VALUE);
            FcgType fcgType2 = stackValue3.getType();
            if (DO_COMPILE_CHECKING && !FinalCodeGenerator.canConvert(fcgType2, fcgType)) {
                FinalCodeGenerator.error("FCG: defineConstVar() can't convert the type of the value: " + fcgType2 + ", to the type of the variable: " + fcgType);
            }
            StackValue stackValue4 = null;
            this.genCode_defineLocalVariable(stackValue4, fcgVariable, stackValue3);
            stackValue3.reset();
        }
        this.clearCachedComments();
        return fcgVariable;
    }

    public final void endMethod() {
        StackValue stackValue = this.pop(METHOD);
        this.undeclareLocals(stackValue);
        StackValue stackValue2 = this.peek();
        this.genCode_endMethod(stackValue2, stackValue);
        stackValue.reset();
        this.m_varStack.m_freeIndex = 0;
        FcgMethodGen fcgMethodGen = this.getMethod();
        FcgInstructionList fcgInstructionList = fcgMethodGen.getInstructionList();
        FcgClassGen fcgClassGen = fcgInstructionList.getFcgClassGen();
        ((FcgClassGenImpl)fcgClassGen).addMethod(fcgMethodGen);
        this.clearCachedComments();
        this.setMethod(null);
        this.m_endMethodWasCalled = true;
    }

    protected abstract void genCode_endMethod(StackValue var1, StackValue var2);

    protected abstract void genCode_endClass(StackValue var1);

    public final FcgType loadInstanceField(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType) {
        StackValue stackValue;
        try {
            stackValue = this.pop(VALUE);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("FCG: loadInstanceField() failed, perhaps no object, whose instance field is being loaded, was pushed on the FCG stack.");
            System.err.flush();
            throw runtimeException;
        }
        Object object = this.genCode_loadInstanceField(stackValue, fcgClassReferenceType, string, fcgType);
        stackValue.reset();
        this.push(VALUE, fcgType, object);
        return fcgType;
    }

    protected abstract Object genCode_loadInstanceField(StackValue var1, FcgClassReferenceType var2, String var3, FcgType var4);

    public final void storeInstanceFieldStmt(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType) {
        FcgType fcgType2 = this.peek().getType();
        if (fcgType != null && fcgType2 != fcgType) {
            this.convertExpr(fcgType2, fcgType);
        }
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        String string2 = fcgClassReferenceType != null ? fcgClassReferenceType.getTypeName() : this.m_classGen.getClassType().getTypeName();
        this.genCode_storeInstanceVariableStmt(stackValue2, string2, string, fcgType, stackValue);
        stackValue.reset();
        stackValue2.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeInstanceVariableStmt(StackValue var1, String var2, String var3, FcgType var4, StackValue var5);

    public final FcgVariable findVar(String string) {
        return this.findFcgVariable2(string);
    }

    public FcgType loadVar(FcgVariable fcgVariable) {
        FcgType fcgType = fcgVariable.getType();
        if (fcgType != FcgType.VOID) {
            this.push(VALUE, fcgType, this.genCode_loadLocalVariable(fcgVariable));
        }
        return fcgType;
    }

    public final FcgClassReferenceType loadThis() {
        if (DO_COMPILE_CHECKING && this.isClassContext()) {
            FinalCodeGenerator.error("FCG: Can't generate a load of 'this' in a class (static) method.");
        }
        Object object = this.genCode_loadThis();
        String string = this.m_classGen.getClassType().getTypeName();
        FcgClassReferenceType fcgClassReferenceType = ((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getClassReferenceType(string);
        this.push(VALUE, fcgClassReferenceType, object);
        return fcgClassReferenceType;
    }

    protected abstract Object genCode_loadThis();

    public final FcgType loadNull() {
        Object object = this.genCode_loadNull();
        this.push(VALUE, FcgType.OBJECT, object);
        return FcgType.OBJECT;
    }

    protected abstract Object genCode_loadNull();

    protected abstract Object genCode_loadClassRef(String var1);

    protected abstract Object genCode_loadLocalVariable(FcgVariable var1);

    public final FcgType loadArrayElement(FcgType fcgType) {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        Object object = this.genCode_loadFromArrayElement(stackValue2, stackValue, fcgType);
        stackValue.reset();
        stackValue2.reset();
        this.push(VALUE, fcgType, object);
        return fcgType;
    }

    protected abstract Object genCode_loadFromArrayElement(StackValue var1, StackValue var2, FcgType var3);

    public final FcgType loadLiteral(boolean bl) {
        this.push(VALUE, FcgBasicType.BOOLEAN, this.genCode_loadLiteralValue(bl));
        return FcgBasicType.BOOLEAN;
    }

    protected abstract Object genCode_loadLiteralValue(boolean var1);

    public final FcgType loadLiteral(long l) {
        this.push(VALUE, FcgBasicType.LONG, this.genCode_loadLiteralValue(l));
        return FcgBasicType.LONG;
    }

    protected abstract Object genCode_loadLiteralValue(long var1);

    public final FcgType loadLiteral(int n) {
        this.push(VALUE, INT_LITERAL, this.genCode_loadLiteralValue(n));
        StackValue stackValue = this.peek();
        stackValue.setLiteralValue(n);
        return FcgType.INT;
    }

    protected abstract Object genCode_loadLiteralValue(int var1);

    public final FcgType loadLiteral(short s) {
        this.push(VALUE, FcgBasicType.SHORT, this.genCode_loadLiteralValue(s));
        return FcgBasicType.SHORT;
    }

    protected abstract Object genCode_loadLiteralValue(short var1);

    public final FcgType loadLiteral(byte by) {
        this.push(VALUE, FcgBasicType.BYTE, this.genCode_loadLiteralValue(by));
        return FcgBasicType.BYTE;
    }

    protected abstract Object genCode_loadLiteralValue(byte var1);

    public final FcgType loadLiteral(char c) {
        this.push(VALUE, FcgBasicType.CHAR, this.genCode_loadLiteralValue(c));
        return FcgBasicType.CHAR;
    }

    protected abstract Object genCode_loadLiteralValue(char var1);

    public final FcgType loadLiteral(String string) {
        this.push(VALUE, FcgBasicType.STRING, this.genCode_loadLiteralValue(string));
        return FcgBasicType.STRING;
    }

    protected abstract Object genCode_loadLiteralValue(String var1);

    public final FcgType loadLiteral(float f) {
        this.push(VALUE, FcgBasicType.FLOAT, this.genCode_loadLiteralValue(f));
        return FcgBasicType.FLOAT;
    }

    protected abstract Object genCode_loadLiteralValue(float var1);

    public final FcgType loadLiteral(double d) {
        this.push(VALUE, FcgBasicType.DOUBLE, this.genCode_loadLiteralValue(d));
        return FcgBasicType.DOUBLE;
    }

    protected abstract Object genCode_loadLiteralValue(double var1);

    public final FcgType invokeInstanceMethod(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType, int n) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(true, bl, fcgClassReferenceType, string, fcgType, n, null);
        return fcgType;
    }

    public final FcgType invokeInstanceMethod(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(true, bl, fcgClassReferenceType, string, fcgType, fcgTypeArray.length, fcgTypeArray);
        return fcgType;
    }

    public final FcgType invokeInstanceMethodStmt(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType, int n) {
        boolean bl = false;
        this.invokeMethod(true, bl, fcgClassReferenceType, string, fcgType, n, null);
        return FcgType.VOID;
    }

    public final FcgType invokeInterfaceMethod(FcgInterfaceType fcgInterfaceType, String string, FcgType fcgType, int n) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(true, bl, fcgInterfaceType, string, fcgType, n, null);
        return fcgType;
    }

    public final FcgType invokeInterfaceMethod(FcgInterfaceType fcgInterfaceType, String string, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(true, bl, fcgInterfaceType, string, fcgType, fcgTypeArray.length, fcgTypeArray);
        return fcgType;
    }

    public final FcgType invokeInterfaceMethodStmt(FcgInterfaceType fcgInterfaceType, String string, FcgType fcgType, int n) {
        boolean bl = false;
        this.invokeMethod(true, bl, fcgInterfaceType, string, fcgType, n, null);
        return FcgType.VOID;
    }

    public final FcgType invokeClassMethod(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType, int n) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(false, bl, fcgClassReferenceType, string, fcgType, n, null);
        return fcgType;
    }

    public final FcgType invokeClassMethod(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType, FcgType[] fcgTypeArray) {
        boolean bl = fcgType != FcgType.VOID;
        this.invokeMethod(false, bl, fcgClassReferenceType, string, fcgType, fcgTypeArray.length, fcgTypeArray);
        return fcgType;
    }

    public final FcgType invokeClassMethodStmt(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType, int n) {
        boolean bl = false;
        boolean bl2 = false;
        this.invokeMethod(bl2, bl, fcgClassReferenceType, string, fcgType, n, null);
        return FcgType.VOID;
    }

    public final void printOut() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        this.genCode_printOut(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_printOut(StackValue var1, StackValue var2);

    public final void throwObject() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        this.genCode_throwObject(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_throwObject(StackValue var1, StackValue var2);

    public final void printErr() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        this.genCode_printErr(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_printErr(StackValue var1, StackValue var2);

    public void storeVar(FcgVariable fcgVariable) {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.peek();
        FcgType fcgType = fcgVariable.getType();
        FcgType fcgType2 = stackValue.getType();
        this.genCode_storeLocalVariableStmt(stackValue2, fcgVariable, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeLocalVariableStmt(StackValue var1, FcgVariable var2, StackValue var3);

    public final FcgType storeAndReloadVarExpr(FcgVariable fcgVariable) {
        StackValue stackValue = this.pop(VALUE);
        FcgType fcgType = stackValue.getType();
        StackValue stackValue2 = this.peek();
        Object object = this.genCode_storeLocalVariableExpr(stackValue2, fcgVariable, stackValue);
        stackValue.reset();
        this.push(VALUE, fcgType, object);
        return fcgType;
    }

    protected abstract Object genCode_storeLocalVariableExpr(StackValue var1, FcgVariable var2, StackValue var3);

    public FcgType preIncrementAndLoadLocalVariable(FcgVariable fcgVariable) {
        StackValue stackValue = this.peek();
        Object object = this.genCode_preIncrementAndLoadLocalVariable(stackValue, fcgVariable);
        FcgType fcgType = fcgVariable.getType();
        this.push(VALUE, fcgType, object);
        return fcgType;
    }

    protected abstract Object genCode_preIncrementAndLoadLocalVariable(StackValue var1, FcgVariable var2);

    public void incrementVarStmt(FcgVariable fcgVariable) {
        StackValue stackValue = this.peek();
        this.genCode_incrementLocalVarStmt(stackValue, fcgVariable);
    }

    protected abstract void genCode_incrementLocalVarStmt(StackValue var1, FcgVariable var2);

    public final void storeAtStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        StackValue stackValue3 = this.peek();
        this.genCode_storeAt(stackValue3, stackValue2, stackValue);
        stackValue2.reset();
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeAt(StackValue var1, StackValue var2, StackValue var3);

    public final void beginConditionalLoop(String string, int n) {
        StackValue stackValue = 2 == n ? this.pop(VALUE) : null;
        StackValue stackValue2 = 1 <= n ? this.pop(VALUE) : null;
        FcgType fcgType = stackValue == null ? FcgBasicType.VOID : stackValue.getType();
        Object object = this.genCode_startConditionalLoop(string, stackValue2, stackValue);
        if (stackValue2 != null) {
            stackValue2.reset();
        }
        if (stackValue != null) {
            stackValue.reset();
        }
        this.push(LOOP, fcgType, object);
        this.clearCachedComments();
    }

    protected abstract Object genCode_startConditionalLoop(String var1, StackValue var2, StackValue var3);

    public final void endConditionalLoop() {
        StackValue stackValue = this.pop(LOOP);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_endLoop(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endLoop(StackValue var1, StackValue var2);

    public final void breakFromLoop() {
        this.breakFromLoop(1);
        this.clearCachedComments();
    }

    public final void breakFromLoop(int n) {
        StackValue stackValue = this.getNthEnclosingLoop(n);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_breakFromLoop(stackValue2, stackValue);
        this.clearCachedComments();
    }

    protected abstract void genCode_breakFromLoop(StackValue var1, StackValue var2);

    public final void nextIterationOfLoop() {
        this.nextIterationOfLoop(1);
    }

    public final void nextIterationOfLoop(int n) {
        StackValue stackValue = this.getNthEnclosingLoop(n);
        StackValue stackValue2 = this.peek();
        this.genCode_nextIterationOfLoop(stackValue2, stackValue);
    }

    protected abstract void genCode_nextIterationOfLoop(StackValue var1, StackValue var2);

    private StackValue getNthEnclosingLoop(int n) {
        int n2 = this.m_codeGenerationStack.size();
        StackValue stackValue = null;
        for (int i = 0; i < n2 && n != 0; ++i) {
            stackValue = this.peek(i);
            if (stackValue.getConstructKind() != LOOP) continue;
            --n;
        }
        if (DO_COMPILE_CHECKING && n != 0) {
            FinalCodeGenerator.error("FCG: Requested break or continue from non-existent loop depth " + n);
        }
        return stackValue;
    }

    public final void beginSwitch() {
        StackValue stackValue = this.pop(VALUE);
        Object object = this.genCode_beginChoice(stackValue);
        stackValue.reset();
        this.push(CHOOSE, FcgBasicType.VOID, object);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoice(StackValue var1);

    public final void beginSwitchCaseBlock(int n) {
        StackValue stackValue = this.peek();
        Object object = this.genCode_beginChoiceBlock(n, stackValue);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, object);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlock(int var1, StackValue var2);

    public final void beginSwitchCaseBlock(char c) {
        StackValue stackValue = this.peek();
        Object object = this.genCode_beginChoiceBlock(c, stackValue);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, object);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlock(char var1, StackValue var2);

    public final void beginSwitchDefaultBlock() {
        StackValue stackValue = this.peek();
        Object object = this.genCode_beginChoiceBlockDefault(stackValue);
        this.push(CHOOSEBLOCK, FcgBasicType.VOID, object);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginChoiceBlockDefault(StackValue var1);

    public final void endSwitchCaseBlock() {
        this.endSwitchCaseBlock(true);
    }

    public final void endSwitchCaseBlockFallThru() {
        this.endSwitchCaseBlock(false);
    }

    private final void endSwitchCaseBlock(boolean bl) {
        StackValue stackValue = this.pop(CHOOSEBLOCK);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_endChoiceBlock(stackValue2, stackValue, bl);
        stackValue.reset();
        this.clearCachedComments();
    }

    public final void endSwitchDefaultBlock() {
        this.endSwitchDefaultBlock(true);
    }

    public final void endSwitchDefaultBlockFallThru() {
        this.endSwitchDefaultBlock(false);
    }

    private final void endSwitchDefaultBlock(boolean bl) {
        this.endSwitchCaseBlock(bl);
    }

    protected abstract Object genCode_endChoiceBlock(StackValue var1, StackValue var2, boolean var3);

    public final void endSwitch() {
        StackValue stackValue = this.pop(CHOOSE);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_endChoice(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endChoice(StackValue var1, StackValue var2);

    public final FcgType unaryOperationExpr(FcgUnaryOp fcgUnaryOp) {
        StackValue stackValue = this.pop(VALUE);
        FcgType fcgType = this.getUnaryExprType(fcgUnaryOp, stackValue.getType());
        Object object = this.genCode_unaryOperation(fcgUnaryOp, stackValue, fcgType);
        stackValue.reset();
        this.push(VALUE, fcgType, object);
        return fcgType;
    }

    private FcgType getUnaryExprType(FcgUnaryOp fcgUnaryOp, FcgType fcgType) {
        FcgType fcgType2;
        if (fcgType == INT_LITERAL) {
            fcgType = FcgType.INT;
        }
        int n = ((Operation2)((Object)fcgUnaryOp)).getFcgOpCode();
        switch (n) {
            case 106: {
                if (fcgType == FcgType.BYTE) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                fcgType2 = fcgType;
                break;
            }
            case 1130: {
                if (fcgType == FcgType.BYTE) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                fcgType2 = fcgType;
                break;
            }
            case 201: {
                fcgType2 = FcgType.BOOLEAN;
                break;
            }
            case 300: {
                if (fcgType == FcgType.BYTE || fcgType == INT_LITERAL) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                fcgType2 = fcgType;
                break;
            }
            case 301: {
                if (fcgType == FcgType.FLOAT) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                if (fcgType == FcgType.DOUBLE) {
                    fcgType2 = FcgType.LONG;
                    break;
                }
                if (fcgType == FcgType.INT || fcgType == INT_LITERAL) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                if (fcgType == FcgType.BYTE) {
                    fcgType2 = FcgType.INT;
                    break;
                }
                if (fcgType == FcgType.LONG) {
                    fcgType2 = FcgType.LONG;
                    break;
                }
                if (fcgType == FcgType.BIG_INTEGER) {
                    fcgType2 = FcgType.BIG_INTEGER;
                    break;
                }
                if (fcgType == FcgType.BIG_DECIMAL) {
                    fcgType2 = FcgType.BIG_DECIMAL;
                    break;
                }
                throw new UnsupportedOperationException("FinalCodeGenerator:  round has an unsupported arg type: " + fcgType);
            }
            case 302: 
            case 303: {
                if (fcgType == FcgType.DOUBLE || fcgType == FcgType.FLOAT || fcgType == FcgType.BYTE || fcgType == FcgType.LONG || fcgType == FcgType.INT) {
                    fcgType2 = FcgType.DOUBLE;
                    break;
                }
                throw new UnsupportedOperationException("FinalCodeGenerator, ceiling or floor has an unsupported arg type: " + fcgType);
            }
            case 305: {
                fcgType2 = FcgType.BOOLEAN;
                break;
            }
            case 306: {
                fcgType2 = FcgType.INT;
                break;
            }
            case 307: {
                fcgType2 = FcgType.CHAR_ARRAY;
                break;
            }
            case 308: {
                fcgType2 = FcgType.CHAR_ARRAY;
                break;
            }
            default: {
                Object var4_5 = null;
                throw new UnsupportedOperationException("FinalCodeGenerator, UNARY_HEX_ESCAPE, has an unsupported op: " + n);
            }
        }
        return fcgType2;
    }

    public final FcgType binaryOperationExpr(FcgBinOp fcgBinOp) {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        FcgType fcgType = this.getBinaryExprType(fcgBinOp, stackValue2.getType(), stackValue.getType());
        Object object = this.genCode_binaryOperation(fcgBinOp, stackValue2, stackValue, fcgType);
        stackValue.reset();
        stackValue2.reset();
        this.push(VALUE, fcgType, object);
        StackValue stackValue3 = this.pop(VALUE);
        Object object2 = this.genCode_coerce(fcgType, fcgType, stackValue3);
        stackValue3.reset();
        this.push(VALUE, fcgType, object2);
        return fcgType;
    }

    private FcgType getBinaryExprType(FcgBinOp fcgBinOp, FcgType fcgType, FcgType fcgType2) {
        FcgType fcgType3;
        int n = ((Operation2)fcgBinOp).getFcgOpCode();
        switch (n) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                if (fcgType == FcgType.BIG_DECIMAL && n != 104) {
                    fcgType3 = FcgType.BIG_DECIMAL;
                    break;
                }
                if (fcgType == FcgType.BIG_INTEGER) {
                    fcgType3 = FcgType.BIG_INTEGER;
                    break;
                }
                if (fcgType == FcgType.DOUBLE || fcgType2 == FcgType.DOUBLE) {
                    fcgType3 = FcgType.DOUBLE;
                    break;
                }
                if (fcgType == FcgType.FLOAT || fcgType2 == FcgType.FLOAT) {
                    fcgType3 = FcgType.FLOAT;
                    break;
                }
                if (fcgType == FcgType.LONG || fcgType2 == FcgType.LONG) {
                    fcgType3 = FcgType.LONG;
                    break;
                }
                fcgType3 = FcgType.INT;
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                if (fcgType == FcgType.LONG) {
                    fcgType3 = FcgType.LONG;
                    break;
                }
                fcgType3 = FcgType.INT;
                break;
            }
            case 114: 
            case 115: 
            case 116: {
                if (fcgType == FcgType.LONG || fcgType2 == FcgType.LONG) {
                    fcgType3 = FcgType.LONG;
                    break;
                }
                fcgType3 = FcgType.INT;
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                fcgType3 = FcgType.BOOLEAN;
                break;
            }
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: {
                fcgType3 = FcgType.BOOLEAN;
                break;
            }
            default: {
                Object var5_6 = null;
                throw new UnsupportedOperationException("FinalCodeGenerator bad opcode: " + n);
            }
        }
        return fcgType3;
    }

    private final FcgType createObjectExpr(FcgType fcgType, int n, FcgType[] fcgTypeArray) {
        int n2;
        int n3 = n;
        StackValue[] stackValueArray = new StackValue[n3];
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            stackValueArray[n2] = this.pop(VALUE);
        }
        Object object = this.genCode_createObject(fcgType, stackValueArray, fcgTypeArray);
        for (n2 = 0; n2 < n3; ++n2) {
            stackValueArray[n2].reset();
        }
        this.push(VALUE, fcgType, object);
        return fcgType;
    }

    public final FcgType createObjectExpr(FcgType fcgType, int n) {
        return this.createObjectExpr(fcgType, n, null);
    }

    public final FcgType createObjectExpr(FcgType fcgType, FcgType[] fcgTypeArray) {
        return this.createObjectExpr(fcgType, fcgTypeArray.length, fcgTypeArray);
    }

    public final FcgType createInnerClassExpr(FcgType fcgType, int n, FcgClassGen fcgClassGen) {
        int n2 = n;
        if (DO_COMPILE_CHECKING && !(fcgClassGen instanceof FcgClassGenJavaSrc)) {
            FinalCodeGenerator.error("FCG: Can only create inner classes with Java source");
        } else {
            int n3;
            StackValue[] stackValueArray = new StackValue[n2];
            for (n3 = n2 - 1; n3 >= 0; --n3) {
                stackValueArray[n3] = this.pop(VALUE);
            }
            Object object = this.genCode_createInnerClass(fcgType, stackValueArray, fcgClassGen);
            for (n3 = 0; n3 < n2; ++n3) {
                stackValueArray[n3].reset();
            }
            this.push(VALUE, fcgType, object);
        }
        return fcgType;
    }

    protected abstract Object genCode_createObject(FcgType var1, StackValue[] var2, FcgType[] var3);

    protected abstract Object genCode_createInnerClass(FcgType var1, StackValue[] var2, FcgClassGen var3);

    public final FcgType createArrayExpr(FcgType fcgType, boolean bl) {
        Object object;
        StackValue stackValue = this.pop(VALUE);
        if (stackValue.m_valueType == INT_LITERAL && bl) {
            int n;
            int n2 = stackValue.getIntLiteralValue();
            StackValue[] stackValueArray = new StackValue[n2];
            for (n = n2 - 1; n >= 0; --n) {
                stackValueArray[n] = this.pop(VALUE);
            }
            object = this.genCode_createArray(fcgType, stackValueArray);
            for (n = 0; n < n2; ++n) {
                stackValueArray[n].reset();
            }
            stackValue.reset();
        } else {
            if (DO_COMPILE_CHECKING && bl) {
                String string = "FCG: Can't initialize created array, size is not a literal integer.";
                FinalCodeGenerator.error(string);
            }
            object = this.genCode_createArray(fcgType, stackValue);
            stackValue.reset();
        }
        FcgType fcgType2 = ((FcgClassGenImpl)this.m_classGen).getFcgCodeGen().getArrayType(fcgType);
        this.push(VALUE, fcgType2, object);
        return fcgType2;
    }

    protected abstract Object genCode_createArray(FcgType var1, StackValue[] var2);

    protected abstract Object genCode_createArray(FcgType var1, StackValue var2);

    public final void beginIf() {
        StackValue stackValue = this.pop(VALUE);
        Object object = this.genCode_beginIf(stackValue);
        stackValue.reset();
        this.push(IF, FcgBasicType.VOID, object);
        this.clearCachedComments();
    }

    protected abstract Object genCode_beginIf(StackValue var1);

    public final void beginElse() {
        this.clearCachedComments();
        StackValue stackValue = this.peek();
        this.undeclareLocals(stackValue);
        stackValue = this.pop(IF);
        Object object = this.genCode_beginElse(stackValue);
        stackValue.reset();
        this.push(ELSE, FcgBasicType.VOID, object);
    }

    protected abstract Object genCode_beginElse(StackValue var1);

    public final void beginElseIf() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(IF);
        this.undeclareLocals(stackValue2);
        Object object = this.genCode_elseIf(stackValue2, stackValue);
        stackValue.reset();
        stackValue2.reset();
        this.push(IF, FcgBasicType.VOID, object);
        this.clearCachedComments();
    }

    protected abstract Object genCode_elseIf(StackValue var1, StackValue var2);

    public final void endIf() {
        Object object;
        StackValue stackValue = this.peek();
        this.undeclareLocals(stackValue);
        stackValue = this.pop(null);
        Construct construct = stackValue.getConstructKind();
        if (DO_COMPILE_CHECKING && construct != IF && construct != ELSE) {
            object = "FCG: endIf() was expecting to pop previously pushed IF or ELSE contruct on the FCG stack but got: " + construct + " construct";
            Object object2 = stackValue.getCodeData();
            if (object2 instanceof String) {
                object = (String)object + ", with value: " + object2;
            }
            FinalCodeGenerator.error((String)object);
        }
        object = this.peek();
        this.genCode_endIf((StackValue)object, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endIf(StackValue var1, StackValue var2);

    public final void endTryBlock() {
        StackValue stackValue = this.pop(CATCHBLOCK);
        StackValue stackValue2 = this.peek();
        this.undeclareLocals(stackValue);
        this.genCode_endTry(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_endTry(StackValue var1, StackValue var2);

    public final FcgType convertExpr(FcgType fcgType, FcgType fcgType2) {
        if (fcgType != fcgType2) {
            StackValue stackValue = this.pop(VALUE);
            Object object = this.genCode_coerce(fcgType, fcgType2, stackValue);
            stackValue.reset();
            this.push(VALUE, fcgType2, object);
        }
        return fcgType2;
    }

    public final void returnInstruction() {
        FcgType fcgType;
        FcgMethodGen fcgMethodGen = this.getMethod();
        if (DO_COMPILE_CHECKING && fcgMethodGen != null && (fcgType = fcgMethodGen.getReturnType()) != FcgBasicType.VOID && fcgType != null) {
            FinalCodeGenerator.error("FCG: internal error generating a return; when a value must be returned");
        }
        this.returnInstruction(FcgType.VOID);
        this.clearCachedComments();
    }

    public final void returnInstruction(FcgType fcgType) {
        StackValue stackValue = this.peek();
        if (stackValue == null) {
            this.genCode_returnInstruction(null);
        } else {
            FcgType fcgType2 = stackValue.getType();
            if (fcgType2 != fcgType) {
                // empty if block
            }
            if (fcgType == FcgType.VOID) {
                StackValue stackValue2 = stackValue;
                this.genCode_returnInstruction(stackValue2);
            } else {
                StackValue stackValue3 = this.pop(VALUE);
                StackValue stackValue4 = this.peek();
                this.genCode_returnInstruction(stackValue4, stackValue3);
                stackValue3.reset();
            }
        }
    }

    protected abstract void genCode_returnInstruction(StackValue var1);

    protected abstract void genCode_returnInstruction(StackValue var1, StackValue var2);

    public void streamElemCopyStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        StackValue stackValue3 = this.pop(VALUE);
        StackValue stackValue4 = this.pop(VALUE);
        StackValue stackValue5 = this.pop(VALUE);
        this.genCode_streamElemCopyStmt(stackValue5, stackValue4, stackValue3, stackValue2, stackValue);
        stackValue.reset();
        stackValue2.reset();
        stackValue3.reset();
        stackValue4.reset();
        stackValue5.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_streamElemCopyStmt(StackValue var1, StackValue var2, StackValue var3, StackValue var4, StackValue var5);

    public static void error(String string) {
        System.err.println(string);
        throw new RuntimeException(string);
    }

    public static void notImplemented() {
        String string = "FCG: not implemented";
        FinalCodeGenerator.error(string);
    }

    private void invokeMethod(boolean bl, boolean bl2, FcgReferenceType fcgReferenceType, String string, FcgType fcgType, int n, FcgType[] fcgTypeArray) {
        String string2;
        Object object;
        StackValue[] stackValueArray;
        if (0 < n) {
            stackValueArray = new StackValue[n];
            for (int i = n - 1; i >= 0; --i) {
                stackValueArray[i] = this.pop(VALUE);
            }
        } else {
            stackValueArray = null;
        }
        StackValue stackValue = null;
        if (bl) {
            stackValue = this.pop(null);
            if (DO_COMPILE_CHECKING && stackValue.getConstructKind() != VALUE) {
                object = "FCG: Expected 'this' reference, but got " + stackValue;
                FinalCodeGenerator.error((String)object);
            }
        }
        boolean bl3 = false;
        if (fcgReferenceType == null) {
            string2 = this.m_classGen.getClassType().getTypeName();
        } else {
            string2 = fcgReferenceType.getTypeName();
            if (fcgReferenceType instanceof FcgInterfaceType) {
                bl3 = true;
            }
        }
        object = this.genCode_invokeMethod(bl, bl3, bl2, stackValue, string2, string, stackValueArray, fcgType, fcgTypeArray);
        if (stackValue != null) {
            stackValue.reset();
        }
        if (stackValueArray != null) {
            for (int i = 0; i < n; ++i) {
                stackValueArray[i].reset();
            }
        }
        if (fcgType != FcgBasicType.VOID && bl2) {
            this.push(VALUE, fcgType, object);
        }
        if (!bl2) {
            this.clearCachedComments();
        }
    }

    protected abstract Object genCode_invokeMethod(boolean var1, boolean var2, boolean var3, StackValue var4, String var5, String var6, StackValue[] var7, FcgType var8, FcgType[] var9);

    private void undeclareLocals(StackValue stackValue) {
        int n = stackValue.getNumLocalVars();
        int n2 = this.m_varStack.numLocalVars();
        for (int i = n; i < n2; ++i) {
            this.undefinelVar();
        }
    }

    public final void invokeSuperConstructor(FcgClassReferenceType fcgClassReferenceType, int n) {
        StackValue stackValue;
        int n2;
        int n3 = n;
        StackValue[] stackValueArray = new StackValue[n3];
        try {
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                stackValueArray[n2] = this.pop(VALUE);
            }
            stackValue = this.pop(VALUE);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("FCG: not enough arguments pushed on FCG stack for invokeSuperConstructor() call.");
            throw runtimeException;
        }
        if (DO_COMPILE_CHECKING && fcgClassReferenceType == null) {
            FinalCodeGenerator.error("FCG: invokeSuperConstructor() requires non-null class type for the super class");
        }
        this.genCode_invokeSuper(fcgClassReferenceType, stackValue, stackValueArray);
        for (n2 = 0; n2 < n3; ++n2) {
            stackValueArray[n2].reset();
        }
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_invokeSuper(FcgClassReferenceType var1, StackValue var2, StackValue[] var3);

    public final void dispose() {
    }

    public final void beginTryBlock() {
        Object object = this.genCode_beginTryBlock();
        this.clearCachedComments();
        this.push(TRYBLOCK, FcgType.VOID, object);
    }

    protected abstract Object genCode_beginTryBlock();

    public final FcgVariable beginCatchBlock(FcgType fcgType, String string) {
        Object object;
        StackValue stackValue = this.pop(null);
        Construct construct = stackValue.getConstructKind();
        if (DO_COMPILE_CHECKING && construct != TRYBLOCK && construct != CATCHBLOCK) {
            object = "FCG: Expecting to pop a TRYBLOCK or CATCHBLOCK Contruct from the FCG stack but got: " + construct;
            FinalCodeGenerator.error((String)object);
        }
        object = this.peek();
        this.undeclareLocals(stackValue);
        FcgVariable fcgVariable = this.defineCatchClauseParam(string, fcgType, null);
        Object object2 = this.genCode_beginCatchBlock((StackValue)object, stackValue, fcgVariable);
        stackValue.reset();
        this.push(CATCHBLOCK, FcgType.VOID, object2);
        this.clearCachedComments();
        return fcgVariable;
    }

    protected abstract Object genCode_beginCatchBlock(StackValue var1, StackValue var2, FcgVariable var3);

    public final FcgType loadClassField(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType) {
        String string2 = fcgClassReferenceType.getTypeName();
        Object object = this.genCode_loadClassVariable(string2, string, fcgType);
        this.push(VALUE, fcgType, object);
        return fcgType;
    }

    protected abstract Object genCode_loadClassVariable(String var1, String var2, FcgType var3);

    public final void storeClassFieldStmt(FcgClassReferenceType fcgClassReferenceType, String string, FcgType fcgType) {
        FcgType fcgType2 = this.peek().getType();
        if (fcgType != null && fcgType2 != fcgType) {
            this.convertExpr(fcgType2, fcgType);
        }
        StackValue stackValue = this.pop(VALUE);
        String string2 = fcgClassReferenceType != null ? fcgClassReferenceType.getTypeName() : this.m_classGen.getClassType().getTypeName();
        this.genCode_storeStaticFieldStmt(string2, fcgType, string, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeStaticFieldStmt(String var1, FcgType var2, String var3, StackValue var4);

    final void setMethod(FcgMethodGen fcgMethodGen) {
        this.m_beginMethod2 = fcgMethodGen;
    }

    protected final FcgMethodGen getMethod() {
        return this.m_beginMethod2;
    }

    public final void beginMethod() {
        FcgMethodGen fcgMethodGen = this.getMethod();
        this.push(METHOD);
        this.genCode_beginMethod(fcgMethodGen);
        this.clearCachedComments();
        if (fcgMethodGen.getAttributes().isStatic()) {
            this.setStaticContext(true);
        } else {
            this.setStaticContext(false);
        }
        if (fcgMethodGen.getName().equals("<init>") && (fcgMethodGen.getArgumentTypes() == null || fcgMethodGen.getArgumentTypes().length == 0)) {
            FcgClassGen fcgClassGen = this.getFcgClassGen();
            ((FcgClassGenImpl)fcgClassGen).setDefaultCtor(fcgMethodGen);
        }
    }

    protected abstract void genCode_beginMethod(FcgMethodGen var1);

    public FcgType loadLiteral(BigDecimal bigDecimal) {
        this.push(VALUE, FcgBasicType.BIG_DECIMAL, this.genCode_loadLiteralValue(bigDecimal));
        return FcgBasicType.BIG_DECIMAL;
    }

    public FcgType loadLiteral(BigInteger bigInteger) {
        this.push(VALUE, FcgBasicType.BIG_INTEGER, this.genCode_loadLiteralValue(bigInteger));
        return FcgBasicType.BIG_INTEGER;
    }

    protected abstract Object genCode_loadLiteralValue(BigDecimal var1);

    protected abstract Object genCode_loadLiteralValue(BigInteger var1);

    protected abstract Object genCode_loadLiteralValue(Character var1);

    protected abstract Object genCode_loadLiteralValue(Boolean var1);

    public final int codeGenStackDepth() {
        return this.m_codeGenerationStack.m_freeIndex;
    }

    protected abstract Object genCode_arrayLengthExpr(StackValue var1);

    public void storeArrayElemStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        StackValue stackValue3 = this.pop(VALUE);
        this.genCode_storeArrayElemStmt(stackValue3, stackValue2, stackValue);
        stackValue.reset();
        stackValue2.reset();
        stackValue3.reset();
        this.clearCachedComments();
    }

    protected abstract void genCode_storeArrayElemStmt(StackValue var1, StackValue var2, StackValue var3);

    public final void fillStmt() {
        StackValue stackValue = this.pop(VALUE);
        StackValue stackValue2 = this.pop(VALUE);
        StackValue stackValue3 = this.pop(VALUE);
        StackValue stackValue4 = this.pop(VALUE);
        this.clearCachedComments();
        this.genCode_fillStmt(stackValue4, stackValue3, stackValue2, stackValue);
        stackValue.reset();
        stackValue2.reset();
        stackValue3.reset();
        stackValue4.reset();
    }

    protected abstract void genCode_fillStmt(StackValue var1, StackValue var2, StackValue var3, StackValue var4);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CODE CURRENTLY PUSHED ON FCG CODE GEN STACK:\n");
        int n = this.m_codeGenerationStack.m_freeIndex - 1;
        for (int i = 0; i <= n; ++i) {
            StackValue stackValue = this.m_codeGenerationStack.peek(i);
            stringBuffer.append("at depth " + (n - i) + " ");
            stringBuffer.append(stackValue.toString());
        }
        return stringBuffer.toString();
    }

    public abstract FcgVarMutableInternal newFcgVariable();

    protected abstract void genCode_beginScopeBlock();

    protected abstract void genCode_endScopeBlock(StackValue var1, StackValue var2);

    public final void beginScopeBlock() {
        this.genCode_beginScopeBlock();
        this.clearCachedComments();
        this.push(SCOPEBLOCK);
    }

    public final void endScopeBlock() {
        StackValue stackValue = this.peek();
        this.undeclareLocals(stackValue);
        stackValue = this.pop(SCOPEBLOCK);
        StackValue stackValue2 = this.peek();
        this.genCode_endScopeBlock(stackValue2, stackValue);
        stackValue.reset();
        this.clearCachedComments();
    }

    private static boolean canConvert(FcgType fcgType, FcgType fcgType2) {
        boolean bl = false;
        if (fcgType == fcgType2) {
            return true;
        }
        if (fcgType == FcgType.STRING) {
            if (fcgType2 == FcgType.CHAR_ARRAY) {
                bl = true;
            } else if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER && fcgType2 != FcgType.BOOLEAN && fcgType2 != FcgType.BYTE && fcgType2 != FcgType.CHAR && !(fcgType2 instanceof FcgClassReferenceType) && fcgType2 != FcgType.DOUBLE && fcgType2 != FcgType.FLOAT && fcgType2 != FcgType.INT && fcgType2 != FcgType.LONG && fcgType2 != FcgType.SHORT && fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                // empty if block
            }
        } else if (fcgType == FcgType.BIG_DECIMAL) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.BIG_INTEGER) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.BOOLEAN) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.BYTE) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.CHAR) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.CHAR_ARRAY) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER && fcgType2 != FcgType.BOOLEAN && fcgType2 != FcgType.BYTE && fcgType2 != FcgType.CHAR && fcgType2 != FcgType.CHAR_ARRAY) {
                if (fcgType2 instanceof FcgClassReferenceType) {
                    if ("java.lang.String".equals(fcgType2.getTypeName())) {
                        bl = true;
                    }
                } else if (fcgType2 != FcgType.DOUBLE && fcgType2 != FcgType.FLOAT && fcgType2 != FcgType.INT && fcgType2 != FcgType.LONG && fcgType2 != FcgType.LONG && fcgType2 != FcgType.SHORT) {
                    if (fcgType2 == FcgType.STRING) {
                        bl = true;
                    } else if (fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType instanceof FcgClassReferenceType) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER && fcgType2 != FcgType.BOOLEAN && fcgType2 != FcgType.BYTE && fcgType2 != FcgType.CHAR && fcgType2 != FcgType.CHAR_ARRAY) {
                if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                    bl = true;
                } else if (fcgType2 != FcgType.DOUBLE && fcgType2 != FcgType.FLOAT && fcgType2 != FcgType.INT && fcgType2 != FcgType.LONG && fcgType2 != FcgType.SHORT && fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                    // empty if block
                }
            }
        } else if (fcgType == FcgType.DOUBLE) {
            if (fcgType2 != FcgType.BIG_DECIMAL) {
                if (fcgType2 == FcgType.BIG_DECIMAL) {
                    bl = true;
                } else if (fcgType2 != FcgType.BIG_INTEGER) {
                    if (fcgType2 == FcgType.BOOLEAN) {
                        bl = true;
                    } else if (fcgType2 == FcgType.BYTE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.CHAR) {
                        bl = true;
                    } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                        if (fcgType2 == FcgType.DOUBLE) {
                            bl = true;
                        } else if (fcgType2 == FcgType.FLOAT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.INT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.LONG) {
                            bl = true;
                        } else if (fcgType2 == FcgType.SHORT) {
                            bl = true;
                        } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                            // empty if block
                        }
                    }
                }
            }
        } else if (fcgType == FcgType.FLOAT) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                bl = true;
            } else if (fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.INT || fcgType == INT_LITERAL) {
            if (fcgType2 != FcgType.BIG_DECIMAL) {
                if (fcgType2 == FcgType.BIG_DECIMAL) {
                    bl = true;
                } else if (fcgType2 != FcgType.BIG_INTEGER) {
                    if (fcgType2 == FcgType.BOOLEAN) {
                        bl = true;
                    } else if (fcgType2 == FcgType.BYTE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.CHAR) {
                        bl = true;
                    } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                        bl = true;
                    } else if (fcgType2 == FcgType.STRING) {
                        bl = true;
                    } else if (!(fcgType2 instanceof FcgClassReferenceType)) {
                        if (fcgType2 == FcgType.DOUBLE) {
                            bl = true;
                        } else if (fcgType2 == FcgType.FLOAT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.INT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.LONG) {
                            bl = true;
                        } else if (fcgType2 == FcgType.SHORT) {
                            bl = true;
                        } else if (fcgType2 == FcgType.STRINGBUFFER) {
                            // empty if block
                        }
                    }
                }
            }
        } else if (fcgType == FcgType.LONG) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.SHORT) {
            if (fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER) {
                if (fcgType2 == FcgType.BOOLEAN) {
                    bl = true;
                } else if (fcgType2 == FcgType.BYTE) {
                    bl = true;
                } else if (fcgType2 == FcgType.CHAR) {
                    bl = true;
                } else if (fcgType2 != FcgType.CHAR_ARRAY && !(fcgType2 instanceof FcgClassReferenceType)) {
                    if (fcgType2 == FcgType.DOUBLE) {
                        bl = true;
                    } else if (fcgType2 == FcgType.FLOAT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.INT) {
                        bl = true;
                    } else if (fcgType2 == FcgType.LONG) {
                        bl = true;
                    } else if (fcgType2 == FcgType.SHORT) {
                        bl = true;
                    } else if (fcgType2 != FcgType.STRING && fcgType2 == FcgType.STRINGBUFFER) {
                        // empty if block
                    }
                }
            }
        } else if (fcgType == FcgType.STRINGBUFFER && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_DECIMAL && fcgType2 != FcgType.BIG_INTEGER && fcgType2 != FcgType.BOOLEAN && fcgType2 != FcgType.BYTE && fcgType2 != FcgType.CHAR) {
            if (fcgType2 == FcgType.CHAR_ARRAY) {
                bl = true;
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 == FcgType.DOUBLE || fcgType2 == FcgType.FLOAT || fcgType2 == FcgType.INT || fcgType2 == FcgType.SHORT || fcgType2 == FcgType.STRING || fcgType2 == FcgType.STRINGBUFFER) {
                // empty if block
            }
        }
        return bl;
    }

    public FcgType loadInstanceField(FcgField fcgField) {
        FcgAttrs fcgAttrs = fcgField.getAttrs();
        FcgClassReferenceType fcgClassReferenceType = ((FcgFieldGenImpl)fcgField).getDefiningClass();
        String string = fcgField.getName();
        FcgType fcgType = fcgField.getType();
        if (DO_COMPILE_CHECKING && fcgAttrs.isStatic()) {
            String string2 = fcgAttrs.toString() + fcgType.getTypeName() + ' ' + fcgClassReferenceType.getTypeName() + '.' + string;
            FinalCodeGenerator.error("FCG: loadInstanceField(FcgField) is trying to load a class field: " + string2);
        }
        this.loadInstanceField(fcgClassReferenceType, string, fcgType);
        return fcgType;
    }

    public FcgType loadClassField(FcgField fcgField) {
        FcgAttrs fcgAttrs = fcgField.getAttrs();
        FcgClassReferenceType fcgClassReferenceType = ((FcgFieldGenImpl)fcgField).getDefiningClass();
        String string = fcgField.getName();
        FcgType fcgType = fcgField.getType();
        if (DO_COMPILE_CHECKING && !fcgAttrs.isStatic()) {
            String string2 = fcgAttrs.toString() + fcgType.getTypeName() + ' ' + fcgClassReferenceType.getTypeName() + '.' + string;
            FinalCodeGenerator.error("FCG: loadClassField(FcgField) is trying to load an instance field: " + string2);
        }
        this.loadClassField(fcgClassReferenceType, string, fcgType);
        return fcgType;
    }

    public void storeInstanceFieldStmt(FcgField fcgField) {
        FcgAttrs fcgAttrs = fcgField.getAttrs();
        FcgClassReferenceType fcgClassReferenceType = ((FcgFieldGenImpl)fcgField).getDefiningClass();
        String string = fcgField.getName();
        FcgType fcgType = fcgField.getType();
        if (DO_COMPILE_CHECKING && fcgAttrs.isStatic()) {
            String string2 = fcgAttrs.toString() + fcgType.getTypeName() + ' ' + fcgClassReferenceType.getTypeName() + '.' + string;
            FinalCodeGenerator.error("FCG: storeInstanceFieldStmt(FcgField) is trying to store to a class field: " + string2);
        }
        this.storeInstanceFieldStmt(fcgClassReferenceType, string, fcgType);
    }

    public void storeClassFieldStmt(FcgField fcgField) {
        FcgAttrs fcgAttrs = fcgField.getAttrs();
        FcgClassReferenceType fcgClassReferenceType = ((FcgFieldGenImpl)fcgField).getDefiningClass();
        String string = fcgField.getName();
        FcgType fcgType = fcgField.getType();
        if (DO_COMPILE_CHECKING && !fcgAttrs.isStatic()) {
            String string2 = fcgAttrs.toString() + fcgType.getTypeName() + ' ' + fcgClassReferenceType.getTypeName() + '.' + string;
            FinalCodeGenerator.error("FCG: storeClassFieldStmt(FcgField) is trying to store to an instance field: " + string2);
        }
        this.storeClassFieldStmt(fcgClassReferenceType, string, fcgType);
    }

    public void runtimeTypeCheck(FcgReferenceType fcgReferenceType) {
        StackValue stackValue = this.pop(VALUE);
        Object object = this.genCode_runtimeTypeCheck(stackValue, fcgReferenceType);
        stackValue.reset();
        this.push(VALUE, FcgType.BOOLEAN, object);
    }

    protected abstract Object genCode_runtimeTypeCheck(StackValue var1, FcgReferenceType var2);

    private final FcgVariable findFcgVariable2(String string) {
        for (int i = this.m_varStack.m_freeIndex - 1; 0 <= i; --i) {
            FcgVarMutableInternal fcgVarMutableInternal = this.m_varStack.m_stackArr[i];
            if (!string.equals(fcgVarMutableInternal.getName())) continue;
            return fcgVarMutableInternal;
        }
        return null;
    }

    public abstract void setStaticContext(boolean var1);

    protected abstract boolean isEmpty();

    protected abstract boolean isClassContext();

    public static void unimplementedException() {
        String string = "FCG BCEL feature is unimplemented";
        throw new RuntimeException(string);
    }

    public static void unimplementedException(String string) {
        throw new FcgRuntimeException("FCG INTERNAL ERROR. " + string);
    }

    private final Object genCode_unaryOperation(FcgUnaryOp fcgUnaryOp, StackValue stackValue, FcgType fcgType) {
        FcgType fcgType2 = stackValue.getType();
        int n = ((Operation2)((Object)fcgUnaryOp)).getFcgOpCode();
        Object object = null;
        switch (n) {
            case 106: {
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) {
                    object = this.gencode_UNARY_NEGATE_BIG(stackValue);
                    break;
                }
                if (fcgType == FcgType.INT) {
                    object = this.genCode_UNARY_NEGATE_INT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object = this.genCode_UNARY_NEGATE_FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object = this.genCode_UNARY_NEGATE_DOUBLE(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.LONG) {
                    object = this.genCode_UNARY_NEGATE_LONG(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 1130: {
                if (fcgType == FcgType.INT) {
                    object = this.genCode_UNARY_BITWISE_NOT_INT(stackValue);
                    break;
                }
                if (fcgType == FcgType.LONG) {
                    object = this.genCode_UNARY_BITWISE_NOT_LONG(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 201: {
                object = this.genCode_UNARY_LOGICAL_NOT(stackValue);
                break;
            }
            case 300: {
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) {
                    object = this.genCode_UNARY_ABS_BIG(stackValue);
                    break;
                }
                if (fcgType == FcgType.INT) {
                    object = this.genCode_UNARY_ABS_INT(stackValue);
                    break;
                }
                if (fcgType == FcgType.LONG) {
                    object = this.genCode_UNARY_ABS_LONG(stackValue);
                    break;
                }
                if (fcgType == FcgType.FLOAT) {
                    object = this.genCode_UNARY_ABS_FLOAT(stackValue);
                    break;
                }
                if (fcgType == FcgType.DOUBLE) {
                    object = this.genCode_UNARY_ABS_DOUBLE(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 301: {
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) {
                    object = this.genCode_UNARY_ROUND_BIG(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object = this.genCode_UNARY_ROUND_FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object = this.genCode_UNARY_ROUND_DOUBLE(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.INT || fcgType2 == FcgType.BYTE || fcgType2 == FcgType.LONG) {
                    object = this.genCode_UNARY_ROUND_INT(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 302: {
                if (fcgType2 == FcgType.BYTE || fcgType2 == FcgType.INT || fcgType2 == INT_LITERAL) {
                    object = this.genCode_UNARY_CEILING_INT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.LONG) {
                    object = this.genCode_UNARY_CEILING_LONG(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object = this.genCode_UNARY_CEILING_FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object = this.genCode_UNARY_CEILING_DOUBLE(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 303: {
                if (fcgType2 == FcgType.BYTE || fcgType2 == FcgType.INT || fcgType2 == INT_LITERAL) {
                    object = this.genCode_UNARY_FLOOR_INT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.LONG) {
                    object = this.genCode_UNARY_FLOOR_LONG(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object = this.genCode_UNARY_FLOOR_FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object = this.genCode_UNARY_FLOOR_DOUBLE(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 305: {
                if (fcgType2 == FcgType.BYTE || fcgType2 == FcgType.INT || fcgType2 == INT_LITERAL) {
                    object = this.genCode_UNARY_IS_NAN_INT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.LONG) {
                    object = this.genCode_UNARY_IS_NAN__LONG(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.FLOAT) {
                    object = this.genCode_UNARY_IS_NAN__FLOAT(stackValue);
                    break;
                }
                if (fcgType2 == FcgType.DOUBLE) {
                    object = this.genCode_UNARY_IS_NAN_DOUBLE(stackValue);
                    break;
                }
                throw new UnsupportedOperationException("FcgInstructionListBCEL: bad op type for isNaN" + fcgType2);
            }
            case 306: {
                if (fcgType2 == FcgType.STRING) {
                    object = this.genCode_UNARY_ARRAY_LENGTH_STRING(stackValue);
                    break;
                }
                if (stackValue.getType() instanceof FcgArrayType) {
                    object = this.genCode_UNARY_ARRAY_LENGTH_ARRAY(stackValue);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            case 307: {
                if (fcgType2 == FcgType.STRING) {
                    object = this.genCode_UNARY_TO_CHAR_ARRAY_STRING(stackValue, fcgType2);
                    break;
                }
                FinalCodeGenerator.unimplementedException();
                break;
            }
            default: {
                FinalCodeGenerator.unimplementedException();
            }
        }
        return object;
    }

    protected abstract Object genCode_UNARY_ABS_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_INT(StackValue var1);

    protected abstract Object genCode_UNARY_ABS_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_ARRAY_LENGTH_ARRAY(StackValue var1);

    protected abstract Object genCode_UNARY_ARRAY_LENGTH_STRING(StackValue var1);

    protected abstract Object genCode_UNARY_BITWISE_NOT_INT(StackValue var1);

    protected abstract Object genCode_UNARY_BITWISE_NOT_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_INT(StackValue var1);

    protected abstract Object genCode_UNARY_CEILING_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_INT(StackValue var1);

    protected abstract Object genCode_UNARY_FLOOR_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN__FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN__LONG(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_IS_NAN_INT(StackValue var1);

    protected abstract Object genCode_UNARY_LOGICAL_NOT(StackValue var1);

    protected abstract Object gencode_UNARY_NEGATE_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_INT(StackValue var1);

    protected abstract Object genCode_UNARY_NEGATE_LONG(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_BIG(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_DOUBLE(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_FLOAT(StackValue var1);

    protected abstract Object genCode_UNARY_ROUND_INT(StackValue var1);

    protected abstract Object genCode_UNARY_TO_CHAR_ARRAY_STRING(StackValue var1, FcgType var2);

    private final Object genCode_binaryOperation(FcgBinOp fcgBinOp, StackValue stackValue, StackValue stackValue2, FcgType fcgType) {
        Object object;
        FcgType fcgType2 = stackValue.getType();
        FcgType fcgType3 = stackValue2.getType();
        int n = ((Operation2)fcgBinOp).getFcgOpCode();
        switch (n) {
            case 100: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object = this.genCode_BINARY_ADD_BIG(stackValue, stackValue2);
                    break;
                }
                if (fcgType2 == FcgType.STRING) {
                    object = this.genCode_BINARY_ADD_STRING(stackValue, stackValue2);
                    break;
                }
                object = this.genCode_BINARY_ADD(stackValue, stackValue2, fcgType, n);
                break;
            }
            case 101: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object = this.genCode_BINARY_SUBTRACT_BIG(stackValue, stackValue2);
                    break;
                }
                object = this.genCode_BINARY_SUBTRACT(stackValue, stackValue2, fcgType, n);
                break;
            }
            case 102: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object = this.genCode_BINARY_MULTIPLY_BIG(stackValue, stackValue2, fcgType, n);
                    break;
                }
                object = this.genCode_BINARY_MULTIPLY(stackValue, stackValue2, fcgType, n);
                break;
            }
            case 103: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object = this.genCode_BINARY_DIVIDE_BIG(stackValue, stackValue2);
                    break;
                }
                object = this.genCode_BINARY_DIVIDE(stackValue, stackValue2, fcgType, n);
                break;
            }
            case 104: {
                if (fcgType2 == FcgType.BIG_INTEGER && fcgType3 == FcgType.BIG_INTEGER) {
                    object = this.genCode_BINARY_MODULO_BIG(stackValue, stackValue2);
                    break;
                }
                object = this.genCode_BINARY_MODULO(stackValue, stackValue2, fcgType, n);
                break;
            }
            case 110: {
                object = this.genCode_BINARY_SHIFT_LEFT(stackValue, stackValue2, fcgType);
                break;
            }
            case 111: {
                object = this.genCode_BINARY_SHIFT_RIGHT(stackValue, stackValue2, fcgType);
                break;
            }
            case 112: {
                object = this.genCode_BINARY_SHIFT_RIGHT_UNSIGNED(stackValue, stackValue2, fcgType);
                break;
            }
            case 114: {
                object = this.genCode_BINARY_BITWISE_AND(stackValue, stackValue2, fcgType);
                break;
            }
            case 115: {
                object = this.genCode_BINARY_BITWISE_OR(stackValue, stackValue2, fcgType);
                break;
            }
            case 116: {
                if (fcgType2 == FcgType.BIG_INTEGER) {
                    object = this.genCode_BINARY_BITWISE_XOR_BIG(stackValue, stackValue2, fcgType);
                    break;
                }
                object = this.genCode_BINARY_BITWISE_XOR(stackValue, stackValue2, fcgType);
                break;
            }
            case 150: {
                object = this.genCode_BINARY_COMPARE_EQ_REFERENCE(stackValue, stackValue2, fcgType2, fcgType3);
                break;
            }
            case 151: {
                if (fcgType2 == FcgType.STRING || fcgType3 == FcgType.STRING) {
                    object = this.genCode_BINARY_COMPARE_EQ_STRING(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL || fcgType3 == FcgType.BIG_INTEGER || fcgType3 == FcgType.BIG_DECIMAL) {
                    object = this.genCode_BINARY_COMPARE_EQ_BIG(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                if (fcgType2 instanceof FcgReferenceType || fcgType3 instanceof FcgReferenceType) {
                    object = this.genCode_BINARY_COMPARE_EQ_REFERENCE(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                object = this.genCode_BINARY_COMPARE_EQ_PRIMITIVE(stackValue, stackValue2, fcgType2, fcgType3);
                break;
            }
            case 152: {
                if (fcgType2 == FcgType.STRING || fcgType3 == FcgType.STRING) {
                    object = this.genCode_BINARY_COMPARE_NOT_EQ_STRING(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                if (fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL || fcgType3 == FcgType.BIG_INTEGER || fcgType3 == FcgType.BIG_DECIMAL) {
                    object = this.genCode_BINARY_COMPARE_NOT_EQ_BIG(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                if (fcgType2 instanceof FcgReferenceType || fcgType3 instanceof FcgReferenceType) {
                    object = this.genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(stackValue, stackValue2, fcgType2, fcgType3);
                    break;
                }
                object = this.genCode_BINARY_COMPARE_NOT_EQ_PRIMITIVE(stackValue, stackValue2, fcgType2, fcgType3);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                if ((fcgType2 == FcgType.BIG_INTEGER || fcgType2 == FcgType.BIG_DECIMAL) && fcgType2 == fcgType3) {
                    object = this.genCode_BINARY_COMPARE_ORDER_BIG(stackValue, stackValue2, fcgType2, fcgType3, n);
                    break;
                }
                if (fcgType2 == FcgType.STRING && fcgType3 == FcgType.STRING) {
                    object = this.genCode_BINARY_COMPARE_ORDER_STRING(stackValue, stackValue2, n);
                    break;
                }
                object = this.genCode_BINARY_COMPARE_ORDER_PRIMITIVE(stackValue, stackValue2, fcgType2, fcgType3, n);
                break;
            }
            case 202: {
                object = this.genCode_BINARY_LOGICAL_AND_EVALBOTH(stackValue, stackValue2);
                break;
            }
            case 203: {
                object = this.genCode_BINARY_LOGICAL_OR_EVALBOTH(stackValue, stackValue2);
                break;
            }
            case 204: {
                object = this.genCode_BINARY_LOGICAL_XOR(stackValue, stackValue2);
                break;
            }
            case 205: {
                object = this.genCode_BINARY_LOGICAL_CONDITIONAL_AND(stackValue, stackValue2);
                break;
            }
            case 206: {
                object = this.genCode_BINARY_LOGICAL_CONDITIONAL_OR(stackValue, stackValue2);
                break;
            }
            default: {
                String string = "unexpected op-code for a binary operation: " + fcgBinOp + " " + fcgBinOp.toString();
                FinalCodeGenerator.unimplementedException(string);
                object = null;
            }
        }
        return object;
    }

    protected abstract Object genCode_BINARY_ADD(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_ADD_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_ADD_STRING(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_BITWISE_AND(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_OR(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_XOR(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_BITWISE_XOR_BIG(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_COMPARE_EQ_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_REFERENCE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_EQ_STRING(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_REFERENCE(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_NOT_EQ_STRING(StackValue var1, StackValue var2, FcgType var3, FcgType var4);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_BIG(StackValue var1, StackValue var2, FcgType var3, FcgType var4, int var5);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_PRIMITIVE(StackValue var1, StackValue var2, FcgType var3, FcgType var4, int var5);

    protected abstract Object genCode_BINARY_COMPARE_ORDER_STRING(StackValue var1, StackValue var2, int var3);

    protected abstract Object genCode_BINARY_DIVIDE(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_DIVIDE_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_AND_EVALBOTH(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_CONDITIONAL_AND(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_CONDITIONAL_OR(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_OR_EVALBOTH(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_LOGICAL_XOR(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_MODULO(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_MODULO_BIG(StackValue var1, StackValue var2);

    protected abstract Object genCode_BINARY_MULTIPLY(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_MULTIPLY_BIG(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_SHIFT_LEFT(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SHIFT_RIGHT(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SHIFT_RIGHT_UNSIGNED(StackValue var1, StackValue var2, FcgType var3);

    protected abstract Object genCode_BINARY_SUBTRACT(StackValue var1, StackValue var2, FcgType var3, int var4);

    protected abstract Object genCode_BINARY_SUBTRACT_BIG(StackValue var1, StackValue var2);

    protected final Object genCode_coerce(FcgType fcgType, FcgType fcgType2, StackValue stackValue) {
        Object object;
        if (fcgType == fcgType2) {
            return stackValue.getCodeData();
        }
        if (fcgType == FcgType.STRING) {
            if (fcgType2 == FcgType.CHAR_ARRAY) {
                object = this.genCode_COERCE_STRING2CHAR_ARRAY(stackValue);
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BYTE) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.CHAR) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                object = this.genCode_COERCE_2REFERENCE_TYPE(fcgType2, stackValue);
            } else if (fcgType2 == FcgType.DOUBLE) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.FLOAT) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.INT) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.LONG) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.OBJECT) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.SHORT) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.BIG_DECIMAL) {
            if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_BIG_DECIMAL2BOOLEAN(fcgType, stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_BIG_DECIMAL2BYTE(fcgType, stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_BIG_DECIMAL2CHAR(fcgType, stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_BIG_DECIMAL2DOUBLE(fcgType, stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_BIG_DECIMAL2FLOAT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_BIG_DECIMAL2INT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_BIG_DECIMAL2LONG(fcgType, stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_BIG_DECIMAL2SHORT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                object = this.genCode_COERCE_2REFERENCE_TYPE(fcgType2, stackValue);
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.BIG_INTEGER) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_BIG_INTEGER2BOOLEAN(fcgType, stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_BIG_INTEGER2BYTE(fcgType, stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_BIG_INTEGER2CHAR(fcgType, stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_BIG_INTEGER2DOUBLE(fcgType, stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_BIG_INTEGER2FLOAT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_BIG_INTEGER2INT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_BIG_INTEGER2LONG(fcgType, stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_BIG_INTEGER2SHORT(fcgType, stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                object = this.genCode_COERCE_2REFERENCE_TYPE(fcgType2, stackValue);
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.BOOLEAN) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_BOOLEAN2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_BOOLEAN2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_BOOLEAN2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_BOOLEAN2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_BOOLEAN2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_BOOLEAN2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_BOOLEAN2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.BYTE) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_BYTE2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_BYTE2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_BYTE2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_BYTE2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_BYTE2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_BYTE2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_BYTE2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.CHAR) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_CHAR2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_CHAR2INT(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_CHAR2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_CHAR2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_CHAR2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_CHAR2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.CHAR_ARRAY) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_CHAR_ARRAY2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_CHAR_ARRAY2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                object = this.genCode_COERCE_CHAR_ARRAY2STRING(stackValue);
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_CHAR_ARRAY2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_CHAR_ARRAY2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_CHAR_ARRAY2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_CHAR_ARRAY2LONG(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_CHAR_ARRAY2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType instanceof FcgClassReferenceType || fcgType instanceof FcgInterfaceType) {
            if (fcgType2 instanceof FcgArrayType) {
                object = this.genCode_COERCE_2REFERENCE_TYPE(fcgType2, stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType || fcgType2 instanceof FcgInterfaceType) {
                object = this.genCode_COERCE_2REFERENCE_TYPE2(fcgType2, stackValue);
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.DOUBLE) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object = this.genCode_COERCE_DOUBLE2BIG_DECIMAL(stackValue);
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_DOUBLE2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_DOUBLE2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_DOUBLE2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_DOUBLE2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_DOUBLE2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_DOUBLE2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_DOUBLE2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.FLOAT) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object = this.genCode_COERCE_FLOAT2BIG_DECIMAL(stackValue);
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_FLOAT2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_FLOAT2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_FLOAT2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_FLOAT2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_FLOAT2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_FLOAT2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_FLOAT2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.INT || fcgType == INT_LITERAL) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object = this.genCode_COERCE_INT2BIG_DECIMAL(stackValue);
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_INT2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_INT2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_INT2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                object = this.genCode_COERCE_INT2CHAR_ARRAY(stackValue);
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_INT2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_INT2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_INT2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_INT2SHORT(stackValue);
            } else if (fcgType2 == FcgType.STRING) {
                object = this.genCode_COERCE_INT2STRING(stackValue);
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.LONG) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                object = this.genCode_COERCE_LONG2BIG_DECIMAL(stackValue);
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_LONG2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_LONG2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_LONG2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRING) {
                object = this.genCode_COERCE_LONG2STRING(stackValue);
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_LONG2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_LONG2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_LONG2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.SHORT) {
                object = this.genCode_COERCE_LONG2SHORT(stackValue);
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.SHORT) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                object = this.genCode_COERCE_SHORT2BOOLEAN(stackValue);
            } else if (fcgType2 == FcgType.BYTE) {
                object = this.genCode_COERCE_SHORT2BYTE(stackValue);
            } else if (fcgType2 == FcgType.CHAR) {
                object = this.genCode_COERCE_SHORT2CHAR(stackValue);
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                object = this.genCode_COERCE_SHORT2CHAR_ARRAY(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                object = this.genCode_COERCE_SHORT2DOUBLE(stackValue);
            } else if (fcgType2 == FcgType.FLOAT) {
                object = this.genCode_COERCE_SHORT2FLOAT(stackValue);
            } else if (fcgType2 == FcgType.INT) {
                object = this.genCode_COERCE_SHORT2INT(stackValue);
            } else if (fcgType2 == FcgType.LONG) {
                object = this.genCode_COERCE_SHORT2LONG(stackValue);
            } else if (fcgType2 == FcgType.SHORT) {
                object = stackValue.getCodeData();
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else if (fcgType == FcgType.STRINGBUFFER) {
            if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_DECIMAL) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BIG_INTEGER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BOOLEAN) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.BYTE) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.CHAR) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.CHAR_ARRAY) {
                object = this.genCode_COERCE_STRINGBUFFER2CHAR_ARRAY(stackValue);
            } else if (fcgType2 instanceof FcgClassReferenceType) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.DOUBLE) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.FLOAT) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.INT) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.SHORT) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRING) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else if (fcgType2 == FcgType.STRINGBUFFER) {
                FinalCodeGenerator.unimplementedException();
                object = null;
            } else {
                FinalCodeGenerator.unimplementedException();
                object = null;
            }
        } else {
            FinalCodeGenerator.unimplementedException();
            object = null;
        }
        return object;
    }

    protected abstract Object genCode_COERCE_2REFERENCE_TYPE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_2REFERENCE_TYPE2(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2BOOLEAN(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2BYTE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2CHAR(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2DOUBLE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2FLOAT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2INT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2LONG(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_DECIMAL2SHORT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2BOOLEAN(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2BYTE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2CHAR(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2DOUBLE(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2FLOAT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2INT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2LONG(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BIG_INTEGER2SHORT(FcgType var1, StackValue var2);

    protected abstract Object genCode_COERCE_BOOLEAN2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2INT(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_BOOLEAN2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2INT(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_BYTE2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2INT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR_ARRAY2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2INT(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_CHAR2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2INT(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_DOUBLE2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2INT(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_FLOAT2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_INT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_INT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_INT2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_INT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_INT2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_INT2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_INT2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BIG_DECIMAL(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2INT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2SHORT(StackValue var1);

    protected abstract Object genCode_COERCE_LONG2STRING(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2BOOLEAN(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2BYTE(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2CHAR(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2DOUBLE(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2FLOAT(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2INT(StackValue var1);

    protected abstract Object genCode_COERCE_SHORT2LONG(StackValue var1);

    protected abstract Object genCode_COERCE_STRING2CHAR_ARRAY(StackValue var1);

    protected abstract Object genCode_COERCE_STRINGBUFFER2CHAR_ARRAY(StackValue var1);

    public static final class UnaryOp
    extends Operation2
    implements FcgUnaryOp {
        public UnaryOp(String string, int n) {
            super(string, n);
        }
    }

    public static final class BinaryOp
    extends Operation2
    implements FcgBinOp {
        public BinaryOp(String string, int n) {
            super(string, n);
        }
    }

    private static class Operation2
    implements FcgBinOp {
        private static HashMap s_opCodes = new HashMap();
        private final String m_name;
        private final int m_opCode;

        private Operation2(String string, int n) {
            String string2;
            this.m_name = string;
            this.m_opCode = n;
            String string3 = Integer.toString(n);
            if (DO_COMPILE_CHECKING && (string2 = (String)s_opCodes.get(string3)) != null) {
                String string4 = "FinalCodeGenerator: opcode " + string3 + " already in use by '" + string2 + "', now wants to be used by '" + string;
                throw new RuntimeException(string4);
            }
            s_opCodes.put(string3, string);
        }

        private int getFcgOpCode() {
            return this.m_opCode;
        }

        public String toString() {
            return this.m_name;
        }
    }

    private final class LocalVarStack {
        private static final int INITIAL_STACK_SIZE = 16;
        private int m_freeIndex = 0;
        private FcgVarMutableInternal[] m_stackArr = new FcgVarMutableInternal[16];

        private int numLocalVars() {
            return this.m_freeIndex;
        }

        private LocalVarStack() {
        }

        private int size() {
            return this.m_freeIndex;
        }

        private FcgVariable push(String string, FcgType fcgType, FcgAttrs fcgAttrs) {
            Object object;
            int n = this.m_stackArr.length;
            if (this.m_freeIndex == n) {
                object = new FcgVarMutableInternal[n * 2];
                System.arraycopy(this.m_stackArr, 0, object, 0, n);
                this.m_stackArr = object;
            }
            if ((object = this.m_stackArr[this.m_freeIndex]) == null) {
                this.m_stackArr[this.m_freeIndex] = object = FinalCodeGenerator.this.newFcgVariable();
            }
            object.setName(string);
            object.setType(fcgType);
            object.setAttrs(fcgAttrs);
            ++this.m_freeIndex;
            return object;
        }

        private void pop(String string) {
            String string2;
            int n = --this.m_freeIndex;
            if (DO_COMPILE_CHECKING && !string.equals(string2 = this.m_stackArr[n].getName())) {
                FinalCodeGenerator.error("FCG: Popped a variable named '" + string2 + "' but expected to pop one named '" + string + "'.");
            }
        }

        FcgType getVarType(String string) {
            FcgType fcgType = null;
            if (string.equals("__should_never_be_used__")) {
                fcgType = FcgType.VOID;
                return fcgType;
            }
            for (int i = this.m_freeIndex - 1; 0 <= i; --i) {
                if (!string.equals(this.m_stackArr[i].getName())) continue;
                fcgType = this.m_stackArr[i].getType();
                break;
            }
            if (fcgType != null) {
                return fcgType;
            }
            if (fcgType == null) {
                fcgType = FcgType.OBJECT;
            }
            if (DO_COMPILE_CHECKING && fcgType == null) {
                FinalCodeGenerator.error("FCG: failed to find variable named '" + string + "'");
            }
            return fcgType;
        }

        private FcgVariable peek() {
            return this.m_stackArr[this.m_freeIndex - 1];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("LocalVarStack:\n");
            if (this.size() == 0) {
                stringBuffer.append("  *** EMPTY ***");
            } else {
                for (int i = this.size() - 1; 0 <= i; --i) {
                    stringBuffer.append("  * ");
                    stringBuffer.append(this.m_stackArr[i].toString());
                    stringBuffer.append('\n');
                }
            }
            return stringBuffer.toString();
        }
    }

    protected static final class CodeGenStack {
        private static final int INITIAL_STACK_SIZE = 16;
        private int m_freeIndex = 0;
        private StackValue[] m_stackArr = new StackValue[16];

        private CodeGenStack() {
        }

        private int size() {
            return this.m_freeIndex;
        }

        private void push(Construct construct, FcgType fcgType, Object object, int n) {
            Object object2;
            int n2 = this.m_stackArr.length;
            if (this.m_freeIndex == n2) {
                object2 = new StackValue[n2 * 2];
                System.arraycopy(this.m_stackArr, 0, object2, 0, n2);
                this.m_stackArr = object2;
            }
            if ((object2 = this.m_stackArr[this.m_freeIndex]) == null) {
                this.m_stackArr[this.m_freeIndex] = object2 = new StackValue();
            } else if (DO_COMPILE_CHECKING && ((StackValue)object2).needsReset()) {
                FinalCodeGenerator.error("FCG: Recycled StackValue was not reset! " + object2);
            }
            if (debug_reset) {
                System.out.println("push: " + object2);
            }
            ((StackValue)object2).setConstructKind(construct);
            ((StackValue)object2).setType(fcgType);
            ((StackValue)object2).setCodeData(object);
            ((StackValue)object2).setNumLocalVars(n);
            ++this.m_freeIndex;
            if (debug_reset) {
                for (int i = this.m_freeIndex; i < this.m_stackArr.length - 1; ++i) {
                    if (this.m_stackArr[i] == null || !this.m_stackArr[i].needsReset()) continue;
                    FinalCodeGenerator.error("FCG: Recycled StackValue was not reset! " + this.m_stackArr[i]);
                }
            }
        }

        private Construct peekAtConstructKind() {
            return this.m_stackArr[this.m_freeIndex - 1].getConstructKind();
        }

        private FcgType peekAtType() {
            return this.m_stackArr[this.m_freeIndex - 1].getType();
        }

        private StackValue peek() {
            if (this.m_freeIndex == 0) {
                return null;
            }
            return this.m_stackArr[this.m_freeIndex - 1];
        }

        private StackValue peek(Construct construct) {
            Object object;
            if (DO_COMPILE_CHECKING) {
                object = this.peekAtConstructKind();
                if (this.peekAtConstructKind() != construct) {
                    String string = "FCG: Construct on top of the FCG stack is " + this.peekAtConstructKind().toString() + " but the expected construct kind is " + construct.toString();
                    FinalCodeGenerator.error(string);
                }
            }
            object = this.peek();
            return object;
        }

        private StackValue peek(int n) {
            return this.m_stackArr[this.m_freeIndex - 1 - n];
        }

        private StackValue pop(Construct construct) {
            Object object;
            if (DO_COMPILE_CHECKING && this.peekAtConstructKind() != construct) {
                object = "FCG: Popped construct from the top of FCG stack is " + this.peekAtConstructKind().toString() + " but the expected construct kind is " + construct.toString();
                FinalCodeGenerator.error((String)object);
            }
            --this.m_freeIndex;
            object = this.m_stackArr[this.m_freeIndex];
            if (debug_reset) {
                System.out.println("pop: " + object);
            }
            return object;
        }

        public StackValue peekAtStackValue(int n) {
            return this.m_stackArr[n];
        }

        private void assertStackIsEmpty() {
            if (this.m_freeIndex != 0) {
                FinalCodeGenerator.error("FCG: Code generation stack is not empty at end of code generation!");
            }
            for (int i = 0; i < this.m_stackArr.length && this.m_stackArr[i] != null; ++i) {
                if (!this.m_stackArr[i].needsReset()) continue;
                FinalCodeGenerator.error("FCG: Recycled StackValue was not reset!");
            }
        }
    }

    public static class Construct {
        final String m_name;

        private Construct(String string) {
            this.m_name = string;
        }

        public String toString() {
            return this.m_name;
        }
    }

    public static final class StackValue {
        private static int s_id_counter;
        private int m_id;
        private Construct m_constructKind;
        private FcgType m_valueType;
        private Object m_codeData;
        private int m_numLocalVars;
        private boolean m_needsReset = false;
        private int m_int_literal = 0;

        private StackValue() {
            if (debug_reset) {
                this.m_id = ++s_id_counter;
            }
        }

        public Object clone() {
            StackValue stackValue = new StackValue();
            stackValue.m_constructKind = this.m_constructKind;
            stackValue.m_valueType = this.m_valueType;
            stackValue.m_codeData = this.m_codeData;
            stackValue.m_numLocalVars = this.m_numLocalVars;
            stackValue.m_needsReset = this.m_needsReset;
            return stackValue;
        }

        public void reset() {
            this.m_constructKind = null;
            this.m_valueType = FcgBasicType.VOID;
            this.m_codeData = null;
            this.m_numLocalVars = 0;
            this.m_needsReset = false;
            if (debug_reset) {
                System.out.println("reset: " + this);
            }
        }

        private void setConstructKind(Construct construct) {
            this.m_constructKind = construct;
            this.m_needsReset = true;
        }

        public Construct getConstructKind() {
            return this.m_constructKind;
        }

        private void setType(FcgType fcgType) {
            this.m_valueType = fcgType == null ? FcgBasicType.VOID : fcgType;
            this.m_needsReset = true;
        }

        private void setLiteralValue(int n) {
            this.m_int_literal = n;
            this.m_needsReset = true;
        }

        public FcgType getType() {
            return this.m_valueType;
        }

        private int getIntLiteralValue() {
            return this.m_int_literal;
        }

        private void setCodeData(Object object) {
            this.m_codeData = object;
        }

        public Object getCodeData() {
            return this.m_codeData;
        }

        private int getNumLocalVars() {
            return this.m_numLocalVars;
        }

        private void setNumLocalVars(int n) {
            this.m_numLocalVars = n;
        }

        private boolean needsReset() {
            return this.m_needsReset;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("StackValue#" + this.m_id + " ");
            if (this.m_constructKind != null) {
                stringBuffer.append(this.m_constructKind.toString()).append(' ');
            }
            if (this.m_valueType != null) {
                stringBuffer.append(((Object)this.m_valueType).toString()).append(' ');
            }
            if (this.m_codeData != null) {
                stringBuffer.append(this.m_codeData.toString()).append(' ');
            }
            if (this.m_valueType == INT_LITERAL) {
                stringBuffer.append(" int literal: ").append(this.m_int_literal).append(' ');
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
    }
}

