/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fcg.ifacecore;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.impl.FinalCodeGenerator;

public final class FcgAttrsImpl
implements FcgAttrs {
    public static final int ACC_SUPER = 128;
    public static final int ACC_PUBLIC = 2;
    public static final int ACC_STATIC = 4;
    public static final int ACC_PRIVATE = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_PROTECTED = 32;
    public static final int ACC_ABSTRACT = 64;
    final int m_attrs;

    public FcgAttrsImpl(int n) {
        this.m_attrs = n;
    }

    public int getAttrs() {
        return this.m_attrs;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.m_attrs & 0x10) > 0) {
            stringBuffer.append("final ");
        }
        if ((this.m_attrs & 0x40) > 0) {
            stringBuffer.append("abstract ");
        }
        if ((this.m_attrs & 2) > 0) {
            stringBuffer.append("public ");
        }
        if ((this.m_attrs & 8) > 0) {
            stringBuffer.append("private ");
        }
        if ((this.m_attrs & 0x20) > 0) {
            stringBuffer.append("protected ");
        }
        if ((this.m_attrs & 4) > 0) {
            stringBuffer.append("static ");
        }
        if ((this.m_attrs & 0x80) > 0) {
            stringBuffer.append("super ");
        }
        return stringBuffer.toString();
    }

    public boolean isStatic() {
        boolean bl = 0 < (this.m_attrs & 4);
        return bl;
    }

    public boolean isPublic() {
        boolean bl = 0 < (this.m_attrs & 2);
        return bl;
    }

    public boolean isAbstract() {
        boolean bl = 0 < (this.m_attrs & 0x40);
        return bl;
    }

    public boolean isProtected() {
        boolean bl = 0 < (this.m_attrs & 0x20);
        return bl;
    }

    public boolean isPrivate() {
        boolean bl = 0 < (this.m_attrs & 8);
        return bl;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isFinal() {
        boolean bl = 0 < (this.m_attrs & 0x10);
        return bl;
    }

    public boolean isSuper() {
        boolean bl = 0 < (this.m_attrs & 0x80);
        return bl;
    }

    public FcgAttrs union(FcgAttrs fcgAttrs) {
        FcgAttrsImpl fcgAttrsImpl = (FcgAttrsImpl)fcgAttrs;
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && (this.isPrivate() && !fcgAttrs.isPackagePrivate() && !fcgAttrs.isPrivate() || this.isPublic() && !fcgAttrs.isPackagePrivate() && !fcgAttrs.isPublic() || this.isProtected() && !fcgAttrs.isPackagePrivate() && !fcgAttrs.isProtected())) {
            String string = "FCG: can't merge attributes \"" + this.toString() + "\" with \"" + fcgAttrs.toString() + "\"";
            FinalCodeGenerator.error(string);
        }
        int n = this.m_attrs | fcgAttrsImpl.m_attrs;
        FcgAttrsImpl fcgAttrsImpl2 = new FcgAttrsImpl(n);
        return fcgAttrsImpl2;
    }
}

