/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fcg.bcel;

import com.ibm.fcg.FcgAttrs;
import com.ibm.fcg.FcgClassGen;
import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgField;
import com.ibm.fcg.FcgInstructionList;
import com.ibm.fcg.FcgMethodGen;
import com.ibm.fcg.FcgReferenceType;
import com.ibm.fcg.FcgType;
import com.ibm.fcg.bcel.FcgCodeGenBCEL;
import com.ibm.fcg.bcel.FcgFieldGenBCEL;
import com.ibm.fcg.bcel.FcgInstructionListBCEL;
import com.ibm.fcg.bcel.FcgMethodGenBCEL;
import com.ibm.fcg.ifacecore.FcgAttrsImpl;
import com.ibm.fcg.ifacecore.FcgBasicType;
import com.ibm.fcg.impl.FcgClassGenImpl;
import com.ibm.fcg.impl.FcgCodeGenImpl;
import com.ibm.fcg.impl.FinalCodeGenerator;
import com.ibm.xtq.bcel.classfile.Code;
import com.ibm.xtq.bcel.classfile.Method;
import com.ibm.xtq.bcel.generic.ClassGen;
import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.Instruction;
import com.ibm.xtq.bcel.generic.InstructionFactory;
import com.ibm.xtq.bcel.generic.InstructionList;
import com.ibm.xtq.bcel.generic.MethodGen;
import com.ibm.xtq.bcel.generic.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class FcgClassGenBCEL
extends FcgClassGenImpl
implements FcgClassGen {
    private static final int METHOD_SIZE_LIMIT = 65535;
    private final FcgClassReferenceType class_name;
    private final FcgClassReferenceType super_class_name;
    private final String file_name;
    private final FcgAttrs m_attrs;
    private int m_numberOfClassFields;
    private final ClassGen _cg;
    private final ConstantPoolGen _cp;
    private final InstructionFactory _factory;
    FcgMethodGen m_staticCode;
    private LinkedInstructionList m_free_ils;
    private FcgMethodGen m_currentMethodGen;

    public FcgClassGenBCEL(FcgCodeGen fcgCodeGen, FcgClassReferenceType fcgClassReferenceType, FcgClassReferenceType fcgClassReferenceType2, String string, FcgAttrs fcgAttrs, String[] stringArray) {
        super(fcgCodeGen);
        this.class_name = fcgClassReferenceType;
        if (fcgClassReferenceType2 == null) {
            fcgClassReferenceType2 = FcgType.OBJECT;
        }
        this.super_class_name = fcgClassReferenceType2;
        this.file_name = string;
        this.m_attrs = fcgAttrs;
        int n = 32;
        n = this.m_attrs != null ? (n |= FcgCodeGenBCEL.fcg2bcelAttrs(this.m_attrs)) : (n |= 1);
        this._cg = new ClassGen(this.class_name.getTypeName(), this.super_class_name.getTypeName(), this.class_name.getTypeName() + ".java", n, stringArray);
        this._cp = this._cg.getConstantPool();
        this._factory = new InstructionFactory(this._cg, this._cp);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this._cg.addInterface(stringArray[i]);
            }
        }
    }

    ConstantPoolGen getbcelConstPool() {
        return this._cp;
    }

    public ClassGen getbcelClassGen() {
        return this._cg;
    }

    public final void dump(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.dump2(fileOutputStream);
        fileOutputStream.flush();
    }

    private void dump2(OutputStream outputStream) throws IOException {
        this.finish();
        this._cg.getJavaClass().dump(outputStream);
    }

    public final void dump(OutputStream outputStream) throws IOException {
        this.dump2(outputStream);
        outputStream.flush();
        outputStream.close();
    }

    public final String getClassName() {
        return this.class_name.getTypeName();
    }

    public final String getSuperClassName() {
        return this.super_class_name.getTypeName();
    }

    public final FcgClassReferenceType getClassType() {
        return this.class_name;
    }

    public final FcgClassReferenceType getSuperClassType() {
        return this.super_class_name;
    }

    public final FcgInstructionList newInstructionList() {
        FcgCodeGenImpl fcgCodeGenImpl = this.m_fcgCodeGen;
        FcgMethodGenBCEL fcgMethodGenBCEL = (FcgMethodGenBCEL)this.getCurrentMethod();
        return new FcgInstructionListBCEL(this, null, fcgMethodGenBCEL);
    }

    public final FcgInstructionList newInstructionList(FcgMethodGen fcgMethodGen) {
        return new FcgInstructionListBCEL(this, null, fcgMethodGen);
    }

    public final FcgInstructionList getClassInstructionList() {
        if (this.m_staticCode == null) {
            this.getClassInitMethod();
        }
        return this.m_staticCode.getInstructionList();
    }

    private String toString(FcgAttrs fcgAttrs) {
        FcgAttrsImpl fcgAttrsImpl = (FcgAttrsImpl)fcgAttrs;
        StringBuffer stringBuffer = new StringBuffer();
        int n = fcgAttrsImpl.getAttrs();
        if ((n & 0x40) > 0) {
            stringBuffer.append("abstract ");
        }
        if ((n & 0x10) > 0) {
            stringBuffer.append("final ");
        }
        if ((n & 2) > 0) {
            stringBuffer.append("public ");
        }
        if ((n & 8) > 0) {
            stringBuffer.append("private ");
        }
        if ((n & 0x20) > 0) {
            stringBuffer.append("protected ");
        }
        if ((n & 4) > 0) {
            stringBuffer.append("static ");
        }
        String string = stringBuffer.toString();
        return string;
    }

    boolean hasDefaultConstructor() {
        return this.m_defaultCtor != null;
    }

    public final FcgMethodGen getClassInitMethod() {
        if (this.m_staticCode == null) {
            this.m_staticCode = new FcgMethodGenBCEL(this, FcgAttrs.STATIC, FcgType.VOID, this.class_name, "<clinit>", null);
        }
        return this.m_staticCode;
    }

    public final FcgField newInstanceField(FcgAttrs fcgAttrs, FcgType fcgType, String string) {
        if (fcgAttrs == null) {
            fcgAttrs = FcgAttrs.PUBLIC;
        }
        if (FinalCodeGenerator.DO_COMPILE_CHECKING) {
            if (fcgAttrs.isStatic()) {
                FinalCodeGenerator.error("FCG: creating an instance field named " + string + " in class " + this.getClassName() + " but its  attributes say it is STATIC.");
            }
            if (fcgType == FcgBasicType.VOID) {
                throw new RuntimeException("FcgClassGenBCEL, internal error, can't have an instance field of type void!");
            }
        }
        FcgFieldGenBCEL fcgFieldGenBCEL = new FcgFieldGenBCEL(this, fcgAttrs, fcgType, string);
        super.addField(fcgFieldGenBCEL);
        return fcgFieldGenBCEL;
    }

    FcgField findInstanceField(String string) {
        int n = super.getNumFcgFields();
        for (int i = 0; i < n; ++i) {
            FcgField fcgField = this.getField(i);
            if (!string.equals(fcgField.getName())) continue;
            return fcgField;
        }
        return null;
    }

    public final FcgField newClassField(FcgAttrs fcgAttrs, FcgType fcgType, String string) {
        if (fcgAttrs == null) {
            fcgAttrs = FcgAttrs.PUBLIC_STATIC;
        }
        if (FinalCodeGenerator.DO_COMPILE_CHECKING && !fcgAttrs.isStatic()) {
            FinalCodeGenerator.error("FCG: creating a class (i.e. static) field named " + string + " in class " + this.getClassName() + " but the creation attributes don't include STATIC");
        }
        FcgFieldGenBCEL fcgFieldGenBCEL = new FcgFieldGenBCEL(this, fcgAttrs, fcgType, string);
        super.addField(fcgFieldGenBCEL);
        ++this.m_numberOfClassFields;
        return fcgFieldGenBCEL;
    }

    public final int getNumberOfClassFields() {
        return this.m_numberOfClassFields;
    }

    public final FcgMethodGen newConstructorGen(FcgAttrs fcgAttrs) {
        FcgMethodGenBCEL fcgMethodGenBCEL = new FcgMethodGenBCEL(this, fcgAttrs, FcgType.VOID, this.class_name, null, null);
        return fcgMethodGenBCEL;
    }

    private FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, FcgReferenceType fcgReferenceType, String string, FcgType[] fcgTypeArray, FcgInstructionList fcgInstructionList) {
        FcgMethodGenBCEL fcgMethodGenBCEL = new FcgMethodGenBCEL(this, fcgAttrs, fcgType, fcgReferenceType, string, fcgInstructionList);
        return fcgMethodGenBCEL;
    }

    public final void addMethod(FcgMethodGen fcgMethodGen) {
        int n;
        super.addMethod(fcgMethodGen);
        FcgMethodGenBCEL fcgMethodGenBCEL = (FcgMethodGenBCEL)fcgMethodGen;
        MethodGen methodGen = fcgMethodGenBCEL.getBCELMethodGen();
        Method method = methodGen.getMethod();
        Code code = method.getCode();
        if (code != null && (n = code.getLength()) > 65535) {
            throw new FcgMethodSizeException(n, fcgMethodGenBCEL.getName());
        }
        this._cg.addMethod(method);
    }

    public final FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, String string, FcgInstructionList fcgInstructionList) {
        FcgClassReferenceType fcgClassReferenceType = this.getClassType();
        FcgMethodGenBCEL fcgMethodGenBCEL = new FcgMethodGenBCEL(this, fcgAttrs, fcgType, fcgClassReferenceType, string, fcgInstructionList);
        return fcgMethodGenBCEL;
    }

    public final void comment(String string) {
    }

    public final void finish() {
        if (!this.hasDefaultConstructor()) {
            this.addDefaultConstructor(this.m_fcgCodeGen);
        }
    }

    public final FcgCodeGen getFcgCodeGen() {
        return this.m_fcgCodeGen;
    }

    private FcgMethodGen newConstructorGen(FcgAttrs fcgAttrs, String string, FcgInstructionList fcgInstructionList) {
        FcgMethodGenBCEL fcgMethodGenBCEL = new FcgMethodGenBCEL(this, fcgInstructionList);
        return fcgMethodGenBCEL;
    }

    public final void addDefaultConstructor(FcgCodeGen fcgCodeGen) {
        this.addDefaultConstructor(fcgCodeGen, null);
    }

    public final void addDefaultConstructor(FcgCodeGen fcgCodeGen, FcgInstructionList fcgInstructionList) {
        FcgInstructionList fcgInstructionList2;
        if (!this.hasDefaultConstructor()) {
            String string = this.getClassName();
            FcgMethodGen fcgMethodGen = this.newConstructorGen(FcgAttrs.PUBLIC, string, fcgInstructionList);
            fcgInstructionList2 = fcgMethodGen.getInstructionList();
            this.setDefaultCtor(fcgMethodGen);
            fcgInstructionList2.beginMethod();
            String string2 = this.super_class_name.getTypeName();
            FcgInstructionListBCEL fcgInstructionListBCEL = (FcgInstructionListBCEL)fcgInstructionList2;
            InstructionList instructionList = fcgInstructionListBCEL.getCode();
            instructionList.append((Instruction)InstructionFactory.createLoad((Type)Type.OBJECT, (int)0));
            instructionList.append((Instruction)this._factory.createInvoke(string2, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
        } else {
            fcgInstructionList2 = this.m_defaultCtor.getInstructionList();
        }
        fcgInstructionList2.returnInstruction();
        fcgInstructionList2.endMethod();
    }

    public final void addInterface(String string) {
        this._cg.addInterface(string);
    }

    InstructionFactory getBCELInstructionFactory() {
        return this._factory;
    }

    InstructionList getInstructionList() {
        LinkedInstructionList linkedInstructionList;
        if (this.m_free_ils != null) {
            linkedInstructionList = this.m_free_ils;
            this.m_free_ils = this.m_free_ils.m_next;
        } else {
            linkedInstructionList = new LinkedInstructionList();
        }
        return linkedInstructionList;
    }

    void disposeInstructionList(InstructionList instructionList) {
        instructionList.dispose();
        LinkedInstructionList linkedInstructionList = (LinkedInstructionList)instructionList;
        linkedInstructionList.m_next = this.m_free_ils;
        this.m_free_ils = linkedInstructionList;
    }

    private FcgMethodGen getCurrentMethod() {
        FcgMethodGen fcgMethodGen = this.m_currentMethodGen;
        return fcgMethodGen;
    }

    private void setCurrentMethod(FcgMethodGen fcgMethodGen) {
        this.m_currentMethodGen = fcgMethodGen;
    }

    public final FcgMethodGen newMethodGen(FcgAttrs fcgAttrs, FcgType fcgType, String string) {
        return this.newMethodGen(fcgAttrs, fcgType, string, null);
    }

    public static class FcgMethodSizeException
    extends RuntimeException {
        public int size;

        FcgMethodSizeException(int n, String string) {
            super("Method size limit of 65535 exceeded for method: " + string);
            this.size = n;
        }
    }

    static final class LinkedInstructionList
    extends InstructionList {
        LinkedInstructionList m_next;

        LinkedInstructionList() {
        }
    }
}

