/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
final class ResourceIterators {
    static final long serialVersionUID = -1334008651855808531L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ResourceIterators() {
        throw new AssertionError((Object)"This class is not instantiable");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ResourceIterators.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class MatchingIterator
    implements Iterator<String> {
        private final Iterator<String> i;
        private final Pattern regex;
        private String next = null;
        static final long serialVersionUID = -8128218374977626462L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        MatchingIterator(Iterator<String> i, String regex) {
            this.i = i;
            this.regex = Pattern.compile(regex);
        }

        @Override
        public boolean hasNext() {
            while (this.i.hasNext()) {
                String n = this.i.next();
                if (!this.regex.matcher(n).matches()) continue;
                this.next = n;
                return true;
            }
            return false;
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException("No more elements");
            }
            return this.next;
        }

        @Override
        public void remove() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(MatchingIterator.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    static class ChildIterator
    implements Iterator<String> {
        private final String[] children;
        private final File parent;
        private int index = 0;
        static final long serialVersionUID = -2892633576404459311L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ChildIterator(File p, String[] kids) {
            this.parent = p;
            this.children = kids == null ? new String[]{} : kids;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.children.length;
        }

        @Override
        public String next() {
            String child;
            File f;
            if (this.index >= this.children.length) {
                throw new NoSuchElementException("No more elements (p=" + this.parent.getAbsolutePath() + ")");
            }
            if ((f = new File(this.parent, child = this.children[this.index++])).isDirectory()) {
                child = child + '/';
            }
            return child;
        }

        @Override
        public void remove() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ChildIterator.class);
        }
    }
}

