/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.service.location.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.location.internal.InternalWsResource;
import com.ibm.ws.kernel.service.location.internal.ResourceUtils;
import com.ibm.ws.kernel.service.location.internal.SymbolicRootResource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.ExistingResourceException;
import com.ibm.wsspi.kernel.service.location.ResourceMismatchException;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class LocalFileResource
implements InternalWsResource {
    private static final TraceComponent tc = Tr.register(LocalFileResource.class);
    private final SymbolicRootResource resourceRoot;
    private final WsResource.Type type;
    private final File wrappedFile;
    private final String normalizedPath;
    private final String name;
    private final int hashCode;
    private String stringValue = null;
    private URI externalURI = null;
    private String repositoryPath = null;
    static final long serialVersionUID = 5701969043832885392L;

    public static LocalFileResource newResource(String normalizedPath, String repositoryPath) {
        return new LocalFileResource(normalizedPath, repositoryPath, null);
    }

    public static LocalFileResource newResource(String normalizedPath, String repositoryPath, SymbolicRootResource root) {
        return new LocalFileResource(normalizedPath, repositoryPath, root);
    }

    public static LocalFileResource newResourceFromResource(String normalizedPath, String repositoryPath, InternalWsResource related) {
        SymbolicRootResource root = null;
        if (related != null) {
            root = related.getSymbolicRoot();
        }
        return new LocalFileResource(normalizedPath, repositoryPath, root);
    }

    private LocalFileResource(String normalizedPath, String repositoryPath, SymbolicRootResource root) {
        if (normalizedPath == null) {
            throw new NullPointerException("File for a LocalFileResource can not be null");
        }
        File f = new File(normalizedPath);
        String tmpName = f.getName();
        if (normalizedPath.charAt(normalizedPath.length() - 1) == '/') {
            this.type = WsResource.Type.DIRECTORY;
            if (repositoryPath != null && repositoryPath.charAt(repositoryPath.length() - 1) != '/') {
                repositoryPath = repositoryPath + '/';
            }
            tmpName = tmpName + '/';
        } else {
            this.type = WsResource.Type.FILE;
            if (repositoryPath != null && repositoryPath.charAt(repositoryPath.length() - 1) == '/') {
                repositoryPath = repositoryPath.substring(0, repositoryPath.length() - 1);
            }
        }
        if (f.exists()) {
            if (f.isFile() && this.type == WsResource.Type.DIRECTORY) {
                throw new IllegalArgumentException("Path specified a directory, but resource exists as a file (path=" + normalizedPath + ")");
            }
            if (f.isDirectory() && this.type == WsResource.Type.FILE) {
                throw new IllegalArgumentException("Path specified a file, but resource exists as a directory (path=" + normalizedPath + ")");
            }
        }
        this.normalizedPath = normalizedPath;
        this.wrappedFile = f;
        this.name = tmpName;
        this.repositoryPath = repositoryPath;
        this.resourceRoot = root;
        this.hashCode = normalizedPath.hashCode();
    }

    @Override
    public String getNormalizedPath() {
        return this.normalizedPath;
    }

    @Override
    public String getRawRepositoryPath() {
        return this.repositoryPath;
    }

    /*
     * WARNING - void declaration
     */
    public boolean create() {
        if (this.wrappedFile.exists()) {
            return false;
        }
        boolean success = true;
        switch (this.type) {
            default: {
                if (!this.wrappedFile.getParentFile().exists()) {
                    success = FileUtils.ensureDirExists((File)this.wrappedFile.getParentFile());
                } else if (!this.wrappedFile.getParentFile().isDirectory()) {
                    return false;
                }
                if (!success) break;
                try {
                    success = this.wrappedFile.createNewFile();
                    break;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.service.location.internal.LocalFileResource", (String)"214", (Object)this, (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)"IOException creating file", (Object[])new Object[]{this.wrappedFile, e});
                    }
                    return false;
                }
            }
            case DIRECTORY: {
                if (this.wrappedFile.getParentFile().exists() && !this.wrappedFile.getParentFile().isDirectory()) {
                    return false;
                }
                success = this.wrappedFile.mkdirs();
            }
        }
        return success;
    }

    public boolean delete() {
        if (!this.wrappedFile.exists()) {
            return false;
        }
        return this.wrappedFile.delete();
    }

    public boolean exists() {
        return this.wrappedFile.exists();
    }

    public InputStream get() throws IOException {
        if (this.type == WsResource.Type.DIRECTORY) {
            throw new IOException("Can not read contents of a directory");
        }
        return new FileInputStream(this.wrappedFile);
    }

    public ReadableByteChannel getChannel() throws IOException {
        if (this.type == WsResource.Type.DIRECTORY) {
            throw new IOException("Can not read contents of a directory");
        }
        return new FileInputStream(this.wrappedFile).getChannel();
    }

    public WsResource getChild(String name) {
        if (this.type == WsResource.Type.FILE || !this.wrappedFile.isDirectory() || this.resourceRoot == null) {
            return null;
        }
        return ResourceUtils.getChildResource(this, name);
    }

    public Iterator<String> getChildren() {
        if (this.type == WsResource.Type.FILE || !this.wrappedFile.isDirectory() || this.resourceRoot == null) {
            return ResourceUtils.EMPTY_STRING_LIST.iterator();
        }
        return ResourceUtils.getChildren(this, this.wrappedFile);
    }

    public Iterator<String> getChildren(String regex) {
        if (this.type == WsResource.Type.FILE || !this.wrappedFile.isDirectory() || this.resourceRoot == null) {
            return ResourceUtils.EMPTY_STRING_LIST.iterator();
        }
        return ResourceUtils.getChildren(this, this.wrappedFile, regex);
    }

    public String getName() {
        return this.name;
    }

    public WsResource getParent() {
        if (this.resourceRoot == null) {
            return null;
        }
        return ResourceUtils.getParentResource(this, this.resourceRoot);
    }

    public WsResource.Type getType() {
        return this.type;
    }

    public boolean isType(WsResource.Type type) {
        return this.type == type;
    }

    public long getLastModified() {
        return this.wrappedFile.lastModified();
    }

    public boolean setLastModified(long lastModified) {
        return this.wrappedFile.setLastModified(lastModified);
    }

    public boolean moveTo(WsResource target) throws IOException {
        if (target == null) {
            throw new NullPointerException("Can not move to a null resource");
        }
        if (this.equals(target)) {
            return false;
        }
        if (target.exists()) {
            throw new ExistingResourceException(this.toString(), target.toString());
        }
        if (!target.isType(this.type)) {
            throw new ResourceMismatchException(target.toRepositoryPath(), this.type, target.getType());
        }
        if (target instanceof LocalFileResource) {
            LocalFileResource targetFile = (LocalFileResource)target;
            return this.wrappedFile.renameTo(targetFile.wrappedFile);
        }
        throw new UnsupportedOperationException("Can only move files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(InputStream source) throws IOException {
        if (source == null) {
            return;
        }
        OutputStream os = this.putStream();
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = source.read(buffer)) >= 0) {
                os.write(buffer, 0, read);
            }
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ReadableByteChannel source) throws IOException {
        if (source == null || !source.isOpen()) {
            return;
        }
        WritableByteChannel os = this.putChannel();
        FileChannel fos = null;
        try {
            if (source instanceof FileChannel) {
                fos = (FileChannel)os;
                FileChannel fis = (FileChannel)source;
                fis.transferTo(0L, fis.size(), fos);
            } else {
                int rc;
                ByteBuffer buf = ByteBuffer.allocate(1024);
                while ((rc = source.read(buf)) >= 0) {
                    if (rc == 0) continue;
                    buf.flip();
                    os.write(buf);
                    buf.clear();
                }
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            } else if (os != null) {
                os.close();
            }
        }
    }

    public WritableByteChannel putChannel() throws IOException {
        FileOutputStream fos = (FileOutputStream)this.putStream();
        return fos.getChannel();
    }

    public OutputStream putStream() throws IOException {
        if (this.type == WsResource.Type.DIRECTORY) {
            throw new IOException("Can not write to a directory");
        }
        if (!FileUtils.ensureDirExists((File)this.wrappedFile.getParentFile())) {
            throw new IOException("Unable to create parent directory");
        }
        return new FileOutputStream(this.wrappedFile);
    }

    public WsResource resolveRelative(String relativeResourceURI) {
        if (relativeResourceURI == null) {
            return null;
        }
        if (relativeResourceURI.length() == 0) {
            return LocalFileResource.newResourceFromResource(this.normalizedPath, this.repositoryPath, this);
        }
        if (this.resourceRoot == null) {
            return null;
        }
        if (relativeResourceURI.equals("${/}")) {
            return this.resourceRoot;
        }
        return ResourceUtils.getRelativeResource(this, relativeResourceURI);
    }

    @Override
    public SymbolicRootResource getSymbolicRoot() {
        return this.resourceRoot;
    }

    @Trivial
    public File asFile() {
        return this.wrappedFile;
    }

    @Trivial
    public URI toExternalURI() {
        URI local = this.externalURI;
        if (local == null) {
            local = this.wrappedFile.toURI();
            String sURI = local.toString();
            if (this.type == WsResource.Type.DIRECTORY && sURI.charAt(sURI.length() - 1) != '/') {
                local = URI.create(sURI + '/');
            }
            this.externalURI = local;
        }
        return local;
    }

    @Trivial
    public String toRepositoryPath() {
        String path = this.repositoryPath;
        if (path == null) {
            this.repositoryPath = this.resourceRoot != null ? (path = ResourceUtils.createRepositoryURI(this, this.resourceRoot)) : (path = new File(this.toExternalURI()).getAbsolutePath());
        }
        return path;
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        String undefined = "<undefined>";
        String result = this.stringValue;
        if (result == null) {
            String rPath = this.repositoryPath == null ? "<undefined>" : this.repositoryPath;
            StringBuilder str = new StringBuilder(simpleName.length() + rPath.length() + this.normalizedPath.length() + 5);
            str.append(simpleName).append("[").append(this.type).append(";").append("@").append(this.hashCode).append(";").append(rPath).append(";").append(this.normalizedPath).append("]");
            this.stringValue = result = str.toString();
        }
        return result;
    }

    public String[] introspectSelf() {
        return new String[]{this.toString()};
    }

    @Trivial
    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalFileResource)) {
            return false;
        }
        LocalFileResource other = (LocalFileResource)obj;
        return this.normalizedPath.equals(other.normalizedPath);
    }

    public long length() {
        return this.wrappedFile.length();
    }
}

