/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.web.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.web.impl.WeldInitialAsyncListener;
import com.ibm.ws.cdi.web.interfaces.CDIWebRuntime;
import com.ibm.ws.cdi.web.interfaces.PreEventListenerProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.filter.IFilterMapping;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.EventListener;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.ConversationFilter;
import org.jboss.weld.servlet.WeldInitialListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractInitialListenerRegistration
implements PreEventListenerProvider {
    public static final String CONVERSATION_FILTER_REGISTERED = ConversationFilter.class.getName() + ".registered";
    private static final TraceComponent tc = Tr.register(AbstractInitialListenerRegistration.class);
    public static final String WELD_INITIAL_LISTENER_ATTRIBUTE = "org.jboss.weld.servlet.WeldInitialListener";
    private final AtomicServiceReference<CDIWebRuntime> cdiWebRuntimeRef = new AtomicServiceReference("cdiWebRuntime");
    static final long serialVersionUID = 4732666634659860553L;

    protected void activate(ComponentContext context) {
        this.cdiWebRuntimeRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        this.cdiWebRuntimeRef.deactivate(context);
    }

    @Reference(name="cdiWebRuntime", service=CDIWebRuntime.class)
    protected void setCdiWebRuntime(ServiceReference<CDIWebRuntime> ref) {
        this.cdiWebRuntimeRef.setReference(ref);
    }

    protected void unsetCdiWebRuntime(ServiceReference<CDIWebRuntime> ref) {
        this.cdiWebRuntimeRef.unsetReference(ref);
    }

    protected abstract ModuleMetaData getModuleMetaData(IServletContext var1);

    @Override
    public void registerListener(IServletContext isc) {
        ModuleMetaData moduleMetaData;
        BeanManager beanManager;
        CDIWebRuntime cdiWebRuntime = (CDIWebRuntime)this.cdiWebRuntimeRef.getService();
        if (cdiWebRuntime != null && cdiWebRuntime.isCdiEnabled(isc) && (beanManager = cdiWebRuntime.getModuleBeanManager(moduleMetaData = this.getModuleMetaData(isc))) != null) {
            List filterMappings = isc.getWebAppConfig().getFilterMappings();
            for (IFilterMapping filterMapping : filterMappings) {
                IFilterConfig filterConfig = filterMapping.getFilterConfig();
                if (!"CDI Conversation Filter".equals(filterConfig.getFilterName())) continue;
                isc.setInitParameter(CONVERSATION_FILTER_REGISTERED, Boolean.TRUE.toString());
            }
            BeanManagerImpl beanManagerImpl = null;
            if (beanManager instanceof BeanManagerProxy) {
                BeanManagerProxy proxy = (BeanManagerProxy)beanManager;
                beanManagerImpl = proxy.delegate();
            } else if (beanManager instanceof BeanManagerImpl) {
                beanManagerImpl = (BeanManagerImpl)beanManager;
            } else {
                throw new RuntimeException("Unexpected beanManager instance.");
            }
            WeldInitialListener weldInitialListener = new WeldInitialListener(beanManagerImpl);
            isc.addListener((EventListener)weldInitialListener);
            isc.setAttribute(WELD_INITIAL_LISTENER_ATTRIBUTE, (Object)weldInitialListener);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"added WeldInitialListener to the servlet context", (Object[])new Object[0]);
            }
            isc.setAttribute("javax.enterprise.inject.spi.BeanManager", (Object)beanManager);
        }
    }

    @Override
    public void registerListener(IServletContext isc, AsyncContextImpl ac) {
        Object obj = isc.getAttribute(WELD_INITIAL_LISTENER_ATTRIBUTE);
        if (obj != null) {
            WeldInitialListener wl = (WeldInitialListener)obj;
            WeldInitialAsyncListener asyncListener = new WeldInitialAsyncListener(wl, (ServletContext)isc);
            ac.addListener((AsyncListener)asyncListener, (ServletRequest)ac.getIExtendedRequest(), (ServletResponse)ac.getIExtendedResponse());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"added WeldInitialAsyncListener to the asyncContext", (Object[])new Object[0]);
            }
        }
    }
}

