/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.apache.yoko.orb.CORBA.DataOutputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.TypeCode;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.util.cmsf.RepIds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public final class ValueWriter {
    private OutputStream out_;
    private Buffer buf_;
    private boolean chunked_ = false;
    private int nestingLevel_ = 0;
    private boolean needChunk_;
    private int chunkSizePos_;
    private int lastEndTagPos_;
    private int lastTag_ = 0;
    private IdentityHashMap instanceTable_;
    private Hashtable idTable_;
    private Hashtable idListTable_;
    private Hashtable codebaseTable_;
    private ValueHandler valueHandler;

    private boolean checkIndirection(Serializable value) {
        Integer pos = (Integer)this.instanceTable_.get(value);
        if (pos != null) {
            this.out_.write_long(-1);
            int p = pos;
            p += 3;
            p -= p & 3;
            int off = p - this.buf_.pos_;
            this.out_.write_long(off);
            return true;
        }
        return false;
    }

    private void beginChunk() {
        Assert._OB_assert(this.chunked_);
        this.out_.write_long(0);
        this.chunkSizePos_ = this.buf_.pos_ - 4;
    }

    private void endChunk() {
        Assert._OB_assert(this.chunked_);
        if (this.chunkSizePos_ > 0) {
            int size = this.buf_.pos_ - (this.chunkSizePos_ + 4);
            int savePos = this.buf_.pos_;
            this.buf_.pos_ = this.chunkSizePos_;
            this.out_.write_long(size);
            this.buf_.pos_ = savePos;
            this.chunkSizePos_ = 0;
        }
    }

    private BoxedValueHelper getHelper(Serializable value, org.omg.CORBA.TypeCode type) {
        BoxedValueHelper result = null;
        Class helperClass = null;
        Class<?> valueClass = value.getClass();
        if (String.class == valueClass) {
            return new WStringValueHelper();
        }
        if (!IDLEntity.class.isAssignableFrom(valueClass)) {
            return null;
        }
        try {
            String name = value.getClass().getName() + "Helper";
            Class c = ProviderLocator.loadClass((String)name, value.getClass(), (ClassLoader)Thread.currentThread().getContextClassLoader());
            if (BoxedValueHelper.class.isAssignableFrom(c)) {
                helperClass = c;
            }
        }
        catch (ClassNotFoundException name) {
            // empty catch block
        }
        if (helperClass == null && type != null) {
            try {
                org.omg.CORBA.TypeCode origType = TypeCode._OB_getOrigType(type);
                String id = origType.id();
                helperClass = RepIds.query((String)id).suffix("Helper").toClass();
            }
            catch (BadKind ex) {
                Assert._OB_assert(ex);
            }
        }
        if (helperClass != null) {
            try {
                result = (BoxedValueHelper)helperClass.newInstance();
            }
            catch (ClassCastException classCastException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return result;
    }

    public ValueWriter(OutputStream out) {
        this.out_ = out;
        this.buf_ = out._OB_buffer();
        this.chunked_ = false;
        this.nestingLevel_ = 0;
        this.needChunk_ = false;
        this.chunkSizePos_ = 0;
        this.lastEndTagPos_ = 0;
        this.instanceTable_ = new IdentityHashMap(131);
        this.idTable_ = new Hashtable(131);
        this.idListTable_ = new Hashtable(131);
        this.codebaseTable_ = new Hashtable(3);
    }

    public void writeValue(Serializable value, String id) {
        if (value == null) {
            this.out_.write_long(0);
        } else if (!this.checkIndirection(value)) {
            String[] ids;
            int tag;
            boolean isStreamable = value instanceof StreamableValue;
            boolean isCustom = value instanceof CustomMarshal;
            boolean rmiCompatMode = false;
            if (id != null) {
                String upperId = id.toUpperCase();
                rmiCompatMode = upperId.startsWith("RMI:");
            }
            if (!isStreamable && !isCustom) {
                BoxedValueHelper helper = this.getHelper(value, null);
                if (helper == null) {
                    this.writeRMIValue(value, id);
                } else {
                    this.writeValueBox(value, null, helper);
                }
                return;
            }
            ValueBase vb = (ValueBase)value;
            String[] truncIds = vb._truncatable_ids();
            String valueId = truncIds[0];
            boolean isTruncatable = truncIds.length > 1;
            boolean typeMatch = id != null && id.equals(valueId);
            boolean chunked = false;
            if (isCustom || isTruncatable && !typeMatch) {
                chunked = true;
            }
            if (rmiCompatMode || !typeMatch || this.nestingLevel_ > 1 && isTruncatable) {
                if (isTruncatable) {
                    tag = 2147483398;
                    ids = truncIds;
                } else {
                    tag = 2147483394;
                    ids = new String[]{valueId};
                }
            } else {
                tag = 0x7FFFFF00;
                ids = new String[]{};
            }
            int startPos = this.beginValue(tag, ids, null, chunked);
            this.instanceTable_.put(value, new Integer(startPos));
            if (isStreamable) {
                ((StreamableValue)value)._write((org.omg.CORBA.portable.OutputStream)this.out_);
            } else {
                DataOutputStream out = new DataOutputStream(this.out_);
                ((CustomMarshal)value).marshal((org.omg.CORBA.DataOutputStream)out);
            }
            this.endValue();
        }
    }

    private void writeRMIValue(Serializable value, String id) {
        if (value == null) {
            this.out_.write_long(0);
            return;
        }
        if (this.checkIndirection(value)) {
            return;
        }
        if (value instanceof String) {
            int pos = this.out_._OB_pos();
            WStringValueHelper.write((org.omg.CORBA.portable.OutputStream)this.out_, (String)((String)((java.lang.Object)value)));
            this.instanceTable_.put(value, new Integer(pos));
            return;
        }
        if (this.valueHandler == null) {
            this.valueHandler = Util.createValueHandler();
        }
        Serializable repValue = this.valueHandler.writeReplace(value);
        Serializable originalValue = null;
        if (value != repValue) {
            if (repValue == null) {
                this.out_.write_long(0);
                return;
            }
            if (this.checkIndirection(repValue)) {
                return;
            }
            if (repValue instanceof String) {
                int pos = this.out_._OB_pos();
                WStringValueHelper.write((org.omg.CORBA.portable.OutputStream)this.out_, (String)((String)((java.lang.Object)repValue)));
                this.instanceTable_.put(repValue, new Integer(pos));
                this.instanceTable_.put(value, new Integer(pos));
                return;
            }
            originalValue = value;
            value = repValue;
        }
        Class<?> clz = value.getClass();
        int tag = 2147483394;
        String codebase = Util.getCodebase(clz);
        if (codebase != null && codebase.length() != 0) {
            tag |= 1;
        }
        String[] ids = new String[]{this.valueHandler.getRMIRepositoryID(clz)};
        boolean isChunked = this.valueHandler.isCustomMarshaled(clz);
        int pos = this.beginValue(tag, ids, codebase, isChunked);
        this.instanceTable_.put(value, new Integer(pos));
        if (originalValue != null) {
            this.instanceTable_.put(originalValue, new Integer(pos));
        }
        this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.out_, value);
        this.endValue();
    }

    public void writeValueBox(Serializable value, org.omg.CORBA.TypeCode type, BoxedValueHelper helper) {
        if (value == null) {
            this.out_.write_long(0);
        } else if (!this.checkIndirection(value)) {
            if (helper == null) {
                helper = this.getHelper(value, type);
            }
            if (helper == null) {
                throw new MARSHAL(MinorCodes.describeMarshal(1330446337) + ": no helper for valuebox", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            String[] ids = new String[]{helper.get_id()};
            int tag = 2147483394;
            int startPos = this.beginValue(tag, ids, null, false);
            this.instanceTable_.put(value, new Integer(startPos));
            helper.write_value((org.omg.CORBA.portable.OutputStream)this.out_, value);
            this.endValue();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeAbstractInterface(java.lang.Object obj) {
        if (obj != null) {
            if (obj instanceof Object) {
                this.out_.write_boolean(true);
                this.out_.write_Object((Object)obj);
                return;
            } else {
                if (!(obj instanceof Serializable)) throw new MARSHAL("Object of class " + obj.getClass().getName() + " is not an object reference or valuetype");
                this.out_.write_boolean(false);
                this.writeValue((Serializable)obj, null);
            }
            return;
        } else {
            this.out_.write_boolean(false);
            this.out_.write_long(0);
        }
    }

    public int beginValue(int tag, String[] ids, String codebase, boolean chunk) {
        int off;
        Integer pos;
        if (chunk) {
            this.chunked_ = true;
        }
        if (this.chunked_) {
            tag |= 8;
            ++this.nestingLevel_;
            this.needChunk_ = false;
            if (this.nestingLevel_ > 1) {
                this.endChunk();
            }
        }
        this.out_.write_long(tag);
        int startPos = this.buf_.pos_ - 4;
        if ((tag & 1) == 1) {
            pos = (Integer)this.codebaseTable_.get(codebase);
            if (pos != null) {
                this.out_.write_long(-1);
                off = pos - this.buf_.pos_;
                this.out_.write_long(off);
            } else {
                this.codebaseTable_.put(codebase, new Integer(this.buf_.pos_));
                this.out_.write_string(codebase);
            }
        }
        if ((tag & 6) == 6) {
            StringSeqHasher key = new StringSeqHasher(ids);
            Integer pos2 = (Integer)this.idListTable_.get(key);
            if (pos2 != null) {
                this.out_.write_long(-1);
                int off2 = pos2 - this.buf_.pos_;
                this.out_.write_long(off2);
            } else {
                this.idListTable_.put(key, new Integer(this.buf_.pos_));
                this.out_.write_long(ids.length);
                for (int i = 0; i < ids.length; ++i) {
                    if (!this.idTable_.containsKey(ids[i])) {
                        this.idTable_.put(ids[i], new Integer(this.buf_.pos_));
                    }
                    this.out_.write_string(ids[i]);
                }
            }
        } else if ((tag & 6) == 2) {
            Assert._OB_assert(ids.length == 1);
            pos = (Integer)this.idTable_.get(ids[0]);
            if (pos != null) {
                this.out_.write_long(-1);
                off = pos - this.buf_.pos_;
                this.out_.write_long(off);
            } else {
                this.idTable_.put(ids[0], new Integer(this.buf_.pos_));
                this.out_.write_string(ids[0]);
            }
        }
        if (this.chunked_) {
            this.needChunk_ = true;
            this.chunkSizePos_ = 0;
            this.lastEndTagPos_ = 0;
        }
        return startPos;
    }

    public void endValue() {
        if (this.chunked_) {
            this.needChunk_ = false;
            if (this.lastEndTagPos_ > 0 && this.buf_.pos_ == this.lastEndTagPos_ + 4) {
                ++this.lastTag_;
                this.buf_.pos_ = this.lastEndTagPos_;
                this.out_.write_long(this.lastTag_);
            } else {
                this.endChunk();
                this.lastTag_ = -this.nestingLevel_;
                this.out_.write_long(this.lastTag_);
                if (this.nestingLevel_ > 1) {
                    this.lastEndTagPos_ = this.buf_.pos_ - 4;
                }
            }
            if (this.nestingLevel_ == 1) {
                this.chunked_ = false;
                this.lastEndTagPos_ = 0;
                this.lastTag_ = 0;
            } else {
                this.needChunk_ = true;
            }
            Assert._OB_assert(this.chunkSizePos_ == 0);
            --this.nestingLevel_;
        }
    }

    public void checkBeginChunk() {
        if (this.needChunk_) {
            this.needChunk_ = false;
            this.beginChunk();
        }
    }

    private class StringSeqHasher {
        String[] seq_;
        int hashCode_;

        StringSeqHasher(String[] seq) {
            this.seq_ = seq;
            this.hashCode_ = 0;
            for (int i = 0; i < seq.length; ++i) {
                this.hashCode_ ^= seq[i].hashCode();
            }
        }

        public int hashCode() {
            return this.hashCode_;
        }

        public boolean equals(java.lang.Object o) {
            StringSeqHasher h = (StringSeqHasher)o;
            if (h.seq_.length != this.seq_.length) {
                return false;
            }
            for (int i = 0; i < h.seq_.length; ++i) {
                if (h.seq_[i].equals(this.seq_[i])) continue;
                return false;
            }
            return true;
        }
    }
}

