/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.GIOPClient;
import org.apache.yoko.orb.OB.GIOPConnection;
import org.apache.yoko.orb.OB.GIOPIncomingMessage;
import org.apache.yoko.orb.OB.GIOPOutgoingMessage;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.OAInterface;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.Upcall;
import org.apache.yoko.orb.OCI.Buffer;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.SendReceiveMode;
import org.apache.yoko.orb.OCI.Transport;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.GIOP.MsgType_1_1;

public final class GIOPConnectionThreaded
extends GIOPConnection {
    static final Logger logger = Logger.getLogger(GIOPConnectionThreaded.class.getName());
    protected Object holdingMonitor_ = new Object();
    protected boolean holding_ = true;
    protected Object sendMutex_ = new Object();
    private boolean shuttingDown;
    private final ReentrantReadWriteLock receiverLock = new ReentrantReadWriteLock(true);

    protected void addReceiverThread() {
        this.getExecutor().submit(new Receiver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseThread() {
        Object object = this.holdingMonitor_;
        synchronized (object) {
            while (this.holding_) {
                try {
                    this.holdingMonitor_.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void abortiveShutdown() {
        this.ACM_disableIdleMonitor();
        if (this.transport_.mode() != SendReceiveMode.ReceiveOnly) {
            try {
                Buffer buf = new Buffer(12);
                OutputStream out = new OutputStream(buf);
                ProfileInfo profileInfo = new ProfileInfo();
                GIOPConnectionThreaded gIOPConnectionThreaded = this;
                synchronized (gIOPConnectionThreaded) {
                    profileInfo.major = this.giopVersion_.major;
                    profileInfo.minor = this.giopVersion_.minor;
                }
                GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
                outgoing.writeMessageHeader(MsgType_1_1.MessageError, false, 0);
                out._OB_pos(0);
                Object object = this.sendMutex_;
                synchronized (object) {
                    this.transport_.send(out._OB_buffer(), true);
                }
                Assert._OB_assert(out._OB_buffer().is_full());
            }
            catch (SystemException ex) {
                this.processException(5, ex, false);
                return;
            }
        }
        this.processException(5, (SystemException)((Object)new TRANSIENT(MinorCodes.describeTransient(1095974916), 1095974916, CompletionStatus.COMPLETED_MAYBE)), false);
        this.arrive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void gracefulShutdown() {
        this.ACM_disableIdleMonitor();
        if (this.upcallsInProgress_ > 0 || this.state_ != 3) {
            logger.fine("pending upcalls: " + this.upcallsInProgress_ + " state: " + this.state_);
            return;
        }
        if (this.canSendCloseConnection()) {
            Buffer buf = new Buffer(12);
            OutputStream out = new OutputStream(buf);
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.major = this.giopVersion_.major;
            profileInfo.minor = this.giopVersion_.minor;
            GIOPOutgoingMessage outgoing = new GIOPOutgoingMessage(this.orbInstance_, out, profileInfo);
            outgoing.writeMessageHeader(MsgType_1_1.CloseConnection, false, 0);
            this.messageQueue_.add(this.orbInstance_, out._OB_buffer());
        } else {
            logger.fine("could not send close connection message");
        }
        try {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
            try {
                this.getExecutor().submit(new Shutdown());
            }
            catch (RejectedExecutionException ree) {
                logger.log(Level.WARNING, "Could not submit shutdown task", ree);
            }
        }
        catch (OutOfMemoryError ex) {
            this.processException(5, (SystemException)new IMP_LIMIT(MinorCodes.describeImpLimit(1095974914), 1095974914, CompletionStatus.COMPLETED_NO), false);
        }
        finally {
            this.arrive();
        }
    }

    private void arrive() {
        if ((this.properties_ & 8) != 0) {
            this.orbInstance_.getClientPhaser().arriveAndDeregister();
        } else {
            this.orbInstance_.getServerPhaser().arriveAndDeregister();
        }
    }

    public GIOPConnectionThreaded(ORBInstance orbInstance, Transport transport, GIOPClient client) {
        super(orbInstance, transport, client);
        orbInstance.getClientPhaser().register();
        this.start();
    }

    public GIOPConnectionThreaded(ORBInstance orbInstance, Transport transport, OAInterface oa) {
        super(orbInstance, transport, oa);
        orbInstance.getServerPhaser().register();
    }

    private ExecutorService getExecutor() {
        if ((this.properties_ & 8) != 0) {
            return this.orbInstance_.getClientExecutor();
        }
        return this.orbInstance_.getServerExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execShutdown() {
        Object object;
        if (this.canSendCloseConnection() && this.transport_.mode() != SendReceiveMode.ReceiveOnly) {
            try {
                object = this;
                synchronized (object) {
                    while (this.messageQueue_.hasUnsent()) {
                        Buffer buf = this.messageQueue_.getFirstUnsentBuffer();
                        if (buf == null) continue;
                        Object object2 = this.sendMutex_;
                        synchronized (object2) {
                            this.transport_.send(buf, true);
                        }
                        this.messageQueue_.moveFirstUnsentToPending();
                    }
                }
            }
            catch (SystemException ex) {
                this.processException(5, ex, false);
                return;
            }
        }
        object = this.sendMutex_;
        synchronized (object) {
            this.transport_.shutdown();
        }
        try {
            this.receiverLock.writeLock().tryLock(this.shutdownTimeout_, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.processException(5, (SystemException)((Object)new TRANSIENT(MinorCodes.describeTransient(1095974916), 1095974916, CompletionStatus.COMPLETED_MAYBE)), false);
        }
        finally {
            if (this.receiverLock.isWriteLockedByCurrentThread()) {
                this.receiverLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execReceive() {
        logger.fine("Receiving incoming message " + this);
        GIOPIncomingMessage inMsg = new GIOPIncomingMessage(this.orbInstance_);
        Buffer buf = null;
        while (true) {
            Upcall upcall;
            block16: {
                Assert._OB_assert(buf == null);
                buf = new Buffer(12);
                try {
                    logger.fine("Reading message header");
                    this.transport_.receive(buf, true);
                    Assert._OB_assert(buf.is_full());
                }
                catch (SystemException ex) {
                    this.processException(5, ex, false);
                    return;
                }
                try {
                    inMsg.extractHeader(buf);
                    logger.fine("Header received for message of size " + inMsg.size());
                    buf.realloc(12 + inMsg.size());
                }
                catch (SystemException ex) {
                    this.processException(4, ex, false);
                    return;
                }
                if (!buf.is_full()) {
                    try {
                        logger.fine("Receiving message body of size " + inMsg.size());
                        this.transport_.receive(buf, true);
                        Assert._OB_assert(buf.is_full());
                    }
                    catch (SystemException ex) {
                        this.processException(5, ex, false);
                        return;
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Message body received ");
                    int currentpos = buf.pos_;
                    buf.pos_ = 0;
                    logger.fine("Received message are: \n" + buf.dumpData());
                    buf.pos_ = currentpos;
                }
                this.pauseThread();
                GIOPConnectionThreaded currentpos = this;
                synchronized (currentpos) {
                    if ((this.enabledOps_ & 1) == 0) {
                        return;
                    }
                }
                upcall = null;
                try {
                    Buffer bufCopy = buf;
                    buf = null;
                    if (!inMsg.consumeBuffer(bufCopy)) break block16;
                    upcall = this.processMessage(inMsg);
                }
                catch (SystemException ex) {
                    this.processException(4, ex, false);
                    return;
                }
            }
            if (upcall == null) continue;
            logger.fine("Processing message using upcall " + upcall.getClass().getName());
            boolean haveBidirSCL = this.transport_.get_info().received_bidir_SCL();
            if (haveBidirSCL) {
                this.addReceiverThread();
            }
            upcall.invoke();
            if (haveBidirSCL) return;
        }
    }

    @Override
    public synchronized void ACM_callback() {
        if (this.acmTimer_ != null) {
            this.acmTimer_.cancel();
            this.acmTimer_ = null;
        }
        if (this.acmTask_ != null) {
            this.acmTask_.cancel();
            this.acmTask_ = null;
        }
        if (this.messageQueue_.hasUnsent() || this.upcallsInProgress_ > 0) {
            this.ACM_enableIdleMonitor();
            return;
        }
        this.setState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Downcall down, boolean block) {
        block30: {
            Assert._OB_assert(this.transport_.mode() != SendReceiveMode.ReceiveOnly);
            Assert._OB_assert(down.unsent());
            logger.fine("Sending a request with Downcall of type " + down.getClass().getName() + " for operation " + down.operation() + " on transport " + this.transport_);
            boolean msgSentMarked = false;
            GIOPConnectionThreaded gIOPConnectionThreaded = this;
            synchronized (gIOPConnectionThreaded) {
                if ((this.enabledOps_ & 2) == 0) {
                    logger.fine("writing not enabled for this connection");
                    down.setFailureException((SystemException)((Object)new TRANSIENT()));
                    return true;
                }
                if (down.responseExpected()) {
                    down.allowWaiting();
                }
                this.messageQueue_.add(this.orbInstance_, down);
                if ((this.properties_ & 1) != 0) {
                    msgSentMarked = true;
                }
            }
            if (block) {
                int t = down.policies().requestTimeout;
                int msgcount = 0;
                while (true) {
                    Downcall nextDown;
                    Buffer buf;
                    Object object = this;
                    synchronized (object) {
                        if (!down.unsent()) {
                            break block30;
                        }
                        Assert._OB_assert(this.messageQueue_.hasUnsent());
                        buf = this.messageQueue_.getFirstUnsentBuffer();
                        nextDown = this.messageQueue_.moveFirstUnsentToPending();
                    }
                    try {
                        object = this.sendMutex_;
                        synchronized (object) {
                            if (t <= 0) {
                                this.transport_.send(buf, true);
                                Assert._OB_assert(buf.is_full());
                            } else {
                                this.transport_.send_timeout(buf, t);
                                if (!buf.is_full()) {
                                    throw new NO_RESPONSE();
                                }
                            }
                        }
                    }
                    catch (SystemException ex) {
                        this.processException(5, ex, false);
                        return true;
                    }
                    if (msgSentMarked || nextDown == null || nextDown.operation().equals("_locate")) continue;
                    msgSentMarked = true;
                    this.properties_ |= 1;
                    if (!logger.isLoggable(Level.FINE)) continue;
                    int currentpos = buf.pos_;
                    buf.pos_ = 0;
                    logger.fine("Sent message in blocking at msgcount=" + msgcount + ", size=" + buf.len_ + ", the message piece is: \n" + buf.dumpData());
                    buf.pos_ = currentpos;
                    ++msgcount;
                }
            }
            gIOPConnectionThreaded = this;
            synchronized (gIOPConnectionThreaded) {
                int msgcount = 0;
                while (down.unsent()) {
                    Assert._OB_assert(this.messageQueue_.hasUnsent());
                    Buffer buf = this.messageQueue_.getFirstUnsentBuffer();
                    try {
                        Object nextDown = this.sendMutex_;
                        synchronized (nextDown) {
                            this.transport_.send(buf, false);
                        }
                    }
                    catch (SystemException ex) {
                        this.processException(5, ex, false);
                        return true;
                    }
                    if (!buf.is_full()) {
                        return false;
                    }
                    Downcall dummy = this.messageQueue_.moveFirstUnsentToPending();
                    if (msgSentMarked || dummy == null || !dummy.responseExpected() || !dummy.operation().equals("_locate")) continue;
                    msgSentMarked = true;
                    this.properties_ |= 1;
                    if (!logger.isLoggable(Level.FINE)) continue;
                    int currentpos = buf.pos_;
                    buf.pos_ = 0;
                    logger.fine("Sent message in non-blocking at msgcount=" + msgcount + ", size=" + buf.len_ + ", the message piece is: \n" + buf.dumpData());
                    buf.pos_ = currentpos;
                    ++msgcount;
                }
            }
        }
        logger.fine(" Request send completed with Downcall of type " + down.getClass().getName());
        return !down.responseExpected();
    }

    @Override
    public boolean receive(Downcall down, boolean block) {
        logger.fine("Receiving response with Downcall of type " + down.getClass().getName() + " for operation " + down.operation() + " from transport " + this.transport_);
        try {
            boolean result = down.waitUntilCompleted(block);
            logger.fine("Completed receiving response with Downcall of type " + down.getClass().getName());
            return result;
        }
        catch (SystemException ex) {
            this.processException(5, ex, false);
            return true;
        }
    }

    @Override
    public boolean sendReceive(Downcall down) {
        this.ACM_disableIdleMonitor();
        try {
            if (this.send(down, true)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.receive(down, true);
            return bl;
        }
        finally {
            this.ACM_enableIdleMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        block13: {
            Object object = this.holdingMonitor_;
            synchronized (object) {
                if (this.holding_) {
                    this.holding_ = false;
                    this.holdingMonitor_.notifyAll();
                }
            }
            if (this.transport_.mode() != SendReceiveMode.SendOnly) {
                try {
                    if (!this.receiverLock.writeLock().tryLock()) break block13;
                    try {
                        this.addReceiverThread();
                    }
                    finally {
                        this.receiverLock.writeLock().unlock();
                    }
                }
                catch (OutOfMemoryError ex) {
                    GIOPConnectionThreaded gIOPConnectionThreaded = this;
                    synchronized (gIOPConnectionThreaded) {
                        this.transport_.close();
                        this.state_ = 5;
                        throw new IMP_LIMIT(MinorCodes.describeImpLimit(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        boolean msgSentMarked = false;
        Object object = this.holdingMonitor_;
        synchronized (object) {
            if (this.holding_) {
                this.holding_ = false;
                this.holdingMonitor_.notifyAll();
            }
        }
        object = this;
        synchronized (object) {
            if ((this.enabledOps_ & 2) == 0) {
                return;
            }
            if ((this.properties_ & 1) != 0) {
                msgSentMarked = true;
            }
        }
        if (this.transport_.mode() == SendReceiveMode.ReceiveOnly) {
            return;
        }
        block17: while (true) {
            try {
                Object object2;
                Downcall dummy;
                do {
                    Buffer buf;
                    object2 = this;
                    synchronized (object2) {
                        if (!this.messageQueue_.hasUnsent()) {
                            break block17;
                        }
                        buf = this.messageQueue_.getFirstUnsentBuffer();
                        buf.pos(0);
                        dummy = this.messageQueue_.moveFirstUnsentToPending();
                    }
                    object2 = this.sendMutex_;
                    synchronized (object2) {
                        this.transport_.send(buf, true);
                    }
                    if (buf.is_full()) continue;
                    throw new COMM_FAILURE(MinorCodes.describeCommFailure(1095974914), 1095974914, CompletionStatus.COMPLETED_NO);
                } while (msgSentMarked || dummy == null || !dummy.responseExpected() || !dummy.operation().equals("_locate"));
                object2 = this;
                synchronized (object2) {
                    msgSentMarked = true;
                    this.properties_ |= 1;
                }
            }
            catch (SystemException ex) {
                this.processException(5, ex, false);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.holdingMonitor_;
        synchronized (object) {
            this.holding_ = true;
        }
    }

    @Override
    public void enableConnectionModes(boolean client, boolean server) {
    }

    public final class Receiver
    implements Runnable {
        Receiver() {
            GIOPConnectionThreaded.this.receiverLock.readLock().lock();
        }

        @Override
        public void run() {
            try {
                GIOPConnectionThreaded.this.execReceive();
            }
            catch (RuntimeException ex) {
                Assert._OB_assert(ex);
            }
            finally {
                GIOPConnectionThreaded.this.receiverLock.readLock().unlock();
            }
        }
    }

    public final class Shutdown
    implements Runnable {
        @Override
        public void run() {
            try {
                GIOPConnectionThreaded.this.execShutdown();
            }
            catch (RuntimeException ex) {
                Assert._OB_assert(ex);
            }
        }
    }
}

