/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.diagnostics.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.logging.Introspector;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServiceIntrospection
implements Introspector {
    BundleContext context;
    static final long serialVersionUID = 8451174483529464690L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(BundleContext context) {
        this.context = context.getBundle("System Bundle").getBundleContext();
    }

    public String getIntrospectorName() {
        return "ServiceIntrospection";
    }

    public String getIntrospectorDescription() {
        return "Introspect all services' state.";
    }

    public void introspect(PrintWriter out) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.context.getBundles()) {
            out.append(Long.toString(bundle.getBundleId())).append(" [").append(ServiceIntrospection.getBundleState(bundle)).append("] ").append(bundle.getSymbolicName()).append(" ").append(String.valueOf(bundle.getVersion())).println();
            out.println("Registered Services:");
            this.writeServiceReferences(out, bundle.getRegisteredServices(), true);
            out.println("Services in Use:");
            this.writeServiceReferences(out, bundle.getServicesInUse(), false);
            out.println();
        }
    }

    private void writeServiceReferences(PrintWriter out, ServiceReference<?>[] services, boolean showUses) {
        if (services != null) {
            for (ServiceReference<?> sr : services) {
                String[] objectClasses = (String[])sr.getProperty("objectClass");
                out.append("  {");
                String separator = "";
                for (String objectClass : objectClasses) {
                    out.append(separator).append(objectClass);
                    separator = ", ";
                }
                separator = "";
                out.append("} = {");
                for (String key : sr.getPropertyKeys()) {
                    if ("objectClass".equals(key)) continue;
                    out.append(separator).append(key).append("=");
                    Object property = sr.getProperty(key);
                    if (property == null || !property.getClass().isArray()) {
                        out.append(String.valueOf(property));
                    } else {
                        out.append("[");
                        int length = Array.getLength(property);
                        for (int i = 0; i < length; ++i) {
                            if (i > 0) {
                                if (length > 10) {
                                    out.println(",");
                                    out.append("      ");
                                } else {
                                    out.append(", ");
                                }
                            }
                            out.append(String.valueOf(Array.get(property, i)));
                        }
                        out.append("]");
                    }
                    separator = ", ";
                }
                out.println("}");
                if (!showUses) continue;
                out.println("    Used by:");
                Bundle[] usingBundles = sr.getUsingBundles();
                if (usingBundles == null) continue;
                Arrays.sort(usingBundles, new Comparator<Bundle>(){
                    static final long serialVersionUID = 5302001565214005158L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public int compare(Bundle arg0, Bundle arg1) {
                        return Long.signum(arg0.getBundleId() - arg1.getBundleId());
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class);
                    }
                });
                for (Bundle b : usingBundles) {
                    out.append("      ").append(Long.toString(b.getBundleId())).append(" ").append(b.getSymbolicName()).append(" ").append(String.valueOf(b.getVersion())).println();
                }
            }
        }
    }

    private static String getBundleState(Bundle bundle) {
        int state = bundle.getState();
        switch (state) {
            case 1: {
                return "Uninstalled";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 16: {
                return "Stopping";
            }
            case 8: {
                return "Starting";
            }
            case 32: {
                return "Active";
            }
        }
        return "Unknown";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServiceIntrospection.class);
    }
}

