/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.management.j2ee.internal;

import com.ibm.websphere.management.j2ee.J2EEManagedObject;
import com.ibm.websphere.management.j2ee.J2EEManagementObjectNameFactory;
import com.ibm.websphere.management.j2ee.JNDIResourceMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component
public class JNDIMBeanRuntime {
    private BundleContext context;
    private WsLocationAdmin locationAdmin;
    private ObjectName objectName;
    private ServiceRegistration<JNDIResourceMBean> serviceRegistration;
    private static final TraceComponent tc = Tr.register(JNDIMBeanRuntime.class);
    static final long serialVersionUID = 218064249893945460L;

    @Reference
    protected void setLocationAdmin(WsLocationAdmin locationAdmin) {
        this.locationAdmin = locationAdmin;
    }

    @Activate
    protected void activate(BundleContext cc, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"JNDIMBeanRuntime activated", (Object[])new Object[]{properties});
        }
        this.context = cc;
        String serverName = this.locationAdmin.getServerName();
        this.objectName = J2EEManagementObjectNameFactory.createResourceObjectName((String)serverName, (String)"JNDIResource", (String)"NameService");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Generated ObjectName", (Object[])new Object[]{this.objectName});
        }
        JNDIMBeanImpl mbean = new JNDIMBeanImpl(this.objectName);
        this.serviceRegistration = this.registerMBean(this.objectName, JNDIResourceMBean.class, mbean);
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("JNDIMBeanRuntime deactivated, reason=" + reason), (Object[])new Object[0]);
        }
        this.serviceRegistration.unregister();
    }

    private <T> ServiceRegistration<T> registerMBean(ObjectName on, Class<T> type, T o) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("jmx.objectname", on.toString());
        return this.context.registerService(type, o, props);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class JNDIMBeanImpl
    extends J2EEManagedObject
    implements JNDIResourceMBean {
        static final long serialVersionUID = -1572259902725491836L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public JNDIMBeanImpl(ObjectName objectName) {
            super(objectName);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(JNDIMBeanImpl.class);
        }
    }
}

