/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.probe.servlet;

import com.ibm.wsspi.request.probe.bci.ContextInfoHelper;
import com.ibm.wsspi.request.probe.bci.RequestProbeTransformDescriptor;
import javax.servlet.GenericServlet;
import javax.servlet.http.HttpServletRequest;

public class ServletWrapperServiceTransformDescriptor
implements RequestProbeTransformDescriptor {
    private static final String classToInstrument = "com/ibm/ws/webcontainer/servlet/ServletWrapper";
    private static final String methodToInstrument = "service";
    private static final String descOfMethod = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;Lcom/ibm/ws/webcontainer/webapp/WebAppServletInvocationEvent;)V";
    private static final String requestProbeType = "websphere.servlet.service";

    public String getClassName() {
        return classToInstrument;
    }

    public String getMethodName() {
        return methodToInstrument;
    }

    public String getMethodDesc() {
        return descOfMethod;
    }

    public String getEventType() {
        return requestProbeType;
    }

    public boolean isCounter() {
        return false;
    }

    public Object getContextInfo(final Object instanceOfThisClass, final Object methodArgs) {
        return new ContextInfoHelper(instanceOfThisClass, methodArgs){

            public String toString() {
                String appName = "";
                String servletName = "";
                String pathInfo = "";
                String queryString = "";
                StringBuilder eventContextInfo = new StringBuilder();
                if (instanceOfThisClass != null) {
                    GenericServlet passedInstance = (GenericServlet)instanceOfThisClass;
                    appName = passedInstance.getServletContext().getServletContextName();
                    servletName = passedInstance.getServletName();
                }
                if (methodArgs != null) {
                    Object[] obj = (Object[])methodArgs;
                    HttpServletRequest servletRequest = (HttpServletRequest)obj[0];
                    pathInfo = servletRequest.getPathInfo();
                    queryString = servletRequest.getQueryString();
                }
                if (appName != null && appName.length() > 0) {
                    eventContextInfo.append(appName);
                }
                if (servletName != null && servletName.length() > 0) {
                    eventContextInfo.append(" | ").append(servletName);
                }
                if (pathInfo != null && pathInfo.length() > 0) {
                    eventContextInfo.append(" | ").append(pathInfo);
                }
                if (queryString != null && queryString.length() > 0) {
                    eventContextInfo.append("?").append(queryString);
                }
                return eventContextInfo.toString();
            }
        };
    }
}

