/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.bundle.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.bundle.internal.BundleContainer;
import com.ibm.ws.artifact.bundle.internal.BundleContainerFactoryHelper;
import com.ibm.ws.artifact.bundle.internal.BundleEntry;
import com.ibm.ws.artifact.bundle.internal.BundleNotifier;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BundleArchive
implements ArtifactContainer {
    private final Bundle bundle;
    private final ArtifactContainer enclosingContainer;
    private final ArtifactEntry entryInEnclosingContainer;
    private final BundleContainerFactoryHelper containerFactoryHolder;
    private final File cacheDir;
    static final long serialVersionUID = -3886926048063247951L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BundleArchive(File cacheDir, Bundle bundle, ArtifactContainer enclosingContainer, ArtifactEntry entryInEnclosingContainer, BundleContainerFactoryHelper containerFactoryHolder) {
        this.cacheDir = cacheDir;
        this.bundle = bundle;
        this.enclosingContainer = enclosingContainer;
        this.containerFactoryHolder = containerFactoryHolder;
        this.entryInEnclosingContainer = entryInEnclosingContainer;
    }

    public ArtifactEntry getEntry(String pathAndName) {
        List wires;
        BundleWiring bundleWiring;
        URL bundleEntry = this.getBundleEntry(this.bundle, pathAndName = PathUtils.checkAndNormalizeRootPath((String)pathAndName));
        if (bundleEntry == null && (bundleWiring = (BundleWiring)this.bundle.adapt(BundleWiring.class)) != null && (wires = bundleWiring.getProvidedWires("osgi.wiring.host")) != null) {
            Iterator wireIterator = wires.iterator();
            while (bundleEntry == null && wireIterator.hasNext()) {
                BundleWire wire = (BundleWire)wireIterator.next();
                Bundle fragment = wire.getRequirerWiring().getBundle();
                bundleEntry = this.getBundleEntry(fragment, pathAndName);
            }
        }
        if (bundleEntry != null) {
            return this.createEntry(bundleEntry);
        }
        return null;
    }

    public URL getBundleEntry(Bundle bundleToTest, String pathAndName) {
        try {
            URL bundleEntry = bundleToTest.getEntry(pathAndName);
            if (bundleEntry == null) {
                bundleEntry = bundleToTest.getEntry(pathAndName + "/");
            }
            return bundleEntry;
        }
        catch (IllegalStateException bundleEntry) {
            FFDCFilter.processException((Throwable)bundleEntry, (String)"com.ibm.ws.artifact.bundle.internal.BundleArchive", (String)"118", (Object)this, (Object[])new Object[]{bundleToTest, pathAndName});
            return null;
        }
    }

    public Collection<URL> getURLs() {
        try {
            URL u = this.bundle.getEntry("/");
            return Collections.singleton(u);
        }
        catch (IllegalStateException u) {
            FFDCFilter.processException((Throwable)u, (String)"com.ibm.ws.artifact.bundle.internal.BundleArchive", (String)"130", (Object)this, (Object[])new Object[0]);
            return Collections.emptyList();
        }
    }

    public boolean isRoot() {
        return true;
    }

    public void stopUsingFastMode() {
    }

    public void useFastMode() {
    }

    public Iterator<ArtifactEntry> iterator() {
        return this.iterator("/");
    }

    protected Iterator<ArtifactEntry> iterator(String path) {
        try {
            Enumeration entryUrls = this.bundle.findEntries(path, "*", false);
            if (entryUrls == null) {
                Set entries = Collections.emptySet();
                return entries.iterator();
            }
            LinkedHashMap<String, ArtifactEntry> entries = new LinkedHashMap<String, ArtifactEntry>();
            while (entryUrls.hasMoreElements()) {
                URL entryUrl = (URL)entryUrls.nextElement();
                ArtifactEntry potential = this.createEntry(entryUrl);
                String potPath = potential.getPath();
                if (entries.containsKey(potPath) || "/".equals(potPath)) continue;
                entries.put(potential.getPath(), potential);
            }
            return entries.values().iterator();
        }
        catch (IllegalStateException entryUrls) {
            FFDCFilter.processException((Throwable)entryUrls, (String)"com.ibm.ws.artifact.bundle.internal.BundleArchive", (String)"180", (Object)this, (Object[])new Object[]{path});
            return Collections.emptyList().iterator();
        }
    }

    public ArtifactContainer getEnclosingContainer() {
        return this.enclosingContainer;
    }

    public ArtifactEntry getEntryInEnclosingContainer() {
        return this.entryInEnclosingContainer;
    }

    public String getPath() {
        return "/";
    }

    public String getName() {
        return "/";
    }

    public String getPhysicalPath() {
        return null;
    }

    public ArtifactContainer getRoot() {
        return this;
    }

    private ArtifactEntry createEntry(URL entryUrl) {
        String path = entryUrl.getPath();
        if ('/' == path.charAt(path.length() - 1)) {
            return new BundleContainer(entryUrl, this);
        }
        return new BundleEntry(entryUrl, this);
    }

    ArtifactContainerFactory getContainerFactory() {
        return this.containerFactoryHolder.getContainerFactory();
    }

    File getCacheDir() {
        return this.cacheDir;
    }

    public ArtifactNotifier getArtifactNotifier() {
        return new BundleNotifier();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BundleArchive.class);
    }
}

